/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.mi.InferenceMI;
import com.mathworks.toolbox.coder.mi.StructureUtils;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.BuildOutputHandler;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class BuildCommand
implements Command {
    private final CoderApp fApp;
    private final BuildOutputHandler fOutputHandler;
    private volatile boolean fCancelled = false;
    private static final Matlab sMatlab = new Matlab();

    public BuildCommand(CoderApp coderApp, BuildOutputHandler buildOutputHandler) {
        this.fApp = coderApp;
        this.fOutputHandler = buildOutputHandler;
    }

    public void execute(final CommandStatus commandStatus) {
        Configuration configuration = this.fApp.getModel().getConfiguration();
        boolean bl = this.fApp.getModel().getGenericArtifact() == GenericArtifact.HDL;
        Object[] objectArray = new Object[]{"codeUnifiedProject", bl, configuration, this, this.getFeatureFlags()};
        sMatlab.fevalConsoleOutput("emlcprivate", objectArray, 6, new CompletionObserver(){

            public void completed(final int n, final Object object) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Matlab.getExecutionStatus((int)n) == 0) {
                            List<InferenceMI.Inference> list3;
                            LinkedList<BuildError> linkedList;
                            Object[] objectArray = (Object[])object;
                            List<Object> list2 = linkedList = objectArray[3] != null ? ConversionUtils.convertErrors(objectArray[3]) : new LinkedList();
                            if (!((boolean[])objectArray[0])[0]) {
                                commandStatus.failed(new CommandExecutionException((Command)BuildCommand.this));
                            } else {
                                commandStatus.finished();
                            }
                            File file = objectArray[1] instanceof File ? (File)objectArray[1] : new File((String)objectArray[1]);
                            ArrayList arrayList = (ArrayList)objectArray[2];
                            FileLocation fileLocation = new FileLocation(Matlab.matlabRoot());
                            FileLocation fileLocation2 = new FileLocation(fileLocation, "toolbox");
                            TreeSet<Object> treeSet = new TreeSet<Object>();
                            for (List<InferenceMI.Inference> list3 : arrayList) {
                                if (new FileLocation((File)((Object)list3)).hasPrefix(fileLocation2)) continue;
                                treeSet.add(list3);
                            }
                            if (objectArray[4] != null && objectArray[4] instanceof String) {
                                commandStatus.printOutputLine((String)objectArray[4]);
                            }
                            Object object2 = null;
                            list3 = StructureUtils.translate(InferenceMI.Inference.class, objectArray[5]);
                            if (!list3.isEmpty()) {
                                object2 = (InferenceMI.Inference)list3.get(0);
                            }
                            BuildCommand.this.fOutputHandler.buildFinished(file, new TreeSet<File>((Collection<File>)treeSet), linkedList, (InferenceMI.Inference)object2);
                        } else {
                            commandStatus.failed(new CommandExecutionException((Command)BuildCommand.this));
                        }
                    }
                });
            }
        });
    }

    private Object[] getFeatureFlags() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.fApp.getModel().getConfiguration().getParamAsString("param.FeatureFlags");
        if (string != null) {
            if (string.trim().startsWith("{") && string.trim().endsWith("}")) {
                return new Object[]{string};
            }
            try {
                int n;
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
                while ((n = streamTokenizer.nextToken()) != -1) {
                    if (n != -3 && n != 39 && n != 34) continue;
                    String string2 = streamTokenizer.sval;
                    if (string2.equals("true")) {
                        arrayList.add(Boolean.TRUE);
                        continue;
                    }
                    if (string2.equals("false")) {
                        arrayList.add(Boolean.FALSE);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (arrayList.size() % 2 != 0) {
            arrayList.clear();
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public void cancel() {
        this.fCancelled = true;
    }

    public boolean isCancelled() {
        return this.fCancelled;
    }

    public String toString() {
        return MessageFormat.format(CoderResources.getString("wfa.progress.building"), this.fApp.getModel().getCompiledArtifactName());
    }
}

