/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.widgets.CustomComboBox;
import com.mathworks.toolbox.coder.widgets.CustomComboModelContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class ArtifactSelector {
    private final CoderApp fApp;
    private final MJPanel fComponent;
    private final MJLabel fLabel;
    private final CustomComboBox<Artifact> fArtifactBox;

    ArtifactSelector(CoderApp coderApp, GenericArtifact genericArtifact, Artifact artifact, boolean bl) {
        this.fApp = coderApp;
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d:grow", "0dlu:grow, fill:d, 0dlu:grow"));
        this.fComponent.setOpaque(false);
        this.fArtifactBox = new CustomComboBox<Artifact>(ArtifactSelector.createArtifactContext());
        this.fArtifactBox.setName("wfa.artifact");
        this.fArtifactBox.setConstrainPopupWidth(false);
        this.fLabel = new MJLabel(CoderResources.getString("wfa.artifact"));
        for (Artifact artifact2 : genericArtifact.getArtifacts()) {
            this.fArtifactBox.addItem((Object)artifact2);
        }
        this.fArtifactBox.setSelectedItem((Object)artifact);
        CellConstraints cellConstraints = new CellConstraints();
        if (bl) {
            this.fComponent.add((Component)this.fLabel, (Object)cellConstraints.xy(1, 2));
            this.fComponent.add(this.fArtifactBox, (Object)cellConstraints.xy(3, 2));
        } else {
            this.fComponent.setLayout((LayoutManager)new BorderLayout());
            this.fComponent.add(this.fArtifactBox);
        }
        this.fArtifactBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent itemEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ArtifactSelector.this.fArtifactBox.getSelectedItem() == itemEvent.getItem()) {
                            ArtifactSelector.this.fApp.getModel().setArtifact((Artifact)((Object)ArtifactSelector.this.fArtifactBox.getSelectedItem()));
                        }
                    }
                });
            }
        });
        this.fArtifactBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArtifactSelector.this.fComponent.revalidate();
                        ArtifactSelector.this.fComponent.repaint();
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.popupMenuWillBecomeInvisible(popupMenuEvent);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArtifactSelector.this.fComponent.revalidate();
                ArtifactSelector.this.fComponent.repaint();
            }
        });
    }

    ArtifactSelector(CoderApp coderApp, GenericArtifact genericArtifact, Artifact artifact) {
        this(coderApp, genericArtifact, artifact, false);
    }

    public void setForeground(Color color) {
        this.fLabel.setForeground(color);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private static CustomComboModelContext<Artifact> createArtifactContext() {
        return new CustomComboModelContext(){

            @Override
            public String getName(Object object) {
                return ((Artifact)((Object)object)).getLabelWithExtension();
            }

            @Override
            public String getShortName(Object object) {
                return ((Artifact)((Object)object)).getLabel();
            }

            @Override
            public Icon getIcon(Object object) {
                return ((Artifact)((Object)object)).getSmallIcon();
            }

            @Override
            public String getDescription(Object object) {
                return ((Artifact)((Object)object)).getDescription();
            }
        };
    }
}

