/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.AnimationUtils;
import com.mathworks.toolbox.coder.wfa.core.CardboardCutout;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepView;
import com.mathworks.toolbox.coder.widgets.BlurPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class AbstractCoderStepView
implements StepView {
    public static final String VIEW_PROPERTY = "StepView";
    private final BlurPanel fBlurPanel;
    private final JComponent fComponent;
    private final MJPanel fContentPane;
    private final CoderApp fApp;
    private final StepModel fModel;
    private final Step fStep;
    private IDEContext fIDEContext;
    private SheetDisplayContext fSheetDisplayContext;
    private SheetDisplayStrategy fDisplayStrategy;
    private MJDialog fSheetDialog;
    private SheetPositionTracker fSheetPositionTracker;
    private PropertyChangeListener fSheetFocusTracker;
    private Runnable fSheetCloseHandler;
    private boolean fIgnoreClose;

    public AbstractCoderStepView(CoderApp coderApp, StepModel stepModel, Step step) {
        this.fApp = coderApp;
        this.fModel = stepModel;
        this.fStep = step;
        this.fContentPane = new MJPanel((LayoutManager)new BorderLayout());
        this.fContentPane.putClientProperty((Object)VIEW_PROPERTY, (Object)this);
        this.fContentPane.setName(step.getKey() + ".contentPane");
        this.fBlurPanel = new BlurPanel((Component)this.fContentPane, coderApp.getAnimator());
        this.fComponent = this.fBlurPanel.getComponent();
        this.fComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("ancestor")) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        AbstractCoderStepView.this.createSheetDialog();
                    } else if (AbstractCoderStepView.this.fSheetDisplayContext != null) {
                        AbstractCoderStepView.this.closeSheet(AbstractCoderStepView.this.fSheetDisplayContext.getSheet(), false);
                    }
                }
            }
        });
        this.fBlurPanel.addEventHandler(new BlurPanel.EventHandler(){

            @Override
            public void handleMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501 && AbstractCoderStepView.this.fSheetDisplayContext != null) {
                    AbstractCoderStepView.this.closeSheet(AbstractCoderStepView.this.fSheetDisplayContext.getSheet());
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.fSheetDialog != null) {
            this.fSheetPositionTracker.dispose();
            this.fSheetDialog.dispose();
            this.fSheetDialog = null;
            this.fSheetDisplayContext = null;
        }
        this.fBlurPanel.dispose();
    }

    @Override
    public final JComponent getComponent() {
        return this.fComponent;
    }

    protected final JComponent getContentPane() {
        return this.fContentPane;
    }

    @Override
    public boolean needsNarrowNavigationBars() {
        return this.fIDEContext != null;
    }

    @Override
    public boolean shouldStretch() {
        return false;
    }

    public final Step getStep() {
        return this.fStep;
    }

    protected final StepModel getModel() {
        return this.fModel;
    }

    protected final CoderApp getApp() {
        return this.fApp;
    }

    @Override
    public void deactivate() {
    }

    protected final void installIDEView(IDEContext iDEContext) {
        this.fIDEContext = iDEContext;
        this.fContentPane.removeAll();
        IDEView iDEView = this.fApp.getIDEView();
        if (iDEView.getComponent().getParent() != null) {
            iDEView.getComponent().getParent().remove(iDEView.getComponent());
        }
        iDEView.setContext(iDEContext);
        this.fContentPane.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fContentPane.add((Component)iDEView.getComponent(), (Object)"Center");
        this.fContentPane.revalidate();
        this.fContentPane.repaint();
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    @Override
    public void displaySheet(Component component, int n, boolean bl, boolean bl2, Runnable runnable) {
        ((JComponent)component).setBorder(new SheetBorder(false));
        this.displaySheet(component, n, bl, bl2, runnable, new VerticalWipeSheetDisplayStrategy());
    }

    @Override
    public void displaySheet(Component component, Component component2, boolean bl, boolean bl2, Runnable runnable) {
        ((JComponent)component).setBorder(new SheetBorder(true));
        this.displaySheet(component, 0, bl, bl2, runnable, new FauxDialogSheetDisplayStrategy(component2));
    }

    private void displaySheet(Component component, int n, boolean bl, boolean bl2, Runnable runnable, SheetDisplayStrategy sheetDisplayStrategy) {
        if (this.fSheetDisplayContext != null) {
            this.closeSheet(this.fSheetDisplayContext.getSheet(), false);
        }
        this.fSheetDisplayContext = new SheetDisplayContext(component, this.fSheetDialog, n, bl2, bl);
        this.fSheetCloseHandler = runnable;
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.fDisplayStrategy = sheetDisplayStrategy;
        if (bl2) {
            this.fBlurPanel.startBlurEffect(true);
        }
        this.fDisplayStrategy.showSheet(this.fSheetDisplayContext, false);
    }

    @Override
    public void updateSheetSize(Component component) {
        if (this.fSheetDisplayContext != null && this.fSheetDisplayContext.getSheet() == component) {
            this.fDisplayStrategy.showSheet(this.fSheetDisplayContext, true);
        }
    }

    private void makeSheetVisible(SheetDisplayContext sheetDisplayContext) {
        MJDialog mJDialog = sheetDisplayContext.getSheetDialog();
        mJDialog.setName("SheetDialog");
        mJDialog.getContentPane().removeAll();
        mJDialog.getContentPane().add(sheetDisplayContext.getSheet());
        mJDialog.getContentPane().revalidate();
        mJDialog.getContentPane().repaint();
        mJDialog.setLayout(null);
        mJDialog.setAutoRequestFocus(false);
        mJDialog.setVisible(true);
    }

    private void makeSheetDisappear(SheetDisplayContext sheetDisplayContext) {
        sheetDisplayContext.getSheetDialog().setVisible(false);
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private Dimension getPreferredSheetSize(SheetDisplayContext sheetDisplayContext) {
        if (sheetDisplayContext.isPack() && sheetDisplayContext.getSheetAlignment() != 0) {
            return sheetDisplayContext.getSheet().getPreferredSize();
        }
        Dimension dimension = new Dimension(this.fComponent.getWidth() - 70, this.fComponent.getHeight() - 35);
        if (sheetDisplayContext.isPack()) {
            dimension.height = Math.min(dimension.height, sheetDisplayContext.getSheet().getPreferredSize().height);
        }
        return dimension;
    }

    @Override
    public void closeSheet(Component component) {
        this.closeSheet(component, true);
    }

    private void closeSheet(Component component, boolean bl) {
        if (this.fSheetDisplayContext == null || component == null || this.fSheetDisplayContext != null && !this.fSheetDisplayContext.getSheet().equals(component)) {
            return;
        }
        if (this.fSheetDisplayContext.isFadeViewForSheet()) {
            this.fBlurPanel.startBlurEffect(false, null, bl);
        }
        if (!bl) {
            this.makeSheetDisappear(this.fSheetDisplayContext);
            this.fSheetDisplayContext = null;
        } else {
            this.fDisplayStrategy.hideSheet(this.fSheetDisplayContext);
        }
        FocusManager.getCurrentManager().removePropertyChangeListener(this.fSheetFocusTracker);
        this.internallyCloseDialog();
        this.runSheetCloseHandler();
    }

    private void runSheetCloseHandler() {
        if (this.fSheetCloseHandler != null) {
            Runnable runnable = this.fSheetCloseHandler;
            this.fSheetCloseHandler = null;
            runnable.run();
        }
    }

    private void createSheetDialog() {
        this.fSheetDialog = new MJDialog((Frame)((JFrame)SwingUtilities.windowForComponent(this.fComponent)));
        this.fSheetDialog.getContentPane().setLayout(null);
        this.fSheetDialog.setCloseOnEscapeEnabled(true);
        this.fSheetDialog.setUndecorated(true);
        this.fSheetDialog.setContentPane((Container)new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (AbstractCoderStepView.this.fSheetDisplayContext != null) {
                    Dimension dimension = AbstractCoderStepView.this.getPreferredSheetSize(AbstractCoderStepView.this.fSheetDisplayContext);
                    for (Component component : this.getComponents()) {
                        component.setBounds(0, 0, dimension.width, dimension.height);
                    }
                }
            }
        });
        this.fSheetDialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                AbstractCoderStepView.this.sheetClosed();
            }
        });
        this.fSheetDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AbstractCoderStepView.this.sheetClosed();
            }
        });
        this.fSheetPositionTracker = new SheetPositionTracker(SwingUtilities.windowForComponent(this.fComponent));
        this.fSheetFocusTracker = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Component component;
                Window window = SwingUtilities.windowForComponent(AbstractCoderStepView.this.fComponent);
                if (window != null && propertyChangeEvent.getPropertyName().equals("focusOwner") && window.isFocused() && (component = FocusManager.getCurrentManager().getFocusOwner()) != null && ComponentUtils.isChild((Component)component, (Component)AbstractCoderStepView.this.fComponent) && AbstractCoderStepView.this.fSheetDisplayContext != null) {
                    AbstractCoderStepView.this.closeSheet(AbstractCoderStepView.this.fSheetDisplayContext.getSheet());
                }
            }
        };
    }

    private void sheetClosed() {
        if (this.fIgnoreClose) {
            this.fIgnoreClose = false;
            return;
        }
        this.runSheetCloseHandler();
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private void internallyCloseDialog() {
        this.fIgnoreClose = true;
        this.fSheetDialog.setVisible(false);
    }

    @Override
    public void showHelp() {
        MLHelpServices.cshDisplayTopic((Object)this.getContentPane(), (String)CoderApp.getHelpMapPath(this.fApp), (String)this.getHelpKey());
    }

    private boolean isCurrentSheet(SheetDisplayContext sheetDisplayContext) {
        return this.fSheetDisplayContext != null && this.fSheetDisplayContext.equals(sheetDisplayContext);
    }

    protected abstract String getHelpKey();

    private static class SheetBorder
    implements Border {
        private final boolean fShowTop;

        SheetBorder(boolean bl) {
            this.fShowTop = bl;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(new Color(134, 134, 134));
            graphics.drawLine(0, 0, 0, component.getHeight());
            graphics.drawLine(0, component.getHeight() - 1, component.getWidth(), component.getHeight() - 1);
            graphics.drawLine(component.getWidth() - 1, 0, component.getWidth() - 1, component.getHeight());
            if (this.fShowTop) {
                graphics.drawLine(0, 0, component.getWidth(), 0);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(this.fShowTop ? 1 : 0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class SheetDisplayContext {
        private final Component fSheet;
        private final MJDialog fSheetDialog;
        private final int fSheetAlignment;
        private final boolean fPack;
        private final boolean fFadeViewForSheet;

        SheetDisplayContext(Component component, MJDialog mJDialog, int n, boolean bl, boolean bl2) {
            this.fFadeViewForSheet = bl;
            this.fSheet = component;
            this.fSheetDialog = mJDialog;
            this.fSheetAlignment = n;
            this.fPack = bl2;
        }

        boolean isFadeViewForSheet() {
            return this.fFadeViewForSheet;
        }

        boolean isPack() {
            return this.fPack;
        }

        Component getSheet() {
            return this.fSheet;
        }

        int getSheetAlignment() {
            return this.fSheetAlignment;
        }

        MJDialog getSheetDialog() {
            return this.fSheetDialog;
        }
    }

    private class FauxDialogSheetDisplayStrategy
    implements SheetDisplayStrategy {
        private final Component fOrigin;

        FauxDialogSheetDisplayStrategy(Component component) {
            this.fOrigin = component;
        }

        @Override
        public void hideSheet(SheetDisplayContext sheetDisplayContext) {
            AbstractCoderStepView.this.makeSheetDisappear(sheetDisplayContext);
            this.performMoveAnimation(AbstractCoderStepView.this.fComponent, this.fOrigin.getBounds(), this.fOrigin.getParent(), new Runnable(){

                @Override
                public void run() {
                    AbstractCoderStepView.this.fSheetDisplayContext = null;
                }
            });
        }

        @Override
        public void showSheet(final SheetDisplayContext sheetDisplayContext, boolean bl) {
            Dimension dimension = AbstractCoderStepView.this.getPreferredSheetSize(sheetDisplayContext);
            Point point = this.findLocation(sheetDisplayContext.getSheetAlignment(), dimension);
            final Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            if (bl) {
                this.performMakeSheetVisible(sheetDisplayContext, rectangle);
            } else {
                Point point2 = new Point(point);
                SwingUtilities.convertPointFromScreen(point2, AbstractCoderStepView.this.fComponent);
                this.performMoveAnimation(this.fOrigin, new Rectangle(point2.x, point2.y, dimension.width, dimension.height), AbstractCoderStepView.this.fComponent, new Runnable(){

                    @Override
                    public void run() {
                        FauxDialogSheetDisplayStrategy.this.performMakeSheetVisible(sheetDisplayContext, rectangle);
                    }
                });
            }
        }

        private void performMoveAnimation(Component component, Rectangle rectangle, Component component2, final Runnable runnable) {
            AnimationUtils.animateMoveInGlassPane(AbstractCoderStepView.this.getApp().getAnimator(), AbstractCoderStepView.this.fApp.getGlassPaneManager(), AbstractCoderStepView.this.fApp.getWindow(), component.getBounds(), component.getParent(), rectangle, component2, AnimationTrack.FAST_ACCELERATING, new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }

        private void performMakeSheetVisible(SheetDisplayContext sheetDisplayContext, Rectangle rectangle) {
            AbstractCoderStepView.this.makeSheetVisible(sheetDisplayContext);
            sheetDisplayContext.getSheetDialog().setBounds(rectangle);
        }

        private Point findLocation(int n, Dimension dimension) {
            Point point = AbstractCoderStepView.this.fComponent.getLocation();
            SwingUtilities.convertPointToScreen(point, AbstractCoderStepView.this.fComponent);
            int n2 = 0;
            int n3 = 0;
            if (n == 4) {
                n2 = AbstractCoderStepView.this.fComponent.getWidth() - dimension.width;
            } else if (n != 2) {
                n2 = (AbstractCoderStepView.this.fComponent.getWidth() - dimension.width) / 2;
            }
            if (n == 3) {
                n3 = AbstractCoderStepView.this.fComponent.getHeight() - dimension.height;
            } else if (n != 1) {
                n3 = (AbstractCoderStepView.this.fComponent.getHeight() - dimension.height) / 2;
            }
            return new Point(point.x + n2, point.y + n3);
        }
    }

    private class VerticalWipeSheetDisplayStrategy
    implements SheetDisplayStrategy {
        private VerticalWipeSheetDisplayStrategy() {
        }

        @Override
        public void hideSheet(final SheetDisplayContext sheetDisplayContext) {
            sheetDisplayContext.getSheetDialog().getContentPane().removeAll();
            sheetDisplayContext.getSheetDialog().getContentPane().add((Component)((Object)new CardboardCutout(sheetDisplayContext.getSheet())));
            AbstractCoderStepView.this.getApp().getAnimator().animate(PlatformInfo.isMacintosh() ? AnimationTrack.FAST_ACCELERATING : AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d) {
                    if (!AbstractCoderStepView.this.isCurrentSheet(sheetDisplayContext)) {
                        return;
                    }
                    d = 1.0 - d;
                    VerticalWipeSheetDisplayStrategy.this.setSheetExpansionRatio(sheetDisplayContext, d);
                    if (d == 0.0 && sheetDisplayContext.getSheetDialog() != null) {
                        AbstractCoderStepView.this.fSheetDisplayContext = null;
                        AbstractCoderStepView.this.makeSheetDisappear(sheetDisplayContext);
                    }
                }
            });
        }

        @Override
        public void showSheet(final SheetDisplayContext sheetDisplayContext, boolean bl) {
            if (bl) {
                this.setSheetExpansionRatio(sheetDisplayContext, 1.0);
            } else {
                AbstractCoderStepView.this.makeSheetVisible(sheetDisplayContext);
                sheetDisplayContext.getSheetDialog().getContentPane().removeAll();
                sheetDisplayContext.getSheetDialog().add((Component)((Object)new CardboardCutout(sheetDisplayContext.getSheet())));
                AbstractCoderStepView.this.fApp.getAnimator().animate(PlatformInfo.isMacintosh() ? AnimationTrack.FAST_ACCELERATING : AnimationTrack.ACCELERATING, new Animation(){

                    @Override
                    public void step(double d) {
                        if (!AbstractCoderStepView.this.isCurrentSheet(sheetDisplayContext)) {
                            return;
                        }
                        VerticalWipeSheetDisplayStrategy.this.setSheetExpansionRatio(sheetDisplayContext, d);
                        if (d == 1.0 && sheetDisplayContext.getSheetDialog() != null) {
                            sheetDisplayContext.getSheetDialog().getContentPane().removeAll();
                            sheetDisplayContext.getSheetDialog().getContentPane().add(sheetDisplayContext.getSheet());
                            FocusManager.getCurrentManager().addPropertyChangeListener(AbstractCoderStepView.this.fSheetFocusTracker);
                        }
                    }
                });
            }
        }

        private void setSheetExpansionRatio(SheetDisplayContext sheetDisplayContext, double d) {
            if (AbstractCoderStepView.this.fSheetDisplayContext != null && AbstractCoderStepView.this.fSheetDisplayContext.getSheet().equals(sheetDisplayContext.getSheet())) {
                JComponent jComponent = AbstractCoderStepView.this.fApp.getAdvisor().getToolbar().getComponent();
                Point point = jComponent.getLocation();
                point.y += ((Component)jComponent).getHeight();
                SwingUtilities.convertPointToScreen(point, jComponent.getParent());
                Dimension dimension = AbstractCoderStepView.this.getPreferredSheetSize(sheetDisplayContext);
                int n = point.x + 35;
                if (sheetDisplayContext.getSheetAlignment() == 2) {
                    JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(jComponent);
                    Point point2 = jFrame.getContentPane().getLocation();
                    SwingUtilities.convertPointToScreen(point2, jFrame);
                    n = point2.x + 8;
                } else if (sheetDisplayContext.getSheetAlignment() == 4) {
                    n = point.x + ((Component)jComponent).getWidth() - dimension.width;
                }
                sheetDisplayContext.getSheetDialog().setBounds(n, point.y, dimension.width, (int)((double)dimension.height * d));
            }
        }
    }

    private static interface SheetDisplayStrategy {
        public void showSheet(SheetDisplayContext var1, boolean var2);

        public void hideSheet(SheetDisplayContext var1);
    }

    private class SheetPositionTracker
    extends ComponentAdapter {
        private final Window fWindow;

        private SheetPositionTracker(Window window) {
            this.fWindow = window;
            if (window != null) {
                window.addComponentListener(this);
            }
        }

        void dispose() {
            if (this.fWindow != null) {
                this.fWindow.removeComponentListener(this);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.revalidateSheet();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.revalidateSheet();
        }

        private void revalidateSheet() {
            if (AbstractCoderStepView.this.fSheetDisplayContext != null) {
                AbstractCoderStepView.this.fDisplayStrategy.showSheet(AbstractCoderStepView.this.fSheetDisplayContext, true);
            }
        }
    }
}

