/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.screener.CallTreeImpactModel;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.FileImpactModel;
import com.mathworks.toolbox.coder.screener.ImpactModelBuilder;
import com.mathworks.toolbox.coder.screener.MathWorksFileException;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerScore;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.toolbox.coder.screener.StoppableVisitor;
import com.mathworks.util.Holder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ScreenerReportModel {
    private final CallTreeImpactModel fCallTree;
    private final ScreenerScore fScore;
    private final Map<File, Integer> fFileScores = new HashMap<File, Integer>();

    public ScreenerReportModel(File file) {
        this(Arrays.asList(file));
    }

    public ScreenerReportModel(List<File> list) {
        this(list, ScreenerTarget.C);
    }

    public ScreenerReportModel(List<File> list, ScreenerTarget screenerTarget) {
        this.fCallTree = ImpactModelBuilder.buildImpactModel(list, screenerTarget);
        this.fScore = ScreenerReportModel.computeScore(this.fCallTree, null);
    }

    public ScreenerTarget getTarget() {
        return this.fCallTree.getTarget();
    }

    public List<BuildError> getErrors() {
        final LinkedList<BuildError> linkedList = new LinkedList<BuildError>();
        this.fCallTree.visitAll(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                linkedList.addAll(ScreenerReportModel.this.getFileImpact(file).getErrors());
                return true;
            }
        });
        return linkedList;
    }

    public static void validate(Collection<File> collection) {
        for (File file : collection) {
            if (!DependencyFileSystem.isInToolbox(file.getAbsolutePath())) continue;
            throw new MathWorksFileException(file);
        }
    }

    private void getErrors(Collection<File> collection, List<BuildError> list) {
        for (File file : collection) {
            FileImpactModel fileImpactModel = this.getFileImpact(file);
            list.addAll(fileImpactModel.getErrors());
        }
    }

    public Set<File> getNonMathWorksFiles() {
        final HashSet<File> hashSet = new HashSet<File>();
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                hashSet.add(file);
                return true;
            }
        });
        return hashSet;
    }

    public Set<File> getRootFiles() {
        return this.fCallTree.getRootFiles();
    }

    public ScreenerScore getScore() {
        return this.fScore;
    }

    public int getFileScore(File file) {
        Integer n = this.fFileScores.get(file);
        if (n == null) {
            n = ScreenerReportModel.computeScore(this.fCallTree, file).getScore();
            this.fFileScores.put(file, n);
        }
        return n;
    }

    public List<File> getOffendersByImpact(final ScreenerProblemType screenerProblemType) {
        final HashMap hashMap = new HashMap();
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                int n = fileImpactModel.getNodeCount(screenerProblemType);
                if (n != 0) {
                    hashMap.put(file, n);
                }
                return true;
            }
        });
        return ScreenerReportModel.getKeysByImpact(hashMap);
    }

    public List<File> getFunctionInvokersByImpact(final String string) {
        final HashMap hashMap = new HashMap();
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                int n = fileImpactModel.getInvocationNodeCount(string);
                if (n != 0) {
                    hashMap.put(file, n);
                }
                return true;
            }
        });
        return ScreenerReportModel.getKeysByImpact(hashMap);
    }

    public Map<File, Integer> getFunctionInvokersByImpact() {
        final HashMap hashMap = new HashMap();
        final ArrayList<String> arrayList = new ArrayList<String>(this.getFunctionsByImpact().keySet());
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                int n = 0;
                for (String string : arrayList) {
                    n += fileImpactModel.getInvocationNodeCount(string);
                }
                if (n != 0) {
                    hashMap.put(file, n);
                }
                return true;
            }
        });
        return ScreenerReportModel.orderByValue(hashMap);
    }

    public FileImpactModel getFileImpact(File file) {
        return this.fCallTree.getFileImpact(file);
    }

    public int getFunctionInvocationCount(File file, String string) {
        return this.fCallTree.getFileImpact(file).getInvocationNodeCount(string);
    }

    public int getOffenseCount(File file, ScreenerProblemType screenerProblemType) {
        return this.fCallTree.getFileImpact(file).getNodeCount(screenerProblemType);
    }

    public Set<Integer> getOffenseLines(File file, ScreenerProblemType screenerProblemType) {
        return this.fCallTree.getFileImpact(file).getLines(screenerProblemType);
    }

    public int getFunctionInvocationCount(final String string) {
        final Holder holder = new Holder((Object)0);
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                int n = fileImpactModel.getInvocationNodeCount(string);
                holder.set((Object)((Integer)holder.get() + n));
                return true;
            }
        });
        return (Integer)holder.get();
    }

    public int getNonMathWorksFileCount() {
        final Holder holder = new Holder((Object)0);
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                holder.set((Object)((Integer)holder.get() + 1));
                return true;
            }
        });
        return (Integer)holder.get();
    }

    public List<File> getNonMathWorksFilesInvoked(File file) {
        return this.fCallTree.getNonMathWorksFilesInvoked(file);
    }

    public List<File> getMathWorksFilesInvoked(File file) {
        return this.fCallTree.getMathWorksFilesInvoked(file);
    }

    public int getProblemViolationCount(final ScreenerProblemType screenerProblemType) {
        final Holder holder = new Holder((Object)0);
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                int n = fileImpactModel.getNodeCount(screenerProblemType);
                holder.set((Object)((Integer)holder.get() + n));
                return true;
            }
        });
        return (Integer)holder.get();
    }

    public Map<String, Integer> getFunctionsByImpact() {
        final HashMap hashMap = new HashMap();
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                for (String string : fileImpactModel.getInvalidMathworksFunctions()) {
                    int n = fileImpactModel.getInvocationNodeCount(string);
                    Integer n2 = (Integer)hashMap.get(string);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    hashMap.put(string, n2 + n);
                }
                return true;
            }
        });
        return ScreenerReportModel.orderByValue(hashMap);
    }

    public Map<String, Integer> getFunctionsByImpact(File file) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FileImpactModel fileImpactModel = this.fCallTree.getFileImpact(file);
        for (String string : fileImpactModel.getInvalidMathworksFunctions()) {
            int n = fileImpactModel.getInvocationNodeCount(string);
            Integer n2 = (Integer)hashMap.get(string);
            if (n2 == null) {
                n2 = 0;
            }
            hashMap.put(string, n2 + n);
        }
        return ScreenerReportModel.orderByValue(hashMap);
    }

    public List<ScreenerProblemType> getProblemsByImpact() {
        final EnumMap enumMap = new EnumMap(ScreenerProblemType.class);
        for (final ScreenerProblemType screenerProblemType : ScreenerProblemType.values()) {
            this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

                @Override
                public boolean visit(File file) {
                    FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                    int n = fileImpactModel.getNodeCount(screenerProblemType);
                    if (n != 0) {
                        Integer n2 = (Integer)enumMap.get((Object)screenerProblemType);
                        if (n2 == null) {
                            n2 = 0;
                        }
                        enumMap.put(screenerProblemType, n2 + n);
                    }
                    return true;
                }
            });
        }
        return ScreenerReportModel.getKeysByImpact(enumMap);
    }

    public Map<File, Double> getFilePercentages() {
        final HashMap hashMap = new HashMap();
        final Holder holder = new Holder((Object)0);
        this.fCallTree.visitAllNonMathWorks(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = ScreenerReportModel.this.fCallTree.getFileImpact(file);
                hashMap.put(file, fileImpactModel.getNodeCount());
                holder.set((Object)((Integer)holder.get() + fileImpactModel.getNodeCount()));
                return true;
            }
        });
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), (double)((Integer)entry.getValue()).intValue() / (double)((Integer)holder.get()).intValue());
        }
        return ScreenerReportModel.orderByValue(hashMap2);
    }

    public boolean hasDifferentFileScores() {
        final Holder holder = new Holder((Object)false);
        this.fCallTree.visitAll(new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                if (ScreenerReportModel.this.getFileScore(file) != ScreenerReportModel.this.getScore().getScore()) {
                    holder.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)holder.get();
    }

    private static ScreenerScore computeScore(final CallTreeImpactModel callTreeImpactModel, File file) {
        final Holder holder = new Holder((Object)0L);
        final Holder holder2 = new Holder((Object)0L);
        final Holder holder3 = new Holder((Object)0L);
        final Holder holder4 = new Holder((Object)0L);
        final Holder holder5 = new Holder((Object)0L);
        final Holder holder6 = new Holder((Object)0L);
        callTreeImpactModel.visitAllNonMathWorks(file, new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                FileImpactModel fileImpactModel = callTreeImpactModel.getFileImpact(file);
                holder.set((Object)((Long)holder.get() + (long)fileImpactModel.getNodeCount()));
                holder2.set((Object)((Long)holder2.get() + (long)fileImpactModel.getBadNodeCount()));
                holder3.set((Object)((Long)holder3.get() + (long)fileImpactModel.getLineCount()));
                holder4.set((Object)((Long)holder4.get() + (long)fileImpactModel.getBadLineCount()));
                holder5.set((Object)((Long)holder5.get() + 1L));
                if (fileImpactModel.getBadNodeCount() > 0) {
                    holder6.set((Object)((Long)holder6.get() + 1L));
                }
                return true;
            }
        });
        if ((Long)holder5.get() < 5L) {
            holder5.set((Object)0L);
            holder6.set((Object)0L);
        }
        if (((Long)holder.get()).equals(0L)) {
            holder.set((Object)1L);
        }
        if (((Long)holder3.get()).equals(0L)) {
            holder3.set((Object)1L);
        }
        return new ScreenerScore(ScreenerReportModel.computeScore((Long)holder.get(), (Long)holder2.get()), ScreenerReportModel.computeScore((Long)holder3.get(), (Long)holder4.get()), ScreenerReportModel.computeScore((Long)holder5.get(), (Long)holder6.get()));
    }

    private static <K, V extends Comparable<V>> List<K> getKeysByImpact(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                return ((Comparable)entry2.getValue()).compareTo(entry.getValue());
            }
        });
        ArrayList arrayList2 = new ArrayList();
        for (Map.Entry entry : arrayList) {
            arrayList2.add(entry.getKey());
        }
        return arrayList2;
    }

    private static <K, V extends Comparable<V>> Map<K, V> orderByValue(Map<K, V> map) {
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>();
        for (K k : ScreenerReportModel.getKeysByImpact(map)) {
            linkedHashMap.put(k, map.get(k));
        }
        return linkedHashMap;
    }

    private static double computeScore(long l, long l2) {
        if (l == 0L) {
            return Double.NaN;
        }
        return Math.max(1.0, 5.0 - (double)l2 / (double)l * 5.0);
    }
}

