/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.screener.ProjectScreenerModel;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerReportDialog;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ProjectScreenerBar {
    private final MJPanel fComponent;
    private final ProjectScreenerModel fModel;
    private final Configuration fConfiguration;
    private Window fCurrentWindow;
    private HyperlinkTextLabel fLink;
    private MJLabel fStatusLabel;
    private BusyAffordance fBusyAffordance;
    private MJLabel fColor;
    private boolean fLoading;
    private static final Color BACKGROUND = new Color(255, 255, 225);
    private static final Color[] UPPER_LEFT = new Color[]{null, new Color(255, 196, 196), new Color(255, 196, 196), new Color(255, 196, 196), new Color(255, 196, 196), new Color(204, 242, 204)};
    private static final Color[] LOWER_RIGHT = new Color[]{null, new Color(255, 76, 76), new Color(255, 76, 76), new Color(255, 76, 76), new Color(255, 76, 76), new Color(76, 210, 76)};

    public ProjectScreenerBar(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fModel = new ProjectScreenerModel(configuration);
        this.fModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProjectScreenerBar.this.update();
            }
        });
        this.fComponent = new Panel();
        this.fComponent.setOpaque(true);
        this.fStatusLabel = new MJLabel(CoderResources.getString("screener.bar.loading"));
        this.fStatusLabel.setForeground(new Color(80, 80, 80));
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.update();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fModel.dispose();
    }

    private void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ProjectScreenerBar.this.fModel.updateReportAndRun(new Runnable(){

                            @Override
                            public void run() {
                                if (!SwingUtilities.isEventDispatchThread()) {
                                    SwingUtilities.invokeLater(this);
                                    return;
                                }
                                if (ProjectScreenerBar.this.fCurrentWindow != null) {
                                    ProjectScreenerBar.this.fCurrentWindow.dispose();
                                }
                                ProjectScreenerBar.this.fCurrentWindow = ScreenerReportDialog.show(CoderResources.getString("screener.project.title"), ProjectScreenerBar.this.fModel.getReportModel());
                            }
                        });
                    }
                };
                ProjectScreenerBar.this.fComponent.removeAll();
                ProjectScreenerBar.this.fComponent.setBorder(null);
                ScreenerReportModel screenerReportModel = ProjectScreenerBar.this.fModel.getReportModel();
                ProjectScreenerBar.this.fLink = null;
                ProjectScreenerBar.this.fColor = null;
                ProjectScreenerBar.this.fBusyAffordance.stop();
                ProjectScreenerBar.this.fLoading = false;
                if (screenerReportModel == null && !ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint() && !ProjectScreenerBar.this.fConfiguration.getFileSet("fileset.entrypoints").getFiles().isEmpty()) {
                    ProjectScreenerBar.this.fBusyAffordance.start();
                    ProjectScreenerBar.this.fLoading = true;
                    ProjectScreenerBar.this.fComponent.add((Component)ProjectScreenerBar.this.fBusyAffordance.getComponent());
                    ProjectScreenerBar.this.fComponent.add((Component)ProjectScreenerBar.this.fStatusLabel);
                } else if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint() || screenerReportModel != null && screenerReportModel.getScore().getScore() < 5) {
                    if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint()) {
                        ProjectScreenerBar.this.fLink = Utilities.createLink(CoderResources.getString("screener.bar.path.problem"), "link.screener", new Runnable(){

                            @Override
                            public void run() {
                                Target target = ProjectGUI.getInstance().getCurrentProject().getConfiguration().getTarget();
                                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                                MLHelpServices.cshDisplayTopic((Object)ProjectScreenerBar.this.fComponent, (String)string, (String)"help_link_screener_file_resolution");
                            }
                        });
                        ProjectScreenerBar.this.fLink.getComponent().setSize(ProjectScreenerBar.this.fComponent.getWidth(), Integer.MAX_VALUE);
                        ProjectScreenerBar.this.fComponent.setBackground(UIManager.getColor("control"));
                        ProjectScreenerBar.this.fComponent.add((Component)ProjectScreenerBar.this.fLink.getComponent());
                    } else {
                        ProjectScreenerBar.this.fComponent.setBackground(BACKGROUND);
                        ProjectScreenerBar.this.fLink = Utilities.createLink(CoderResources.getString("screener.bar.warning"), "link.screener", runnable);
                        ProjectScreenerBar.this.fColor = new MJLabel(ProjectScreenerBar.createStatusIcon(screenerReportModel));
                        ProjectScreenerBar.this.fColor.setName("screener.bar.label");
                        if (screenerReportModel != null) {
                            ProjectScreenerBar.this.fColor.setToolTipText(ProjectScreenerBar.createToolTipText(screenerReportModel));
                        }
                        ProjectScreenerBar.this.fColor.setVerticalAlignment(0);
                        ProjectScreenerBar.this.fComponent.add((Component)ProjectScreenerBar.this.fColor);
                        ProjectScreenerBar.this.fComponent.add((Component)ProjectScreenerBar.this.fLink.getComponent());
                    }
                }
                ProjectScreenerBar.this.fComponent.revalidate();
                ProjectScreenerBar.this.fComponent.repaint();
            }
        });
    }

    private static Icon createStatusIcon(ScreenerReportModel screenerReportModel) {
        BufferedImage bufferedImage = new BufferedImage(12, 12, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = screenerReportModel == null ? 1 : screenerReportModel.getScore().getScore();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UPPER_LEFT[n], 12.0f, 12.0f, LOWER_RIGHT[n]));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 11.0, 11.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(double_);
        graphics2D.setColor(new Color(128, 128, 128));
        graphics2D.draw(double_);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static String createToolTipText(ScreenerReportModel screenerReportModel) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<html>The following issues were detected:<br>");
        for (ScreenerProblemType screenerProblemType : screenerReportModel.getProblemsByImpact()) {
            printWriter.println("  - " + CoderResources.getString("screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false)) + "<br>");
        }
        printWriter.println("<br>Click the link to see more details.</html>");
        printWriter.close();
        return stringWriter.toString();
    }

    private class Panel
    extends MJPanel
    implements ExplicitColorAndFontProvider {
        private HyperlinkTextLabel fLastLink;
        private int fLastWidth;

        Panel() {
            this.setLayout(null);
        }

        public void doLayout() {
            super.doLayout();
            if (ProjectScreenerBar.this.fLink != null) {
                Dimension dimension = ProjectScreenerBar.this.fLink.getComponent().getPreferredSize();
                int n = 2;
                if (ProjectScreenerBar.this.fColor != null) {
                    Dimension dimension2 = ProjectScreenerBar.this.fColor.getPreferredSize();
                    ProjectScreenerBar.this.fColor.setBounds(2, 5, dimension2.width, dimension2.height);
                    n = dimension2.width + 4;
                }
                ProjectScreenerBar.this.fLink.getComponent().setBounds(n, 2, this.getWidth() - n, dimension.height);
                if (ProjectScreenerBar.this.fLink != this.fLastLink || this.getWidth() != this.fLastWidth) {
                    this.fLastLink = ProjectScreenerBar.this.fLink;
                    this.fLastWidth = this.getWidth();
                    this.revalidate();
                    this.repaint();
                }
            } else {
                Dimension dimension = ProjectScreenerBar.this.fStatusLabel.getPreferredSize();
                ProjectScreenerBar.this.fBusyAffordance.getComponent().setBounds(2, 2, 16, 16);
                ProjectScreenerBar.this.fStatusLabel.setBounds(20, 2, dimension.width, dimension.height);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(UIManager.getColor("control"));
            graphics.fillRect(0, this.getHeight() - 4, this.getWidth(), this.getHeight());
        }

        public Dimension getPreferredSize() {
            if (ProjectScreenerBar.this.fLoading) {
                Dimension dimension = ProjectScreenerBar.this.fStatusLabel.getPreferredSize();
                int n = dimension.width + 20;
                if (ProjectScreenerBar.this.fColor != null) {
                    Dimension dimension2 = ProjectScreenerBar.this.fColor.getPreferredSize();
                    n += dimension2.width + 4;
                }
                return new Dimension(n, dimension.height + 8);
            }
            if (ProjectScreenerBar.this.fLink != null) {
                Dimension dimension = ProjectScreenerBar.this.fLink.getComponent().getPreferredSize();
                return new Dimension(dimension.width + 2, dimension.height + 8);
            }
            return new Dimension(0, 0);
        }
    }
}

