/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.toolbox.coder.plugin.inputtypes.CStructProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.FiMathProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.NumericTypeProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinder;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinderCellEditorFactory;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinderNameColumn;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinderValueColumn;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class InputAttributesTable {
    private final PropertyTableModel<PropertyBinder> fModel;
    private final PropertyTable<PropertyBinder> fTable;
    private final IDPAttributes fAttributes;
    private final ChangeListener fChangeListener;
    private final Set<PropertyBinder> fHiddenProperties;
    private static final String FILTER = "_filter";

    public InputAttributesTable(InputDataProperty inputDataProperty, IDPAttributes iDPAttributes) {
        double[] dArray;
        this.fAttributes = iDPAttributes;
        this.fHiddenProperties = new HashSet<PropertyBinder>();
        List<AbstractPropertyTableColumn> list = Arrays.asList(new AbstractPropertyTableColumn[]{new PropertyBinderNameColumn(), new PropertyBinderValueColumn(iDPAttributes)});
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.fChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InputAttributesTable.this.updateFilter();
                InputAttributesTable.this.fTable.getComponent().revalidate();
                InputAttributesTable.this.fTable.getComponent().repaint();
            }
        };
        Object object2 = new Predicate<PropertyBinder>(){

            public boolean accept(PropertyBinder propertyBinder) {
                return true;
            }
        };
        if (this.fAttributes.isFixedPoint()) {
            PropertyTableNode object = new PropertyTableNode(null, true, "numerictype");
            PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, "fimath");
            for (NumericTypeProperty numericTypeProperty : NumericTypeProperty.values()) {
                InputAttributesTable.createNode((PropertyTableNode<PropertyBinder>)object, numericTypeProperty.getBinder());
                numericTypeProperty.getBinder().addChangeListener(this.fChangeListener);
            }
            for (Enum enum_ : FiMathProperty.values()) {
                InputAttributesTable.createNode((PropertyTableNode<PropertyBinder>)propertyTableNode, ((FiMathProperty)enum_).getBinder());
                ((FiMathProperty)enum_).getBinder().addChangeListener(this.fChangeListener);
            }
            arrayList.add(object);
            arrayList.add(propertyTableNode);
        } else if (iDPAttributes.isStruct()) {
            for (CStructProperty cStructProperty : CStructProperty.values()) {
                arrayList.add(InputAttributesTable.createNode(null, cStructProperty.getBinder()));
            }
            object2 = new Predicate<PropertyBinder>(){

                public boolean accept(PropertyBinder propertyBinder) {
                    boolean bl = InputAttributesTable.this.fAttributes.hasCStructNameTypeName();
                    boolean bl2 = InputAttributesTable.this.fAttributes.isCStructNameExtern() && bl;
                    return propertyBinder.equals(CStructProperty.C_NAME.getBinder()) || propertyBinder.equals(CStructProperty.EXTERNAL.getBinder()) && bl || bl2;
                }
            };
        }
        PropertyTableSearchPredicate<PropertyBinder> propertyTableSearchPredicate = new PropertyTableSearchPredicate<PropertyBinder>(){

            public boolean accept(PropertyBinder propertyBinder, String string) {
                return !InputAttributesTable.this.fHiddenProperties.contains(propertyBinder);
            }
        };
        this.fModel = new PropertyTableModel(list, new Runnable(){

            @Override
            public void run() {
            }
        }, (Predicate)object2, (PropertyTableSearchPredicate)propertyTableSearchPredicate, arrayList);
        this.fModel.expandAll();
        this.fTable = new PropertyTable(this.fModel, (PropertyTableCellEditorFactory)new PropertyBinderCellEditorFactory(inputDataProperty, this.fAttributes));
        if (iDPAttributes.isStruct()) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.7;
            dArray = dArray2;
            dArray2[1] = 0.3;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.4;
            dArray = dArray3;
            dArray3[1] = 0.6;
        }
        this.fTable.setColumnWeights(dArray);
        this.fTable.setHeaderVisible(false);
        this.updateFilter();
        this.fModel.setSearchText(FILTER);
    }

    public JComponent getComponent() {
        return this.fTable.getComponent();
    }

    public void dispose() {
        for (NumericTypeProperty enum_ : NumericTypeProperty.values()) {
            enum_.getBinder().removeChangeListener(this.fChangeListener);
        }
        for (Enum enum_ : FiMathProperty.values()) {
            ((FiMathProperty)enum_).getBinder().removeChangeListener(this.fChangeListener);
        }
    }

    private void updateFilter() {
        boolean bl;
        this.fHiddenProperties.clear();
        if (this.fAttributes.getNumericType() == null) {
            return;
        }
        if (!this.fAttributes.getNumericType().hasSignednessAndWordLength()) {
            this.fHiddenProperties.add(NumericTypeProperty.SIGNEDNESS_MODE.getBinder());
            this.fHiddenProperties.add(NumericTypeProperty.WORD_LENGTH.getBinder());
        }
        if (!this.fAttributes.getNumericType().hasFractionLength()) {
            this.fHiddenProperties.add(NumericTypeProperty.FRACTION_LENGTH.getBinder());
        }
        if (!this.fAttributes.getNumericType().hasSlopeAndBias()) {
            this.fHiddenProperties.add(NumericTypeProperty.SLOPE.getBinder());
            this.fHiddenProperties.add(NumericTypeProperty.BIAS.getBinder());
        }
        if (!this.fAttributes.getFimath().getFimathIsLocal().booleanValue()) {
            this.fHiddenProperties.add(FiMathProperty.ROUNDING_METHOD.getBinder());
            this.fHiddenProperties.add(FiMathProperty.PRODUCT_MODE.getBinder());
            this.fHiddenProperties.add(FiMathProperty.SUM_MODE.getBinder());
            this.fHiddenProperties.add(FiMathProperty.OVERFLOW_ACTION.getBinder());
        }
        boolean bl2 = bl = this.fAttributes.getFimath().getSumMode() != FimathPanel.PrecisionMode.FULL_PRECISION;
        if (!this.fAttributes.getFimath().getFimathIsLocal().booleanValue() || !bl) {
            this.fHiddenProperties.add(FiMathProperty.CAST_BEFORE_SUM.getBinder());
        }
        this.updatePrecisionFilter(FiMathProperty.PRODUCT_MODE, FiMathProperty.PRODUCT_WORD_LENGTH, FiMathProperty.PRODUCT_FRACTION_LENGTH);
        this.updatePrecisionFilter(FiMathProperty.SUM_MODE, FiMathProperty.SUM_WORD_LENGTH, FiMathProperty.SUM_FRACTION_LENGTH);
        this.fTable.setSearchText(FILTER);
    }

    private void updatePrecisionFilter(FiMathProperty fiMathProperty, FiMathProperty fiMathProperty2, FiMathProperty fiMathProperty3) {
        boolean bl = this.fAttributes.getFimath().getFimathIsLocal();
        Object object = fiMathProperty.getBinder().getData(this.fAttributes);
        boolean bl2 = object != FimathPanel.PrecisionMode.FULL_PRECISION;
        boolean bl3 = object == FimathPanel.PrecisionMode.SPECIFY_PRECISION;
        if (!bl | !bl2) {
            this.fHiddenProperties.add(fiMathProperty2.getBinder());
        }
        if (!bl || !bl3) {
            this.fHiddenProperties.add(fiMathProperty3.getBinder());
        }
    }

    private static PropertyTableNode<PropertyBinder> createNode(PropertyTableNode<PropertyBinder> propertyTableNode, PropertyBinder propertyBinder) {
        return new PropertyTableNode(propertyTableNode, propertyBinder.getType() == Boolean.class || propertyBinder.getType().isEnum(), Arrays.asList(propertyBinder));
    }
}

