/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jidesoft.swing.MultilineLabel;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MatlabRequest;
import com.mathworks.mvm.exec.MvmSwingWorker;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class InstrumentationUtils {
    private static final String PROPOSE_FIXED_POINT_DATA_TYPES_KEY = "param.ProposeFixedPointDataTypes";
    private static final String FIXED_POINT_TYPE_PROPOSAL_MODE_KEY = "param.FixedPointTypeProposalMode";
    private static final String DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY = "param.DefaultProposedFixedPointType";
    private static final String MIN_MAX_SAFETY_MARGIN_KEY = "param.MinMaxSafetyMargin";
    private static final String OPTIMIZE_WHOLE_NUMBERS_KEY = "param.OptimizeWholeNumbers";
    public static final String WORD_LENGTH_OPTION_KEY = "option.FixedPointTypeProposalMode.ProposeWordLengths";
    public static final String FRACTION_LENGTH_OPTION_KEY = "option.FixedPointTypeProposalMode.ProposeFractionLengths";

    private InstrumentationUtils() {
    }

    public static Param getProposeFixedPointDataTypesParam(Configuration configuration) {
        return configuration.getTarget().getParam(PROPOSE_FIXED_POINT_DATA_TYPES_KEY);
    }

    public static Param getFixedPointTypeProposalModeParam(Configuration configuration) {
        return configuration.getTarget().getParam(FIXED_POINT_TYPE_PROPOSAL_MODE_KEY);
    }

    public static Param getDefaultProposedFixedPointTypeParam(Configuration configuration) {
        return configuration.getTarget().getParam(DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY);
    }

    public static Param getMinMaxSafetyMarginParam(Configuration configuration) {
        return configuration.getTarget().getParam(MIN_MAX_SAFETY_MARGIN_KEY);
    }

    public static Param getOptimizeWholeNumbersParam(Configuration configuration) {
        return configuration.getTarget().getParam(OPTIMIZE_WHOLE_NUMBERS_KEY);
    }

    public static List<String> convertSettingsToFlags(Configuration configuration) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (configuration.getParamAsBoolean(PROPOSE_FIXED_POINT_DATA_TYPES_KEY)) {
            if (configuration.getParamAsString(FIXED_POINT_TYPE_PROPOSAL_MODE_KEY).equals(WORD_LENGTH_OPTION_KEY)) {
                linkedList.add("-proposeWL");
            } else {
                linkedList.add("-proposeFL");
            }
            String string = configuration.getParamAsString(DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY);
            if (!string.equals("Remain floating-point")) {
                linkedList.add("-defaultDT");
                linkedList.add(string);
            }
            linkedList.add("-percentSafetyMargin");
            linkedList.add(Integer.toString(configuration.getParamAsInt(MIN_MAX_SAFETY_MARGIN_KEY)));
            if (configuration.getParamAsBoolean(OPTIMIZE_WHOLE_NUMBERS_KEY)) {
                linkedList.add("-optimizeWholeNumbers");
            }
        }
        if (configuration.getParamAsBoolean("param.OpenInstrumentationReportInBrowser")) {
            linkedList.add("-browser");
        }
        if (configuration.getParamAsBoolean("param.CreatePrintableInstrumentationReport")) {
            linkedList.add("-printable");
        }
        return linkedList;
    }

    public static void terminateVerification(String string, final @Nullable Runnable runnable) {
        new Matlab().fevalConsoleOutput("coder.internal.terminateVerification", new Object[]{string}, 0, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (runnable != null) {
                    MJUtilities.runOnEventDispatchThread((Runnable)runnable);
                }
            }
        });
    }

    public static void clearResults(Configuration configuration, @Nullable Runnable runnable) {
        InstrumentationUtils.runVoidMatlabFunction("clearInstrumentationResults", false, runnable, configuration.getParamAsString("param.mex.outputfile"));
    }

    public static void isSilPilWrapperLoaded(final String string, final ParameterRunnable<Boolean> parameterRunnable) {
        InstrumentationUtils.runMatlabFunctionWithoutError("inmem", new ParameterRunnable<Object[]>(){

            public void run(Object[] objectArray) {
                if (objectArray != null && objectArray.length >= 2 && objectArray[1] instanceof String[]) {
                    parameterRunnable.run((Object)InstrumentationUtils.isMexListed(string, (String[])objectArray[1]));
                } else {
                    parameterRunnable.run((Object)false);
                }
            }
        }, 2, "-completenames");
    }

    public static void hasInstrumentationResults(Configuration configuration, final ParameterRunnable<Boolean> parameterRunnable) {
        InstrumentationUtils.runMatlabFunctionWithoutError("fixed.internal.InstrumentationManager.getResults", new ParameterRunnable<Object>(){

            public void run(Object object) {
                parameterRunnable.run((Object)(object != null ? 1 : 0));
            }
        }, 1, configuration.getParamAsString("param.mex.outputfile"));
    }

    private static boolean isMexListed(String string, String[] stringArray) {
        File file = new File(string);
        for (String string2 : stringArray) {
            if (!file.equals(new File(string2))) continue;
            return true;
        }
        return false;
    }

    private static <T> void runMatlabFunctionWithoutError(String string, final ParameterRunnable<T> parameterRunnable, int n, Object ... objectArray) {
        MvmSwingWorker mvmSwingWorker = new MvmSwingWorker<T>((FutureResult)MvmContext.get().getExecutor().submit(new MatlabFevalRequest(string, Integer.valueOf(n), MatlabRequest.NULL_WRITER, MatlabRequest.NULL_WRITER, objectArray))){

            protected void done() {
                try {
                    parameterRunnable.run(this.get());
                }
                catch (ExecutionException executionException) {
                    parameterRunnable.run(null);
                }
            }
        };
        mvmSwingWorker.runWhenReady();
    }

    private static void runVoidMatlabFunction(String string, boolean bl, final @Nullable Runnable runnable, Object ... objectArray) {
        StringWriter stringWriter = bl ? null : new StringWriter();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(string, Integer.valueOf(0), (Writer)stringWriter, (Writer)stringWriter, objectArray);
        FutureFevalResult futureFevalResult = MvmContext.get().getExecutor().submit(matlabFevalRequest);
        MvmSwingWorker<Object> mvmSwingWorker = new MvmSwingWorker<Object>((FutureResult)futureFevalResult){

            protected void done() {
                try {
                    this.get();
                }
                catch (ExecutionException executionException) {
                    InstrumentationUtils.showError(executionException);
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        mvmSwingWorker.runWhenReady();
    }

    public static boolean isInstrumentedMex(Configuration configuration) {
        String string = configuration.getParamAsString("param.artifact");
        return string.equals("option.target.artifact.mex.instrumented");
    }

    public static void showReport(Configuration configuration, final BusyAffordance busyAffordance, String ... stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        busyAffordance.start();
        busyAffordance.getComponent().setVisible(true);
        linkedList.add(configuration.getParamAsString("param.mex.outputfile"));
        linkedList.addAll(Arrays.asList(stringArray));
        linkedList.addAll(InstrumentationUtils.convertSettingsToFlags(configuration));
        InstrumentationUtils.runVoidMatlabFunction("showInstrumentationResults", true, new Runnable(){

            @Override
            public void run() {
                busyAffordance.stop();
                busyAffordance.getComponent().setVisible(false);
            }
        }, linkedList.toArray(new String[linkedList.size()]));
    }

    private static void showError(final ExecutionException executionException) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)MLDesktop.getInstance().getMainFrame(), (Object)((Object)new WrappingMessage(executionException.getLocalizedMessage())), (String)CoderResources.getString("instrumentation.report.error.title"), (int)0);
            }
        });
    }

    private static class WrappingMessage
    extends MJPanel {
        WrappingMessage(String string) {
            this.setLayout(new BorderLayout());
            this.add((Component)new MultilineLabel(string));
        }

        public Dimension getPreferredSize() {
            return new Dimension(375, 100);
        }
    }
}

