/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.jmi.MatlabException;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.explorer.extensions.matlab.Variable;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.ImportExportUtils;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestQueue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class ImportAction
extends ProjectAction {
    private final Component fDialogParent;
    private final RequestQueue fBackgroundThread;
    public static final String KEY = "IMPORT_CONFIG_OBJECT";

    public ImportAction(Component component) {
        super(KEY, CoderResources.getString("action.importConfigObject"), CoderResources.getIcon("import.png"));
        this.fDialogParent = component;
        this.fBackgroundThread = new RequestQueue("MATLAB Coder settings import thread");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fBackgroundThread.request(new Runnable(){

            @Override
            public void run() {
                List list = MATFileUtils.getWorkspaceVariables();
                final HashSet<String> hashSet = new HashSet<String>();
                for (Variable variable : list) {
                    if (!variable.getType().equals("coder.MexCodeConfig") && !variable.getType().equals("coder.CodeConfig") && !variable.getType().equals("coder.EmbeddedCodeConfig")) continue;
                    hashSet.add(variable.getName());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportAction.this.showDialog(hashSet);
                    }
                });
            }
        });
    }

    public void showDialog(Set<String> set) {
        String string3;
        Window window = SwingUtilities.windowForComponent(this.fDialogParent);
        String string2 = CoderResources.getString("import.settings.title");
        final MJDialog mJDialog = window instanceof Frame ? new MJDialog((Frame)window, string2) : new MJDialog((Dialog)window, string2);
        mJDialog.setName("import.settings.dialog");
        MJLabel mJLabel = new MJLabel(CoderResources.getString("import.settings.desc"));
        MJHelpButton mJHelpButton = new MJHelpButton();
        MJButton mJButton = new MJButton(BuiltInResources.getString((String)"button.ok"));
        mJButton.setName("import.settings.button.ok");
        MJButton mJButton2 = new MJButton(BuiltInResources.getString((String)"button.cancel"));
        mJButton2.setName("import.settings.button.cancel");
        MJLabel mJLabel2 = new MJLabel();
        mJLabel2.setHorizontalAlignment(0);
        JPanel jPanel = ButtonBarFactory.buildHelpBar((JButton)mJHelpButton, (JButton)mJButton, (JButton)mJButton2);
        MJLabel mJLabel3 = new MJLabel(CoderResources.getString("import.settings.varname.label"));
        mJHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = ProjectGUI.getInstance().getCurrentProject().getConfiguration().getTarget();
                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                MLHelpServices.cshDisplayTopic((Object)ImportAction.this.fDialogParent, (String)string, (String)"help_button_import_settings");
            }
        });
        final MJComboBox mJComboBox = new MJComboBox();
        mJComboBox.setName("import.settings.combobox");
        for (String string3 : set) {
            mJComboBox.addItem((Object)string3);
        }
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportExportUtils.importCurrentProjectSettings((String)mJComboBox.getSelectedItem(), new ParameterRunnable<MatlabException>(){

                    public void run(MatlabException matlabException) {
                        MJOptionPane.showMessageDialog((Component)mJDialog, (Object)matlabException.getMessage(), (String)CoderResources.getString("import.settings.title"), (int)0);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        mJDialog.dispose();
                    }
                });
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJDialog.dispose();
            }
        });
        mJDialog.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = Utilities.getDialogBannerInsets();
        gridBagConstraints.insets.left = Utilities.getDialogButtonBarInsets().left + 2;
        gridBagConstraints.insets.right = Utilities.getDialogButtonBarInsets().right;
        mJDialog.add((Component)mJLabel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 4;
        if (PlatformInfo.isMacintosh()) {
            string3 = new MJPanel((LayoutManager)new FlowLayout(1));
            string3.add((Component)mJLabel3);
            string3.add((Component)mJComboBox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            mJDialog.add((Component)((Object)string3), (Object)gridBagConstraints);
            gridBagConstraints.fill = 2;
        } else {
            mJDialog.add((Component)mJLabel3, (Object)gridBagConstraints);
            gridBagConstraints.insets.right = gridBagConstraints.insets.left;
            gridBagConstraints.insets.left = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridx;
            mJDialog.add((Component)mJComboBox, (Object)gridBagConstraints);
        }
        if (set.isEmpty()) {
            mJComboBox.addItem((Object)CoderResources.getString("error.import.no.variables"));
            mJComboBox.setEnabled(false);
            mJButton.setEnabled(false);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        string3 = new MJPanel();
        string3.setOpaque(false);
        mJDialog.add((Component)((Object)string3), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = Utilities.getDialogButtonBarInsets();
        mJDialog.add((Component)jPanel, (Object)gridBagConstraints);
        mJDialog.pack();
        mJDialog.setResizable(false);
        mJDialog.getRootPane().setDefaultButton((JButton)mJButton);
        mJDialog.setLocationRelativeTo((Component)window);
        mJDialog.setVisible(true);
    }
}

