/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class HardwareImplementationWidget
implements ProjectComponent {
    private final Project fProject;
    private final Configuration fConfiguration;
    private final PropertyTable<Param> fTable;
    private final MJLabel fCodeReplacementLibraryWarningLabel;
    private final MJLabel fSizeErrorLabel;
    private final MJPanel fSizeErrorLabelContainer;
    private final ParamWidgetBinder fBinder;
    private final PropertyChangeListener fPropertyChangeListener;
    private final BusyAffordance fBusyAffordance;
    private MJPanel fComponent;
    private Timer fTimer;
    private volatile int fUpdateCount;
    private static final String TARGET_INSTANCE_KEY = "Target";
    private static final String PRODUCTION_INSTANCE_KEY = "Production";
    private static final String SAME_HARDWARE_FLAG_KEY = "param.SameHardware";
    private static final String TARGET_LANG_STANDARD_KEY = "param.TargetLangStandard";
    private static final String TARGET_LANG_KEY = "param.TargetLang";
    private static final String DEPRECATED_CRL_FLAG_KEY = "param.DeprecatedCRLFlag";
    private static final String CODE_REPLACEMENT_LIBRARY_KEY = "param.CodeReplacementLibrary";
    private static final String HARDWARE_VENDOR_KEY_PREFIX = "param.HardwareVendor.";
    private static final String HARDWARE_TYPE_KEY_PREFIX = "param.HardwareType.";
    private static final String HARDWARE_SIZE_KEY_PREFIX = "param.HardwareSize";
    private static final String RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX = "param.HardwareArithmeticRightShift.";
    private static final String ENDIANNESS_KEY_PREFIX = "param.HardwareEndianness.";
    private static final String ENDIANNESS_OPTION_PREFIX = "option.HardwareEndianness.";
    private static final String ATOMIC_INTEGER_KEY_PREFIX = "param.HardwareAtomicIntegerSize.";
    private static final String ENABLE_LONG_LONG_KEY_PREFIX = "param.HardwareLongLongMode.";
    private static final String ATOMIC_INTEGER_OPTION_PREFIX = "option.HardwareAtomicIntegerSize.";
    private static final String ATOMIC_FLOAT_KEY_PREFIX = "param.HardwareAtomicFloatSize.";
    private static final String ATOMIC_FLOAT_OPTION_PREFIX = "option.HardwareAtomicFloatSize.";
    private static final String INTEGER_DIVISION_ROUNDING_KEY_PREFIX = "param.HardwareDivisionRounding.";
    private static final String INTEGER_DIVISION_ROUNDING_OPTION_PREFIX = "option.HardwareDivisionRounding.";
    private static final String ASIC_DEVICE = "ASIC/FPGA";
    private static final String[] TYPE_NAMES = new String[]{"Char", "Short", "Int", "Long", "LongLong", "Float", "Double", "Pointer", "Word"};

    public HardwareImplementationWidget(WritableConfiguration writableConfiguration) {
        this(writableConfiguration, false);
    }

    public HardwareImplementationWidget(WritableConfiguration writableConfiguration, boolean bl) {
        Font font;
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fProject = this.fConfiguration.getProject();
        this.fCodeReplacementLibraryWarningLabel = new MJLabel();
        this.fSizeErrorLabel = new MJLabel();
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fSizeErrorLabelContainer = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fSizeErrorLabelContainer.add((Component)this.fSizeErrorLabel);
        this.fSizeErrorLabelContainer.setOpaque(false);
        if (PlatformInfo.isMacintosh()) {
            font = this.fCodeReplacementLibraryWarningLabel.getFont();
            this.fCodeReplacementLibraryWarningLabel.setFont(font.deriveFont((float)font.getSize() - 1.0f));
            this.fSizeErrorLabel.setFont(this.fCodeReplacementLibraryWarningLabel.getFont());
        }
        this.fBinder = new ParamWidgetBinder(this.fProject, false);
        font = this.fConfiguration.getTarget().getParamSet("paramset.hardware");
        if (font == null) {
            font = this.fConfiguration.getTarget().getParamSet("paramset.c.hardware");
        }
        List<Param> list = HardwareImplementationWidget.findTableParams((ParamSet)font);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new NameColumn());
        arrayList.add(new ValueColumn(this.fConfiguration, CoderResources.getString("hardware.column.production")));
        arrayList.add(new ValueColumn(this.fConfiguration, CoderResources.getString("hardware.column.test")));
        this.fTable = SettingsTableUtils.createTable((Configuration)this.fConfiguration, (ParamSet)font, list, Arrays.asList(PRODUCTION_INSTANCE_KEY, TARGET_INSTANCE_KEY), arrayList);
        this.fTable.setName("hardware.table");
        this.fTable.setPreferToShowAllRows(true);
        this.fTable.setColumnWeights(new double[]{0.48, 0.26, 0.26});
        this.fTable.setNoStretch(true);
        if (bl) {
            this.setupMcosLayout();
        } else if (PlatformInfo.isMacintosh()) {
            this.setupMacLayout();
        } else {
            this.setupWindowsLayout();
        }
        if (this.fConfiguration.getParamAsBoolean(SAME_HARDWARE_FLAG_KEY)) {
            this.fTable.foldInLastColumn(true);
        }
        if (this.fConfiguration.getParamAsBoolean(DEPRECATED_CRL_FLAG_KEY)) {
            this.fConfiguration.setParamAsBoolean(DEPRECATED_CRL_FLAG_KEY, false);
            this.setInitialTargetLangStandard();
        }
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HardwareImplementationWidget.this.fUpdateCount >= 2 && propertyChangeEvent.getPropertyName().startsWith(HardwareImplementationWidget.HARDWARE_TYPE_KEY_PREFIX)) {
                    for (String string : new String[]{HardwareImplementationWidget.TARGET_INSTANCE_KEY, HardwareImplementationWidget.PRODUCTION_INSTANCE_KEY}) {
                        for (int i = 0; i < TYPE_NAMES.length; ++i) {
                            String string2 = HardwareImplementationWidget.HARDWARE_SIZE_KEY_PREFIX + TYPE_NAMES[i] + "." + string;
                            HardwareImplementationWidget.this.fConfiguration.setParamAsObject(string2, HardwareImplementationWidget.this.fConfiguration.getParamDefaultValue(string2));
                        }
                        String i = HardwareImplementationWidget.ENABLE_LONG_LONG_KEY_PREFIX + string;
                        HardwareImplementationWidget.this.fConfiguration.setParamAsObject(i, HardwareImplementationWidget.this.fConfiguration.getParamDefaultValue(i));
                    }
                    String string = propertyChangeEvent.getPropertyName().substring(HardwareImplementationWidget.HARDWARE_TYPE_KEY_PREFIX.length());
                    HardwareImplementationWidget.this.updateHardwareDetails(string, true, false);
                } else if (propertyChangeEvent.getPropertyName().equals("param.HardwareVendor.Production") && propertyChangeEvent.getNewValue().equals(HardwareImplementationWidget.ASIC_DEVICE)) {
                    HardwareImplementationWidget.this.fConfiguration.setParamAsBoolean(HardwareImplementationWidget.SAME_HARDWARE_FLAG_KEY, false);
                } else if (propertyChangeEvent.getPropertyName().equals(HardwareImplementationWidget.SAME_HARDWARE_FLAG_KEY)) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        HardwareImplementationWidget.this.fTable.foldInLastColumn(false);
                    } else {
                        HardwareImplementationWidget.this.fTable.foldOutLastColumn();
                        HardwareImplementationWidget.this.updateHardwareDetails(HardwareImplementationWidget.TARGET_INSTANCE_KEY, false, false);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY)) {
                    HardwareImplementationWidget.this.updateCodeReplacementLibraryWarning();
                } else if (propertyChangeEvent.getPropertyName().startsWith(HardwareImplementationWidget.HARDWARE_SIZE_KEY_PREFIX)) {
                    HardwareImplementationWidget.this.updateSizeError();
                } else if (propertyChangeEvent.getPropertyName().equals(HardwareImplementationWidget.TARGET_LANG_KEY)) {
                    HardwareImplementationWidget.this.fConfiguration.refreshParamOptions(HardwareImplementationWidget.TARGET_LANG_STANDARD_KEY);
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.updateHardwareDetails(TARGET_INSTANCE_KEY, false, bl);
        this.updateHardwareDetails(PRODUCTION_INSTANCE_KEY, false, bl);
        this.updateCodeReplacementLibraryWarning();
        this.updateSizeError();
        if (!this.fConfiguration.areOptionsReallyLoaded(CODE_REPLACEMENT_LIBRARY_KEY)) {
            this.setCRLClientsEnabled(false);
            this.fConfiguration.forceEnumOptionLoad(CODE_REPLACEMENT_LIBRARY_KEY);
            this.fTimer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HardwareImplementationWidget.this.fConfiguration.areOptionsReallyLoaded(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY)) {
                        HardwareImplementationWidget.this.setCRLClientsEnabled(true);
                        HardwareImplementationWidget.this.fTimer.stop();
                        HardwareImplementationWidget.this.fTimer = null;
                    }
                }
            });
            this.fTimer.setRepeats(true);
            this.fTimer.start();
        } else {
            this.setCRLClientsEnabled(true);
        }
    }

    private void setCRLClientsEnabled(boolean bl) {
        this.fConfiguration.setForcedDisabled(CODE_REPLACEMENT_LIBRARY_KEY, !bl);
        this.fConfiguration.setForcedDisabled(SAME_HARDWARE_FLAG_KEY, !bl);
        this.fTable.setEnabled(bl);
        if (bl) {
            this.fBusyAffordance.stop();
        } else {
            this.fBusyAffordance.start();
        }
    }

    private void updateCodeReplacementLibraryWarning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string = HardwareImplementationWidget.this.fConfiguration.getParamAsString(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY);
                if (HardwareImplementationWidget.this.fConfiguration.areOptionsReallyLoaded(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY) && !HardwareImplementationWidget.this.fConfiguration.getParamOptions(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY).getOptions().containsKey(string)) {
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setText(CoderResources.getString("msg.crl.notRegistered"));
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setIcon((Icon)DialogIcon.WARNING_12x12.getIcon());
                } else {
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setText("");
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setIcon(null);
                }
            }
        });
    }

    private void updateSizeError() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                List list = HardwareImplementationWidget.this.fConfiguration.getTarget().validate(HardwareImplementationWidget.this.fConfiguration.getProject());
                for (ValidationMessage validationMessage : list) {
                    if (validationMessage.getParamKey() == null || !validationMessage.getParamKey().startsWith(HardwareImplementationWidget.HARDWARE_SIZE_KEY_PREFIX)) continue;
                    HardwareImplementationWidget.this.fSizeErrorLabel.setText(validationMessage.getText());
                    HardwareImplementationWidget.this.fSizeErrorLabel.setIcon((Icon)DialogIcon.ERROR_12x12.getIcon());
                    if (!PlatformInfo.isMacintosh()) {
                        HardwareImplementationWidget.this.fSizeErrorLabel.setBorder((Border)new LineBorder(Color.RED));
                    }
                    HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBorder((Border)new EmptyBorder(4, 0, 1, 0));
                    HardwareImplementationWidget.this.fSizeErrorLabel.setOpaque(true);
                    HardwareImplementationWidget.this.fSizeErrorLabel.setBackground(new Color(230, 180, 180));
                    return;
                }
                HardwareImplementationWidget.this.fSizeErrorLabel.setText("");
                HardwareImplementationWidget.this.fSizeErrorLabel.setIcon(null);
                HardwareImplementationWidget.this.fSizeErrorLabel.setBorder(null);
                HardwareImplementationWidget.this.fSizeErrorLabel.setOpaque(false);
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBorder(null);
            }
        });
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fTable.dispose();
        this.fBinder.dispose();
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
        }
    }

    private void setInitialTargetLangStandard() {
        new Matlab().fevalConsoleOutput("coder.internal.getTargetLangStdFromCrl", new Object[]{this.fConfiguration.getParamAsString(CODE_REPLACEMENT_LIBRARY_KEY)}, 1, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) == 0 && object != null && !object.toString().trim().isEmpty()) {
                    HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.TARGET_LANG_STANDARD_KEY, object.toString());
                }
            }
        });
    }

    private void updateHardwareDetails(final String string, final boolean bl, boolean bl2) {
        String string2 = this.fConfiguration.getParamAsString(HARDWARE_VENDOR_KEY_PREFIX + string);
        String string3 = this.fConfiguration.getParamAsString(HARDWARE_TYPE_KEY_PREFIX + string);
        new Matlab().fevalConsoleOutput("emlcprivate", new Object[]{"getHardwareDetails", string2, string3}, TYPE_NAMES.length + 7, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) == 0 && object != null) {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < TYPE_NAMES.length; ++i) {
                        HardwareImplementationWidget.this.setSizeParam(objectArray, i, TYPE_NAMES[i], string);
                    }
                    String string5 = (String)objectArray[TYPE_NAMES.length];
                    if (string5.endsWith("Endian")) {
                        string5 = string5.substring(0, string5.indexOf("Endian"));
                    }
                    boolean bl3 = ((boolean[])objectArray[TYPE_NAMES.length + 1])[0];
                    String string2 = (String)objectArray[TYPE_NAMES.length + 2];
                    String string3 = (String)objectArray[TYPE_NAMES.length + 3];
                    String string4 = (String)objectArray[TYPE_NAMES.length + 4];
                    HardwareImplementationWidget.this.fConfiguration.setParamAsBoolean(HardwareImplementationWidget.RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX + string, bl3);
                    HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ENDIANNESS_KEY_PREFIX + string, HardwareImplementationWidget.ENDIANNESS_OPTION_PREFIX + string5);
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string, HardwareImplementationWidget.ATOMIC_INTEGER_OPTION_PREFIX + string2);
                    }
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string, HardwareImplementationWidget.ATOMIC_FLOAT_OPTION_PREFIX + string3);
                    }
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string, HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_OPTION_PREFIX + string4);
                    }
                    boolean bl2 = ((boolean[])objectArray[TYPE_NAMES.length + 5])[0];
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.ENABLE_LONG_LONG_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsBoolean(HardwareImplementationWidget.ENABLE_LONG_LONG_KEY_PREFIX + string, bl2);
                    }
                    boolean[] blArray = (boolean[])objectArray[TYPE_NAMES.length + 6];
                    for (int i = 0; i < TYPE_NAMES.length; ++i) {
                        HardwareImplementationWidget.this.setForceDisableSizeParam(!blArray[i], TYPE_NAMES[i], string);
                    }
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ENDIANNESS_KEY_PREFIX + string, !blArray[TYPE_NAMES.length]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX + string, !blArray[TYPE_NAMES.length + 1]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string, !blArray[TYPE_NAMES.length + 2]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string, !blArray[TYPE_NAMES.length + 3]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string, !blArray[TYPE_NAMES.length + 4]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ENABLE_LONG_LONG_KEY_PREFIX + string, !blArray[TYPE_NAMES.length + 5]);
                    HardwareImplementationWidget.this.fUpdateCount++;
                }
            }
        });
    }

    private void setSizeParam(Object[] objectArray, int n, String string, String string2) {
        String string3 = HARDWARE_SIZE_KEY_PREFIX + string + "." + string2;
        int n2 = (int)((double[])objectArray[n])[0];
        if (!this.fConfiguration.isParamExplicitlySet(string3) || !this.fConfiguration.isParamEnabled(string3)) {
            this.fConfiguration.setParamAsInt(string3, n2);
        }
    }

    private void setForceDisableSizeParam(boolean bl, String string, String string2) {
        this.fConfiguration.setForcedDisabled(HARDWARE_SIZE_KEY_PREFIX + string + "." + string2, bl);
    }

    private static List<Param> findTableParams(ParamSet paramSet) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (Param param : paramSet.getParams()) {
            String string = param.getKey();
            if (!string.startsWith("param.Hardware")) continue;
            arrayList.add(param);
        }
        return arrayList;
    }

    private MJLabel createLabel(String string) {
        return new MJLabel(this.fConfiguration.getTarget().getParam(string).getName() + (PlatformInfo.isMacintosh() ? "" : ":"));
    }

    private void setupMcosLayout() {
        Target target = this.fConfiguration.getTarget();
        final Component component = this.fBinder.createOrGet(target.getParam(SAME_HARDWARE_FLAG_KEY));
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = component.getPreferredSize();
                Dimension dimension2 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                Dimension dimension3 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                Dimension dimension4 = new Dimension(Math.max(dimension.width, dimension2.width) + 30, dimension3.height + dimension2.height + dimension.height + 56);
                return dimension4;
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = component.getPreferredSize();
                component.setBounds(16, 16, dimension.width, dimension.height);
                Dimension dimension2 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                Dimension dimension3 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(component.getX(), component.getY() + component.getHeight() + 8, 1, dimension3.height);
                HardwareImplementationWidget.this.fTable.getComponent().setBounds(component.getX(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY() + HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight(), Math.min(dimension2.width, this.getWidth() - component.getX() - 8), Math.min(dimension2.height, this.getHeight() - (HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY() + HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight() + 8) - 24));
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(HardwareImplementationWidget.this.fSizeErrorLabelContainer.getX(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY(), HardwareImplementationWidget.this.fTable.getComponent().getWidth(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight());
            }
        };
        this.fComponent.setOpaque(false);
        this.fComponent.add((Component)this.fSizeErrorLabelContainer);
        this.fComponent.add(component);
        this.fComponent.add((Component)this.fTable.getComponent());
    }

    private void setupWindowsLayout() {
        Target target = this.fConfiguration.getTarget();
        final MJLabel mJLabel = this.createLabel(TARGET_LANG_STANDARD_KEY);
        final Component component = this.fBinder.createOrGet(target.getParam(TARGET_LANG_STANDARD_KEY));
        final MJLabel mJLabel2 = this.createLabel(CODE_REPLACEMENT_LIBRARY_KEY);
        final Component component2 = this.fBinder.createOrGet(target.getParam(CODE_REPLACEMENT_LIBRARY_KEY));
        final Component component3 = this.fBinder.createOrGet(target.getParam(SAME_HARDWARE_FLAG_KEY));
        final MJPanel mJPanel = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = component3.getPreferredSize();
                Dimension dimension2 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                Dimension dimension3 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                Dimension dimension4 = new Dimension(dimension2.width + 30, dimension.height + dimension3.height + dimension2.height + 48);
                return dimension4;
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = component3.getPreferredSize();
                Dimension dimension2 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                Dimension dimension3 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                component3.setBounds(8, 24, dimension.width, dimension.height);
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(component3.getX(), component3.getY() + component3.getHeight() + 8, 1, dimension2.height);
                int n = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY() + HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight();
                HardwareImplementationWidget.this.fTable.getComponent().setBounds(component3.getX(), n, Math.min(this.getWidth() - 16, dimension3.width), Math.min(dimension3.height, this.getHeight() - n - 8));
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(HardwareImplementationWidget.this.fSizeErrorLabelContainer.getX(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY(), HardwareImplementationWidget.this.fTable.getComponent().getWidth(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight());
            }
        };
        mJPanel.setBorder((Border)new TitledBorder(CoderResources.getString("category.hardware.settings")));
        mJPanel.add(component3);
        mJPanel.add((Component)this.fSizeErrorLabelContainer);
        mJPanel.add((Component)this.fTable.getComponent());
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = mJLabel.getPreferredSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = mJLabel2.getPreferredSize();
                Dimension dimension4 = HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getPreferredSize();
                Dimension dimension5 = component2.getPreferredSize();
                Dimension dimension6 = mJPanel.getPreferredSize();
                int n = HardwareImplementationWidget.this.fBusyAffordance.getComponent().getWidth() + 16;
                Dimension dimension7 = new Dimension(20 + Math.max(Math.max(dimension6.width, dimension.width + dimension2.width + n), dimension3.width + dimension5.width + n), Math.max(Math.max(dimension.height, dimension2.height), Math.max(dimension3.height, dimension5.height)) + dimension4.height + dimension6.height + 10);
                return dimension7;
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = mJLabel.getPreferredSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = mJLabel2.getPreferredSize();
                Dimension dimension4 = HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getPreferredSize();
                Dimension dimension5 = ((JComboBox)TreeUtils.findComponent((Component)component2, JComboBox.class)).getPreferredSize();
                mJLabel.setBounds(14, 10, dimension.width, dimension.height);
                mJLabel2.setBounds(14, mJLabel.getY() + mJLabel.getHeight() + 12, dimension3.width, dimension3.height);
                int n = mJLabel.getX() + Math.max(mJLabel.getWidth(), mJLabel2.getWidth()) + 8;
                component.setBounds(n, mJLabel.getY(), Math.max(dimension2.width, dimension5.width), dimension2.height);
                HardwareImplementationWidget.alignVertically(new Component[]{mJLabel, component});
                Dimension dimension6 = component2.getPreferredSize();
                Dimension dimension7 = HardwareImplementationWidget.this.fBusyAffordance.getComponent().getPreferredSize();
                component2.setBounds(n, mJLabel2.getY(), dimension6.width, dimension6.height);
                HardwareImplementationWidget.this.fBusyAffordance.getComponent().setBounds(component2.getX() + component2.getWidth() + 8, component2.getY(), dimension7.width, dimension7.height);
                HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setBounds(component2.getX(), component2.getY() + component2.getHeight() + 4, dimension4.width, dimension4.height);
                HardwareImplementationWidget.alignVertically(new Component[]{mJLabel2, component2, HardwareImplementationWidget.this.fBusyAffordance.getComponent()});
                int n2 = HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getY() + HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getHeight() + 8;
                mJPanel.setBounds(10, n2, this.getWidth() - 20, this.getHeight() - n2 - 20);
            }
        };
        this.fComponent.setOpaque(false);
        this.fComponent.add((Component)mJLabel);
        this.fComponent.add(component);
        this.fComponent.add((Component)mJLabel2);
        this.fComponent.add(component2);
        this.fComponent.add((Component)this.fBusyAffordance.getComponent());
        this.fComponent.add((Component)this.fCodeReplacementLibraryWarningLabel);
        this.fComponent.add((Component)mJPanel);
    }

    private void setupMacLayout() {
        Target target = this.fConfiguration.getTarget();
        final MJLabel mJLabel = this.createLabel(TARGET_LANG_STANDARD_KEY);
        final Component component = this.fBinder.createOrGet(target.getParam(TARGET_LANG_STANDARD_KEY));
        final MJLabel mJLabel2 = this.createLabel(CODE_REPLACEMENT_LIBRARY_KEY);
        final MJLabel mJLabel3 = new MJLabel(CoderResources.getString("category.hardware.settings"));
        final Component component2 = this.fBinder.createOrGet(target.getParam(CODE_REPLACEMENT_LIBRARY_KEY));
        final Component component3 = this.fBinder.createOrGet(target.getParam(SAME_HARDWARE_FLAG_KEY));
        this.fComponent = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = mJLabel.getPreferredSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = mJLabel2.getPreferredSize();
                Dimension dimension4 = HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getPreferredSize();
                Dimension dimension5 = mJLabel3.getPreferredSize();
                Dimension dimension6 = component2.getPreferredSize();
                Dimension dimension7 = component3.getPreferredSize();
                Dimension dimension8 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                Dimension dimension9 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                Dimension dimension10 = new Dimension(dimension8.width + 30 + Math.max(Math.max(dimension.width, dimension3.width), dimension5.width), Math.max(dimension3.height, dimension6.height) + Math.max(dimension.height, dimension2.height) + Math.max(dimension5.height, dimension7.height) + dimension4.height + dimension9.height + dimension8.height + 64);
                return dimension10;
            }

            public void doLayout() {
                super.doLayout();
                Dimension dimension = mJLabel.getPreferredSize();
                Dimension dimension2 = mJLabel2.getPreferredSize();
                Dimension dimension3 = HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getPreferredSize();
                Dimension dimension4 = mJLabel3.getPreferredSize();
                int n = Math.min(this.getPreferredSize().width, this.getWidth() - 16);
                int n2 = Math.max(Math.max(dimension.width, dimension2.width), dimension4.width);
                mJLabel.setBounds(this.getWidth() / 2 - n / 2 + (n2 - dimension.width), 10, dimension.width, dimension.height);
                mJLabel2.setBounds(this.getWidth() / 2 - n / 2 + (n2 - dimension2.width), mJLabel.getY() + mJLabel.getHeight() + 8, dimension2.width, dimension2.height);
                Dimension dimension5 = component.getPreferredSize();
                Dimension dimension6 = component2.getPreferredSize();
                Dimension dimension7 = component3.getPreferredSize();
                Dimension dimension8 = HardwareImplementationWidget.this.fBusyAffordance.getComponent().getPreferredSize();
                component.setBounds(this.getWidth() / 2 - n / 2 + n2 + 8, mJLabel.getY(), dimension5.width, dimension5.height);
                component2.setBounds(this.getWidth() / 2 - n / 2 + n2 + 8, mJLabel2.getY(), dimension6.width, dimension6.height);
                HardwareImplementationWidget.this.fBusyAffordance.getComponent().setBounds(component2.getX() + component2.getWidth() + 8, component2.getY(), dimension8.width, dimension8.height);
                HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setBounds(component2.getX(), component2.getY() + component2.getHeight() + 4, dimension3.width, dimension3.height);
                mJLabel3.setBounds(this.getWidth() / 2 - n / 2 + (n2 - dimension4.width), HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getY() + HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.getHeight() + 8, dimension4.width, dimension4.height);
                component3.setBounds(this.getWidth() / 2 - n / 2 + n2 + 8, mJLabel3.getY(), dimension7.width, dimension7.height);
                HardwareImplementationWidget.alignVertically(new Component[]{mJLabel, component});
                HardwareImplementationWidget.alignVertically(new Component[]{mJLabel2, component2, HardwareImplementationWidget.this.fBusyAffordance.getComponent()});
                HardwareImplementationWidget.alignVertically(new Component[]{mJLabel3, component3});
                Dimension dimension9 = HardwareImplementationWidget.this.fTable.getComponent().getPreferredSize();
                Dimension dimension10 = HardwareImplementationWidget.this.fSizeErrorLabelContainer.getPreferredSize();
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(component3.getX(), component3.getY() + component3.getHeight() + 8, 1, dimension10.height);
                HardwareImplementationWidget.this.fTable.getComponent().setBounds(component3.getX(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY() + HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight(), Math.min(dimension9.width, this.getWidth() - component3.getX() - 8), Math.min(dimension9.height, this.getHeight() - (HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY() + HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight() + 8) - 24));
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBounds(HardwareImplementationWidget.this.fSizeErrorLabelContainer.getX(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getY(), HardwareImplementationWidget.this.fTable.getComponent().getWidth(), HardwareImplementationWidget.this.fSizeErrorLabelContainer.getHeight());
            }
        };
        this.fComponent.setOpaque(false);
        this.fComponent.add((Component)mJLabel);
        this.fComponent.add(component);
        this.fComponent.add((Component)mJLabel2);
        this.fComponent.add(component2);
        this.fComponent.add((Component)this.fBusyAffordance.getComponent());
        this.fComponent.add((Component)this.fCodeReplacementLibraryWarningLabel);
        this.fComponent.add((Component)this.fSizeErrorLabelContainer);
        this.fComponent.add((Component)mJLabel3);
        this.fComponent.add(component3);
        this.fComponent.add((Component)this.fTable.getComponent());
    }

    private static void alignVertically(Component ... componentArray) {
        Arrays.sort(componentArray, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                return component.getHeight() - component2.getHeight();
            }
        });
        Component component = componentArray[componentArray.length - 1];
        for (int i = 0; i < componentArray.length - 1; ++i) {
            componentArray[i].setLocation(componentArray[i].getX(), component.getY() + component.getHeight() / 2 - componentArray[i].getHeight() / 2);
        }
    }
}

