/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Project;
import com.mathworks.toolbox.coder.app.CoderRegistry;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointTool;
import com.mathworks.toolbox.coder.plugin.ExportAction;
import com.mathworks.toolbox.coder.plugin.ImportAction;
import com.mathworks.toolbox.coder.screener.ProjectScreenerBar;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class CoderToolbarClient
extends BasicProjectClient {
    public static final String NAME = "MATLAB Coder";
    public static final String TITLE = BuiltInResources.getString((String)"title");
    private static final String ENABLE_SCREENER_PARAM = "param.EnableScreener";
    private Configuration fConfiguration;
    private PropertyChangeListener fConfigurationListener;
    private ProjectScreenerBar fScreenerBar;

    public CoderToolbarClient() {
        super(NAME, TITLE);
        String string = BuiltInResources.getString((String)"newproject.title.codegen");
        this.setTitle(string);
        this.setShortTitle(string);
        this.addAction(new ExportAction((Component)((Object)this)), false);
        this.addAction(new ImportAction((Component)((Object)this)), false);
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(CoderToolbarClient.ENABLE_SCREENER_PARAM)) {
                    if (CoderToolbarClient.this.fScreenerBar != null) {
                        CoderToolbarClient.this.fScreenerBar.dispose();
                        CoderToolbarClient.this.fScreenerBar = null;
                    }
                    if (CoderToolbarClient.this.fConfiguration != null && CoderToolbarClient.this.fConfiguration.getParamAsBoolean(CoderToolbarClient.ENABLE_SCREENER_PARAM)) {
                        CoderToolbarClient.this.fScreenerBar = new ProjectScreenerBar(CoderToolbarClient.this.fConfiguration);
                        CoderToolbarClient.this.setInfoComponent(CoderToolbarClient.this.fScreenerBar.getComponent());
                    } else {
                        CoderToolbarClient.this.setInfoComponent(null);
                    }
                }
            }
        };
    }

    public void loadingFinished(final Project project) {
        super.loadingFinished(project);
        CoderRegistry.getInstance().register(project);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (project.getConfiguration().getParamAsBoolean(CoderToolbarClient.ENABLE_SCREENER_PARAM)) {
                    CoderToolbarClient.this.fScreenerBar = new ProjectScreenerBar(project.getConfiguration());
                    CoderToolbarClient.this.setInfoComponent(CoderToolbarClient.this.fScreenerBar.getComponent());
                }
                CoderToolbarClient.this.fConfiguration = project.getConfiguration();
                CoderToolbarClient.this.fConfiguration.addPropertyChangeListener(CoderToolbarClient.this.fConfigurationListener);
            }
        });
    }

    public void projectClosed() {
        if (this.fConfiguration != null) {
            this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
            this.fConfiguration = null;
        }
        if (this.fScreenerBar != null) {
            this.fScreenerBar.dispose();
            this.fScreenerBar = null;
            this.setInfoComponent(null);
        }
        CoderRegistry.getInstance().unregister(this.getProject());
        super.projectClosed();
        FixedPointTool.close();
    }

    protected void switchToNoProjectMode() {
        super.switchToNoProjectMode();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CoderToolbarClient.this.fScreenerBar != null) {
                    CoderToolbarClient.this.fScreenerBar.dispose();
                    CoderToolbarClient.this.fScreenerBar = null;
                }
            }
        });
    }

    protected void addExtraActions(JPopupMenu jPopupMenu) {
        CoderToolbarClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("EXPORT_CONFIG_OBJECT"));
        CoderToolbarClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("IMPORT_CONFIG_OBJECT"));
        jPopupMenu.addSeparator();
    }

    protected void addExtraProjectMenuActions(JMenu jMenu) {
        jMenu.addSeparator();
        jMenu.add((Action)this.getAction("EXPORT_CONFIG_OBJECT"));
        jMenu.add((Action)this.getAction("IMPORT_CONFIG_OBJECT"));
    }
}

