/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.toolbox.coder.plugin.CodeGenResult;
import com.mathworks.toolbox.coder.plugin.TargetArtifact;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class CodeGenWrapper
implements Command {
    private final File fProjectFile;
    private final WritableConfiguration fConfig;
    private final boolean fSilPilBuild;
    private volatile boolean fCancelled = false;
    private static final Matlab sMatlab = new Matlab();

    public CodeGenWrapper(File file, WritableConfiguration writableConfiguration, XmlReader xmlReader) {
        this(file, writableConfiguration, false);
    }

    public CodeGenWrapper(File file, WritableConfiguration writableConfiguration, boolean bl) {
        this.fProjectFile = file;
        this.fConfig = writableConfiguration;
        this.fSilPilBuild = bl;
    }

    public void execute(final CommandStatus commandStatus) {
        final boolean bl = this.fConfig.getParamAsString("param.artifact").equals("option.target.artifact.mex.instrumented");
        this.fConfig.setParamAsBoolean("param.BuiltInstrumentedMex", false);
        boolean bl2 = !this.fConfig.getParamAsBoolean("param.LogHistogram");
        Object[] objectArray = new Object[]{"codeProject", this.fProjectFile.getAbsolutePath(), this, bl, bl2, this.getFeatureFlags()};
        if (this.fSilPilBuild) {
            if (Utilities.isPilBuild((ReadableConfiguration)this.fConfig)) {
                this.fConfig.setParamAsString("param.VerificationMode", "option.VerificationMode.PIL");
            } else {
                this.fConfig.setParamAsString("param.VerificationMode", "option.VerificationMode.SIL");
            }
        } else {
            this.fConfig.setParamAsString("param.VerificationMode", "option.VerificationMode.None");
        }
        ProjectManager.forceSave((Project)((Configuration)this.fConfig).getProject());
        sMatlab.fevalConsoleOutput("emlcprivate", objectArray, 1, new CompletionObserver(){

            public void completed(final int n, final Object object) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Matlab.getExecutionStatus((int)n) == 0) {
                            CodeGenResult codeGenResult = (CodeGenResult)object;
                            CodeGenWrapper.this.logBuildResults(codeGenResult);
                            commandStatus.printOutputLine(codeGenResult.getLog());
                            if (CodeGenWrapper.this.fCancelled) {
                                commandStatus.canceled();
                                return;
                            }
                            if (codeGenResult.isSucceeded()) {
                                commandStatus.finished();
                                CodeGenWrapper.this.fConfig.setParamAsBoolean("param.BuiltInstrumentedMex", bl);
                                CodeGenWrapper.this.fConfig.setParamAsBoolean("param.RanInstrumentedMex", false);
                                return;
                            }
                        }
                        commandStatus.failed(new CommandExecutionException((Command)CodeGenWrapper.this));
                    }
                });
            }
        });
    }

    private void logBuildResults(CodeGenResult codeGenResult) {
        String string = this.fConfig.getParamAsString("param.artifact");
        String string2 = TargetArtifact.isMexTarget(string) ? "param.mex.mainhtml" : "param.grt.mainhtml";
        this.fConfig.setParamAsString(string2, codeGenResult.getMainHtml());
    }

    private Object[] getFeatureFlags() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.fConfig.getParamAsString("param.FeatureFlags");
        if (string != null) {
            if (string.trim().startsWith("{") && string.trim().endsWith("}")) {
                return new Object[]{string};
            }
            try {
                int n;
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
                block10: while ((n = streamTokenizer.nextToken()) != -1) {
                    String string2;
                    if (n != -3 && n != 39 && n != 34) continue;
                    switch (string2 = streamTokenizer.sval) {
                        case "true": {
                            arrayList.add(Boolean.TRUE);
                            continue block10;
                        }
                        case "false": {
                            arrayList.add(Boolean.FALSE);
                            continue block10;
                        }
                    }
                    arrayList.add(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fSilPilBuild) {
            arrayList.add("EnableSILPILGeneration");
            arrayList.add(Boolean.TRUE);
        }
        if (arrayList.size() % 2 != 0) {
            arrayList.clear();
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public void cancel() {
        this.fCancelled = true;
    }

    public boolean isCancelled() {
        return this.fCancelled;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.fProjectFile.getName();
        if (string.indexOf(32) == -1) {
            stringBuilder.append(">> coder -build ");
            stringBuilder.append(string);
        } else {
            stringBuilder.append(">> coder('-build', '");
            stringBuilder.append(string);
            stringBuilder.append("')");
        }
        return stringBuilder.toString();
    }
}

