/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum VariableKind {
    INPUT("inputVar"),
    OUTPUT("outputVar"),
    INPUT_OUTPUT,
    PERSISTENT("persistentVar"),
    LOCAL,
    TEMP,
    INDEX("loopIdxVars"),
    GLOBAL("globalVar"),
    FIELD,
    PROPERTY;

    private static final Map<String, VariableKind> INFERENCE_TYPE_MAPPINGS;
    private final String fNodeType;

    private VariableKind(String string2) {
        this.fNodeType = string2;
    }

    private VariableKind() {
        this(null);
    }

    public String getLabel() {
        return CoderResources.getString("f2f.group." + this.toString().toLowerCase(Locale.ENGLISH));
    }

    public boolean isInput() {
        return this == INPUT || this == INPUT_OUTPUT;
    }

    public String getInferenceNodeType() {
        return this.fNodeType;
    }

    public static VariableKind mapFromInferenceNodeType(String string) {
        return INFERENCE_TYPE_MAPPINGS.get(string);
    }

    static {
        HashMap<String, VariableKind> hashMap = new HashMap<String, VariableKind>();
        for (VariableKind variableKind : VariableKind.values()) {
            if (variableKind.getInferenceNodeType() == null) continue;
            hashMap.put(variableKind.getInferenceNodeType(), variableKind);
        }
        INFERENCE_TYPE_MAPPINGS = Collections.unmodifiableMap(hashMap);
    }
}

