/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import java.util.LinkedList;
import java.util.List;

public final class CoverageRegion {
    private final int fStartIndex;
    private final int fLength;
    private final double fCoveredTimes;
    private final double fEnclosingTimes;
    private final double fFactor;
    private Integer fMaxHits;

    public CoverageRegion(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 1.0);
    }

    public CoverageRegion(int n, int n2, double d, double d2, double d3) {
        this.fStartIndex = n;
        this.fLength = n2;
        this.fCoveredTimes = Math.round(d);
        this.fEnclosingTimes = Math.round(d2);
        this.fFactor = d3;
    }

    public void setMaxHits(int n) {
        this.fMaxHits = n;
    }

    public int getMaxHits() {
        return this.fMaxHits;
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getCoveredTimes() {
        return (int)this.fCoveredTimes;
    }

    public boolean hasMaxPossibleHits() {
        return this.fMaxHits != null && (double)this.fMaxHits.intValue() == this.fCoveredTimes;
    }

    public boolean isDead() {
        return this.fMaxHits != null && this.fMaxHits == 0;
    }

    public int getEnclosingTimes() {
        return (int)this.fEnclosingTimes;
    }

    public double getCoveragePercent() {
        if (this.fMaxHits != null && (double)this.fMaxHits.intValue() == this.fCoveredTimes) {
            return 1.0;
        }
        return this.fEnclosingTimes == 0.0 ? 0.0 : this.fCoveredTimes / this.fEnclosingTimes;
    }

    public boolean contains(int n, int n2) {
        return this.fStartIndex <= n && this.fStartIndex + this.fLength >= n + n2;
    }

    public List<CoverageRegion> split(int n, int n2, int n3, double d) {
        LinkedList<CoverageRegion> linkedList = new LinkedList<CoverageRegion>();
        if (n > this.fStartIndex) {
            linkedList.add(new CoverageRegion(this.fStartIndex, n - this.fStartIndex, this.fCoveredTimes, this.fEnclosingTimes, this.fFactor));
        }
        linkedList.add(new CoverageRegion(n, n2, n3 == Integer.MAX_VALUE ? this.fEnclosingTimes * this.fFactor : (double)n3, this.fEnclosingTimes * this.fFactor, d));
        if (n + n2 < this.fStartIndex + this.fLength) {
            linkedList.add(new CoverageRegion(n + n2, this.fStartIndex + this.fLength - (n + n2), this.fCoveredTimes, this.fEnclosingTimes, this.fFactor));
        }
        return linkedList;
    }
}

