/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.mi.CodeCoverageMI;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.CoverageRegion;
import com.mathworks.util.MulticastChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CodeCoverageModel {
    private final FixedPointDataAdapter fData;
    private final MulticastChangeListener fChangeListeners;
    private final PropertyChangeListener fEnabledListener;
    private Map<File, CoverageData> fCoverage;

    public CodeCoverageModel(FixedPointDataAdapter fixedPointDataAdapter) {
        this.fData = fixedPointDataAdapter;
        this.fChangeListeners = new MulticastChangeListener();
        this.fEnabledListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().contains("Coverage")) {
                    CodeCoverageModel.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                }
            }
        };
        this.fData.addPropertyChangeListener(this.fEnabledListener);
    }

    public void dispose() {
        this.fData.removePropertyChangeListener(this.fEnabledListener);
    }

    public boolean isEnabled() {
        return this.fData.isCoverageEnabled();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public List<CoverageRegion> getCoverage(File file) {
        if (this.fCoverage == null) {
            return new ArrayList<CoverageRegion>(0);
        }
        CoverageData coverageData = this.fCoverage.get(file);
        return coverageData == null ? new ArrayList(0) : coverageData.getRegions();
    }

    public void invalidate(final File file) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CodeCoverageModel.this.fCoverage != null) {
                    CodeCoverageModel.this.fCoverage.remove(file);
                    CodeCoverageModel.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    private static void contourSort(List<CodeCoverageMI.Construct> list) {
        Collections.sort(list, new Comparator<CodeCoverageMI.Construct>(){

            @Override
            public int compare(CodeCoverageMI.Construct construct, CodeCoverageMI.Construct construct2) {
                return construct2.getLength() - construct.getLength();
            }
        });
    }

    public void setStaticAnalysisData(final List<CodeCoverageMI.StaticAnalysisInfo> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (CodeCoverageMI.StaticAnalysisInfo staticAnalysisInfo : list) {
                    CoverageData coverageData = (CoverageData)CodeCoverageModel.this.fCoverage.get(staticAnalysisInfo.scriptPath);
                    if (coverageData == null) continue;
                    for (CodeCoverageMI.StaticBasicBlock staticBasicBlock : staticAnalysisInfo.basicBlocks) {
                        CoverageRegion coverageRegion = coverageData.getRegion(staticBasicBlock.charStartIdx - 1, staticBasicBlock.charEndIdx - staticBasicBlock.charStartIdx + 2);
                        if (coverageRegion == null) continue;
                        coverageRegion.setMaxHits(staticBasicBlock.maxHits);
                    }
                }
                CodeCoverageModel.this.fChangeListeners.stateChanged(new ChangeEvent(CodeCoverageModel.this));
            }
        });
    }

    public void refresh(final List<CodeCoverageMI.CovInfo> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CodeCoverageModel.this.fCoverage = new HashMap();
                for (CodeCoverageMI.CovInfo covInfo : list) {
                    File file = covInfo.path;
                    ArrayList<CoverageRegion> arrayList = new ArrayList<CoverageRegion>();
                    for (CodeCoverageMI.FcnInfo fcnInfo : covInfo.fcnInfos) {
                        arrayList.add(new CoverageRegion(fcnInfo.charStartIdx, fcnInfo.charEndIdx - fcnInfo.charStartIdx + 1, fcnInfo.calls, fcnInfo.calls));
                    }
                    Object object = null;
                    try {
                        object = CoderFileSupport.readMatlabSource(file);
                        object = ((String)object).replaceAll("\\r", "");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ArrayList<CodeCoverageMI.Construct> arrayList2 = new ArrayList<CodeCoverageMI.Construct>();
                    arrayList2.addAll(Arrays.asList(covInfo.ifInfos));
                    arrayList2.addAll(Arrays.asList(covInfo.whileInfos));
                    arrayList2.addAll(Arrays.asList(covInfo.forInfos));
                    arrayList2.addAll(Arrays.asList(covInfo.switchInfos));
                    arrayList2.addAll(Arrays.asList(covInfo.basicBlockInfos));
                    Arrays.sort(covInfo.basicBlockInfos, new Comparator<CodeCoverageMI.BasicBlockInfo>(){

                        @Override
                        public int compare(CodeCoverageMI.BasicBlockInfo basicBlockInfo, CodeCoverageMI.BasicBlockInfo basicBlockInfo2) {
                            return basicBlockInfo.charStartIdx - basicBlockInfo2.charStartIdx;
                        }
                    });
                    for (CodeCoverageMI.BasicBlockInfo basicBlockInfo : covInfo.basicBlockInfos) {
                        if (basicBlockInfo.charEndIdx < basicBlockInfo.charStartIdx) {
                            basicBlockInfo.charEndIdx = basicBlockInfo.charStartIdx;
                        }
                        while (object != null && basicBlockInfo.charEndIdx < ((String)object).length() && ((String)object).charAt(basicBlockInfo.charEndIdx) != '\n') {
                            ++basicBlockInfo.charEndIdx;
                        }
                    }
                    CodeCoverageModel.contourSort(arrayList2);
                    for (Object e : arrayList2) {
                        int n;
                        if (e instanceof CodeCoverageMI.IfInfo) {
                            CodeCoverageMI.IfInfo ifInfo = (CodeCoverageMI.IfInfo)e;
                            n = ifInfo.charElseStartIdx <= 0 ? ifInfo.charEndIdx : ifInfo.charElseStartIdx - 1;
                            CodeCoverageModel.split(arrayList, ifInfo.charStartIdx, n - ifInfo.charStartIdx + 1, ifInfo.trueCount, 1, false);
                            if (ifInfo.charElseStartIdx <= 0) continue;
                            CodeCoverageModel.split(arrayList, ifInfo.charElseStartIdx, ifInfo.charEndIdx - ifInfo.charElseStartIdx + 1, ifInfo.falseCount, 1, false);
                            continue;
                        }
                        if (e instanceof CodeCoverageMI.WhileInfo) {
                            CodeCoverageMI.WhileInfo whileInfo = (CodeCoverageMI.WhileInfo)e;
                            CodeCoverageModel.split(arrayList, whileInfo.charStartIdx, whileInfo.charEndIdx - whileInfo.charStartIdx + 1, whileInfo.hitCount > 0 ? Integer.MAX_VALUE : 0, whileInfo.hitCount, false);
                            continue;
                        }
                        if (e instanceof CodeCoverageMI.ForInfo) {
                            CodeCoverageMI.ForInfo forInfo = (CodeCoverageMI.ForInfo)e;
                            CodeCoverageModel.split(arrayList, forInfo.charStartIdx, forInfo.charEndIdx - forInfo.charStartIdx + 1, forInfo.entryCount > 0 ? Integer.MAX_VALUE : 0, forInfo.entryCount, true);
                            continue;
                        }
                        if (e instanceof CodeCoverageMI.SwitchInfo) {
                            CodeCoverageMI.Case[] caseArray = ((CodeCoverageMI.SwitchInfo)e).cases;
                            Arrays.sort(caseArray, new Comparator<CodeCoverageMI.Case>(){

                                @Override
                                public int compare(CodeCoverageMI.Case case_, CodeCoverageMI.Case case_2) {
                                    return case_.charStartIdx - case_2.charStartIdx;
                                }
                            });
                            n = ((CodeCoverageMI.SwitchInfo)e).charEndIdx - 3;
                            for (int i = 0; i < caseArray.length; ++i) {
                                if (caseArray[i].charStartIdx == -1) continue;
                                CodeCoverageModel.split(arrayList, caseArray[i].charStartIdx, i == caseArray.length - 1 ? n - caseArray[i].charStartIdx + 1 : caseArray[i + 1].charStartIdx - caseArray[i].charStartIdx, caseArray[i].hitCount, 1, false);
                            }
                            continue;
                        }
                        if (!(e instanceof CodeCoverageMI.BasicBlockInfo)) continue;
                        CodeCoverageMI.BasicBlockInfo basicBlockInfo = (CodeCoverageMI.BasicBlockInfo)e;
                        CodeCoverageModel.split(arrayList, basicBlockInfo.charStartIdx, basicBlockInfo.charEndIdx - basicBlockInfo.charStartIdx + 1, basicBlockInfo.hits, 1, false);
                    }
                    CodeCoverageModel.this.fCoverage.put(file, new CoverageData(arrayList));
                    CodeCoverageModel.this.fChangeListeners.stateChanged(new ChangeEvent(CodeCoverageModel.this));
                }
            }
        });
    }

    private static void split(List<CoverageRegion> list, int n, int n2, int n3, int n4, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).contains(n, n2)) continue;
            CoverageRegion coverageRegion = list.remove(i);
            List<CoverageRegion> list2 = coverageRegion.split(n, n2, n3, bl ? (double)n4 / (double)coverageRegion.getEnclosingTimes() : (double)n4);
            list.addAll(i, list2);
            break;
        }
    }

    private static long createKey(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private static class CoverageData {
        private final List<CoverageRegion> fRegionList;
        private final Map<Long, CoverageRegion> fRegionMap;

        public CoverageData(List<CoverageRegion> list) {
            this.fRegionList = new ArrayList<CoverageRegion>(list);
            this.fRegionMap = new HashMap<Long, CoverageRegion>();
            for (CoverageRegion coverageRegion : list) {
                this.fRegionMap.put(CodeCoverageModel.createKey(coverageRegion.getStartIndex(), coverageRegion.getLength()), coverageRegion);
            }
        }

        public List<CoverageRegion> getRegions() {
            return new ArrayList<CoverageRegion>(this.fRegionList);
        }

        public CoverageRegion getRegion(int n, int n2) {
            return this.fRegionMap.get(CodeCoverageModel.createKey(n, n2));
        }
    }
}

