/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.functionbrowser;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.functionbrowser.DefaultFunctionBrowserPainter;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserModel;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserNode;
import com.mathworks.toolbox.coder.functionbrowser.FunctionBrowserPainter;
import com.mathworks.util.MulticastChangeListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FunctionBrowser {
    private final FunctionBrowserModel fModel = new FunctionBrowserModel();
    private final FunctionBrowserPainter fPainter = new DefaultFunctionBrowserPainter();
    private final MJPanel fComponent;
    private final MulticastChangeListener fSelectionListeners = new MulticastChangeListener();
    private int fSelectedRow = -1;

    public FunctionBrowser() {
        this.fComponent = new MJPanel(){

            public void paint(Graphics graphics) {
                FunctionBrowser.this.fPainter.paint(FunctionBrowser.this, (Graphics2D)graphics);
            }

            public Dimension getPreferredSize() {
                return FunctionBrowser.this.fPainter.getPreferredSize(FunctionBrowser.this);
            }
        };
        this.fPainter.update(this);
        this.fModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FunctionBrowser.this.fPainter.update(FunctionBrowser.this);
                FunctionBrowser.this.fComponent.revalidate();
                FunctionBrowser.this.fComponent.repaint();
            }
        });
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FunctionBrowserNode functionBrowserNode;
                int n = FunctionBrowser.this.fPainter.getLabelRow(FunctionBrowser.this, mouseEvent.getPoint());
                if (n != -1 && (functionBrowserNode = FunctionBrowser.this.fModel.get(n)).getArtifact() != null) {
                    FunctionBrowser.this.fSelectedRow = n;
                    FunctionBrowser.this.fComponent.revalidate();
                    FunctionBrowser.this.fComponent.repaint();
                    FunctionBrowser.this.fSelectionListeners.stateChanged(new ChangeEvent(FunctionBrowser.this));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = FunctionBrowser.this.fPainter.getExpanderRow(FunctionBrowser.this, mouseEvent.getPoint());
                if (n != -1) {
                    FunctionBrowserNode functionBrowserNode = FunctionBrowser.this.fModel.get(n);
                    FunctionBrowser.this.fModel.setExpanded(functionBrowserNode, !FunctionBrowser.this.fModel.isExpanded(functionBrowserNode));
                }
            }
        });
        this.fComponent.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FunctionBrowser.this.fPainter.update(FunctionBrowser.this);
                FunctionBrowser.this.fComponent.revalidate();
                FunctionBrowser.this.fComponent.repaint();
            }
        });
    }

    public int getSelectedRow() {
        return this.fSelectedRow;
    }

    public void addSelectionListener(ChangeListener changeListener) {
        this.fSelectionListeners.addChangeListener(changeListener);
    }

    public void removeSelectionListener(ChangeListener changeListener) {
        this.fSelectionListeners.removeChangeListener(changeListener);
    }

    public FunctionBrowserModel getModel() {
        return this.fModel;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }
}

