/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint.replace;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementKey;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategies;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementType;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public interface ReplacementSerializer {
    public void serialize(Map<ReplacementKey, FunctionReplacementStrategy> var1, XmlWriter var2);

    public Map<ReplacementKey, FunctionReplacementStrategy> deserialize(XmlReader var1);

    public static class CompatibilitySerializer
    implements ReplacementSerializer {
        private static final String TAG_FUNCTION_ENTRY = "Function";
        private static final String ATTR_FUNCTION_NAME = "name";
        private static final String ATTR_REPLACEMENT = "replacement";

        @Override
        public void serialize(Map<ReplacementKey, FunctionReplacementStrategy> map, XmlWriter xmlWriter) {
            for (Map.Entry<ReplacementKey, FunctionReplacementStrategy> entry : map.entrySet()) {
                if (entry.getValue().isValid() && entry.getValue() instanceof FunctionReplacementStrategies.UserDefined) {
                    FunctionReplacementStrategies.UserDefined userDefined = (FunctionReplacementStrategies.UserDefined)entry.getValue();
                    XmlWriter xmlWriter2 = xmlWriter.createElement(TAG_FUNCTION_ENTRY);
                    xmlWriter2.writeAttribute(ATTR_FUNCTION_NAME, (Object)entry.getKey().getDisplayString());
                    String string = userDefined.getReplacement();
                    xmlWriter2.writeAttribute(ATTR_REPLACEMENT, (Object)(string != null ? string : ""));
                    continue;
                }
                if (!(entry.getValue() instanceof FunctionReplacementStrategies.UserDefined)) assert (entry.getValue().getFunctionReplacementType() != FunctionReplacementType.USER_DEFINED) : "UserDefined should be the only class returning USER_DEFINED as the replacement type.";
            }
        }

        @Override
        public Map<ReplacementKey, FunctionReplacementStrategy> deserialize(XmlReader xmlReader) {
            LinkedHashMap<ReplacementKey, FunctionReplacementStrategy> linkedHashMap = new LinkedHashMap<ReplacementKey, FunctionReplacementStrategy>();
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{TAG_FUNCTION_ENTRY});
            while (xmlReader2.isPresent()) {
                String string = xmlReader2.readAttribute(ATTR_FUNCTION_NAME);
                String string2 = xmlReader2.readAttribute(ATTR_REPLACEMENT);
                if (string != null && string2 != null) {
                    FunctionReplacementKey functionReplacementKey = new FunctionReplacementKey(string);
                    FunctionReplacementStrategies.UserDefined userDefined = new FunctionReplacementStrategies.UserDefined();
                    userDefined.setReplacement(string2);
                    linkedHashMap.put(functionReplacementKey, userDefined);
                }
                xmlReader2 = xmlReader2.next();
            }
            return linkedHashMap;
        }
    }

    public static class DefaultSerializer
    implements ReplacementSerializer {
        private static final String TAG_PAIR = "Replacement";
        private static final String TAG_KEY = "Key";
        private static final String TAG_STRATEGY = "Strategy";
        private static final String ATTR_KEY_TYE = "keyType";
        private static final String ATTR_STRATEGY_TYPE = "strategyType";

        @Override
        public void serialize(Map<ReplacementKey, FunctionReplacementStrategy> map, XmlWriter xmlWriter) {
            for (Map.Entry<ReplacementKey, FunctionReplacementStrategy> entry : map.entrySet()) {
                DefaultSerializer.serialize(entry.getKey(), entry.getValue(), xmlWriter.createElement(TAG_PAIR));
            }
        }

        @Override
        public Map<ReplacementKey, FunctionReplacementStrategy> deserialize(XmlReader xmlReader) {
            LinkedHashMap<ReplacementKey, FunctionReplacementStrategy> linkedHashMap = new LinkedHashMap<ReplacementKey, FunctionReplacementStrategy>();
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{TAG_PAIR});
            while (xmlReader2.isPresent()) {
                ReplacementKey replacementKey = DefaultSerializer.deserializeKey(xmlReader2);
                FunctionReplacementStrategy functionReplacementStrategy = DefaultSerializer.deserializeStrategy(xmlReader2);
                if (replacementKey != null && functionReplacementStrategy != null) {
                    linkedHashMap.put(replacementKey, functionReplacementStrategy);
                }
                xmlReader2 = xmlReader2.next();
            }
            return linkedHashMap;
        }

        private static void serialize(ReplacementKey replacementKey, FunctionReplacementStrategy functionReplacementStrategy, XmlWriter xmlWriter) {
            if (!functionReplacementStrategy.isValid()) {
                return;
            }
            xmlWriter.writeAttribute(ATTR_KEY_TYE, (Object)replacementKey.getKeyType());
            xmlWriter.writeAttribute(ATTR_STRATEGY_TYPE, (Object)functionReplacementStrategy.getFunctionReplacementType());
            XmlWriter xmlWriter2 = xmlWriter.createElement(TAG_KEY);
            for (Map.Entry<String, String> object : replacementKey.getSerializeableProperties().entrySet()) {
                xmlWriter2.writeAttribute(object.getKey(), (Object)object.getValue());
            }
            xmlWriter2 = xmlWriter.createElement(TAG_STRATEGY);
            for (FunctionReplacementStrategy.Property property : functionReplacementStrategy.getProperties()) {
                String string = property.getStringValue();
                if (string == null) continue;
                xmlWriter2.writeAttribute(property.getId(), (Object)string);
            }
        }

        private static ReplacementKey deserializeKey(XmlReader xmlReader) {
            String string = xmlReader.readAttribute(ATTR_KEY_TYE);
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{TAG_KEY});
            if (string != null && xmlReader2.isPresent()) {
                return ReplacementKey.parse(string, xmlReader2.readAttributes());
            }
            return null;
        }

        private static FunctionReplacementStrategy deserializeStrategy(XmlReader xmlReader) {
            FunctionReplacementType functionReplacementType;
            String string = xmlReader.readAttribute(ATTR_STRATEGY_TYPE);
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{TAG_STRATEGY});
            if (string != null && xmlReader2.isPresent() && (functionReplacementType = FunctionReplacementType.valueOf(string.toUpperCase(Locale.ENGLISH))) != null) {
                FunctionReplacementStrategy functionReplacementStrategy = functionReplacementType.createStrategy();
                functionReplacementStrategy.loadProperties(xmlReader2.readAttributes());
                return functionReplacementStrategy;
            }
            return null;
        }
    }
}

