/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.textfield.DefaultFormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.FormatTip;
import com.mathworks.project.impl.textfield.FormatTipContent;
import com.mathworks.project.impl.textfield.FormatTipProvider;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.FormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.Histogram;
import com.mathworks.toolbox.coder.mi.MatlabInterfaceLogger;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class NumericTypeTextField {
    private final FormattedTextField fField;
    private final FixedPointDataAdapter fData;
    private final ConversionModel fConversionModel;
    private final Variable fVariable;
    private final PropertyTable<Variable> fTable;
    private final KeyEventDispatcher fKeyDispatcher;
    private final CoderApp fApp;
    private Histogram fHistogram;
    private boolean fSuppressUpdate;
    private static final int PREFIX = 0;
    private static final int SIGN = 1;
    private static final int WORD_LENGTH = 2;
    private static final int FRACTION_LENGTH = 3;
    private static final int SUFFIX = 4;
    private static final int SEPARATOR = 5;

    public NumericTypeTextField(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, Variable variable, PropertyTable<Variable> propertyTable) {
        this(fixedPointDataAdapter, conversionModel, variable, propertyTable, null);
    }

    public NumericTypeTextField(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, Variable variable, PropertyTable<Variable> propertyTable, @Nullable CoderApp coderApp) {
        this.fApp = coderApp;
        this.fData = fixedPointDataAdapter;
        this.fConversionModel = conversionModel;
        this.fVariable = variable;
        this.fTable = propertyTable;
        this.fField = new FormattedTextField((FormattedTextFieldPainter)new Painter()){

            protected boolean isField(Token token) {
                return NumericTypeTextField.this.isEditableSignToken(token) || token.getType() == 2 || token.getType() == 3;
            }

            protected boolean isSkippable(Token token) {
                return token.getType() == 5;
            }

            protected boolean isPrompt(Token token) {
                return false;
            }

            public void doEscape() {
                if (NumericTypeTextField.this.fTable != null) {
                    NumericTypeTextField.this.fTable.stopEditing(true);
                }
            }

            public void doEnter() {
                if (NumericTypeTextField.this.fTable != null) {
                    NumericTypeTextField.this.fTable.stopEditing(false);
                }
            }
        };
        this.fField.setTokenizer((FormatTokenizer)new Tokenizer());
        this.fField.setTipProvider((FormatTipProvider)new TipProvider());
        this.fField.setName(propertyTable.getName() + ".editor");
        this.fField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (NumericTypeTextField.this.fHistogram != null && !NumericTypeTextField.this.fSuppressUpdate) {
                    List list = NumericTypeTextField.this.fField.getTokens();
                    NumericTypeTextField.this.fHistogram.update(NumericTypeTextField.isSigned(list), NumericTypeTextField.this.getWordLength(list), NumericTypeTextField.this.getFractionLength(list));
                }
            }
        });
        this.fKeyDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (NumericTypeTextField.this.fHistogram != null && NumericTypeTextField.this.fHistogram.getComponent().isShowing()) {
                    if (keyEvent.getKeyCode() == 10) {
                        NumericTypeTextField.this.fTable.stopEditing(false);
                        return true;
                    }
                    if (keyEvent.getKeyCode() == 27) {
                        NumericTypeTextField.this.fTable.stopEditing(true);
                        return true;
                    }
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.fKeyDispatcher);
    }

    public void requestFocus() {
        this.fField.requestFocus();
    }

    public String getText() {
        return this.fField.getText();
    }

    public void setText(String string) {
        this.fField.setText(string);
    }

    public JComponent getComponent() {
        return this.fField.getComponent();
    }

    public void lockFormatTip() {
        this.fField.lockFormatTip();
    }

    public void unlockFormatTip() {
        this.fField.unlockFormatTip();
    }

    public void dispose() {
        this.fField.dispose();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.fKeyDispatcher);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fField.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fField.removeChangeListener(changeListener);
    }

    private boolean isEditableSignToken(Token token) {
        return token != null && token.getType() == 1 && !token.getText().endsWith(NumericType.Signedness.AUTO.getUserRepresentation());
    }

    public void clickFromRendererIntoEditor(String string, Font font, Point point) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length() && (double)n < point.getX()) {
            n += fontMetrics.charWidth(string.charAt(n2++));
        }
        --n2;
        if ((double)n < point.getX()) {
            this.fField.setInsertionPoint(this.fField.getText().length());
        } else {
            this.fField.setInsertionPointWithAutoSelect(n2);
        }
    }

    private void loadHistogram(final JComponent jComponent, final List<Token> list) {
        if (this.fHistogram == null) {
            final Object[] objectArray = new Object[]{"fpGetHistogramData", this.fVariable.getFunction().toString(), this.fVariable.getName()};
            new Matlab().feval("emlcprivate", objectArray, 1, new CompletionObserver(){

                public void completed(int n, Object object) {
                    MatlabInterfaceLogger.logReturn("emlcprivate", 1, objectArray, object);
                    Object[] objectArray4 = (Object[])object;
                    Object[] objectArray2 = (Object[])objectArray4[1];
                    Object[] objectArray3 = (Object[])objectArray2[0];
                    double[] dArray = (double[])objectArray3[0];
                    double[] dArray2 = (double[])objectArray3[1];
                    final Map map = NumericTypeTextField.mapCounts(dArray);
                    final Map map2 = NumericTypeTextField.mapCounts(dArray2);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NumericTypeTextField.this.fHistogram = new Histogram(FormatTip.BACKGROUND, NumericTypeTextField.isSigned(list), NumericTypeTextField.this.getWordLength(list), NumericTypeTextField.this.getFractionLength(list), map, map2, new Runnable(){

                                @Override
                                public void run() {
                                    NumericTypeTextField.this.lockFormatTip();
                                    Target target = NumericTypeTextField.this.fData.getConfiguration().getTarget();
                                    String string = NumericTypeTextField.this.fApp != null ? CoderApp.getHelpMapPath(NumericTypeTextField.this.fApp, true) : PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                                    MLHelpServices.cshDisplayTopic((Object)NumericTypeTextField.this.fTable.getComponent(), (String)string, (String)"help_button_histogram");
                                    Timer timer = new Timer(250, new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            NumericTypeTextField.this.unlockFormatTip();
                                        }
                                    });
                                    timer.setRepeats(false);
                                    timer.start();
                                }
                            });
                            NumericTypeTextField.this.fHistogram.addChangeListener(new ChangeListener(){

                                @Override
                                public void stateChanged(ChangeEvent changeEvent) {
                                    NumericTypeTextField.this.lockFormatTip();
                                    NumericTypeTextField.this.fSuppressUpdate = true;
                                    NumericTypeTextField.this.updateAll();
                                    NumericTypeTextField.this.unlockFormatTip();
                                    NumericTypeTextField.this.fSuppressUpdate = false;
                                }
                            });
                            jComponent.add(NumericTypeTextField.this.fHistogram.getComponent());
                            jComponent.revalidate();
                            jComponent.repaint();
                        }
                    });
                }
            });
        } else {
            this.fHistogram.update(NumericTypeTextField.isSigned(list), this.getWordLength(list), this.getFractionLength(list));
            jComponent.add(this.fHistogram.getComponent());
        }
    }

    private static Map<Integer, Integer> mapCounts(double[] dArray) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = dArray.length - 1;
        int n2 = dArray.length / 2;
        while (n >= 0) {
            if (dArray[n] != 0.0) {
                hashMap.put(n2, (int)dArray[n]);
            }
            --n;
            --n2;
        }
        return hashMap;
    }

    private static Token getFormatTipToken(List<Token> list) {
        return list.isEmpty() ? null : list.iterator().next();
    }

    private static boolean isSigned(List<Token> list) {
        for (Token token : list) {
            if (token.getType() != 1) continue;
            return token.getText().equals("1") || token.getText().equals("true");
        }
        return false;
    }

    private int getWordLength(List<Token> list) {
        for (Token token : list) {
            if (token.getType() != 2) continue;
            try {
                return Integer.parseInt(token.getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return this.fData.getDefaultWordLength();
    }

    private int getFractionLength(List<Token> list) {
        for (Token token : list) {
            if (token.getType() != 3) continue;
            try {
                return Integer.parseInt(token.getText());
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return this.fData.getDefaultFractionLength();
    }

    private boolean hasFractionLength(List<Token> list) {
        for (Token token : list) {
            if (token.getType() != 3) continue;
            return true;
        }
        return false;
    }

    private void updateAll() {
        this.setText("numerictype(" + (this.fHistogram.isSigned() ? "1" : "0") + ", " + this.fHistogram.getWordLength() + ", " + this.fHistogram.getFractionLength() + ")");
    }

    private static class FractionLengthPanel
    extends MJPanel {
        FractionLengthPanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)new MJLabel(CoderResources.getString("f2f.tip.fractionLength")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 3, 3, 3), 0, 0));
        }
    }

    private static class WordLengthPanel
    extends MJPanel {
        WordLengthPanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)new MJLabel(CoderResources.getString("f2f.tip.wordLength")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 3, 3, 3), 0, 0));
        }
    }

    private class SignPanel
    extends MJPanel {
        SignPanel(Token token) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            MJCheckBox mJCheckBox = new MJCheckBox(CoderResources.getString("f2f.check.signed"));
            if (!NumericTypeTextField.this.isEditableSignToken(token)) {
                mJCheckBox.setEnabled(false);
                mJCheckBox.setSelected(false);
            } else {
                mJCheckBox.setSelected(token.getText().equals(NumericType.Signedness.SIGNED.getUserRepresentation()));
                mJCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        NumericTypeTextField.this.fField.replaceFieldToken((((JCheckBox)itemEvent.getItem()).isSelected() ? NumericType.Signedness.SIGNED : NumericType.Signedness.UNSIGNED).getUserRepresentation(), false);
                    }
                });
                mJCheckBox.setEnabled(true);
            }
            mJCheckBox.setOpaque(false);
            this.add((Component)mJCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 3, 3, 3), 0, 0));
        }
    }

    private class TipProvider
    implements FormatTipProvider {
        private TipProvider() {
        }

        public FormatTipContent getTipComponent(FormattedTextField formattedTextField) {
            Object object;
            List list = formattedTextField.getTokens();
            if (list.isEmpty()) {
                return null;
            }
            if (!NumericTypeTextField.this.fConversionModel.hasHistogram()) {
                object = formattedTextField.getFieldTokenForCharIndex(formattedTextField.getInsertionPoint());
                if (object == null) {
                    return null;
                }
                if (object.getType() == 1) {
                    if (!NumericTypeTextField.this.isEditableSignToken(object)) {
                        return null;
                    }
                    return new FormatTipContent((Component)((Object)new SignPanel((Token)object)), object);
                }
                if (object.getType() == 2) {
                    return new FormatTipContent((Component)((Object)new WordLengthPanel()), object);
                }
                if (object.getType() == 3) {
                    return new FormatTipContent((Component)((Object)new FractionLengthPanel()), object);
                }
            }
            object = new MJPanel(new BorderLayout(0, 0)){

                public Dimension getPreferredSize() {
                    return Histogram.HISTOGRAM_SIZE;
                }
            };
            object.setOpaque(false);
            NumericTypeTextField.this.loadHistogram((JComponent)object, list);
            return new FormatTipContent((Component)object, NumericTypeTextField.getFormatTipToken(list));
        }
    }

    private class Tokenizer
    implements FormatTokenizer {
        private Tokenizer() {
        }

        public List<Token> tokenize(String string) {
            int n = string.indexOf(40);
            if (n < 1 || !string.substring(0, n).trim().equals("numerictype")) {
                return Arrays.asList(new Token(0, string));
            }
            ArrayList<Token> arrayList = new ArrayList<Token>();
            arrayList.add(new Token(0, string.substring(0, n + 1)));
            State state = new State(arrayList);
            for (int i = n + 1; i < string.length(); ++i) {
                state.consume(string.charAt(i));
            }
            state.flush();
            return arrayList;
        }

        private class State {
            private List<Token> tokens = new ArrayList<Token>();
            private StringBuilder content = new StringBuilder();
            private int nextTokenType = 1;
            private boolean separator;
            private boolean suffix;

            State(List<Token> list) {
                this.tokens = list;
            }

            public void consume(char c) {
                if (this.suffix) {
                    this.content.append(c);
                } else if (Character.isWhitespace(c) || c == ',') {
                    this.flush();
                    this.separator = true;
                    this.content.append(c);
                } else if (Character.isDigit(c) || c == '-') {
                    if (this.separator) {
                        this.flush();
                    }
                    this.content.append(c);
                } else {
                    this.flush();
                    this.suffix = true;
                    this.content.append(c);
                }
            }

            public void flush() {
                if (this.separator && this.content.length() > 0) {
                    this.tokens.add(new Token(5, this.content.toString()));
                } else if (this.suffix && this.content.length() > 0) {
                    this.tokens.add(new Token(4, this.content.toString()));
                } else {
                    if (this.content.length() > 0) {
                        this.tokens.add(new Token(this.nextTokenType, this.content.toString()));
                    }
                    this.nextTokenType = this.nextTokenType == 1 ? 2 : 3;
                }
                this.separator = false;
                this.content.setLength(0);
            }
        }
    }

    private static class Painter
    extends DefaultFormattedTextFieldPainter {
        private Painter() {
        }

        protected boolean hasBorder(Token token) {
            return token.getType() == 1 || token.getType() == 2 || token.getType() == 3;
        }

        protected boolean isPromptChar(char c) {
            return false;
        }
    }
}

