/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class HDLParameterScope {
    private static final Map<HDLParameterScope, HDLParameterScope> SINGLETONS = new HashMap<HDLParameterScope, HDLParameterScope>();
    public static final HDLParameterScope ENTRY_POINT_FUNCTION = new HDLParameterScope("Entry Point Function", new HDLParameterScope[0]);
    public static final HDLParameterScope SUB_FUNCTION = new HDLParameterScope("Sub-Function", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_INPUT = new HDLParameterScope("Input Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_OUTPUT = new HDLParameterScope("Output Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_TEMP = new HDLParameterScope("Temp Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_INDEX = new HDLParameterScope("Index Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_PERSIST = new HDLParameterScope("Persistent Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope VAR_LOCAL = new HDLParameterScope("Local Variable", new HDLParameterScope[0]);
    public static final HDLParameterScope FUNCTION_CALL = new HDLParameterScope("Function Call", new HDLParameterScope[0]);
    public static final HDLParameterScope FUNCTION = HDLParameterScope.getCompositeInstance("FUNCTION", ENTRY_POINT_FUNCTION, SUB_FUNCTION);
    public static final HDLParameterScope VAR = HDLParameterScope.getCompositeInstance("VARIABLE", VAR_INPUT, VAR_OUTPUT, VAR_TEMP, VAR_INDEX, VAR_PERSIST, VAR_LOCAL);
    public static final HDLParameterScope ALL = HDLParameterScope.getCompositeInstance("ALL", FUNCTION, VAR, FUNCTION_CALL);
    private final Set<HDLParameterScope> fChildScopes;
    private final Set<HDLParameterScope> fParentScopes;
    private final String fDebugName;

    public static synchronized HDLParameterScope getCompositeInstance(String string, HDLParameterScope ... hDLParameterScopeArray) {
        if (hDLParameterScopeArray.length == 0) {
            return null;
        }
        HDLParameterScope hDLParameterScope = new HDLParameterScope(string, hDLParameterScopeArray);
        if (SINGLETONS.containsKey(hDLParameterScope)) {
            return SINGLETONS.get(hDLParameterScope);
        }
        SINGLETONS.put(hDLParameterScope, hDLParameterScope);
        return hDLParameterScope;
    }

    private HDLParameterScope(String string, HDLParameterScope ... hDLParameterScopeArray) {
        this.fChildScopes = new HashSet<HDLParameterScope>(Arrays.asList(hDLParameterScopeArray));
        this.fParentScopes = new HashSet<HDLParameterScope>();
        this.fDebugName = string;
        for (HDLParameterScope hDLParameterScope : hDLParameterScopeArray) {
            hDLParameterScope.addParentScope(this);
        }
    }

    private void addParentScope(HDLParameterScope hDLParameterScope) {
        this.fParentScopes.add(hDLParameterScope);
    }

    public Set<HDLParameterScope> getChildScopes() {
        return new HashSet<HDLParameterScope>(this.fChildScopes);
    }

    public boolean containsScope(HDLParameterScope hDLParameterScope) {
        for (HDLParameterScope hDLParameterScope2 : this.fChildScopes) {
            if (!hDLParameterScope2.equals(hDLParameterScope)) continue;
            return true;
        }
        for (HDLParameterScope hDLParameterScope2 : this.fChildScopes) {
            if (!hDLParameterScope2.containsScope(hDLParameterScope)) continue;
            return true;
        }
        return false;
    }

    public Set<HDLParameterScope> getSuperScopes() {
        HashSet<HDLParameterScope> hashSet = new HashSet<HDLParameterScope>(this.fParentScopes);
        for (HDLParameterScope hDLParameterScope : this.fParentScopes) {
            hashSet.addAll(hDLParameterScope.getSuperScopes());
        }
        return hashSet;
    }

    public String toString() {
        return this.fDebugName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HDLParameterScope)) {
            return false;
        }
        HDLParameterScope hDLParameterScope = (HDLParameterScope)object;
        if (!this.fChildScopes.equals(hDLParameterScope.fChildScopes)) {
            return false;
        }
        return this.fDebugName.equals(hDLParameterScope.fDebugName);
    }

    public int hashCode() {
        int n = this.fChildScopes.hashCode();
        n = 31 * n + this.fDebugName.hashCode();
        return n;
    }
}

