/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.project.impl.workflowui.WorkflowModel;
import com.mathworks.project.impl.workflowui.WorkflowStepWidget;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.TaskListener;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointToolPanel;
import com.mathworks.toolbox.coder.fixedpoint.HDLCoderDataAdapter;
import com.mathworks.toolbox.coder.plugin.workflow.HDLGlassPaneRegistry;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class HDLFixedPointToolWrapper
implements WorkflowStepWidget {
    private final Configuration fConfiguration;
    private final ConversionModel fModel;
    private final FixedPointToolPanel fPanel;
    private final FixedPointDataAdapter fData;
    private final WorkflowStep fStep;
    private final File fEntryPoint;
    private final ConversionStatusManager fStatus;

    public HDLFixedPointToolWrapper(MJFrame mJFrame, Configuration configuration) {
        this.fConfiguration = configuration;
        this.fStep = configuration.getTarget().getWorkflow().getStepByKey("category.float2fixedconversion");
        this.fEntryPoint = (File)configuration.getFileSet("fileset.entrypoints").getFiles().iterator().next();
        this.fModel = new ConversionModel();
        this.fData = new HDLCoderDataAdapter(configuration);
        this.fModel.updateDefaultsFromFimath(this.fData.getFimath());
        this.fModel.deserialize(this.fData, false);
        this.fStatus = new ConversionStatusManager(this.fData, this.fModel);
        GlassPaneManager glassPaneManager = HDLGlassPaneRegistry.getInstance().getGlassPaneManager((JFrame)mJFrame);
        this.fPanel = new FixedPointToolPanel((Window)mJFrame, glassPaneManager, this.fData, this.fStatus, this.fModel, this.fEntryPoint);
        this.fStatus.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HDLFixedPointToolWrapper.this.updateStepState();
            }
        });
    }

    public Component getComponent() {
        return this.fPanel.getComponent();
    }

    public void dispose() {
        this.fPanel.dispose();
        this.fData.dispose();
        this.fStatus.dispose();
    }

    private void updateStepState() {
        if (WorkflowDialog.getInstance() == null) {
            return;
        }
        WorkflowModel workflowModel = WorkflowDialog.getInstance().getModel();
        if (this.fStatus.isSourceCodeOutdated() || this.fStatus.needsValidation() || this.fStatus.needsTypes()) {
            for (WorkflowStep workflowStep = this.fStep; workflowStep != null; workflowStep = workflowStep.getParent()) {
                workflowModel.setResult(workflowStep, null);
            }
        } else if (!this.fStatus.needsTypes()) {
            workflowModel.setResult(this.fStep, WorkflowStepResult.COMPLETED);
        }
    }

    public void activate() {
        this.fPanel.activate();
    }

    public DeploymentProcess createStepRunProcess() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new ReadyStatePoller());
        if (this.fData.getDefaultTestFile() == null && !this.fData.getTestFiles().isEmpty()) {
            this.fData.setDefaultTestFile(this.fData.getTestFiles().iterator().next());
        }
        if (this.fData.getDefaultTestFile() == null) {
            linkedList.add(new TaskWrapper("runStaticAnalysis"){

                @Override
                public void launch(ParameterRunnable<Boolean> parameterRunnable) {
                    HDLFixedPointToolWrapper.this.fPanel.runStaticAnalysis(parameterRunnable);
                }
            });
        } else {
            linkedList.add(new TaskWrapper("runSimulation"){

                @Override
                protected void launch(ParameterRunnable<Boolean> parameterRunnable) {
                    parameterRunnable.run((Object)HDLFixedPointToolWrapper.this.fPanel.runSimulation());
                }
            });
            linkedList.add(new Command(){

                public void execute(final CommandStatus commandStatus) {
                    HDLFixedPointToolWrapper.this.fPanel.getController().checkIfTestbenchInvalidatesMex(new Runnable(){

                        @Override
                        public void run() {
                            commandStatus.finished();
                        }
                    });
                }

                public void cancel() {
                }
            });
        }
        linkedList.add(new TaskWrapper("validateTypes"){

            @Override
            protected void launch(ParameterRunnable<Boolean> parameterRunnable) {
                parameterRunnable.run((Object)HDLFixedPointToolWrapper.this.fPanel.validateTypes());
            }
        });
        return DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])linkedList.toArray(new Command[linkedList.size()]));
    }

    public void reset() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HDLFixedPointToolWrapper.this.fPanel.reset(false);
            }
        });
    }

    public boolean hasIntegratedControlsAndOutput() {
        return true;
    }

    private class ReadyStatePoller
    implements Command {
        private Timer fTimer;
        private boolean fCanceled;

        private ReadyStatePoller() {
        }

        public void execute(final CommandStatus commandStatus) {
            this.fTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ReadyStatePoller.this.fCanceled) {
                        commandStatus.canceled();
                        ReadyStatePoller.this.fTimer.stop();
                    } else if (HDLFixedPointToolWrapper.this.fPanel.getCurrentProcess() == null && (HDLFixedPointToolWrapper.this.fPanel.isTableInitialized() || HDLFixedPointToolWrapper.this.fPanel.getOutputPane().isRetryShowing())) {
                        commandStatus.finished();
                        ReadyStatePoller.this.fTimer.stop();
                    }
                }
            });
            this.fTimer.setRepeats(true);
            this.fTimer.start();
        }

        public void cancel() {
            this.fCanceled = true;
        }
    }

    private class StatusBinder
    implements TaskListener {
        private final String fTaskKey;
        private final Command fCommand;
        private final CommandStatus fStatus;

        StatusBinder(String string, Command command, CommandStatus commandStatus) {
            this.fTaskKey = string;
            this.fCommand = command;
            this.fStatus = commandStatus;
        }

        @Override
        public void taskStarted(String string) {
        }

        @Override
        public void taskSucceeded(String string) {
            if (string.equals(this.fTaskKey)) {
                this.fStatus.finished();
                HDLFixedPointToolWrapper.this.fPanel.getOutputPane().removeTaskListener(this);
            }
        }

        @Override
        public void taskFailed(String string) {
            if (string.equals(this.fTaskKey) || string.equals("build")) {
                this.fStatus.failed(new CommandExecutionException(this.fCommand));
                HDLFixedPointToolWrapper.this.fPanel.getOutputPane().removeTaskListener(this);
            }
        }

        @Override
        public void taskCanceled(String string) {
            if (string.equals(this.fTaskKey) || string.equals("build")) {
                this.fStatus.canceled();
                HDLFixedPointToolWrapper.this.fPanel.getOutputPane().removeTaskListener(this);
            }
        }
    }

    private abstract class TaskWrapper
    implements Command {
        private final String fTaskKey;

        TaskWrapper(String string) {
            this.fTaskKey = string;
        }

        public void execute(final CommandStatus commandStatus) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    final StatusBinder statusBinder = new StatusBinder(TaskWrapper.this.fTaskKey, TaskWrapper.this, commandStatus);
                    HDLFixedPointToolWrapper.this.fPanel.getOutputPane().addTaskListener(statusBinder);
                    TaskWrapper.this.launch(new ParameterRunnable<Boolean>(){

                        public void run(Boolean bl) {
                            if (!bl.booleanValue()) {
                                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        HDLFixedPointToolWrapper.this.fPanel.getOutputPane().removeTaskListener(statusBinder);
                                        commandStatus.failed(new CommandExecutionException((Command)TaskWrapper.this));
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }

        protected abstract void launch(ParameterRunnable<Boolean> var1);

        public void cancel() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    DeploymentProcess deploymentProcess = HDLFixedPointToolWrapper.this.fPanel.getOutputPane().getCurrentProcess();
                    if (deploymentProcess != null) {
                        deploymentProcess.cancel();
                    }
                }
            });
        }
    }
}

