/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.NotificationManager;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.TabbedOutputContext;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTable;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointBuildManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.mi.CodeCoverageMI;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.mi.FevalCommand;
import com.mathworks.toolbox.coder.mi.StructureUtils;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FixedPointController {
    private final FixedPointDataAdapter fData;
    private final ConversionModel fModel;
    private final ConversionStatusManager fStatus;
    private final FixedPointBuildManager fBuildManager;
    private final CodeCoverageModel fCoverageModel;
    private final AnalysisTable fTable;
    private final TabbedOutputContext fOutputContext;
    private final PopupBarManager fPopupBar;
    private final NotificationManager fNotificationManager;
    private final String fTableTabKey;
    private final Runnable fPreRun;
    private final RequestFilter fUpdateTypes;
    private final ParameterRunnable<Boolean> fPostDeriveAction;
    private final ParameterRunnable<Collection<BuildError>> fErrorHandler;
    private int fProposedTypesUpdateIndex;
    public static final String SIMULATION_TASK_KEY = "runSimulation";
    public static final String SIMULATION_ERRORS_KEY = "runSimulation-errors";
    public static final String STATIC_ANALYSIS_TASK_KEY = "runStaticAnalysis";
    public static final String STATIC_ANALYSIS_ERRORS_KEY = "runStaticAnalysis-errors";
    public static final String VALIDATE_TASK_KEY = "validateTypes";
    public static final String VALIDATE_ERRORS_KEY = "validateTypes-errors";
    public static final String TEST_NUMERICS_TASK_KEY = "verifyNumerics";
    public static final String TEST_NUMERICS_ERRORS_KEY = "verifyNumerics-errors";
    private boolean fAutomaticPostSimMexCheck;

    public FixedPointController(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, ConversionStatusManager conversionStatusManager, FixedPointBuildManager fixedPointBuildManager, CodeCoverageModel codeCoverageModel, AnalysisTable analysisTable, TabbedOutputContext tabbedOutputContext, PopupBarManager popupBarManager, NotificationManager notificationManager, String string, @NotNull Runnable runnable, @Nullable ParameterRunnable<Boolean> parameterRunnable, @Nullable ParameterRunnable<Collection<BuildError>> parameterRunnable2) {
        this.fData = fixedPointDataAdapter;
        this.fModel = conversionModel;
        this.fStatus = conversionStatusManager;
        this.fBuildManager = fixedPointBuildManager;
        this.fCoverageModel = codeCoverageModel;
        this.fTable = analysisTable;
        this.fOutputContext = tabbedOutputContext;
        this.fPopupBar = popupBarManager;
        this.fNotificationManager = notificationManager;
        this.fTableTabKey = string;
        this.fPreRun = runnable;
        this.fPostDeriveAction = parameterRunnable;
        this.fUpdateTypes = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                FixedPointController.this.doProposedTypesUpdate();
            }
        }, 100);
        this.fErrorHandler = parameterRunnable2;
        this.setAutomaticPostSimMexCheck(true);
    }

    public boolean isAutomaticPostSimMexCheck() {
        return this.fAutomaticPostSimMexCheck;
    }

    public void setAutomaticPostSimMexCheck(boolean bl) {
        this.fAutomaticPostSimMexCheck = bl;
    }

    public void preRun() {
        this.fPreRun.run();
    }

    public FixedPointDataAdapter getData() {
        return this.fData;
    }

    public ConversionStatusManager getStatus() {
        return this.fStatus;
    }

    public void runSimulation(Runnable runnable) {
        final Set<File> set = this.fData.getSimulationTestFiles().getFiles();
        this.runSimulation(new SimulationContext(){

            @Override
            public List<File> getTestFiles() {
                return new ArrayList<File>(set);
            }

            @Override
            public boolean isSynthetic() {
                return false;
            }

            @Override
            public String getCodeIfSynthetic(File file) {
                return null;
            }
        }, runnable, null);
    }

    public void runSimulation(SimulationContext simulationContext, Runnable runnable, @Nullable Runnable runnable2) {
        this.fPreRun.run();
        this.fTable.hideMissingDesignRangeHint();
        List<File> list = simulationContext.getTestFiles();
        Command[] commandArray = new FevalCommand[1 + list.size()];
        Iterator<File> iterator = list.iterator();
        commandArray[0] = new FevalCommand("", "clear", "mex");
        commandArray[0].setOutputCount(0);
        File file = this.fData.getEntryPoints().iterator().next();
        for (int i = 1; i < commandArray.length; ++i) {
            File file2 = iterator.next();
            final int n = i;
            commandArray[i] = new FevalCommand(MessageFormat.format(CoderResources.getString("f2f.task.runningSimulation"), simulationContext.isSynthetic() ? "" : file2.getName()), "emlcprivate", new Object[]{"fpRunSimulation", this.fData, file.getAbsolutePath(), file2.getAbsolutePath(), simulationContext.isSynthetic(), false, false}, (FevalCommand[])commandArray, simulationContext, runnable, runnable2){
                final /* synthetic */ FevalCommand[] val$commands;
                final /* synthetic */ SimulationContext val$simContext;
                final /* synthetic */ Runnable val$passContinuation;
                final /* synthetic */ Runnable val$failContinuation;
                {
                    this.val$commands = fevalCommandArray;
                    this.val$simContext = simulationContext;
                    this.val$passContinuation = runnable;
                    this.val$failContinuation = runnable2;
                    super(string, string2, objectArray);
                }

                @Override
                protected void handleResult(final Object object) {
                    if (FixedPointController.this.isAutomaticPostSimMexCheck()) {
                        FixedPointController.this.checkIfTestbenchInvalidatesMex(new Runnable(){

                            @Override
                            public void run() {
                                FixedPointController.this.handleSimulationResults(object, n, val$commands, val$simContext, val$passContinuation, val$failContinuation);
                            }
                        });
                    } else {
                        FixedPointController.this.handleSimulationResults(object, n, this.val$commands, this.val$simContext, this.val$passContinuation, this.val$failContinuation);
                    }
                }
            };
            commandArray[i].setOutputCount(5);
            commandArray[i].setFatalErrorMessageIndex(3);
        }
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])commandArray);
        this.fBuildManager.buildIfNecessaryAndRun(SIMULATION_TASK_KEY, CoderResources.getString("f2f.tab.simulationOutput"), deploymentProcess);
    }

    public void checkIfTestbenchInvalidatesMex(final @Nullable Runnable runnable) {
        this.fBuildManager.checkInstrumentedMex(new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                FixedPointController.this.fModel.setDependencyModifyingTestBenchFlag(bl == false);
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    private void handleSimulationResults(Object object, int n, FevalCommand[] fevalCommandArray, SimulationContext simulationContext, Runnable runnable, @Nullable Runnable runnable2) {
        MetadataTree<Range> metadataTree = new MetadataTree<Range>();
        MetadataTree<MatlabType> metadataTree2 = new MetadataTree<MatlabType>();
        MetadataTree<String> metadataTree3 = new MetadataTree<String>();
        MetadataTree<Boolean> metadataTree4 = new MetadataTree<Boolean>();
        MetadataTree<Boolean> metadataTree5 = new MetadataTree<Boolean>();
        MetadataTree<FimathPanel.RoundingMethod> metadataTree6 = new MetadataTree<FimathPanel.RoundingMethod>();
        MetadataTree<FimathPanel.OverflowAction> metadataTree7 = new MetadataTree<FimathPanel.OverflowAction>();
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        List<BuildError> list = ConversionUtils.convertErrors(((Object[])object)[4]);
        if (simulationContext.isSynthetic()) {
            for (File object22 : simulationContext.getTestFiles()) {
                if (!object22.exists()) continue;
                object22.delete();
            }
            if (!list.isEmpty()) {
                List<BuildError> list2 = list;
                list = new LinkedList<BuildError>();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    BuildError buildError = (BuildError)iterator.next();
                    if (buildError.getFunction() != null && buildError.getFunction().getFile() != null && (string = simulationContext.getCodeIfSynthetic(buildError.getFunction().getFile())) != null) {
                        buildError = new BuildError(string, buildError.getPosition(), buildError.getLine(), buildError.getLength(), buildError.getSeverity(), buildError.getMessage());
                    }
                    list.add(buildError);
                }
            }
        }
        boolean bl = true;
        if (!list.isEmpty()) {
            bl = Utilities.maxValue(list, new Converter<BuildError, BuildErrorSeverity>(){

                public BuildErrorSeverity convert(BuildError buildError) {
                    return buildError.getSeverity();
                }
            }).compareTo(BuildErrorSeverity.ERROR) < 0;
            this.fOutputContext.showErrors(SIMULATION_TASK_KEY, SIMULATION_ERRORS_KEY, CoderResources.getString("f2f.errors.simulation"), true, true, FixedPointController.createErrorTableHeader(bl ? "f2f.simulation.warnings" : "f2f.simulation.errors", bl), list);
            if (!bl && runnable2 != null) {
                runnable2.run();
            }
        }
        if (this.fErrorHandler != null) {
            this.fErrorHandler.run(list);
        }
        if (!bl) {
            return;
        }
        ConversionUtils.convertRangesAndTypes(object, "SimMin", "SimMax", metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree5, metadataTree6, metadataTree7, linkedList);
        this.fModel.setSimulationData(metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree5, metadataTree6, metadataTree7, this.fData.isHistogramLoggingEnabled());
        this.fModel.setExpressions(linkedList);
        this.fModel.fireQueuedPropertyChanges();
        List<CodeCoverageMI.CovInfo> list2 = StructureUtils.translate(CodeCoverageMI.CovInfo.class, ((Object[])object)[2]);
        ConversionUtils.convertOffsets(list2);
        this.fCoverageModel.refresh(list2);
        if (n == fevalCommandArray.length - 1) {
            runnable.run();
        }
    }

    public boolean runStaticAnalysis(final ParameterRunnable<Boolean> parameterRunnable) {
        this.fPreRun.run();
        final Holder holder = new Holder((Object)true);
        this.fBuildManager.buildIfNecessaryAndRun(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!FixedPointController.this.prepareForStaticAnalysis(true)) {
                            holder.set((Object)false);
                            if (parameterRunnable != null) {
                                parameterRunnable.run(holder.get());
                            }
                        }
                    }
                });
            }
        });
        return (Boolean)holder.get();
    }

    public void cancelStaticAnalysis() {
        this.fTable.hideMissingDesignRangeHint();
    }

    public boolean prepareForStaticAnalysis(final boolean bl) {
        boolean bl2;
        if (!this.fModel.getVariablesWithUnspecifiedDesignRanges(this.fData, true).isEmpty()) {
            bl2 = this.fTable.autoDefineInputRanges(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        final PopupBarManager.Block block = FixedPointController.this.fPopupBar.block();
                        Timer timer = new Timer(800, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                FixedPointController.this.doStaticAnalysis();
                                block.dispose();
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    }
                }
            });
            if (bl2) {
                return true;
            }
            if (!this.fModel.getVariablesWithUnspecifiedDesignRanges(this.fData, false).isEmpty()) {
                this.fTable.showMissingDesignRanges();
                this.fOutputContext.activateTab(this.fTableTabKey);
                this.fTable.showMissingDesignRangeHint();
                return false;
            }
        }
        if (!this.fTable.getVariablesWithOldAutoDefinedDesignRanges().isEmpty() && (bl2 = this.fTable.autoDefineInputRanges(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    FixedPointController.this.fPreRun.run();
                    final PopupBarManager.Block block = FixedPointController.this.fPopupBar.block();
                    Timer timer = new Timer(800, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            FixedPointController.this.doStaticAnalysis();
                            block.dispose();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        }))) {
            return true;
        }
        if (bl) {
            this.doStaticAnalysis();
        }
        return true;
    }

    private void doStaticAnalysis() {
        this.fTable.hideMissingDesignRangeHint();
        File file = this.fData.getEntryPoints().iterator().next();
        FevalCommand fevalCommand = new FevalCommand(CoderResources.getString("f2f.task.computingStaticRanges"), "emlcprivate", new Object[]{"fpComputeStaticRanges", this.fData, file.getAbsolutePath()}){

            @Override
            protected void handleResult(Object object) {
                MetadataTree<Range> metadataTree = new MetadataTree<Range>();
                MetadataTree<MatlabType> metadataTree2 = new MetadataTree<MatlabType>();
                MetadataTree<String> metadataTree3 = new MetadataTree<String>();
                MetadataTree<Boolean> metadataTree4 = new MetadataTree<Boolean>();
                MetadataTree<Boolean> metadataTree5 = new MetadataTree<Boolean>();
                MetadataTree<FimathPanel.RoundingMethod> metadataTree6 = new MetadataTree<FimathPanel.RoundingMethod>();
                MetadataTree<FimathPanel.OverflowAction> metadataTree7 = new MetadataTree<FimathPanel.OverflowAction>();
                LinkedList<Expression> linkedList = new LinkedList<Expression>();
                ConversionUtils.convertRangesAndTypes(object, "DerivedMin", "DerivedMax", metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree5, metadataTree6, metadataTree7, linkedList);
                FixedPointController.this.fData.setStaticAnalysisChecksum(FixedPointController.this.fTable.getConversionModel().generateDesignRangeChecksum());
                FixedPointController.this.fTable.getConversionModel().setDerivedRangesAndTypes(metadataTree, metadataTree2, metadataTree3, metadataTree4, metadataTree6, metadataTree7);
                FixedPointController.this.fStatus.refreshStaticAnalysisStatus();
                List<CodeCoverageMI.StaticAnalysisInfo> list = StructureUtils.translate(CodeCoverageMI.StaticAnalysisInfo.class, ((Object[])object)[4]);
                FixedPointController.this.fModel.setExpressions(linkedList);
                FixedPointController.this.fModel.fireQueuedPropertyChanges();
                FixedPointController.this.fCoverageModel.setStaticAnalysisData(list);
                List<BuildError> list2 = ConversionUtils.convertErrors(((Object[])object)[2]);
                boolean bl = list2.isEmpty();
                if (!bl) {
                    FixedPointController.this.fOutputContext.showErrors(FixedPointController.STATIC_ANALYSIS_TASK_KEY, FixedPointController.STATIC_ANALYSIS_ERRORS_KEY, CoderResources.getString("f2f.errors.staticAnalysis"), true, false, null, list2);
                } else {
                    FixedPointController.this.fOutputContext.activateTab(FixedPointController.this.fTableTabKey);
                }
                if (FixedPointController.this.fErrorHandler != null) {
                    FixedPointController.this.fErrorHandler.run(list2);
                }
                if (FixedPointController.this.fPostDeriveAction != null) {
                    FixedPointController.this.fPostDeriveAction.run((Object)bl);
                }
            }
        };
        fevalCommand.setOutputCount(5);
        fevalCommand.setFatalErrorMessageIndex(3);
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])new Command[]{fevalCommand});
        this.fOutputContext.runWithLog(STATIC_ANALYSIS_TASK_KEY, CoderResources.getString("f2f.tab.staticAnalysisOutput"), deploymentProcess);
    }

    public void validateTypes(final boolean bl, final Runnable runnable) {
        this.fBuildManager.buildIfNecessaryAndRun(new Runnable(){

            @Override
            public void run() {
                FixedPointController.this.doValidateTypes(bl, runnable);
            }
        });
    }

    private void doValidateTypes(final boolean bl, final Runnable runnable) {
        this.fTable.hideMissingDesignRangeHint();
        File file = this.fData.getEntryPoints().iterator().next();
        FevalCommand fevalCommand = new FevalCommand(CoderResources.getString(bl ? "f2f.task.buildFixedPoint" : "f2f.task.validateTypes"), "emlcprivate", new Object[]{"fpGenerateFixedPointCode", this.fData, file.getAbsolutePath()}){

            @Override
            protected boolean checkForSuccess(final Object object, CommandStatus commandStatus) {
                final Object[] objectArray = (Object[])object;
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        List<BuildError> list = ConversionUtils.convertErrors(((Object[])object)[0]);
                        if (!list.isEmpty()) {
                            boolean bl = ((boolean[])objectArray[1])[0];
                            String string = bl ? "f2f.validation.warnings" : "f2f.validation.failed";
                            Component component = FixedPointController.createErrorTableHeader(string, bl);
                            FixedPointController.this.fOutputContext.showErrors(FixedPointController.VALIDATE_TASK_KEY, FixedPointController.VALIDATE_ERRORS_KEY, CoderResources.getString("f2f.errors.validation"), false, false, component, list);
                        } else if (!this.wasCanceled()) {
                            FixedPointController.this.fNotificationManager.showMessage(CoderResources.getString(bl ? "f2f.fixedPointBuild.succeeded" : "f2f.validation.succeeded"));
                            FixedPointController.this.fOutputContext.activateTab(FixedPointController.this.fTableTabKey);
                        }
                        if (FixedPointController.this.fErrorHandler != null) {
                            FixedPointController.this.fErrorHandler.run(list);
                        }
                    }
                });
                if (!((boolean[])objectArray[1])[0]) {
                    commandStatus.failed(new CommandExecutionException((Command)this));
                    return false;
                }
                return true;
            }
        };
        fevalCommand.setOutputCount(3);
        fevalCommand.setFatalErrorMessageIndex(2);
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])new Command[]{fevalCommand});
        deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){

            public void finished() {
                FixedPointController.this.fStatus.validationSucceeded();
                if (runnable != null) {
                    runnable.run();
                }
            }

            public void failed() {
                FixedPointController.this.fStatus.validationFailed();
            }

            public void canceled() {
                this.failed();
            }
        });
        this.fOutputContext.runWithLog(VALIDATE_TASK_KEY, CoderResources.getString("f2f.tab.typeValidationOutput"), deploymentProcess);
    }

    public void testNumerics(List<File> list, boolean bl, final Runnable runnable) {
        this.fTable.hideMissingDesignRangeHint();
        Command[] commandArray = new FevalCommand[list.size()];
        Iterator<File> iterator = list.iterator();
        final LinkedList linkedList = new LinkedList();
        for (int i = 0; i < commandArray.length; ++i) {
            File file = iterator.next();
            commandArray[i] = new FevalCommand(MessageFormat.format(CoderResources.getString("f2f.task.verify"), bl ? "" : file.getName()), "emlcprivate", new Object[]{"fpVerifyNumerics", this.fData, this.fData.getEntryPoints().iterator().next().getAbsolutePath(), file.getAbsolutePath()}){

                @Override
                public void handleResult(Object object) {
                    linkedList.addAll(ConversionUtils.convertErrors(((Object[])object)[0]));
                }
            };
            commandArray[i].setOutputCount(2);
            commandArray[i].setFatalErrorMessageIndex(1);
        }
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])commandArray);
        deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){

            public void finished() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!linkedList.isEmpty()) {
                            FixedPointController.this.fOutputContext.showErrors(FixedPointController.TEST_NUMERICS_TASK_KEY, FixedPointController.TEST_NUMERICS_ERRORS_KEY, CoderResources.getString("f2f.errors.overflow"), false, true, null, linkedList);
                        }
                        if (FixedPointController.this.fErrorHandler != null) {
                            FixedPointController.this.fErrorHandler.run((Object)linkedList);
                        }
                    }
                });
                if (runnable != null) {
                    runnable.run();
                }
            }

            public void failed() {
                if (runnable != null) {
                    runnable.run();
                }
            }

            public void canceled() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.fOutputContext.runWithLog(TEST_NUMERICS_TASK_KEY, CoderResources.getString("f2f.tab.verificationOutput"), deploymentProcess);
    }

    public RequestFilter getProposedTypesUpdater() {
        return this.fUpdateTypes;
    }

    public void updateProposedTypes() {
        this.fUpdateTypes.request();
    }

    private void doProposedTypesUpdate() {
        final int n = ++this.fProposedTypesUpdateIndex;
        if (this.fModel.hasComputedProposedTypes()) {
            FevalCommand fevalCommand = new FevalCommand(CoderResources.getString("f2f.status.updatingTypes"), "emlcprivate", new Object[]{"fpProposeTypes", this.fData}){

                @Override
                protected void handleResult(Object object) {
                    MetadataTree<String> metadataTree = new MetadataTree<String>();
                    MetadataTree<Boolean> metadataTree2 = new MetadataTree<Boolean>();
                    ConversionUtils.convertTypes(object, metadataTree, metadataTree2);
                    if (FixedPointController.this.fProposedTypesUpdateIndex == n) {
                        FixedPointController.this.fTable.setProposedTypes(metadataTree, metadataTree2);
                    }
                }
            };
            fevalCommand.setOutputCount(2);
            DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.fData.getConfiguration(), (Command[])new Command[]{fevalCommand});
            this.fOutputContext.runWithoutLog(deploymentProcess);
            deploymentProcess.start();
        }
    }

    private static Component createErrorTableHeader(String string, boolean bl) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
        MJLabel mJLabel = new MJLabel();
        mJPanel.add((Component)mJLabel);
        if (bl) {
            mJPanel.setBackground(new Color(230, 255, 230));
        } else {
            mJPanel.setBackground(new Color(230, 85, 85));
            mJLabel.setForeground(Color.WHITE);
        }
        mJLabel.setText(CoderResources.getString(string));
        mJPanel.setBorder(new LineBorder(new Color(225, 225, 225)));
        return mJPanel;
    }

    public static interface SimulationContext {
        @NotNull
        public List<File> getTestFiles();

        public boolean isSynthetic();

        @Nullable
        public String getCodeIfSynthetic(File var1);
    }
}

