/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mlwidgets.MatlabHyperlinkHandler;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.app.StaleTextMapper;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.Interval;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.ext.ExtUtilities;

public final class CodePopupController {
    public static final int SCAN_PERIOD = 600;
    public static final int TRIGGER_DELAY = 650;
    private final EditorView fCodePane;
    private final Timer fTimer;
    private final Map<String, Function> fFunctions;
    private final UnifiedModel fModel;
    private final MouseAdapter fMouseAdapter;
    private final DocumentListener fDocumentListener;
    private final FocusListener fFocusListener;
    private final CodePopupFrame.CodePopupFrameListener fPopupFrameListener;
    private final StaleTextMapper fTextMapper;
    private final Collection<PopupControllerObserver> fObservers;
    private EditorLoadContext fEditorContext;
    private CodePopupFrame fInfoPopup;
    private HintPopupFrame fErrorPopup;
    private HintPopupFrame fSpecializationPopup;
    private SyntaxTextPane fTextPane = null;
    private PopupContext fTrigger;
    private PopupContext fPopup;
    private Timer fTriggerTimer;
    private Point fForcedPoint;
    private boolean fDisposed;

    public CodePopupController(CodePopupFrame codePopupFrame, EditorView editorView, UnifiedModel unifiedModel) {
        this.fCodePane = editorView;
        this.fFunctions = new HashMap<String, Function>();
        this.fTextMapper = editorView.getTextMapper();
        this.fObservers = new LinkedList<PopupControllerObserver>();
        this.fInfoPopup = codePopupFrame;
        this.fModel = unifiedModel;
        this.fPopupFrameListener = new CodePopupFrame.CodePopupFrameListener(){

            @Override
            public void popupVisibilityChanged(boolean bl, boolean bl2) {
                if (!bl) {
                    CodePopupController.this.updatePopup();
                }
            }
        };
        this.fInfoPopup.addCodePopupFrameListener(this.fPopupFrameListener);
        this.fTimer = new Timer(600, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodePopupController.this.updatePopup();
            }
        });
        this.fMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                CodePopupController.this.updatePopup();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CodePopupController.this.updatePopup();
            }
        };
        this.fFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CodePopupController.this.updatePopup();
            }
        };
        this.fDocumentListener = this.createDocumentListener();
    }

    public CodePopupController(Window window, EditorView editorView, UnifiedModel unifiedModel, CodePopupFrame.CodePopupContentView codePopupContentView) {
        this(new CodePopupFrame(window, codePopupContentView), editorView, unifiedModel);
    }

    public void addPopupControllerObserver(PopupControllerObserver popupControllerObserver) {
        this.fObservers.add(popupControllerObserver);
    }

    public void setSyntaxTextPane(SyntaxTextPane syntaxTextPane) {
        assert (MJUtilities.isEventDispatchThread());
        if (this.fTextPane != null) {
            this.fTextPane.removeMouseMotionListener((MouseMotionListener)this.fMouseAdapter);
            this.fTextPane.removeMouseListener((MouseListener)this.fMouseAdapter);
            this.fTextPane.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fTextPane.removeFocusListener(this.fFocusListener);
        }
        this.fTextPane = syntaxTextPane;
        if (this.fTextPane != null) {
            this.fTextPane.addMouseMotionListener((MouseMotionListener)this.fMouseAdapter);
            this.fTextPane.addMouseListener((MouseListener)this.fMouseAdapter);
            this.fTextPane.getDocument().addDocumentListener(this.fDocumentListener);
            this.fTextPane.addFocusListener(this.fFocusListener);
            MWToolTipSupport mWToolTipSupport = (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)this.fTextPane).getToolTipSupport();
            if (mWToolTipSupport != null) {
                mWToolTipSupport.unregisterMouseListeners((JTextComponent)this.fTextPane);
            }
        }
    }

    public void takeCodeStateSnapshot() {
    }

    public void dispose() {
        this.fDisposed = true;
        this.fTimer.stop();
        this.closeActivePopup(null);
        this.setSyntaxTextPane(null);
        this.fInfoPopup.removeCodePopupFrameListener(this.fPopupFrameListener);
    }

    public void setEditorLoadContext(@Nullable EditorLoadContext editorLoadContext) {
        this.fEditorContext = editorLoadContext;
        this.fFunctions.clear();
        this.closeActivePopup(null);
        this.fTrigger = null;
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.performUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.performUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.performUpdate(documentEvent);
            }

            private void performUpdate(DocumentEvent documentEvent) {
                CodePopupController.this.updatePopupPosition(documentEvent);
            }
        };
    }

    private CodePopupFrame.CodePopupContext createPopupContext(FunctionScopedKey<?> functionScopedKey, int n, int n2, PopupContext popupContext) {
        return this.createPopupContext(functionScopedKey, null, n, n2, popupContext);
    }

    private CodePopupFrame.CodePopupContext createPopupContext(Function function, int n, int n2, PopupContext popupContext) {
        return this.createPopupContext(null, function, n, n2, popupContext);
    }

    private CodePopupFrame.CodePopupContext createPopupContext(FunctionScopedKey<?> functionScopedKey, Function function, int n, int n2, final PopupContext popupContext) {
        SyntaxTextPane syntaxTextPane = this.fCodePane.getTextPane();
        Point point = new Point(n, n2);
        Predicate<Point> predicate = new Predicate<Point>(){

            public boolean accept(Point point) {
                int n = CodePopupController.this.fCodePane.getPosFromPoint(point);
                if (n != -1) {
                    Interval interval = popupContext.getInterval();
                    return interval != null && interval.contains(n);
                }
                return false;
            }
        };
        if (functionScopedKey != null) {
            return new CodePopupFrame.CodePopupContext(functionScopedKey, (Component)syntaxTextPane, point, predicate);
        }
        return new CodePopupFrame.CodePopupContext(function, (Component)syntaxTextPane, point, predicate);
    }

    private void updatePopupPosition(DocumentEvent documentEvent) {
        if (this.fPopup == null) {
            return;
        }
        try {
            if (documentEvent.getType().equals(DocumentEvent.EventType.INSERT) && this.fPopup.getAnchorPosition() >= documentEvent.getOffset()) {
                this.fPopup.setAnchorPosition(this.fPopup.getAnchorPosition() + documentEvent.getLength());
            } else if (documentEvent.getType().equals(DocumentEvent.EventType.REMOVE)) {
                int n = documentEvent.getOffset() + documentEvent.getLength();
                if (this.fPopup.getAnchorPosition() >= n) {
                    this.fPopup.setAnchorPosition(this.fPopup.getAnchorPosition() - documentEvent.getLength());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static Dimension calcCenterOffset(int n, STPBaseInterface sTPBaseInterface) {
        Dimension dimension = new Dimension();
        try {
            int n2 = sTPBaseInterface.getWordEndFromPos(n);
            Point point = sTPBaseInterface.getPointFromPos(n);
            Point point2 = n2 >= 0 ? sTPBaseInterface.getPointFromPos(n2) : point;
            dimension.setSize((point2.x - point.x) / 2, sTPBaseInterface.getLineHeight());
        }
        catch (BadLocationException badLocationException) {
            dimension.setSize(0, 0);
        }
        return dimension;
    }

    public Function getEffectiveFunction(int n, boolean bl) {
        MTree.Node node;
        if (this.getFunctionIfActive() == null) {
            return null;
        }
        int n2 = this.fTextMapper.mapToOriginal(n);
        MTree.Node node2 = this.fTextMapper.getNodeAtPosition(n2);
        if (node2 != null && (node = FunctionUtils.getParentOfType(node2, MTree.NodeType.FUNCTION)) != null && node.getType() == MTree.NodeType.FUNCTION) {
            String string = node.getFunctionName().getText();
            return this.getFunctions(bl).get(string);
        }
        return null;
    }

    public void forcePointForTesting(Point point) {
        this.fForcedPoint = point;
        this.updatePopup();
    }

    public void closeActivePopup(@Nullable Class<?> clazz) {
        if (this.fPopup != null && (clazz == null || clazz.equals(this.fPopup.getClass()))) {
            this.fPopup.close();
            this.fPopup = null;
            this.fireCurrentPopupChanged(null);
        }
    }

    private void setTrigger(PopupContext popupContext) {
        if (this.fDisposed) {
            return;
        }
        if (popupContext != null && this.fTrigger != null && popupContext.equals(this.fTrigger)) {
            return;
        }
        if (this.fPopup != null && this.fPopup.hasFocus()) {
            return;
        }
        if (this.fTrigger != null && !this.fTrigger.equals(popupContext) || popupContext != null && this.fTrigger == null) {
            this.fTrigger = popupContext;
            if (this.fTriggerTimer != null) {
                this.fTriggerTimer.stop();
            }
            this.fTriggerTimer = new Timer(650, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!(CodePopupController.this.fDisposed || CodePopupController.this.fPopup != null && CodePopupController.this.fPopup.hasFocus())) {
                        CodePopupController.this.closeActivePopup(null);
                        CodePopupController.this.fPopup = CodePopupController.this.fTrigger;
                        if (CodePopupController.this.fTrigger != null) {
                            CodePopupController.this.fTrigger.run();
                        }
                        CodePopupController.this.fireCurrentPopupChanged(CodePopupController.this.fTrigger);
                    }
                }
            });
            this.fTriggerTimer.setRepeats(false);
            this.fTriggerTimer.start();
        }
    }

    private void fireCurrentPopupChanged(@Nullable PopupContext popupContext) {
        PopupFlavor popupFlavor = null;
        Interval interval = null;
        if (popupContext != null) {
            popupFlavor = popupContext.getPopupFlavor();
            interval = popupContext.getInterval();
        }
        for (PopupControllerObserver popupControllerObserver : this.fObservers) {
            popupControllerObserver.currentPopupChanged(popupFlavor, interval);
        }
    }

    private Map<String, Function> getFunctions(boolean bl) {
        Map<String, Function> map = this.fFunctions;
        if (bl) {
            map = new HashMap<String, Function>();
        }
        if (map.isEmpty() && this.fModel.hasVariableNames()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Function object : this.fModel.getFunctions()) {
                if (!object.getFile().equals(this.fEditorContext.getFunction().getFile())) continue;
                if (object.isSpecialized() && !bl) {
                    hashSet.add(object.getName());
                }
                if (object.isSpecialized() && (map.containsKey(object.getName()) || !bl)) continue;
                map.put(object.getName(), object);
            }
            for (String string : hashSet) {
                map.remove(string);
            }
        }
        return map;
    }

    public void updatePopup() {
        this.updatePopup(false);
    }

    private void updatePopup(boolean bl) {
        MTree.Node node;
        if (this.fTextPane == null || this.fModel.getVariableNames() == null || this.fPopup != null && this.fPopup.hasFocus()) {
            return;
        }
        if (this.getFunctionIfActive() == null) {
            this.closeActivePopup(null);
            return;
        }
        Point point = this.fTextPane.getMousePosition(true);
        if (this.fForcedPoint != null) {
            point = this.fForcedPoint;
        }
        if (point == null) {
            this.setTrigger(null);
            return;
        }
        if (this.fInfoPopup != null && this.fInfoPopup.getBounds() != null) {
            Point point2 = new Point(point);
            SwingUtilities.convertPointToScreen(point2, (Component)this.fTextPane);
            if (this.fInfoPopup.getBounds().contains(point2) && !bl) {
                return;
            }
        }
        int n = -1;
        int n2 = -1;
        try {
            n2 = this.fTextPane.getPosFromPoint(point);
            n = this.fTextMapper.mapToOriginal(n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        PopupContext popupContext = this.handleAsBuildError(n, n2, point);
        if (popupContext == null && (node = this.fTextMapper.getNodeAtPosition(n)) != null) {
            popupContext = this.handleFromMTreeNode(n, node);
        }
        this.setTrigger(popupContext);
    }

    private Function getFunctionIfActive() {
        return this.fEditorContext != null && this.fEditorContext.hasFunction() ? this.fEditorContext.getFunction() : null;
    }

    private PopupContext handleFromMTreeNode(int n, MTree.Node node) {
        PopupContext popupContext = null;
        MTree.Node node2 = FunctionUtils.getParentOfType(node, MTree.NodeType.FUNCTION);
        String string = node2 != null && node2.getType() == MTree.NodeType.FUNCTION ? node2.getFunctionName().getText() : null;
        Function function = this.getFunctionIfActive();
        Map<String, Function> map = this.getFunctions(false);
        Function function2 = null;
        if (function != null && string != null) {
            function2 = function.getName().equals(string) && (map.containsKey(string) || function.isSpecialized()) ? function : map.get(string);
        }
        if (node.getType() != MTree.NodeType.ID && node.getType() != MTree.NodeType.FIELD && node.getType() != MTree.NodeType.DOT || node.getAttribute() == null || (popupContext = this.handleAsVariable(n, string, function2, node)) != null || node.getType() != MTree.NodeType.NOT) {
            // empty if block
        }
        if (popupContext == null) {
            popupContext = this.handleAsExpression(n, function2);
        }
        return popupContext;
    }

    private Point calcAnchorPoint(MTree.Node node) throws BadLocationException {
        int n = this.fTextMapper.mapToCurrent(this.fTextMapper.getMinimumPosition(node));
        int n2 = this.fTextMapper.mapToCurrent(this.fTextMapper.getMaximumPosition(node));
        Point point = this.fTextPane.getPointFromPos(n);
        Point point2 = this.fTextPane.getPointFromPos(n2);
        Point point3 = new Point((int)(point.getX() + point2.getX()) / 2, (int)point.getY() + this.fTextPane.getLineHeight());
        SwingUtilities.convertPointToScreen(point3, (Component)this.fTextPane);
        return point3;
    }

    private Interval getUnmappedInterval(MTree.Node node) {
        int n = this.fTextMapper.getMinimumPosition(node);
        return new Interval(n, this.fTextMapper.getMaximumPosition(node));
    }

    private PopupContext handleAsBuildError(int n, int n2, Point point) {
        BuildError buildError = this.fCodePane.getBuildError(n);
        if (buildError != null) {
            try {
                Point point2 = new Point((int)point.getX(), (int)this.fTextPane.getPointFromPos(n2).getY() + this.fTextPane.getLineHeight());
                SwingUtilities.convertPointToScreen(point2, (Component)this.fTextPane);
                return new ErrorPopupTrigger(buildError, point2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private PopupContext handleAsVariable(int n, String string, Function function, MTree.Node node) {
        Object object;
        MTree.NodeType nodeType = node.getType();
        if (nodeType != MTree.NodeType.NOT && nodeType != MTree.NodeType.FIELD && nodeType != MTree.NodeType.DOT && node.getAttribute() != MTree.Attribute.VARIABLE) {
            return null;
        }
        String string2 = node.isTextSupported() ? node.getText() : "";
        MTree.Node node2 = node;
        if (nodeType == MTree.NodeType.FIELD) {
            object = node.getParent().getLeft();
            if (object.isTextSupported()) {
                string2 = object.getText() + '.' + string2;
            }
            node2 = node.getParent();
        } else if (nodeType == MTree.NodeType.ID && node.getParent().getType() == MTree.NodeType.DOT) {
            object = node.getParent().getRight();
            if (object != null && object.isTextSupported()) {
                string2 = string2 + '.' + object.getText();
            }
            node2 = node.getParent();
        } else if (nodeType == MTree.NodeType.DOT && node.getLeft() != null && node.getLeft().getType() == MTree.NodeType.ID && node.getRight() != null && node.getRight().getType() == MTree.NodeType.FIELD) {
            string2 = (node.getLeft().isTextSupported() ? node.getLeft().getText() : "") + '.' + (node.getRight().isTextSupported() ? node.getRight().getText() : "");
        } else if (nodeType == MTree.NodeType.NOT) {
            string2 = "~";
        }
        object = null;
        Interval interval = null;
        try {
            object = this.calcAnchorPoint(node2);
            interval = this.getUnmappedInterval(node2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        PopupContext popupContext = null;
        if (function == null) {
            Function function2 = this.getFunctions(true).get(string);
            Variable variable = new Variable(function2, string2);
            if (this.fModel.hasVariable(variable)) {
                popupContext = new SpecializationHintTrigger(variable, (Point)object, interval, n);
            }
        } else {
            Variable variable = new Variable(function, string2);
            if (this.fModel.hasVariable(variable)) {
                popupContext = new VariablePopupTrigger(variable, (Point)object, interval, n);
            }
        }
        return popupContext;
    }

    private PopupContext handleAsFunction(int n, Function function, MTree.Node node) {
        PopupContext popupContext = this.handleAsExpression(n, function);
        if (popupContext == null && function != null && node.getAttribute() == MTree.Attribute.FUNCTION && this.fModel.hasFunction(function)) {
            Point point = null;
            Interval interval = this.getUnmappedInterval(node);
            try {
                point = this.calcAnchorPoint(node);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            popupContext = new FunctionPopupTrigger(function, point, interval, n);
        }
        return popupContext;
    }

    private PopupContext handleAsExpression(int n, Function function) {
        if (function == null || !this.fModel.hasExpressions(function)) {
            return null;
        }
        Expression expression = this.fModel.getExpressions(function).getNarrowestExpression(n);
        if (expression == null) {
            return null;
        }
        try {
            int n2 = expression.getStart();
            int n3 = expression.getEnd();
            int n4 = this.fTextMapper.mapToCurrent(n2);
            int n5 = this.fTextMapper.mapToCurrent(n3);
            if (n4 >= 0 && n5 >= 0 && n5 <= this.fTextPane.getLength()) {
                int n6;
                int n7;
                Rectangle rectangle = this.fTextPane.getVisibleRect();
                int n8 = (int)(this.fTextPane.getPointFromPos(n4).getY() + (double)this.fTextPane.getLineHeight());
                Point point = null;
                if (expression.getFocalPosition() != -1 && (n7 = this.fTextMapper.mapToCurrent(expression.getFocalPosition())) >= 0) {
                    n6 = this.fTextPane.getPointFromPos((int)n7).x;
                    int n9 = n7 > 0 ? this.fTextPane.getPointFromPos((int)(n7 - 1)).x : n6;
                    point = new Point((n9 + n6) / 2, n8);
                }
                if (point == null) {
                    n7 = (int)Math.min(rectangle.getWidth(), this.fTextPane.getPointFromPos(n5).getX());
                    n6 = (int)((this.fTextPane.getPointFromPos(n4).getX() + (double)n7) / 2.0);
                    point = new Point(n6, n8);
                }
                SwingUtilities.convertPointToScreen(point, (Component)this.fTextPane);
                return new ExpressionPopupTrigger(expression, point, new Interval(n2, n3));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public static interface PopupControllerObserver
    extends EventListener {
        public void currentPopupChanged(PopupFlavor var1, Interval var2);
    }

    public static enum PopupFlavor {
        BUILD_ERROR,
        EXPRESSION,
        FUNCTION,
        VARIABLE,
        SPECIALIZATION_HINT;

    }

    private class SpecializationHintTrigger
    extends PopupContext {
        private final Variable fVariable;
        private Point fAnchor;

        SpecializationHintTrigger(Variable variable, Point point, Interval interval, int n) {
            super(PopupFlavor.SPECIALIZATION_HINT, n, interval);
            this.fAnchor = point;
            this.fVariable = variable;
        }

        @Override
        public void run() {
            CodePopupController.this.fSpecializationPopup = new HintPopupFrame(SwingUtilities.windowForComponent((Component)CodePopupController.this.fTextPane), (Component)CodePopupController.this.fTextPane, CoderResources.getString("f2f.popup.chooseSpecialization"), null, false, false, new ReturnRunnable<Point>(){

                public Point run() {
                    return SpecializationHintTrigger.this.fAnchor;
                }
            });
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof SpecializationHintTrigger && this.getVariable().equals(((SpecializationHintTrigger)object).getVariable()) && this.getAnchorPosition() == ((PopupContext)object).getAnchorPosition();
        }

        @Override
        void anchorPointChanged(Point point) {
            CodePopupController.this.fSpecializationPopup.setLocation(point.x, point.y);
        }

        @Override
        void close() {
            if (CodePopupController.this.fSpecializationPopup != null) {
                CodePopupController.this.fSpecializationPopup.close();
                CodePopupController.this.fSpecializationPopup = null;
            }
        }

        @Override
        boolean hasFocus() {
            return false;
        }

        public Variable getVariable() {
            return this.fVariable;
        }
    }

    private class FunctionPopupTrigger
    extends PopupContext {
        private final Function fPopUpFunction;
        private final Dimension fCenterOffset;
        private final Point fAnchor;

        FunctionPopupTrigger(Function function, Point point, Interval interval, int n) {
            super(PopupFlavor.FUNCTION, n, interval);
            this.fAnchor = point;
            this.fPopUpFunction = function;
            this.fCenterOffset = CodePopupController.calcCenterOffset(n, (STPBaseInterface)CodePopupController.this.fTextPane);
        }

        @Override
        void anchorPointChanged(Point point) {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.getPopUpFunction(), point.x + this.getCenterOffset().width, point.y + this.getCenterOffset().height, this));
        }

        @Override
        void close() {
            CodePopupController.this.fInfoPopup.close();
        }

        @Override
        boolean hasFocus() {
            return CodePopupController.this.fInfoPopup.hasFocus();
        }

        @Override
        public void run() {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.getPopUpFunction(), this.getAnchor().x, this.getAnchor().y, this));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FunctionPopupTrigger)) {
                return false;
            }
            FunctionPopupTrigger functionPopupTrigger = (FunctionPopupTrigger)object;
            return !(this.getAnchor() == null ? functionPopupTrigger.getAnchor() != null : !this.getAnchor().equals(functionPopupTrigger.getAnchor())) && !(this.getCenterOffset() == null ? functionPopupTrigger.getCenterOffset() != null : !this.getCenterOffset().equals(functionPopupTrigger.getCenterOffset())) && this.getPopUpFunction().equals(functionPopupTrigger.getPopUpFunction());
        }

        @Override
        public int hashCode() {
            int n = this.getPopUpFunction().hashCode();
            n = 31 * n + (this.getCenterOffset() != null ? this.getCenterOffset().hashCode() : 0);
            n = 31 * n + (this.getAnchor() != null ? this.getAnchor().hashCode() : 0);
            return n;
        }

        public Point getAnchor() {
            return this.fAnchor;
        }

        public Dimension getCenterOffset() {
            return this.fCenterOffset;
        }

        public Function getPopUpFunction() {
            return this.fPopUpFunction;
        }
    }

    private class ExpressionPopupTrigger
    extends PopupContext {
        private final Expression fExpression;
        private final Point fAnchor;
        private final Dimension fCenterOffset;

        ExpressionPopupTrigger(Expression expression, Point point, Interval interval) {
            super(PopupFlavor.EXPRESSION, expression.getStart(), interval);
            this.fExpression = expression;
            this.fAnchor = point;
            this.fCenterOffset = CodePopupController.calcCenterOffset(expression.getStart(), (STPBaseInterface)CodePopupController.this.fTextPane);
        }

        @Override
        public void run() {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.fExpression, this.fAnchor.x, this.fAnchor.y, this));
        }

        @Override
        void anchorPointChanged(Point point) {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.fExpression, point.x + this.fCenterOffset.width, point.y + this.fCenterOffset.height, this));
        }

        @Override
        void close() {
            CodePopupController.this.fInfoPopup.close();
        }

        @Override
        boolean hasFocus() {
            return CodePopupController.this.fInfoPopup.hasFocus();
        }
    }

    private class VariablePopupTrigger
    extends PopupContext {
        private final Variable fVariable;
        private final Point fAnchor;
        private final Dimension fCenterOffset;

        VariablePopupTrigger(Variable variable, Point point, Interval interval, int n) {
            super(PopupFlavor.VARIABLE, n, interval);
            this.fVariable = variable;
            this.fAnchor = point;
            this.fCenterOffset = CodePopupController.calcCenterOffset(n, (STPBaseInterface)CodePopupController.this.fTextPane);
        }

        @Override
        public void run() {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.fVariable, this.fAnchor.x, this.fAnchor.y, this));
        }

        @Override
        void anchorPointChanged(Point point) {
            CodePopupController.this.fInfoPopup.update(CodePopupController.this.createPopupContext(this.fVariable, point.x + this.fCenterOffset.width, point.y + this.fCenterOffset.height, this));
        }

        @Override
        void close() {
            CodePopupController.this.fInfoPopup.close();
        }

        @Override
        boolean hasFocus() {
            return CodePopupController.this.fInfoPopup.hasFocus();
        }
    }

    private class ErrorPopupTrigger
    extends PopupContext {
        private final BuildError fError;
        private final Point fAnchor;

        ErrorPopupTrigger(BuildError buildError, Point point) {
            super(PopupFlavor.BUILD_ERROR);
            this.fError = buildError;
            this.fAnchor = point;
        }

        @Override
        public void run() {
            CodePopupController.this.fErrorPopup = new HintPopupFrame(SwingUtilities.windowForComponent((Component)CodePopupController.this.fTextPane), (Component)CodePopupController.this.fTextPane, this.getError().getMessage(), this.getError().getSeverity().getIcon(), false, false, new ReturnRunnable<Point>(){

                public Point run() {
                    return ErrorPopupTrigger.this.fAnchor;
                }
            });
            CodePopupController.this.fErrorPopup.setHyperlinkHandler((HyperlinkTextLabel.HyperlinkHandler)new MatlabHyperlinkHandler());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ErrorPopupTrigger && this.getError().equals(((ErrorPopupTrigger)object).getError());
        }

        @Override
        void anchorPointChanged(Point point) {
            CodePopupController.this.fErrorPopup.setLocation(point.x, point.y);
        }

        @Override
        void close() {
            if (CodePopupController.this.fErrorPopup != null) {
                CodePopupController.this.fErrorPopup.close();
                CodePopupController.this.fErrorPopup = null;
            }
        }

        @Override
        Interval getInterval() {
            int n = CodePopupController.this.fTextMapper.mapToCurrent(this.getError().getPosition());
            int n2 = CodePopupController.this.fTextMapper.mapToCurrent(this.getError().getPosition() + this.getError().getLength());
            return new Interval(n, n2);
        }

        @Override
        boolean hasFocus() {
            return false;
        }

        public BuildError getError() {
            return this.fError;
        }
    }

    private abstract class PopupContext
    implements Runnable {
        private final Interval fOrigInterval;
        private final PopupFlavor fPopupFlavor;
        private int fAnchorPosition;

        PopupContext(PopupFlavor popupFlavor) {
            this(popupFlavor, -1, null);
        }

        PopupContext(PopupFlavor popupFlavor, @Nullable int n, Interval interval) {
            this.fAnchorPosition = n;
            this.fOrigInterval = interval;
            this.fPopupFlavor = popupFlavor;
        }

        final PopupFlavor getPopupFlavor() {
            return this.fPopupFlavor;
        }

        final int getAnchorPosition() {
            return this.fAnchorPosition;
        }

        final void setAnchorPosition(int n) throws BadLocationException {
            if (this.fAnchorPosition != n) {
                this.fAnchorPosition = n;
                Point point = CodePopupController.this.fCodePane.getPointFromPos(this.fAnchorPosition);
                if (point != null) {
                    SwingUtilities.convertPointToScreen(point, (Component)CodePopupController.this.fTextPane);
                    this.anchorPointChanged(point);
                }
            }
        }

        Interval getInterval() {
            return this.getOrigInterval() != null ? CodePopupController.this.fTextMapper.mapToCurrent(this.getOrigInterval()) : null;
        }

        abstract void anchorPointChanged(Point var1);

        abstract void close();

        abstract boolean hasFocus();

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PopupContext)) {
                return false;
            }
            PopupContext popupContext = (PopupContext)object;
            return !(this.getOrigInterval() == null ? popupContext.getOrigInterval() != null : !this.getOrigInterval().equals(popupContext.getOrigInterval())) && this.getPopupFlavor() == popupContext.getPopupFlavor();
        }

        public int hashCode() {
            int n = this.getOrigInterval() != null ? this.getOrigInterval().hashCode() : 0;
            n = 31 * n + this.getPopupFlavor().hashCode();
            return n;
        }

        public Interval getOrigInterval() {
            return this.fOrigInterval;
        }
    }
}

