/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.settingsui.table.DefaultSettingsTableCellEditorFactory;
import com.mathworks.project.impl.settingsui.table.MacSettingsTableCellEditorFactory;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.SimpleCellEditor;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.CellPredicate;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.FiMathProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinder;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinderCellEditorFactory;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedSettingsTable {
    private final FixedPointDataAdapter fData;
    private final PropertyTableModel fModel;
    private final PropertyTable fTable;
    private final InputDataProperty fIdpProxy;
    private final IDPAttributes fFimathProxy;
    private final IDPAttributes fDefaultFimath;
    private final Set<FiMathProperty> fHiddenProperties;
    private final ChangeListener fChangeListener;
    private final JComponent fComponent;
    private final CustomSettingNodeStrategy<?> fCustomSettingNodeStrategy;
    private boolean fSuppressSerialize;
    private static final String FILTER = "__filter";
    private static final String WIZARD_GUI_TARGET_KEY = "target.coder";
    private static final String TYPE_PROPOSAL_MODE_KEY = "param.FixedPointTypeProposalMode";
    private static final String DEFAULT_WORD_LENGTH_KEY = "param.DefaultWordLength";
    private static final String DEFAULT_FRACTION_LENGTH_KEY = "param.DefaultFractionLength";

    public AdvancedSettingsTable(FixedPointDataAdapter fixedPointDataAdapter) {
        this(fixedPointDataAdapter, false);
    }

    public AdvancedSettingsTable(FixedPointDataAdapter fixedPointDataAdapter, boolean bl) {
        this(fixedPointDataAdapter, null, bl, fixedPointDataAdapter.getConfiguration().getTarget().getKey().equals(WIZARD_GUI_TARGET_KEY));
    }

    public AdvancedSettingsTable(FixedPointDataAdapter fixedPointDataAdapter, @Nullable CustomSettingNodeStrategy<?> customSettingNodeStrategy, boolean bl, boolean bl2) {
        PropertyTableNode propertyTableNode;
        this.fData = fixedPointDataAdapter;
        this.fCustomSettingNodeStrategy = customSettingNodeStrategy;
        this.fIdpProxy = new InputDataProperty("");
        this.fFimathProxy = this.fIdpProxy.getAttributes();
        this.fDefaultFimath = new IDPAttributes("");
        this.deserializeFimath(fixedPointDataAdapter.getDefaultFimath(), this.fDefaultFimath);
        this.fHiddenProperties = EnumSet.noneOf(FiMathProperty.class);
        List<PropertyTableColumn> list = Arrays.asList(new PropertyTableColumn[]{new NameColumn(), new ValueColumn()});
        ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
        Target target = fixedPointDataAdapter.getConfiguration().getTarget();
        if (bl2) {
            propertyTableNode = new PropertyTableNode(null, true, CoderResources.getString("wfa.fixedpoint.basicSettings"));
            arrayList.add(propertyTableNode);
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(target.getParam(TYPE_PROPOSAL_MODE_KEY)));
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(target.getParam(DEFAULT_WORD_LENGTH_KEY)));
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(target.getParam(DEFAULT_FRACTION_LENGTH_KEY)));
        }
        propertyTableNode = fixedPointDataAdapter.getCategorizedAdvancedSettings();
        Map<Object, Integer> map = AdvancedSettingsTable.populateRows((Map<FixedPointDataAdapter.SettingsCategory, List<Param>>)propertyTableNode, arrayList, true, bl2, bl);
        this.fChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AdvancedSettingsTable.this.updateFilter();
                AdvancedSettingsTable.this.serializeFimath();
            }
        };
        PropertyTableNode propertyTableNode2 = new PropertyTableNode(null, true, CoderResources.getString("f2f.advanced.fimath.root"));
        arrayList.add(propertyTableNode2);
        for (FiMathProperty fiMathProperty : FiMathProperty.values()) {
            if (fiMathProperty == FiMathProperty.LOCAL_FIMATH) continue;
            new PropertyTableNode(propertyTableNode2, false, Arrays.asList(fiMathProperty));
            fiMathProperty.getBinder().addChangeListener(this.fChangeListener);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (FiMathProperty fiMathProperty : FiMathProperty.values()) {
                    fiMathProperty.getBinder().removeChangeListener(AdvancedSettingsTable.this.fChangeListener);
                }
            }
        };
        map.putAll(AdvancedSettingsTable.populateRows((Map<FixedPointDataAdapter.SettingsCategory, List<Param>>)propertyTableNode, arrayList, false, bl2, bl));
        if (this.fCustomSettingNodeStrategy != null) {
            int propertyTableSearchPredicate = arrayList.size();
            if (AdvancedSettingsTable.populateRows(this.fCustomSettingNodeStrategy, arrayList)) {
                map.put(this.fCustomSettingNodeStrategy, propertyTableSearchPredicate);
            }
            this.fCustomSettingNodeStrategy.addChangeListener(this.fChangeListener);
        }
        PropertyTableSearchPredicate propertyTableSearchPredicate = new PropertyTableSearchPredicate(){

            public boolean accept(Object object, String string) {
                boolean bl;
                string = string.toUpperCase(Locale.ENGLISH);
                boolean bl2 = bl = object instanceof FiMathProperty && !AdvancedSettingsTable.this.fHiddenProperties.contains(object) || object instanceof Param || AdvancedSettingsTable.this.fCustomSettingNodeStrategy != null && AdvancedSettingsTable.this.isCustomSetting(object);
                if (bl && !string.equalsIgnoreCase(AdvancedSettingsTable.FILTER)) {
                    if (object instanceof FiMathProperty && !((FiMathProperty)((Object)object)).getBinder().getName().toUpperCase(Locale.ENGLISH).contains(string)) {
                        return false;
                    }
                    if (object instanceof Param && !((Param)object).getName().toUpperCase(Locale.ENGLISH).contains(string)) {
                        return false;
                    }
                    if (AdvancedSettingsTable.this.isCustomSetting(object) && !AdvancedSettingsTable.this.fCustomSettingNodeStrategy.getNodeName().toUpperCase(Locale.ENGLISH).contains(string)) {
                        return false;
                    }
                }
                return bl;
            }
        };
        this.fModel = new PropertyTableModel(list, runnable, this.createEnabledPredicate(), propertyTableSearchPredicate, arrayList);
        this.deserializeFimath();
        this.updateFilter();
        this.fTable = new PropertyTable(this.fModel, (PropertyTableCellEditorFactory)new EditorFactory());
        this.fTable.setName("f2f.moreSettings.table");
        this.fTable.setRowAsExpander(true);
        this.fTable.setColumnWeights(new double[]{0.65, 0.35});
        this.fTable.setPreferToShowAllRows(bl2);
        this.fTable.setSearchText(FILTER);
        this.fTable.setDefaultPredicate(this.createDefaultValuePredicate(this.fModel));
        this.fModel.expandAll();
        if (bl2) {
            this.collapseAddedRoots(map);
        }
        this.fComponent = bl2 ? SettingsTableUtils.bindWithFilter((PropertyTable)this.fTable) : this.fTable.getComponent();
    }

    public void expandTable() {
        this.fModel.expandAll();
    }

    private void collapseAddedRoots(Map<?, Integer> map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(map.values());
        Collections.sort(arrayList);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.fModel.getRowCount(); ++i) {
            if (this.fModel.getNode(i).getGroupLabel() == null || !this.fModel.getNode(i).isPrimaryGroupNode() || (Integer)arrayList.get(n) + 1 != ++n2) continue;
            this.fModel.setExpanded(i, false);
            if (++n == arrayList.size()) break;
        }
    }

    private static Map<Object, Integer> populateRows(Map<FixedPointDataAdapter.SettingsCategory, List<Param>> map, List<PropertyTableNode> list, boolean bl, boolean bl2, boolean bl3) {
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (Map.Entry<FixedPointDataAdapter.SettingsCategory, List<Param>> entry : map.entrySet()) {
            if (entry.getKey().isBeforeFimath() != bl || entry.getKey().equals((Object)FixedPointDataAdapter.SettingsCategory.FIACCEL) && (!bl2 || !bl3)) continue;
            int n = list.size();
            boolean bl4 = AdvancedSettingsTable.populateRows(entry.getKey(), entry.getValue(), list, bl2);
            if (!bl4) continue;
            hashMap.put((Object)entry.getKey(), n);
        }
        return hashMap;
    }

    private static boolean populateRows(FixedPointDataAdapter.SettingsCategory settingsCategory, List<Param> list, List<PropertyTableNode> list2, boolean bl) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, MessageFormat.format(CoderResources.getString(settingsCategory.getResourceKey()), "").trim());
        list2.add(propertyTableNode);
        for (Param param : list) {
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(param));
        }
        return true;
    }

    private static boolean populateRows(CustomSettingNodeStrategy<?> customSettingNodeStrategy, List<PropertyTableNode> list) {
        List<?> list2 = customSettingNodeStrategy.getCustomSettings();
        if (list2 != null && !list2.isEmpty()) {
            PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, customSettingNodeStrategy.getNodeName());
            list.add(propertyTableNode);
            for (Object obj : list2) {
                new PropertyTableNode(propertyTableNode, false, Arrays.asList(obj));
            }
            return true;
        }
        return false;
    }

    protected Predicate<Object> createEnabledPredicate() {
        return new Predicate(){

            public boolean accept(Object object) {
                return object instanceof FiMathProperty || object instanceof Param && AdvancedSettingsTable.this.fData.getConfiguration().isParamVisible(((Param)object).getKey()) && AdvancedSettingsTable.this.fData.getConfiguration().isParamEnabled(((Param)object).getKey()) || AdvancedSettingsTable.this.isCustomSetting(object);
            }
        };
    }

    protected CellPredicate createDefaultValuePredicate(final PropertyTableModel<?> propertyTableModel) {
        return new CellPredicate(){

            public boolean accept(int n, int n2) {
                if (n2 != 1) {
                    return true;
                }
                Object object = propertyTableModel.getValue(n, n2);
                if (object != null && object instanceof Param) {
                    String string = ((Param)object).getKey();
                    return AdvancedSettingsTable.compareAgainstDefault(AdvancedSettingsTable.this.fData.getConfiguration().getParamAsObject(string), AdvancedSettingsTable.this.fData.getConfiguration().getParamDefaultValue(string));
                }
                if (object != null && object instanceof FiMathProperty) {
                    Object object2 = ((FiMathProperty)((Object)object)).getBinder().getData(AdvancedSettingsTable.this.fFimathProxy);
                    Object object3 = ((FiMathProperty)((Object)object)).getBinder().getData(AdvancedSettingsTable.this.fDefaultFimath);
                    return AdvancedSettingsTable.compareAgainstDefault(object2, object3);
                }
                return true;
            }
        };
    }

    private static boolean compareAgainstDefault(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void updateFilter() {
        boolean bl;
        if (this.fTable != null) {
            this.fTable.stopEditing(true);
        }
        EnumSet<FiMathProperty> enumSet = EnumSet.copyOf(this.fHiddenProperties);
        this.fHiddenProperties.clear();
        boolean bl2 = bl = this.fFimathProxy.getFimath().getSumMode() != FimathPanel.PrecisionMode.FULL_PRECISION;
        if (!this.fFimathProxy.getFimath().getFimathIsLocal().booleanValue() || !bl) {
            this.fHiddenProperties.add(FiMathProperty.CAST_BEFORE_SUM);
        }
        this.updatePrecisionFilter(FiMathProperty.PRODUCT_MODE, FiMathProperty.PRODUCT_WORD_LENGTH, FiMathProperty.PRODUCT_FRACTION_LENGTH);
        this.updatePrecisionFilter(FiMathProperty.SUM_MODE, FiMathProperty.SUM_WORD_LENGTH, FiMathProperty.SUM_FRACTION_LENGTH);
        this.fModel.setSearchText(FILTER);
    }

    private void updatePrecisionFilter(FiMathProperty fiMathProperty, FiMathProperty fiMathProperty2, FiMathProperty fiMathProperty3) {
        boolean bl;
        Object object = fiMathProperty.getBinder().getData(this.fFimathProxy);
        boolean bl2 = object != FimathPanel.PrecisionMode.FULL_PRECISION;
        boolean bl3 = bl = object == FimathPanel.PrecisionMode.SPECIFY_PRECISION;
        if (!bl2) {
            this.fHiddenProperties.add(fiMathProperty2);
        }
        if (!bl) {
            this.fHiddenProperties.add(fiMathProperty3);
        }
    }

    private void serializeFimath() {
        if (this.fSuppressSerialize) {
            return;
        }
        LinkedList<FiMathProperty> linkedList = new LinkedList<FiMathProperty>();
        for (int i = 0; i < this.fModel.getRowCount(); ++i) {
            Object object = this.fModel.getValue(i, 0);
            if (object == null || !(object instanceof FiMathProperty)) continue;
            linkedList.add((FiMathProperty)((Object)object));
        }
        this.fData.setFimath(Utilities.fimathToString(linkedList, this.fFimathProxy));
    }

    public boolean isProposedTypeInputChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(TYPE_PROPOSAL_MODE_KEY) || propertyChangeEvent.getPropertyName().equals(DEFAULT_FRACTION_LENGTH_KEY) || propertyChangeEvent.getPropertyName().equals(DEFAULT_WORD_LENGTH_KEY) || this.fData.isAdvancedTypeProposalSetting(propertyChangeEvent);
    }

    private void deserializeFimath() {
        this.deserializeFimath(this.fData.getFimath(), this.fFimathProxy);
    }

    private void deserializeFimath(String string, IDPAttributes iDPAttributes) {
        this.fSuppressSerialize = true;
        Utilities.stringToFimath(string, iDPAttributes);
        this.fSuppressSerialize = false;
    }

    private boolean isCustomSetting(Object object) {
        return this.fCustomSettingNodeStrategy != null && this.fCustomSettingNodeStrategy.getCustomSettingClass().isInstance(object);
    }

    public static interface CustomSettingNodeStrategy<T> {
        @NotNull
        public PropertyTableCellEditorFactory<Object> getCellEditorFactory();

        @NotNull
        public Class<T> getCustomSettingClass();

        public List<T> getCustomSettings();

        public String getDisplayName(Object var1);

        public String getDisplayValue(Object var1);

        public String getNodeName();

        public void addChangeListener(ChangeListener var1);
    }

    private class EditorFactory
    implements PropertyTableCellEditorFactory {
        private final PropertyTableCellEditorFactory<Param> fParamEditorFactory;
        private final PropertyBinderCellEditorFactory fFimathEditorFactory;

        private EditorFactory() {
            this.fParamEditorFactory = PlatformInfo.isMacintosh() ? new MacSettingsTableCellEditorFactory(AdvancedSettingsTable.this.fData.getConfiguration()) : new DefaultSettingsTableCellEditorFactory(AdvancedSettingsTable.this.fData.getConfiguration());
            this.fFimathEditorFactory = new PropertyBinderCellEditorFactory(AdvancedSettingsTable.this.fIdpProxy, AdvancedSettingsTable.this.fFimathProxy);
        }

        public PropertyTableCellEditor createWidget(PropertyTable propertyTable, int n, int n2, Object object) {
            if (object instanceof Param) {
                Param param = (Param)object;
                if (param.getValidationRule() != null) {
                    return SimpleCellEditor.create((PropertyTable)propertyTable, (Configuration)AdvancedSettingsTable.this.fData.getConfiguration(), (Param)param);
                }
                return this.fParamEditorFactory.createWidget(propertyTable, n, n2, (Object)param);
            }
            if (AdvancedSettingsTable.this.isCustomSetting(object)) {
                return AdvancedSettingsTable.this.fCustomSettingNodeStrategy.getCellEditorFactory().createWidget(propertyTable, n, n2, object);
            }
            return this.fFimathEditorFactory.createWidget((PropertyTable<PropertyBinder>)propertyTable, n, n2, ((FiMathProperty)((Object)object)).getBinder());
        }
    }

    private class ValueColumn
    implements PropertyTableColumn {
        private final com.mathworks.project.impl.settingsui.table.ValueColumn fParamValueColumn;

        private ValueColumn() {
            this.fParamValueColumn = new com.mathworks.project.impl.settingsui.table.ValueColumn(AdvancedSettingsTable.this.fData.getConfiguration());
        }

        public String getText(Object object) {
            if (object instanceof Param) {
                return this.fParamValueColumn.getText((Param)object);
            }
            if (AdvancedSettingsTable.this.isCustomSetting(object)) {
                return AdvancedSettingsTable.this.fCustomSettingNodeStrategy.getDisplayValue(object);
            }
            return ((FiMathProperty)((Object)object)).getBinder().getText(AdvancedSettingsTable.this.fFimathProxy);
        }

        public JComponent createLink(Object object) {
            if (object instanceof Param) {
                return this.fParamValueColumn.createLink((Param)object);
            }
            return null;
        }

        public String getName() {
            return this.fParamValueColumn.getName();
        }

        public boolean isEditable() {
            return true;
        }

        public boolean isFinite() {
            return false;
        }

        public int compareForAscendingSort(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }

        public PropertyTableDecorator getDecorator() {
            return null;
        }

        public boolean isNumericallyAligned() {
            return false;
        }

        public boolean hasHiddenDigits(Object object, String string, Graphics2D graphics2D, Rectangle2D rectangle2D) {
            return false;
        }

        public int getRightMargin(boolean bl, boolean bl2, Graphics2D graphics2D) {
            return 0;
        }
    }

    private class NameColumn
    extends AbstractPropertyTableColumn {
        NameColumn() {
            super(BuiltInResources.getString((String)"settings.header.name"));
        }

        public String getText(Object object) {
            if (object instanceof Param) {
                return ((Param)object).getName();
            }
            if (AdvancedSettingsTable.this.isCustomSetting(object)) {
                return AdvancedSettingsTable.this.fCustomSettingNodeStrategy.getDisplayName(object);
            }
            return ((FiMathProperty)((Object)object)).getBinder().getName();
        }
    }
}

