/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.toolstrip;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.toolstrip.CategorizedComboBoxModel;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CategorizedComboBox<T> {
    private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final BusyAffordance fBusyAffordance;
    private final TSDropDownButton fButton;
    private final CategorizedComboBoxModel<T> fModel;
    private final ListStyle fListStyle;
    private final MulticastChangeListener fChangeListeners;
    private T fSelectedItem;

    public CategorizedComboBox(CategorizedComboBoxModel<T> categorizedComboBoxModel, ListStyle listStyle) {
        this.fComponent.setOpaque(false);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fComponent.add((Component)this.fBusyAffordance.getComponent());
        this.fBusyAffordance.start();
        this.fModel = categorizedComboBoxModel;
        this.fListStyle = listStyle;
        this.fChangeListeners = new MulticastChangeListener();
        this.fButton = new TSDropDownButton();
        this.fButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                CategorizedComboBox.this.createPopupList(popupCallback);
            }
        });
        this.fModel.getDefault(new ParameterRunnable<T>(){

            public void run(T t) {
                CategorizedComboBox.this.fBusyAffordance.stop();
                CategorizedComboBox.this.fComponent.removeAll();
                CategorizedComboBox.this.fComponent.add((Component)CategorizedComboBox.this.fButton);
                CategorizedComboBox.this.fSelectedItem = t;
                if (CategorizedComboBox.this.fSelectedItem != null) {
                    CategorizedComboBox.this.fButton.setText((String)CategorizedComboBox.this.fModel.createItem(CategorizedComboBox.this.fSelectedItem).getAttributes().getAttribute((Attribute)ListItem.TITLE));
                    CategorizedComboBox.this.fButton.setIcon(CategorizedComboBox.this.fModel.getCollapsedIcon(CategorizedComboBox.this.fSelectedItem));
                } else {
                    CategorizedComboBox.this.fButton.setText("");
                    CategorizedComboBox.this.fButton.setIcon(null);
                }
                CategorizedComboBox.this.fComponent.revalidate();
                CategorizedComboBox.this.fComponent.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public T getSelectedItem() {
        return this.fSelectedItem;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    private void createPopupList(final PopupListener.PopupCallback popupCallback) {
        final PopupList popupList = new PopupList();
        popupList.setListStyle(this.fListStyle);
        final DefaultListModel defaultListModel = new DefaultListModel();
        popupList.setModel(defaultListModel);
        this.fModel.getCategories(new ParameterRunnable<List<String>>(){

            public void run(List<String> list) {
                final Iterator<String> iterator = list.iterator();
                final Holder holder = new Holder();
                holder.set((Object)new Runnable(){

                    @Override
                    public void run() {
                        String string = (String)iterator.next();
                        ListItem listItem = new ListItem(string);
                        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)string);
                        listItem.setAttribute((Attribute)ListItem.HEADER, (Object)true);
                        defaultListModel.addElement(listItem);
                        CategorizedComboBox.this.fModel.getItems(string, new ParameterRunnable<List<T>>(){

                            public void run(List<T> list) {
                                for (Object t : list) {
                                    ListItem listItem = CategorizedComboBox.this.fModel.createItem(t);
                                    if (listItem.getAttributes().getAttribute((Attribute)ListItem.ICON) == null) {
                                        listItem.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
                                        listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)(CategorizedComboBox.this.fSelectedItem != null && t.equals(CategorizedComboBox.this.fSelectedItem) ? 1 : 0));
                                    }
                                    defaultListModel.addElement(listItem);
                                }
                                if (iterator.hasNext()) {
                                    ((Runnable)holder.get()).run();
                                } else {
                                    popupCallback.show((JComponent)popupList);
                                }
                            }
                        });
                    }
                });
                if (iterator.hasNext()) {
                    ((Runnable)holder.get()).run();
                }
            }
        });
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                CategorizedComboBox.this.fSelectedItem = CategorizedComboBox.this.fModel.getValue(listActionEvent.getListItem());
                CategorizedComboBox.this.fButton.setText((String)listActionEvent.getListItem().getAttributes().getAttribute((Attribute)ListItem.TITLE));
                CategorizedComboBox.this.fButton.setIcon(CategorizedComboBox.this.fModel.getCollapsedIcon(CategorizedComboBox.this.fSelectedItem));
                CategorizedComboBox.this.fChangeListeners.stateChanged(new ChangeEvent(CategorizedComboBox.this));
            }
        });
    }
}

