/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Variable;
import java.io.File;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectionEvent
extends EventObject {
    private final Function fFunction;
    private final File fFile;
    private final Object fValue;
    private final EventType fEventType;
    private boolean fConsumed;

    SelectionEvent(@Nullable Selector selector, Object object, @NotNull EventType eventType) {
        this(selector, object, eventType, null, null);
    }

    SelectionEvent(@Nullable Selector selector, Object object, @NotNull EventType eventType, File file) {
        this(selector, object, eventType, null, file);
    }

    SelectionEvent(@Nullable Selector selector, Object object, @NotNull EventType eventType, Function function) {
        this(selector, object, eventType, function, function != null ? function.getFile() : null);
    }

    private SelectionEvent(@Nullable Selector selector, Object object, @NotNull EventType eventType, Function function, File file) {
        super(selector != null ? selector : SelectionEvent.createEmptySelector());
        this.fValue = object;
        this.fEventType = eventType;
        this.fFunction = function;
        this.fFile = file;
    }

    @Override
    @Nullable
    public Selector getSource() {
        return (Selector)super.getSource();
    }

    @Nullable
    public Object getSelectedValue() {
        return this.fValue;
    }

    @NotNull
    public final EventType getEventType() {
        return this.fEventType;
    }

    @Nullable
    public final Function getFunction() {
        return this.fFunction;
    }

    @Nullable
    public final File getFile() {
        return this.fFile;
    }

    @Nullable
    public Variable getVariable() {
        return null;
    }

    @Nullable
    public CallTree.CallSite getCallSite() {
        return null;
    }

    @Nullable
    public final CodableEntity.Type getCodableEntityType() {
        return this.isCodableEntity() ? ((CodableEntity)this.getSelectedValue()).getEntityType() : null;
    }

    public final boolean isCodableEntity() {
        return this.getSelectedValue() != null && this.getSelectedValue() instanceof CodableEntity;
    }

    public final boolean isConsumed() {
        return this.fConsumed;
    }

    public final void consume() {
        this.fConsumed = true;
    }

    void setConsumed(boolean bl) {
        this.fConsumed = bl;
    }

    public abstract SelectionEvent derive(Selector var1);

    private static Selector createEmptySelector() {
        return new Selector(){

            @Override
            public void select(SelectionEvent selectionEvent) {
            }

            @Override
            public void addSelectionListener(SelectionListener selectionListener) {
            }

            @Override
            public void removeSelectionListener(SelectionListener selectionListener) {
            }
        };
    }

    public static enum EventType {
        FILE,
        FUNCTION,
        CALLSITE,
        VARIABLE,
        ERROR;

    }
}

