/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.html.HtmlComponent;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.util.CoderLogger;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EditorFileViewProvider
implements EditorView.FileViewProvider {
    private final Set<String> fBinaryExtensions;
    private File fFile;
    private HtmlComponent fHtmlPanel;
    private boolean fIsHtml;
    private boolean fIsBinary;

    public EditorFileViewProvider(String ... stringArray) {
        this.fBinaryExtensions = new HashSet<String>(Arrays.asList(stringArray));
        this.fBinaryExtensions.add("dll");
        this.fBinaryExtensions.add("lib");
        this.fBinaryExtensions.add("exe");
        this.fBinaryExtensions.add("mat");
    }

    protected File getFile() {
        return this.fFile;
    }

    private HtmlComponent getHtmlComponent() {
        MJUtilities.assertEventDispatchThread();
        if (this.fHtmlPanel == null) {
            return HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.CHROMIUM, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});
        }
        return this.fHtmlPanel;
    }

    @Override
    public void setCurrentFile(File file) {
        this.fFile = file;
        if (this.fFile == null) {
            this.fIsBinary = false;
            this.fIsHtml = false;
            return;
        }
        String string = new FileLocation(file).getExtension();
        if (string != null) {
            this.fIsHtml = string.equalsIgnoreCase("html") || string.equalsIgnoreCase("htm");
            this.fIsBinary = string.matches("(?i)mex.*") || this.fBinaryExtensions.contains(string);
        } else {
            this.fIsHtml = false;
            this.fIsBinary = false;
        }
    }

    @Override
    public void provideComponentWhenReady(ParameterRunnable<Component> parameterRunnable) {
        if (this.fIsHtml) {
            try {
                HtmlComponent htmlComponent = this.getHtmlComponent();
                htmlComponent.setCurrentLocation(this.fFile.toURI().toURL().toExternalForm());
                parameterRunnable.run((Object)htmlComponent.getComponent());
            }
            catch (MalformedURLException malformedURLException) {
                CoderLogger.logError("Error initializing HTML widget: %s", malformedURLException.getMessage());
            }
        }
        parameterRunnable.run(null);
    }

    @Override
    public void dipose() {
        if (this.fHtmlPanel != null) {
            this.fHtmlPanel.dispose();
        }
    }

    @Override
    public boolean isShowTextView() {
        return !this.fIsHtml && !this.fIsBinary;
    }

    @Override
    public Runnable getTextViewContinuation() {
        return null;
    }

    @Override
    public boolean isShowDisclaimer() {
        return false;
    }

    @Override
    public String getDisclaimer() {
        return null;
    }

    @Override
    public ParameterRunnable<Boolean> getDisclaimerCallback() {
        return null;
    }
}

