/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.DefaultProjectVersionSupport;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Plugin;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ProjectVersionSupport;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.TargetFactory;
import com.mathworks.project.impl.plugin.JavaAttribute;
import com.mathworks.project.impl.plugin.PluginDiagnosticMessage;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.plugin.PluginProblemTracker;
import com.mathworks.project.impl.plugin.PluginReaderStack;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.wfa.CoderWorkflowFrame;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class UnifiedTargetFactory
implements TargetFactory {
    public static final String UNIFIED_TARGET_KEY = "target.coder";
    public static final String OLD_C_TARGET_KEY = "target.matlab.coder";
    public static final String OLD_ECODER_TARGET_KEY = "target.matlab.ecoder";
    public static final String OLD_HDL_TARGET_KEY = "target.matlab.hdlcoder";
    public static final String FIXED_POINT_TOOLBOX = "fixedpoint";
    public static final String MATLAB_CODER_TOOLBOX = "matlabcoder";
    public static final String HDL_CODER_TOOLBOX = "matlabhdlcoder";
    public static final String EMBEDDED_CODER_TOOLBOX = "embeddedcoder";
    private static final String ICON_RESOURCE_PATH = "/com/mathworks/toolbox/coder/resources/icons";
    private static final String ROOT_RESOURCE_PATH = "/com/mathworks/toolbox/coder/resources";

    public List<Target> defineTargets() {
        PluginDiagnosticMessage pluginDiagnosticMessage2;
        UnifiedTargetFactory.registerToolboxes();
        ArrayList<ParamSet> arrayList = new ArrayList<ParamSet>();
        PluginProblemTracker pluginProblemTracker = new PluginProblemTracker();
        XmlWriter xmlWriter = XmlApi.getInstance().create("plugin");
        try {
            arrayList.add(UnifiedTargetFactory.readParamSet("system", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("c.target", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.target", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("paths", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("speed", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("memory", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("code.appearance", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("debug", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("c.customcode", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.scripts", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("c.hardware", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("c.toolchain", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.clocks.ports", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.coding.standards", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.cosimulation", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.fil", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.testbench", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("c.advanced", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet("hdl.advanced", pluginProblemTracker, xmlWriter));
            arrayList.add(UnifiedTargetFactory.readParamSet(FIXED_POINT_TOOLBOX, pluginProblemTracker, xmlWriter));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        for (PluginDiagnosticMessage pluginDiagnosticMessage2 : pluginProblemTracker.getMessages()) {
            System.err.println(pluginDiagnosticMessage2.toString());
        }
        if (!pluginProblemTracker.getMessages().isEmpty()) {
            throw new IllegalStateException("Check settings definition files");
        }
        ProjectVersionSupport projectVersionSupport = UnifiedTargetFactory.createVersionSupport();
        pluginDiagnosticMessage2 = new Plugin(projectVersionSupport, "plugin.coder", CoderResources.getString("target"), "R2014b", "R2014b", xmlWriter.getXML());
        Target target = new Target((Plugin)pluginDiagnosticMessage2, UNIFIED_TARGET_KEY, CoderResources.getString("target"), CoderResources.getString("target.desc"), CoderResources.getString("target"), null, CoderResources.getIcon("coder_unified_target.png"), UnifiedTargetFactory.createProjectNameOverrider());
        target.setLicenseNames(new String[]{"MATLAB_Coder", "fixed_point_toolbox"});
        target.setEnabled((DynamicTargetAttribute)new JavaAttribute<Boolean>(){

            protected Boolean evaluate(ReadableConfiguration readableConfiguration) {
                return ProjectManager.hasToolbox((String)UnifiedTargetFactory.FIXED_POINT_TOOLBOX) || ProjectManager.hasToolbox((String)UnifiedTargetFactory.MATLAB_CODER_TOOLBOX) || ProjectManager.hasToolbox((String)UnifiedTargetFactory.HDL_CODER_TOOLBOX);
            }

            public boolean hasReference(String string) {
                return false;
            }
        });
        ArrayList<Profile> arrayList2 = new ArrayList<Profile>();
        arrayList2.add(UnifiedTargetFactory.createMexProfile());
        arrayList2.add(UnifiedTargetFactory.createCProfile());
        arrayList2.add(UnifiedTargetFactory.createHdlProfile());
        target.setParamSets(arrayList);
        target.setFileSets(Arrays.asList(UnifiedTargetFactory.createEntrypointFileSet(), UnifiedTargetFactory.createTestbenchFileSet()));
        target.setProfiles(arrayList2);
        target.setLazyDataEnabled(true);
        target.setOpener((ParameterRunnable)new ParameterRunnable<ProjectGUI.OpenRequest>(){

            public void run(ProjectGUI.OpenRequest openRequest) {
                CoderApp.open(CoderWorkflowFrame.class, openRequest.getFile(), openRequest.getTargetHint());
            }
        });
        target.addPackageType(new PackageType("package.type.zip", CoderResources.getString("package.type.zip"), "zip", null));
        target.getParam("param.UseECoderFeatures").setToolboxToEnable(EMBEDDED_CODER_TOOLBOX);
        return Arrays.asList(target);
    }

    private static FileSetDefinition createEntrypointFileSet() {
        return new FileSetDefinition("fileset.entrypoints", CoderResources.getString("fileset.entrypoints"), CoderResources.getString("fileset.entrypoints.single"), CoderResources.getString("fileset.entrypoints.desc"), null, null, EntryPointFileDataWidget.class.getName(), null, null, false, 1, Integer.MAX_VALUE, new ArrayList(0), Arrays.asList(new FileSetRule("*.m", false), new FileSetRule("*.mlx", false)), new ArrayList(0), new ArrayList(0), false);
    }

    private static FileSetDefinition createTestbenchFileSet() {
        return new FileSetDefinition("fileset.testbench", CoderResources.getString("fileset.testbench"), CoderResources.getString("fileset.testbench.single"), CoderResources.getString("fileset.testbench.desc"), null, null, null, null, null, false, 0, Integer.MAX_VALUE, new ArrayList(0), Arrays.asList(new FileSetRule("*.m", false), new FileSetRule("*.mlx", false)), new ArrayList(0), new ArrayList(0), true);
    }

    public static void registerToolboxes() {
        if (Matlab.isMatlabAvailable()) {
            ProjectManager.registerToolbox((String)FIXED_POINT_TOOLBOX, (String)"toolbox/fixedpoint/fixedpoint/Contents.m");
            ProjectManager.registerToolbox((String)MATLAB_CODER_TOOLBOX, (String)"toolbox/coder/matlabcoder/Contents.m");
            ProjectManager.registerToolbox((String)HDL_CODER_TOOLBOX, (String)"toolbox/hdlcoder/matlabhdlcoder");
            ProjectManager.registerToolbox((String)EMBEDDED_CODER_TOOLBOX, (String)"toolbox/coder/embeddedcoder/Contents.m");
        }
    }

    private static ParamSet readParamSet(String string, PluginProblemTracker pluginProblemTracker, XmlWriter xmlWriter) throws IOException {
        return UnifiedTargetFactory.readParamSet(string, "/com/mathworks/toolbox/coder/resources/settings/paramset." + string + ".xml", pluginProblemTracker, xmlWriter);
    }

    public static ParamSet readParamSet(String string, String string2, PluginProblemTracker pluginProblemTracker, XmlWriter xmlWriter) throws IOException {
        XmlReader xmlReader = XmlApi.getInstance().read(StringUtils.read((InputStream)UnifiedTargetFactory.class.getResourceAsStream(string2)));
        xmlWriter.writeXML(xmlReader.getXML());
        PluginReaderStack pluginReaderStack = new PluginReaderStack("/com/mathworks/toolbox/coder/resources/settings", ICON_RESOURCE_PATH, string.replace('.', '_'), xmlReader);
        return PluginManager.readParameterSet((PluginReaderStack)pluginReaderStack, (PluginProblemTracker)pluginProblemTracker, (XmlReader)xmlReader);
    }

    private static Profile createMexProfile() {
        return new Profile("profile.mex", (DynamicTargetAttribute)new JavaAttribute<Boolean>(){

            protected Boolean evaluate(ReadableConfiguration readableConfiguration) {
                return !readableConfiguration.getParamAsString("param.objective").endsWith(".hdl") && readableConfiguration.getParamAsString("param.artifact").contains("mex");
            }

            public boolean hasReference(String string) {
                return string.equals("param.objective") || string.equals("param.artifact");
            }
        });
    }

    private static Profile createCProfile() {
        return new Profile("profile.c", (DynamicTargetAttribute)new JavaAttribute<Boolean>(){

            protected Boolean evaluate(ReadableConfiguration readableConfiguration) {
                return readableConfiguration.getParamAsString("param.objective").endsWith(".c") && !readableConfiguration.getParamAsString("param.artifact").contains("mex");
            }

            public boolean hasReference(String string) {
                return string.equals("param.objective") || string.equals("param.artifact");
            }
        });
    }

    private static Profile createHdlProfile() {
        return new Profile("profile.hdl", (DynamicTargetAttribute)new JavaAttribute<Boolean>(){

            protected Boolean evaluate(ReadableConfiguration readableConfiguration) {
                return readableConfiguration.getParamAsString("param.objective").endsWith(".hdl");
            }

            public boolean hasReference(String string) {
                return string.equals("param.objective");
            }
        });
    }

    private static void addLegacyTranslation(DefaultProjectVersionSupport defaultProjectVersionSupport, String string, String string2) {
        defaultProjectVersionSupport.addTranslationResource(OLD_C_TARGET_KEY, string, string2, ROOT_RESOURCE_PATH, "coder_plugin_" + string + "_to_" + string2 + ".xsl");
        if (!string2.equals("R2013a")) {
            defaultProjectVersionSupport.addTranslationResource(OLD_ECODER_TARGET_KEY, string, string2, ROOT_RESOURCE_PATH, "coder_plugin_" + string + "_to_" + string2 + ".xsl");
        } else {
            defaultProjectVersionSupport.addTranslationResource(OLD_ECODER_TARGET_KEY, string, OLD_C_TARGET_KEY, string2, ROOT_RESOURCE_PATH, "coder_plugin_" + string + "_to_" + string2 + ".xsl");
        }
    }

    private static ProjectVersionSupport createVersionSupport() {
        DefaultProjectVersionSupport defaultProjectVersionSupport = new DefaultProjectVersionSupport();
        UnifiedTargetFactory.addLegacyTranslation(defaultProjectVersionSupport, "1.0", "R2012a");
        UnifiedTargetFactory.addLegacyTranslation(defaultProjectVersionSupport, "R2012a", "R2013a");
        UnifiedTargetFactory.addLegacyTranslation(defaultProjectVersionSupport, "R2013a", "R2014a_nu");
        UnifiedTargetFactory.addLegacyTranslation(defaultProjectVersionSupport, "R2014a", "R2014b");
        defaultProjectVersionSupport.addTranslationResource(OLD_C_TARGET_KEY, "R2014a_nu", UNIFIED_TARGET_KEY, "R2014b", ROOT_RESOURCE_PATH, "non_unified_to_R2014b.xsl");
        if (!CoderApp.isUsingUnifiedUIForC()) {
            defaultProjectVersionSupport.markTranslationAsPrivate(UNIFIED_TARGET_KEY, "R2014b");
        }
        defaultProjectVersionSupport.addTranslationResource(OLD_ECODER_TARGET_KEY, "R2014a_nu", UNIFIED_TARGET_KEY, "R2014b", ROOT_RESOURCE_PATH, "non_unified_to_R2014b.xsl");
        defaultProjectVersionSupport.addTranslationResource(OLD_HDL_TARGET_KEY, "R2013a", UNIFIED_TARGET_KEY, "R2014b", ROOT_RESOURCE_PATH, "non_unified_to_R2014b.xsl");
        if (!CoderApp.isUsingUnifiedUIForHDL()) {
            defaultProjectVersionSupport.markTranslationAsPrivate(UNIFIED_TARGET_KEY, "R2014b");
        }
        return defaultProjectVersionSupport;
    }

    static Target getUnifiedTargetIfSupported(String string) {
        boolean bl = false;
        Target target = null;
        if (string.equals(UNIFIED_TARGET_KEY)) {
            bl = true;
        } else {
            target = PluginManager.getLicensedTarget((String)string);
            if (target == null) {
                // empty if block
            }
        }
        return bl ? PluginManager.getTarget((String)UNIFIED_TARGET_KEY) : null;
    }

    static boolean isOldCoderTarget(Target target) {
        return target.getKey().equals(OLD_C_TARGET_KEY) || target.getKey().equals(OLD_ECODER_TARGET_KEY);
    }

    static boolean isOldHDLCoderTarget(Target target) {
        return target.getKey().equals(OLD_HDL_TARGET_KEY);
    }

    public static boolean isUnifiedTarget(Target target) {
        return target.getKey().equals(UNIFIED_TARGET_KEY);
    }

    private static Converter<FileSystemEntry, String> createProjectNameOverrider() {
        return new Converter<FileSystemEntry, String>(){

            public String convert(FileSystemEntry fileSystemEntry) {
                try {
                    GenericArtifact genericArtifact;
                    String string;
                    XmlReader xmlReader = ProjectManager.getStandardProjectXml((FileSystemEntry)fileSystemEntry, (boolean)false);
                    xmlReader = xmlReader.getChild(new String[]{"configuration"});
                    if (xmlReader.isPresent() && (xmlReader = xmlReader.getChild(new String[]{"param.objective"})).isPresent() && (string = xmlReader.readText()) != null && (genericArtifact = GenericArtifact.toGenericArifact(string)) != null) {
                        return genericArtifact.getProjectLabel();
                    }
                }
                catch (UnavailableTargetException unavailableTargetException) {
                    // empty catch block
                }
                return null;
            }
        };
    }
}

