/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.model.Interval;
import com.mathworks.toolbox.coder.screener.MTreeUtils;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTree;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;

public final class StaleTextMapper {
    private final DocumentListener fDocumentListener;
    private final PropertyChangeListener fWidgetListener;
    private final UnmappablePositionPolicy fPositionPolicy;
    private final Map<File, MappableContext> fContexts;
    private final Set<File> fInvalids;
    private final EditorView fEditor;
    private MappableContext fCurrentContext;
    private SyntaxTextPane fTextPane;
    private boolean fMonitoring;

    public StaleTextMapper(EditorView editorView, @Nullable UnmappablePositionPolicy unmappablePositionPolicy) {
        this.fEditor = editorView;
        this.fContexts = new HashMap<File, MappableContext>();
        this.fInvalids = new HashSet<File>();
        this.fDocumentListener = this.createDocumentListener();
        this.fWidgetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("document") && propertyChangeEvent.getOldValue() != null) {
                    ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(StaleTextMapper.this.fDocumentListener);
                    ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(StaleTextMapper.this.fDocumentListener);
                    StaleTextMapper.this.reset(false);
                }
            }
        };
        this.fPositionPolicy = unmappablePositionPolicy != null ? unmappablePositionPolicy : UnmappablePositionPolicy.RETURN_ZERO;
        this.resetAll();
    }

    public StaleTextMapper(EditorView editorView) {
        this(editorView, null);
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.processDocumentEvent(documentEvent, EditType.ADD);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.processDocumentEvent(documentEvent, EditType.DELETE);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void processDocumentEvent(DocumentEvent documentEvent, EditType editType) {
                if (StaleTextMapper.this.fMonitoring && StaleTextMapper.this.fEditor.isLoaded() && StaleTextMapper.this.fCurrentContext != null && StaleTextMapper.this.isValid()) {
                    List<Edit> list = StaleTextMapper.this.fCurrentContext.getEdits();
                    if (!((BaseDocumentEvent)documentEvent).isInUndo()) {
                        list.add(new Edit(editType, documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength()));
                    } else if (!list.isEmpty()) {
                        list.remove(list.size() - 1);
                    }
                }
            }
        };
    }

    public boolean isValid() {
        return this.fCurrentContext == null || this.isValid(this.fCurrentContext.getLoadContext());
    }

    public boolean isValid(EditorLoadContext editorLoadContext) {
        return editorLoadContext.hasFile() && !this.fInvalids.contains(editorLoadContext.getFile());
    }

    public void mark(File file, String string) {
        if (this.fContexts.containsKey(file)) {
            MappableContext mappableContext = this.fContexts.get(file);
            Set<String> set = mappableContext.getTags().get(mappableContext.getEdits().size());
            if (set == null) {
                set = new HashSet<String>();
                mappableContext.getTags().put(mappableContext.getEdits().size(), set);
            }
            set.add(string);
        }
    }

    @NotNull
    public Set<String> getTags(File file) {
        MappableContext mappableContext;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.fContexts.containsKey(file) && (mappableContext = this.fContexts.get(file)).getTags().containsKey(mappableContext.getEdits().size())) {
            hashSet.addAll((Collection<String>)mappableContext.getTags().get(mappableContext.getEdits().size()));
        }
        return hashSet;
    }

    public void setCurrent(EditorLoadContext editorLoadContext) {
        if (editorLoadContext == null || !editorLoadContext.hasFile()) {
            this.fCurrentContext = null;
        } else if (this.fContexts.containsKey(editorLoadContext.getFile())) {
            this.fCurrentContext = this.fContexts.get(editorLoadContext.getFile());
        } else {
            BaseDocument baseDocument = new BaseDocument(MLanguage.INSTANCE.createDefaultKit().getClass(), false);
            String string = this.fEditor.getTextPane().getText();
            try {
                baseDocument.insertString(0, string, null);
                MTree mTree = MTree.parse((String)string, (boolean)true);
                this.fCurrentContext = new MappableContext(mTree, baseDocument, editorLoadContext);
                this.fContexts.put(editorLoadContext.getFile(), this.fCurrentContext);
            }
            catch (BadLocationException badLocationException) {
                this.fCurrentContext = null;
            }
        }
    }

    public void invalidate(File file) {
        this.fInvalids.add(file);
    }

    public void resetCurrent() {
        this.reset(false);
    }

    public void resetAll() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        if (bl) {
            this.fInvalids.clear();
            this.fContexts.clear();
        } else if (this.fCurrentContext != null) {
            this.fInvalids.remove(this.fCurrentContext.getLoadContext().getFile());
            this.fContexts.remove(this.fCurrentContext.getLoadContext().getFile());
        }
        this.setCurrent(this.fCurrentContext != null ? this.fCurrentContext.getLoadContext() : null);
    }

    public void setMonitoring(boolean bl) {
        this.fMonitoring = bl;
    }

    public MTree.Node getNodeAtPosition(int n) {
        return this.fCurrentContext != null ? MTreeUtils.getNodeAtPosition(this.fCurrentContext.getOriginalParseTree(), n, this.fCurrentContext.getOriginalCode(), false) : null;
    }

    public int getMinimumPosition(MTree.Node node) {
        return this.fCurrentContext != null ? MTreeUtils.getMinimumPosition(node, this.fCurrentContext.getOriginalCode()) : -1;
    }

    public int getMaximumPosition(MTree.Node node) {
        return this.fCurrentContext != null ? MTreeUtils.getMaximumPosition(node, this.fCurrentContext.getOriginalCode()) : -1;
    }

    public int mapToCurrent(int n) {
        Edit edit;
        if (this.fCurrentContext == null || !this.isValid()) {
            return -1;
        }
        int n2 = n;
        Iterator<Edit> iterator = this.fCurrentContext.getEdits().iterator();
        while (iterator.hasNext() && (n2 = (edit = iterator.next()).mapToCurrent(n2)) >= 0) {
        }
        return this.validatePosition(n, n2);
    }

    public int mapToOriginal(int n) {
        if (!this.isValid()) {
            return -1;
        }
        int n2 = n;
        for (int i = this.fCurrentContext.getEdits().size() - 1; i >= 0 && (n2 = this.fCurrentContext.getEdits().get(i).mapToOriginal(n2)) >= 0; --i) {
        }
        return this.validatePosition(n, n2);
    }

    public Interval mapToCurrent(Interval interval) {
        return new Interval(this.mapToCurrent(interval.getStart()), this.mapToCurrent(interval.getEnd()));
    }

    public Interval mapToOriginal(Interval interval) {
        return new Interval(this.mapToOriginal(interval.getStart()), this.mapToOriginal(interval.getEnd()));
    }

    private int validatePosition(int n, int n2) {
        int n3 = n2;
        if (n3 == -1) {
            switch (this.fPositionPolicy) {
                case RETURN_ARGUMENT: {
                    n3 = n;
                    break;
                }
                case RETURN_NEGATIVE_ONE: {
                    n3 = -1;
                    break;
                }
                case RETURN_ZERO: {
                    n3 = 0;
                }
            }
        }
        return n3;
    }

    public void setTextPane(SyntaxTextPane syntaxTextPane) {
        if (this.fTextPane != null) {
            this.fTextPane.removePropertyChangeListener(this.fWidgetListener);
            this.fTextPane.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        this.fTextPane = syntaxTextPane;
        syntaxTextPane.addPropertyChangeListener("document", this.fWidgetListener);
        syntaxTextPane.getDocument().addDocumentListener(this.fDocumentListener);
        this.resetAll();
        this.setMonitoring(true);
    }

    private static class MappableContext {
        private final List<Edit> fEdits;
        private final Map<Integer, Set<String>> fTags;
        private final MTree fOriginalParseTree;
        private final BaseDocument fOriginalCode;
        private final EditorLoadContext fLoadContext;

        MappableContext(MTree mTree, BaseDocument baseDocument, EditorLoadContext editorLoadContext) {
            this.fOriginalParseTree = mTree;
            this.fOriginalCode = baseDocument;
            this.fLoadContext = editorLoadContext;
            this.fEdits = new ArrayList<Edit>(50);
            this.fTags = new TreeMap<Integer, Set<String>>(new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return n2.compareTo(n);
                }
            });
        }

        Map<Integer, Set<String>> getTags() {
            return this.fTags;
        }

        MTree getOriginalParseTree() {
            return this.fOriginalParseTree;
        }

        BaseDocument getOriginalCode() {
            return this.fOriginalCode;
        }

        List<Edit> getEdits() {
            return this.fEdits;
        }

        EditorLoadContext getLoadContext() {
            return this.fLoadContext;
        }
    }

    private static class Edit {
        private final EditType fEditType;
        private final int fStart;
        private final int fEnd;

        Edit(EditType editType, int n, int n2) {
            this.fEditType = editType;
            this.fStart = n;
            this.fEnd = n2;
        }

        int mapToOriginal(int n) {
            int n2 = n;
            if (n2 >= this.getStart()) {
                n2 = n2 < this.getEnd() && this.getEditType() == EditType.ADD ? -1 : (n2 += (this.getEditType() == EditType.DELETE ? 1 : -1) * (this.getEnd() - this.getStart()));
            }
            return n2;
        }

        int mapToCurrent(int n) {
            int n2 = n;
            if (n2 >= this.getStart()) {
                n2 = n2 < this.getEnd() && this.getEditType() == EditType.DELETE ? -1 : (n2 += (this.getEditType() == EditType.ADD ? 1 : -1) * (this.getEnd() - this.getStart()));
            }
            return n2;
        }

        private EditType getEditType() {
            return this.fEditType;
        }

        private int getEnd() {
            return this.fEnd;
        }

        private int getStart() {
            return this.fStart;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Edit)) {
                return false;
            }
            Edit edit = (Edit)object;
            return this.getEnd() == edit.getEnd() && this.getStart() == edit.getStart() && this.getEditType() == edit.getEditType();
        }

        public int hashCode() {
            int n = this.getEditType().hashCode();
            n = 31 * n + this.getStart();
            n = 31 * n + this.getEnd();
            return n;
        }
    }

    private static enum EditType {
        ADD,
        DELETE;

    }

    public static enum UnmappablePositionPolicy {
        RETURN_ZERO,
        RETURN_NEGATIVE_ONE,
        RETURN_ARGUMENT;

    }
}

