/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.GlassPaneWidget;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class NotificationManager {
    private final GlassPaneManager fGlassPane;
    private final GlassPaneWidget fWidget;
    private String fText;
    private double fRatio;
    private JComponent fComponent;
    private Timer fTimer;
    private static final int WIDTH = PlatformInfo.isMacintosh() ? 220 : 200;
    private static final int HEIGHT = 100;
    private static final int CHECK_WIDTH = 40;
    private static final int CHECK_HEIGHT = 50;
    private static final int CHECK_MARGIN = 12;
    private static final float CHECK_THICKNESS = 5.0f;
    private static final Font FONT = new MJLabel().getFont().deriveFont(1, 18.0f);

    public NotificationManager(GlassPaneManager glassPaneManager) {
        this.fGlassPane = glassPaneManager;
        this.fWidget = new GlassPaneWidget.AbstractGlassPaneWidget(){

            @Override
            public void paint(Component component, Graphics2D graphics2D) {
                if (!NotificationManager.this.fComponent.isShowing()) {
                    return;
                }
                if (NotificationManager.this.fRatio > 0.0 && NotificationManager.this.fText != null) {
                    RectangularShape rectangularShape;
                    Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setColor(new Color(150, 150, 150));
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)NotificationManager.this.fRatio));
                    Point point = NotificationManager.this.fComponent.getLocation();
                    point = SwingUtilities.convertPoint(NotificationManager.this.fComponent.getParent(), point, NotificationManager.this.fGlassPane.getPane());
                    double d = point.getX() + (double)(NotificationManager.this.fComponent.getWidth() / 2);
                    double d2 = point.getY() + (double)(NotificationManager.this.fComponent.getHeight() / 2);
                    graphics2D.setFont(FONT);
                    int n = (int)graphics2D.getFontMetrics().getStringBounds(NotificationManager.this.fText, graphics2D).getWidth();
                    int n2 = Math.max(n + 8, WIDTH);
                    RectangularShape rectangularShape2 = rectangularShape = PlatformInfo.isMacintosh() ? new RoundRectangle2D.Double((int)(d - (double)(n2 / 2)), (int)(d2 - 50.0), n2, 100.0, 16.0, 16.0) : new Rectangle2D.Double((int)(d - (double)(n2 / 2)), (int)(d2 - 50.0), n2, 100.0);
                    if (PlatformInfo.isMacintosh()) {
                        graphics2D.setColor(new Color(150, 150, 150));
                    } else {
                        graphics2D.setColor(new Color(230, 255, 230));
                    }
                    graphics2D.fill(rectangularShape);
                    if (!PlatformInfo.isMacintosh()) {
                        graphics2D.setColor(new Color(150, 150, 150));
                        graphics2D.setStroke(new BasicStroke(2.0f));
                        graphics2D.draw(rectangularShape);
                    }
                    graphics2D.setColor(PlatformInfo.isMacintosh() ? Color.WHITE : new Color(100, 100, 100));
                    graphics2D.drawString(NotificationManager.this.fText, (float)(d - (double)(n / 2)), (float)(rectangularShape.getBounds().getY() + rectangularShape.getBounds().getHeight() - (double)graphics2D.getFontMetrics().getDescent() - 4.0));
                    graphics2D.setStroke(new BasicStroke(5.0f, 1, 1));
                    graphics2D.draw(new Line2D.Double(d, rectangularShape.getBounds().getY() + 12.0 + 50.0, d - 20.0, rectangularShape.getBounds().getY() + 12.0 + 25.0));
                    graphics2D.draw(new Line2D.Double(d, rectangularShape.getBounds().getY() + 12.0 + 50.0, d + 20.0, rectangularShape.getBounds().getY() + 12.0));
                    graphics2D.setComposite(composite);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public boolean contains(int n, int n2) {
                return false;
            }
        };
    }

    public void setComponent(JComponent jComponent) {
        this.fComponent = jComponent;
    }

    public void showMessage(String string) {
        this.fText = string;
        this.fRatio = 1.0;
        if (this.fTimer != null) {
            this.fTimer.stop();
        }
        this.fGlassPane.add(this.fWidget);
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.fTimer = new Timer(800, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotificationManager.this.fTimer = new Timer(10, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NotificationManager.this.fRatio -= 0.05;
                        NotificationManager.this.fComponent.revalidate();
                        NotificationManager.this.fComponent.repaint();
                        if (NotificationManager.this.fRatio <= 0.0) {
                            NotificationManager.this.fGlassPane.remove(NotificationManager.this.fWidget);
                            NotificationManager.this.fText = null;
                            NotificationManager.this.fTimer.stop();
                            NotificationManager.this.fTimer = null;
                        }
                    }
                });
                NotificationManager.this.fTimer.setRepeats(true);
                NotificationManager.this.fTimer.start();
            }
        });
        this.fTimer.setRepeats(false);
        this.fTimer.start();
    }
}

