/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.toolbox.coder.app.GlassPaneWidget;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class GlassPaneManager {
    private static GlassPaneManager sTestingSingleton;
    private final JRootPane fRootPane;
    private final Set<WidgetContext> fWidgets;
    private final List<Blocker> fBlockers;
    private final Point fRootTranslation;
    private final AWTEventListener fAwtListener;
    private String fTooltip;

    public GlassPaneManager(JRootPane jRootPane) {
        this.fRootPane = jRootPane;
        this.fWidgets = new HashSet<WidgetContext>();
        this.fBlockers = new LinkedList<Blocker>();
        this.fRootTranslation = new Point(jRootPane.getX(), jRootPane.getY());
        this.fAwtListener = this.createInterceptingListener();
        jRootPane.addComponentListener(this.createRootPaneListener());
        this.fRootPane.setGlassPane(new JComponent(){

            @Override
            public void paintComponent(Graphics graphics) {
                graphics.translate((int)(-GlassPaneManager.this.fRootTranslation.getX()), (int)(-GlassPaneManager.this.fRootTranslation.getY()));
                GlassPaneManager.this.paintNormally((Graphics2D)graphics, (JComponent)GlassPaneManager.this.fRootPane.getGlassPane());
            }

            @Override
            public boolean contains(int n, int n2) {
                n = (int)((double)n + GlassPaneManager.this.fRootTranslation.getX());
                n2 = (int)((double)n2 + GlassPaneManager.this.fRootTranslation.getY());
                for (GlassPaneWidget glassPaneWidget : GlassPaneManager.this.iterableWidgets()) {
                    if (!glassPaneWidget.contains(n, n2)) continue;
                    return true;
                }
                return GlassPaneManager.this.fTooltip != null;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return GlassPaneManager.this.fTooltip != null ? GlassPaneManager.this.fTooltip : super.getToolTipText(mouseEvent);
            }
        });
        this.fRootPane.getGlassPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = (int)((double)mouseEvent.getX() + GlassPaneManager.this.fRootTranslation.getX());
                int n2 = (int)((double)mouseEvent.getY() + GlassPaneManager.this.fRootTranslation.getY());
                for (GlassPaneWidget glassPaneWidget : GlassPaneManager.this.iterableWidgets()) {
                    if (!glassPaneWidget.contains(n, n2)) continue;
                    glassPaneWidget.mouseClicked(mouseEvent);
                    mouseEvent.consume();
                }
            }
        });
        this.fRootPane.getGlassPane().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = (int)((double)mouseEvent.getX() + GlassPaneManager.this.fRootTranslation.getX());
                int n2 = (int)((double)mouseEvent.getY() + GlassPaneManager.this.fRootTranslation.getY());
                Point point = new Point(n, n2);
                GlassPaneManager.this.fTooltip = null;
                for (GlassPaneWidget glassPaneWidget : GlassPaneManager.this.iterableWidgets()) {
                    String string = glassPaneWidget.getTooltip(point);
                    if (string == null || !glassPaneWidget.contains(n, n2)) continue;
                    GlassPaneManager.this.fTooltip = string;
                    ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(GlassPaneManager.this.fRootPane.getGlassPane(), 0, 0L, 0, mouseEvent.getX(), mouseEvent.getY(), 0, false));
                    break;
                }
                if (GlassPaneManager.this.fTooltip == null) {
                    GlassPaneManager.this.hideTooltip();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GlassPaneManager.this.hideTooltip();
            }
        });
        sTestingSingleton = this;
    }

    private void hideTooltip() {
        this.fTooltip = null;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        boolean bl = toolTipManager.isEnabled();
        toolTipManager.setEnabled(false);
        if (bl) {
            toolTipManager.setEnabled(true);
        }
    }

    private ComponentListener createRootPaneListener() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.resetTranslation();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.resetTranslation();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                this.resetTranslation();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                this.resetTranslation();
            }

            private void resetTranslation() {
                GlassPaneManager.this.fRootTranslation.setLocation(GlassPaneManager.this.fRootPane.getX(), GlassPaneManager.this.fRootPane.getY());
                GlassPaneManager.this.repaint();
            }
        };
    }

    public void repaint() {
        this.getPane().revalidate();
        this.getPane().repaint();
    }

    public void repaint(GlassPaneWidget glassPaneWidget) {
        this.paintEfficiently((JComponent)this.fRootPane.getGlassPane(), glassPaneWidget);
    }

    public Component getPane() {
        return this.fRootPane.getGlassPane();
    }

    public Blocker createBlocker() {
        return new Blocker();
    }

    public void add(GlassPaneWidget glassPaneWidget) {
        this.add(glassPaneWidget, false);
    }

    public void add(GlassPaneWidget glassPaneWidget, boolean bl) {
        boolean bl2 = this.isFreezeFrame();
        this.fWidgets.add(new WidgetContext(glassPaneWidget, bl));
        if (this.fBlockers.isEmpty()) {
            this.fRootPane.getGlassPane().setVisible(true);
        }
        if (bl && !bl2) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fAwtListener, 131120L);
        }
    }

    public void remove(GlassPaneWidget glassPaneWidget) {
        boolean bl = this.isFreezeFrame();
        Iterator<WidgetContext> iterator = this.fWidgets.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getWidget().equals(glassPaneWidget)) continue;
            iterator.remove();
        }
        if (this.fWidgets.isEmpty()) {
            this.fRootPane.getGlassPane().setVisible(false);
        }
        if (bl && !this.isFreezeFrame()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fAwtListener);
        }
        this.hideTooltip();
    }

    private List<GlassPaneWidget> iterableWidgets() {
        LinkedList<GlassPaneWidget> linkedList = new LinkedList<GlassPaneWidget>();
        for (WidgetContext widgetContext : this.fWidgets) {
            linkedList.add(widgetContext.getWidget());
        }
        return linkedList;
    }

    private boolean isFreezeFrame() {
        for (WidgetContext widgetContext : this.fWidgets) {
            if (!widgetContext.isFreezeFrame()) continue;
            return true;
        }
        return false;
    }

    private AWTEventListener createInterceptingListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                MouseEvent mouseEvent;
                if (aWTEvent instanceof MouseEvent && !SwingUtilities.isDescendingFrom((mouseEvent = (MouseEvent)aWTEvent).getComponent(), GlassPaneManager.this.fRootPane)) {
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), GlassPaneManager.this.fRootPane);
                    if (!GlassPaneManager.this.fRootPane.contains(point)) {
                        ((MouseEvent)aWTEvent).consume();
                    }
                }
            }
        };
    }

    private WidgetContext getWidgetContext(GlassPaneWidget glassPaneWidget) {
        for (WidgetContext widgetContext : this.fWidgets) {
            if (!glassPaneWidget.equals(widgetContext.getWidget())) continue;
            return widgetContext;
        }
        return null;
    }

    private void paintEfficiently(JComponent jComponent, GlassPaneWidget glassPaneWidget) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        LinkedList<Rectangle> linkedList = new LinkedList<Rectangle>();
        WidgetContext widgetContext = this.getWidgetContext(glassPaneWidget);
        if (widgetContext == null) {
            return;
        }
        Rectangle rectangle = widgetContext.getWidget().getBounds();
        if (rectangle != null) {
            if (widgetContext.getStoredBounds() == null) {
                linkedList.add(rectangle);
            } else if (widgetContext.getStoredBounds().intersects(rectangle)) {
                linkedList.add(rectangle.union(widgetContext.getStoredBounds()));
            } else {
                linkedList.add(rectangle);
                linkedList.add(widgetContext.getStoredBounds());
            }
        }
        widgetContext.setStoredBounds(rectangle);
        if (!linkedList.isEmpty()) {
            repaintManager.markCompletelyClean(jComponent);
            for (Rectangle rectangle2 : linkedList) {
                rectangle2.translate((int)(-this.fRootTranslation.getX()), (int)(-this.fRootTranslation.getY()));
                jComponent.paintImmediately(rectangle2);
            }
        }
    }

    private void paintNormally(Graphics2D graphics2D, JComponent jComponent) {
        for (GlassPaneWidget glassPaneWidget : this.iterableWidgets()) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            glassPaneWidget.paint(jComponent, graphics2D2);
            graphics2D2.dispose();
        }
    }

    public Rectangle getFirstWidgetRect() {
        if (this.fWidgets.isEmpty()) {
            return null;
        }
        return this.fWidgets.iterator().next().getWidget().getBounds();
    }

    public static GlassPaneManager getTestingInstance() {
        return sTestingSingleton;
    }

    private class WidgetContext {
        private final GlassPaneWidget fWidget;
        private final boolean fFreezeFrame;
        private Rectangle fStoredBounds;

        WidgetContext(GlassPaneWidget glassPaneWidget, boolean bl) {
            this.fWidget = glassPaneWidget;
            this.fFreezeFrame = bl;
            this.setStoredBounds(glassPaneWidget.getBounds());
        }

        GlassPaneWidget getWidget() {
            return this.fWidget;
        }

        boolean isFreezeFrame() {
            return this.fFreezeFrame;
        }

        Rectangle getStoredBounds() {
            return this.fStoredBounds;
        }

        void setStoredBounds(Rectangle rectangle) {
            this.fStoredBounds = rectangle;
        }
    }

    public class Blocker {
        private Blocker() {
            GlassPaneManager.this.fBlockers.add(this);
            GlassPaneManager.this.fRootPane.getGlassPane().setVisible(false);
        }

        public void dispose() {
            GlassPaneManager.this.hideTooltip();
            GlassPaneManager.this.fBlockers.remove(this);
            if (GlassPaneManager.this.fBlockers.isEmpty() && !GlassPaneManager.this.fWidgets.isEmpty()) {
                GlassPaneManager.this.fRootPane.getGlassPane().setVisible(true);
            }
        }
    }
}

