/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppFacet;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointAppFacet;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import java.io.File;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;

public enum GenericArtifact {
    C,
    HDL,
    FIXED_POINT(new ReturnRunnable<CoderAppFacet>(){

        public CoderAppFacet run() {
            return new FixedPointAppFacet();
        }
    });

    private static final Object MUTEX;
    private static final boolean CACHE_LICENSE_STATE = false;
    private static Set<GenericArtifact> sLicensedArtifacts;
    private final String fLabel;
    private final String fProductLabel;
    private final String fObjective;
    private final String fProjectLabel;
    private final ReturnRunnable<CoderAppFacet> fFacetFactory;

    private GenericArtifact() {
        this(null);
    }

    private GenericArtifact(ReturnRunnable<CoderAppFacet> returnRunnable) {
        this.fFacetFactory = returnRunnable;
        this.fLabel = this.stringFromName("wfa.genericArtifact");
        this.fProductLabel = this.stringFromName("wfa.title");
        this.fProjectLabel = this.stringFromName("wfa.projectLabel");
        this.fObjective = "option.objective." + this.filterName();
    }

    CoderAppFacet createNewAppFacet() {
        if (this.fFacetFactory != null) {
            return (CoderAppFacet)this.fFacetFactory.run();
        }
        return null;
    }

    public String getObjectiveString() {
        return this.fObjective;
    }

    public String getProjectLabel() {
        return this.fProjectLabel;
    }

    private String stringFromName(String string) {
        return CoderResources.getString(string + '.' + this.filterName());
    }

    private String filterName() {
        return this.name().toLowerCase(Locale.ENGLISH).replaceAll("_", "");
    }

    public static GenericArtifact toGenericArifact(@NotNull String string) {
        for (GenericArtifact genericArtifact : GenericArtifact.values()) {
            if (!string.equals(genericArtifact.getObjectiveString())) continue;
            return genericArtifact;
        }
        return null;
    }

    @NotNull
    public Artifact getDefaultSpecificArtifact() {
        return this == HDL ? Artifact.GENERIC_ASIC_FPGA : Artifact.MEX_FILE;
    }

    @NotNull
    public Set<Artifact> getArtifacts() {
        if (this == FIXED_POINT) {
            return EnumSet.of(Artifact.MEX_FILE);
        }
        if (this == C) {
            return EnumSet.of(Artifact.MEX_FILE, Artifact.STATIC_LIBRARY, Artifact.SHARED_LIBRARY, Artifact.EXECUTABLE);
        }
        return EnumSet.of(Artifact.GENERIC_ASIC_FPGA, Artifact.FPGA_TURNKEY, Artifact.IP_CORE_LIBRARY);
    }

    public String toString() {
        return this.fLabel;
    }

    public String getProductLabel() {
        return this.fProductLabel;
    }

    public static boolean isFixedPointLicensed() {
        return GenericArtifact.getSupportedArtifacts(false).contains((Object)FIXED_POINT);
    }

    public static boolean isMatlabCoderLicensed() {
        return GenericArtifact.getSupportedArtifacts(false).contains((Object)C);
    }

    public static boolean isHDLCoderLicensed() {
        return GenericArtifact.getSupportedArtifacts(false).contains((Object)HDL);
    }

    public static void getSupportedArtifacts(final @NotNull ParameterRunnable<EnumSet<GenericArtifact>> parameterRunnable, boolean bl) {
        final EnumSet<GenericArtifact> enumSet = EnumSet.noneOf(GenericArtifact.class);
        final Predicate<GenericArtifact> predicate = bl ? GenericArtifact.createUnifiedUIFilter() : null;
        GenericArtifact.runLicenseChecksAsync(new ParameterRunnable<EnumSet<GenericArtifact>>(){

            public void run(EnumSet<GenericArtifact> enumSet2) {
                GenericArtifact.filterInto(enumSet2, enumSet, (Predicate<GenericArtifact>)predicate);
                parameterRunnable.run((Object)enumSet);
            }
        });
    }

    public static void getSupportedArtifacts(@NotNull ParameterRunnable<EnumSet<GenericArtifact>> parameterRunnable) {
        GenericArtifact.getSupportedArtifacts(parameterRunnable, true);
    }

    private static void filterInto(Set<GenericArtifact> set, Set<GenericArtifact> set2, Predicate<GenericArtifact> predicate) {
        if (predicate == null) {
            set2.addAll(set);
        } else {
            for (GenericArtifact genericArtifact : set) {
                if (!predicate.accept((Object)genericArtifact)) continue;
                set2.add(genericArtifact);
            }
        }
    }

    private static Predicate<GenericArtifact> createUnifiedUIFilter() {
        return new Predicate<GenericArtifact>(){

            public boolean accept(GenericArtifact genericArtifact) {
                if (genericArtifact == C && !CoderApp.isUsingUnifiedUIForC()) {
                    return false;
                }
                return genericArtifact != HDL || CoderApp.isUsingUnifiedUIForHDL();
            }
        };
    }

    @NotNull
    public static Set<GenericArtifact> getSupportedArtifacts(boolean bl) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Holder holder = new Holder();
        GenericArtifact.getSupportedArtifacts(new ParameterRunnable<EnumSet<GenericArtifact>>(){

            public void run(EnumSet<GenericArtifact> enumSet) {
                holder.set(enumSet);
                countDownLatch.countDown();
            }
        }, bl);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        return (Set)holder.get();
    }

    private static void runLicenseChecksAsync(final @NotNull ParameterRunnable<EnumSet<GenericArtifact>> parameterRunnable) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            parameterRunnable.run(GenericArtifact.runLicenseChecksSynchronously());
        } else {
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    parameterRunnable.run((Object)GenericArtifact.runLicenseChecksSynchronously());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static EnumSet<GenericArtifact> runLicenseChecksSynchronously() {
        Object object = MUTEX;
        synchronized (object) {
            if (sLicensedArtifacts != null) {
                // empty if block
            }
            if (sLicensedArtifacts != null) {
                sLicensedArtifacts.clear();
            } else {
                sLicensedArtifacts = EnumSet.noneOf(GenericArtifact.class);
            }
            if (GenericArtifact.checkLicenseMT("MATLAB_Coder", "toolbox/coder/matlabcoder/Contents.m")) {
                sLicensedArtifacts.add(C);
            }
            if (GenericArtifact.checkLicenseMT("MATLAB_HDL_Coder", "toolbox/hdlcoder/matlabhdlcoder")) {
                sLicensedArtifacts.add(HDL);
            }
            if (GenericArtifact.checkLicenseMT("Fixed_Point_Toolbox", "toolbox/fixedpoint/fixedpoint/Contents.m")) {
                sLicensedArtifacts.add(FIXED_POINT);
            }
            return EnumSet.copyOf(sLicensedArtifacts);
        }
    }

    private static boolean checkLicenseMT(String string, String string2) {
        try {
            File file = new File(Matlab.matlabRoot(), string2);
            if (!file.exists()) {
                return false;
            }
            Object object = Matlab.mtFeval((String)"license", (Object[])new Object[]{"test", string}, (int)1);
            return ((double[])object)[0] > 0.0;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        MUTEX = new Object();
    }
}

