/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class FindPanel
implements PopupBarContent {
    private final MJLabel fStatusLabel;
    private final MJTextField fSearchField;
    private final FindAdapter fFinder;
    private MJPanel fComponent;

    public FindPanel(FindAdapter findAdapter) {
        this.fFinder = findAdapter;
        this.fSearchField = new SearchField();
        this.fStatusLabel = new MJLabel();
        this.fStatusLabel.setFont(this.fStatusLabel.getFont().deriveFont(0));
    }

    @Override
    public String getCloseButtonText() {
        return CoderResources.getString("f2f.find.done");
    }

    @Override
    public JComponent createComponent(MJButton mJButton) {
        if (this.fComponent != null) {
            return this.fComponent;
        }
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.setLayout((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d, 1dlu, fill:d, 1dlu", "1px:grow, fill:d, 1px:grow"));
        } else {
            this.fComponent.setLayout((LayoutManager)new FlowLayout(0, 1, 1));
        }
        if (PlatformInfo.isMacintosh()) {
            CellConstraints cellConstraints = new CellConstraints();
            this.fComponent.add((Component)this.fStatusLabel, (Object)cellConstraints.xy(2, 2));
            this.fComponent.add((Component)this.fSearchField, (Object)cellConstraints.xy(4, 2));
            this.fComponent.add((Component)mJButton, (Object)cellConstraints.xy(6, 2));
        } else {
            this.fComponent.add((Component)((Object)new SearchFieldWrapper()));
            MJToolBar mJToolBar = new MJToolBar();
            mJToolBar.add((Component)mJButton);
            mJToolBar.setFloatable(false);
            mJToolBar.setOpaque(false);
            this.fComponent.add((Component)mJToolBar);
            this.fStatusLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
            this.fComponent.add((Component)this.fStatusLabel);
        }
        return this.fComponent;
    }

    private void updateSearch() {
        String string = this.fSearchField.getText();
        if (string.trim().isEmpty()) {
            this.fFinder.clearSearch();
            this.fStatusLabel.setText("");
        } else {
            int n = this.fFinder.find(string);
            if (n == 0) {
                this.fStatusLabel.setText(CoderResources.getString("f2f.find.notFound"));
            } else if (n == 1) {
                this.fStatusLabel.setText(CoderResources.getString("f2f.find.oneMatch"));
            } else {
                this.fStatusLabel.setText(MessageFormat.format(CoderResources.getString("f2f.find.matches"), n));
            }
        }
    }

    @Override
    public void activate() {
        this.fSearchField.requestFocus();
        this.fSearchField.selectAll();
        this.updateSearch();
    }

    @Override
    public void close() {
        this.fFinder.clearSearch();
    }

    private class SearchField
    extends MJTextField {
        SearchField() {
            this.setColumns(PlatformInfo.isMacintosh() ? 15 : 20);
            if (PlatformInfo.isMacintosh()) {
                this.putClientProperty("JTextField.variant", "search");
            }
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        FindPanel.this.fFinder.findNext();
                    }
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    FindPanel.this.updateSearch();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    FindPanel.this.updateSearch();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    FindPanel.this.updateSearch();
                }
            });
        }
    }

    private class SearchFieldWrapper
    extends MJPanel {
        SearchFieldWrapper() {
            this.setBackground(Color.WHITE);
            this.setLayout((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d:grow", "fill:d"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)FindPanel.this.fSearchField, cellConstraints.xy(3, 1));
            MJLabel mJLabel = new MJLabel((Icon)MiscellaneousIcon.MAGNIFYING_GLASS_BLUE.getIcon());
            mJLabel.setBackground(Color.WHITE);
            mJLabel.setOpaque(true);
            this.add((Component)mJLabel, cellConstraints.xy(1, 1));
            this.setBorder(new CompoundBorder(new EmptyBorder(0, 2, 0, 0), FindPanel.this.fSearchField.getBorder()));
            FindPanel.this.fSearchField.setBorder(null);
        }
    }
}

