/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.widgets.messagepanel.AbstractMessageModel;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.LayerMarkList;
import com.mathworks.widgets.text.MarkPair;
import com.mathworks.widgets.text.STPInterface;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.InvalidMarkException;

public final class CoderMessageModel
extends AbstractMessageModel {
    private static final String RES_GENERIC_MESSAGE_LABEL = "wfa.msg.label";
    private final List<EditorMessage> fMessages = new ArrayList<EditorMessage>();
    private final EditorMessageFactory fMessageFactory;
    private LayerMarkList fMarkModel;
    private MessageModel.Priority fPriority;

    public CoderMessageModel(EditorMessageFactory editorMessageFactory) {
        this.fMessageFactory = editorMessageFactory;
    }

    public CoderMessageModel(EditorMessageFactory editorMessageFactory, LayerMarkList layerMarkList) {
        this(editorMessageFactory);
        this.initModel(layerMarkList);
    }

    public void initModel(LayerMarkList layerMarkList) {
        this.fMessages.clear();
        this.fMarkModel = layerMarkList;
        for (int i = 0; i < layerMarkList.size(); ++i) {
            this.fMessages.add(this.fMessageFactory.buildEditorMessage(layerMarkList, i));
        }
        this.notifyListeners();
    }

    public int getMessageCount() {
        return this.fMessages.size();
    }

    public void setPriority(MessageModel.Priority priority) {
        this.fPriority = priority;
    }

    public String getLayerNameAt(int n) {
        return this.fMarkModel.get(n).getLayerName();
    }

    public EditorMessage getMessageAt(int n) {
        return this.fMessages.get(n);
    }

    public String getTextAt(int n) {
        return this.getMessageAt(n).getMessage();
    }

    public int getLineNumberAt(int n) {
        return this.getMessageAt(n).getLineNumber();
    }

    public int getPriorityAt(int n) {
        return n;
    }

    public MessageModel.Priority getModelPriority(int n) {
        return this.fPriority;
    }

    private static abstract class AbstractCoderEditorMessage
    implements EditorMessage {
        private final MarkPair fPair;
        private final STPInterface fStp;

        protected AbstractCoderEditorMessage(MarkPair markPair, STPInterface sTPInterface) {
            this.fPair = markPair;
            this.fStp = sTPInterface;
        }

        public int getStartPosition() {
            try {
                return this.fPair.getStartOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                return 0;
            }
        }

        public int getEndPosition() {
            try {
                return this.fPair.getEndOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                return 0;
            }
        }

        public int getNumberOfLines() {
            try {
                return this.fStp.getLineFromPos(this.getEndPosition()) - this.fStp.getLineFromPos(this.getStartPosition());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        public int getLineNumber() {
            return 0;
        }

        public Color getColor() {
            return null;
        }

        public boolean dismissOnCaretUpdate() {
            return false;
        }

        public Icon getIcon(int n) {
            return null;
        }

        public boolean isActionable() {
            return false;
        }

        public boolean hasTooltipAction() {
            return false;
        }

        public Action getTooltipAction() {
            return null;
        }

        public boolean isTooltipActionVisible() {
            return false;
        }

        public boolean isExtendable() {
            return false;
        }

        public boolean hasExtendedInformation() {
            return false;
        }

        public String getExtendedInformation() {
            return null;
        }

        public boolean isStatic() {
            return false;
        }
    }

    public static class GenericMarkPairMessageFactory
    implements EditorMessageFactory {
        private final String fLabelString = CoderResources.getString("wfa.msg.label");
        private final STPInterface fStp;

        public GenericMarkPairMessageFactory(STPInterface sTPInterface) {
            this.fStp = sTPInterface;
        }

        @Override
        public EditorMessage buildEditorMessage(LayerMarkList layerMarkList, int n) {
            return new AbstractCoderEditorMessage(layerMarkList.get(n), this.fStp){

                public String getMessage() {
                    return GenericMarkPairMessageFactory.this.fLabelString + this.getLineNumber();
                }
            };
        }
    }

    public static class BuildErrorMessageFactory
    implements EditorMessageFactory {
        private final STPInterface fStp;
        private final List<BuildError> fErrors;

        public BuildErrorMessageFactory(STPInterface sTPInterface, List<BuildError> list) {
            this.fStp = sTPInterface;
            this.fErrors = list;
        }

        @Override
        public EditorMessage buildEditorMessage(LayerMarkList layerMarkList, final int n) {
            return new AbstractCoderEditorMessage(layerMarkList.get(n), this.fStp){
                private final BuildError fError;
                {
                    super(markPair, sTPInterface);
                    this.fError = (BuildError)BuildErrorMessageFactory.this.fErrors.get(n);
                }

                public String getMessage() {
                    return this.fError.getMessage();
                }
            };
        }
    }

    public static interface EditorMessageFactory {
        public EditorMessage buildEditorMessage(LayerMarkList var1, int var2);
    }

    public static interface LayerMarkCallback {
        public String getMessageText(String var1, int var2);

        public int getLineNumber(int var1);
    }
}

