/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.NewOrOpenDialog;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderAppFacet;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.CoderRegistry;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.UnifiedTargetFactory;
import com.mathworks.toolbox.coder.app.ide.EditManager;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.CoderWorkflowFrame;
import com.mathworks.toolbox.coder.wfa.WorkflowAdvisor;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolbox.coder.widgets.GuiDefaults;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public final class CoderApp {
    static final String LEGACY_PROJECT_VAR = "var.LegacyTarget";
    private static final Object IDLE_MUTEX = new Object();
    private static Runnable sTaskWhenIdle;
    private static boolean sBusy;
    private CoderAppModel fModel;
    private MJFrame fFrame;
    private Animator fAnimator;
    private GlassPaneManager fGlassPane;
    private PopupBarManager fPopupBar;
    private ParamWidgetBinder fBinder;
    private EditManager fEditManager;
    private IDEView fIDEView;
    private FixedPointController fFixedPointController;
    private WorkflowAdvisor fAdvisor;
    private boolean fDisposed;
    private static final boolean USING_C_UNIFIED_UI_BY_DEFAULT = false;
    private static final boolean USING_HDL_UNIFIED_UI_BY_DEFAULT = false;
    private static final String C_FEATURE_SWITCH = "CoderUnifiedUIEnabled";
    private static final String HDL_FEATURE_SWITCH = "HDLCoderUnifiedUIEnabled";
    private static final String DEPRECATED_C_FEATURE_SWITCH = "CoderForceUnifiedUI";
    private static final String DEPRECATED_HDL_FEATURE_SWITCH = "HDLCoderForceUnifiedUI";
    private static final String CODER_HELP_MAP_PATH = "coder/helptargets.map";
    private static final String FIXED_POINT_HELP_MAP_PATH = "fixedpoint/fixedpoint.map";

    public static void run() throws Exception {
        CoderApp.run(GenericArtifact.C, Artifact.MEX_FILE);
    }

    public static void run(GenericArtifact genericArtifact, Artifact artifact) throws Exception {
        new CoderApp(CoderWorkflowFrame.class, genericArtifact, artifact, null);
    }

    public static void runMatlabCoder() throws Exception {
        if (CoderApp.isUsingUnifiedUIForC()) {
            CoderApp.run(GenericArtifact.C, Artifact.MEX_FILE);
        } else {
            NewOrOpenDialog.invoke((boolean)false, (String)"plugin.matlabcoder", (boolean)true);
        }
    }

    public static void runHdlCoder() throws Exception {
        if (CoderApp.isUsingUnifiedUIForHDL()) {
            CoderApp.run(GenericArtifact.HDL, Artifact.GENERIC_ASIC_FPGA);
        } else {
            NewOrOpenDialog.invoke((boolean)false, (String)"plugin.matlabhdlcoder", (boolean)true);
        }
    }

    public static void runFixedPointConverter() throws Exception {
        CoderApp.run(GenericArtifact.FIXED_POINT, Artifact.MEX_FILE);
    }

    public static void createSpecifiedCProject(final File file, final boolean bl) throws Exception {
        new CoderApp(CoderWorkflowFrame.class, GenericArtifact.C, Artifact.MEX_FILE, new ParameterRunnable<CoderApp>(){

            public void run(final CoderApp coderApp) {
                final File file2 = CoderFileSupport.toExistingSourceFile(file.getParentFile(), new FileLocation(file).getNameBeforeDot());
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (file2 != null) {
                            HashSet<File> hashSet = new HashSet<File>();
                            hashSet.add(file2);
                            coderApp.getModel().setEntryPoints(hashSet);
                        } else {
                            coderApp.getModel().setProjectFile(file);
                        }
                        coderApp.getModel().getConfiguration().setParamAsBoolean("param.UseECoderFeatures", bl);
                        coderApp.getAdvisor().getModel().setCurrentStep(CoderStepModel.CHOOSE_SOURCE_FILES_STEP, true);
                    }
                });
            }
        });
    }

    public static void revertDefaultGui() {
        Prefs.remove((String)C_FEATURE_SWITCH);
        Prefs.remove((String)HDL_FEATURE_SWITCH);
        PluginManager.init();
    }

    public static void enableNewGui() {
        Prefs.setBooleanPref((String)C_FEATURE_SWITCH, (boolean)true);
        Prefs.setBooleanPref((String)HDL_FEATURE_SWITCH, (boolean)true);
        PluginManager.init();
    }

    public static boolean isUsingUnifiedUIForC() {
        if (Prefs.exists((String)DEPRECATED_C_FEATURE_SWITCH)) {
            Prefs.remove((String)DEPRECATED_C_FEATURE_SWITCH);
        }
        return Prefs.getBooleanPref((String)C_FEATURE_SWITCH, (boolean)false);
    }

    public static boolean isUsingUnifiedUIForHDL() {
        if (Prefs.exists((String)DEPRECATED_HDL_FEATURE_SWITCH)) {
            Prefs.remove((String)DEPRECATED_HDL_FEATURE_SWITCH);
        }
        return Prefs.getBooleanPref((String)HDL_FEATURE_SWITCH, (boolean)false);
    }

    public static String getHelpMapPath(CoderApp coderApp) {
        return CoderApp.getHelpMapPath(coderApp, false);
    }

    public static String getHelpMapPath(CoderApp coderApp, boolean bl) {
        String string = bl || coderApp.getModel().getGenericArtifact() != GenericArtifact.FIXED_POINT ? CODER_HELP_MAP_PATH : FIXED_POINT_HELP_MAP_PATH;
        return PluginManager.resolveHelpMapPath((String)string);
    }

    public static void setUnifiedUIEnabledForC(boolean bl) {
        Prefs.setBooleanPref((String)C_FEATURE_SWITCH, (boolean)bl);
        PluginManager.init();
    }

    public static void setUnifiedUIEnabledForHDL(boolean bl) {
        Prefs.setBooleanPref((String)HDL_FEATURE_SWITCH, (boolean)bl);
        PluginManager.init();
    }

    public CoderApp(final Class<?> clazz, final GenericArtifact genericArtifact, final Artifact artifact, final ParameterRunnable<CoderApp> parameterRunnable) throws IOException {
        CoderAppModel.createNew(new ParameterRunnable<CoderAppModel>(){

            public void run(CoderAppModel coderAppModel) {
                CoderApp.this.setup(clazz, coderAppModel, genericArtifact, artifact);
                CoderRegistry.getInstance().register(CoderApp.this);
                if (parameterRunnable != null) {
                    parameterRunnable.run((Object)CoderApp.this);
                }
            }
        });
    }

    public static void open(Class<?> clazz, File file) {
        CoderApp.open(clazz, file, null);
    }

    public static void open(final Class<?> clazz, final File file, final @Nullable Target target) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderApp coderApp = CoderRegistry.getInstance().getOpenApp(file);
                if (coderApp != null) {
                    coderApp.show();
                } else {
                    CoderRegistry.getInstance().closeOpenGuis(false);
                    CoderApp.runWhenIdle(new Runnable(){

                        @Override
                        public void run() {
                            new CoderApp(clazz, file, target);
                        }
                    });
                }
            }
        });
    }

    private CoderApp(final Class<?> clazz, final File file, final @Nullable Target target) {
        CoderAppModel.load(file, new ParameterRunnable<CoderAppModel>(){

            public void run(CoderAppModel coderAppModel) {
                CoderApp.this.setup(clazz, coderAppModel, null, null);
                CoderRegistry.getInstance().register(CoderApp.this);
            }
        }, new ParameterRunnable<Target>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run(Target var1_1) {
                var2_2 = null;
                var3_3 = null;
                if (target != null && var1_1.getKey().equals("target.coder")) {
                    try {
                        var4_4 = ProjectManager.getStandardProjectXml((FileSystemEntry)RealFileSystem.getInstance().getEntry(new FileLocation(file)), (boolean)false);
                        var5_7 = var4_4.getChild(new String[]{"configuration"}).getChild(new String[]{"var.LegacyTarget"}).readText();
                        if (var5_7 == null) ** GOTO lbl28
                        if (var5_7.equals("target.matlab.coder")) {
                            var2_2 = PluginManager.getLicensedTarget((String)"target.matlab.coder");
                            var3_3 = "R2014a_nu";
                        }
                        if (!var5_7.endsWith("target.matlab.hdlcoder")) ** GOTO lbl28
                        var2_2 = PluginManager.getLicensedTarget((String)"target.matlab.hdlcoder");
                        var3_3 = "R2013a";
                    }
                    catch (UnavailableTargetException | IOException var4_5) {
                    }
                    finally {
                        if (var2_2 == null && target != null) {
                            if (!6.$assertionsDisabled && var3_3 != null) {
                                throw new AssertionError();
                            }
                            var2_2 = target;
                            var3_3 = target.getPlugin().getSaveVersion();
                        }
                    }
                } else if (target == null && (UnifiedTargetFactory.isOldCoderTarget(var1_1) || UnifiedTargetFactory.isOldHDLCoderTarget(var1_1))) {
                    var2_2 = PluginManager.getLicensedTarget((String)"target.coder");
                    var3_3 = "R2014b";
                }
lbl28:
                // 8 sources

                var4_6 = var2_2 != null && var3_3 != null && ProjectManager.retargetProject((File)file, (Target)var2_2, (String)var3_3) != false;
                var5_7 = var2_2;
                ProjectGUI.getInstance().open(file, (Converter)new Converter<String, Target>((Target)var5_7){
                    final /* synthetic */ Target val$finalAltTarget;
                    {
                        this.val$finalAltTarget = target;
                    }

                    public Target convert(String string) {
                        return var4_6 ? this.val$finalAltTarget : PluginManager.getLicensedTarget((String)string);
                    }
                }, false, target != null, target);
            }
        }, new ParameterRunnable<Exception>(){

            public void run(Exception exception) {
                if (exception instanceof UnavailableTargetException) {
                    CoderApp.showError("error.badtarget", "error.badtarget.title", new Object[]{file.getName()});
                } else {
                    CoderApp.showError("error.badproject", "error.badproject.title", new Object[]{file.getName()});
                }
                CoderRegistry.getInstance().unregister(CoderApp.this);
            }
        }, target != null);
    }

    private void setup(final Class<?> clazz, final CoderAppModel coderAppModel, final @Nullable GenericArtifact genericArtifact, final @Nullable Artifact artifact) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderApp.this.fModel = coderAppModel;
                CoderApp.this.installFacets();
                CoderApp.this.fAnimator = new Animator();
                CoderApp.this.fEditManager = new EditManager(new Predicate<File>(){

                    public boolean accept(File file) {
                        return !CoderApp.this.fModel.getOutputFiles().contains(file);
                    }
                });
                final RequestFilter requestFilter = new RequestFilter(new Runnable(){

                    @Override
                    public void run() {
                        coderAppModel.getScreenerModel().updateReport();
                    }
                }, 3000);
                CoderApp.this.fEditManager.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        requestFilter.request();
                    }
                });
                if (genericArtifact != null) {
                    coderAppModel.setGenericArtifact(genericArtifact);
                }
                if (artifact != null) {
                    CoderApp.this.fModel.setArtifact(artifact);
                }
                try {
                    Constructor constructor = clazz.getConstructor(CoderApp.class);
                    constructor.newInstance(CoderApp.this);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    throw new IllegalStateException(reflectiveOperationException);
                }
                CoderApp.this.fFrame.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        CoderRegistry.getInstance().unregister(CoderApp.this);
                        CoderApp.this.fFrame.removeWindowListener((WindowListener)this);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        CoderRegistry.getInstance().unregister(CoderApp.this);
                        CoderApp.this.fFrame.removeWindowListener((WindowListener)this);
                    }
                });
            }
        });
    }

    private void installFacets() {
        for (GenericArtifact genericArtifact : this.fModel.getSupportedGenericArtifacts()) {
            CoderAppFacet coderAppFacet = genericArtifact.createNewAppFacet();
            if (coderAppFacet == null) continue;
            this.fModel.installFacet(coderAppFacet, this, true);
        }
    }

    public boolean isFixedPointOnly() {
        return this.fModel.getSupportedGenericArtifacts().size() == 1 && this.fModel.getSupportedGenericArtifacts().contains((Object)GenericArtifact.FIXED_POINT);
    }

    public void setFrame(MJFrame mJFrame, GlassPaneManager glassPaneManager) {
        this.fFrame = mJFrame;
        this.fGlassPane = glassPaneManager;
        this.fIDEView = new IDEView(this);
        this.fPopupBar = this.fIDEView.getCodeInfoView().getPopupBarManager();
        CoderRegistry.getInstance().register(this);
    }

    public void setAdvisor(WorkflowAdvisor workflowAdvisor) {
        this.fAdvisor = workflowAdvisor;
    }

    public WorkflowAdvisor getAdvisor() {
        return this.fAdvisor;
    }

    public void show() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderApp.this.fFrame.toFront();
                CoderApp.this.fFrame.repaint();
            }
        });
    }

    public Animator getAnimator() {
        return this.fAnimator;
    }

    public void setFixedPointController(FixedPointController fixedPointController) {
        this.fFixedPointController = fixedPointController;
    }

    public FixedPointController getFixedPointController() {
        return this.fFixedPointController;
    }

    public EditManager getEditManager() {
        return this.fEditManager;
    }

    public Window getWindow() {
        return this.fFrame;
    }

    public GlassPaneManager getGlassPaneManager() {
        return this.fGlassPane;
    }

    public PopupBarManager getPopupBarManager() {
        return this.fPopupBar;
    }

    public CoderAppModel getModel() {
        return this.fModel;
    }

    public static Font getFont() {
        return GuiDefaults.getCoderFont();
    }

    public MJLabel createLabel(String string) {
        Configuration configuration = this.fModel.getConfiguration();
        return new MJLabel(configuration.getTarget().getParam(string).getName());
    }

    public IDEView getIDEView() {
        return this.fIDEView;
    }

    public Component createWidget(String string) {
        Configuration configuration = this.fModel.getConfiguration();
        if (this.fBinder == null) {
            this.fBinder = new ParamWidgetBinder(configuration.getProject(), false);
        }
        return this.fBinder.createAndRegister(configuration.getTarget().getParam(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.fDisposed) {
            int n;
            if (this.fEditManager.hasDirtyFiles() && (n = MJOptionPane.showConfirmDialog((Component)this.fFrame, (Object)CoderResources.getString("msg.unsavedSourceChanges.prompt"), (String)CoderResources.getString("msg.unsavedSourceChanges.title"), (int)0)) == 0) {
                this.fEditManager.saveAll();
            }
            this.fDisposed = true;
            this.fAdvisor.dispose();
            this.fEditManager.dispose();
            this.fFrame.setVisible(false);
            this.fFrame.dispose();
            this.fModel.dispose();
            this.fIDEView.dispose();
            CoderRegistry.getInstance().unregister(this);
            if (this.getModel().getSupportedGenericArtifacts().contains((Object)GenericArtifact.FIXED_POINT)) {
                Object object = IDLE_MUTEX;
                synchronized (object) {
                    sBusy = true;
                }
                object = new Matlab();
                Matlab.whenMatlabIdle((Runnable)new Runnable((Matlab)object){
                    final /* synthetic */ Matlab val$matlab;
                    {
                        this.val$matlab = matlab;
                    }

                    @Override
                    public void run() {
                        try {
                            Matlab.mtEval((String)"emlcprivate('coderProjectCloseCallback')");
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException(exception);
                        }
                        finally {
                            CoderApp.setIdleAndRunQueued();
                        }
                    }
                });
            }
        }
    }

    private static void showError(final String string, final String string2, final Object ... objectArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string3 = MessageFormat.format(BuiltInResources.getString((String)string), objectArray);
                String string22 = BuiltInResources.getString((String)string2);
                MJOptionPane.showMessageDialog((Component)MLDesktop.getInstance().getMainFrame(), (Object)string3, (String)string22, (int)0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWhenIdle(Runnable runnable) {
        Runnable runnable2 = null;
        Object object = IDLE_MUTEX;
        synchronized (object) {
            if (!sBusy) {
                runnable2 = runnable;
            } else {
                sTaskWhenIdle = runnable;
            }
        }
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIdleAndRunQueued() {
        Runnable runnable = null;
        Object object = IDLE_MUTEX;
        synchronized (object) {
            sBusy = false;
            runnable = sTaskWhenIdle;
            sTaskWhenIdle = null;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    static {
        CoderRegistry.getInstance().addClosePredicate(new Predicate<CoderRegistry.CloseContext>(){

            public boolean accept(CoderRegistry.CloseContext closeContext) {
                if (closeContext.getApp() == null || !closeContext.getApp().getModel().isTemporaryProjectFile() && !closeContext.getApp().getModel().hasOverwriteWarning()) {
                    String string = MessageFormat.format(CoderResources.getString("wfa.project.closeOpen.message"), closeContext.getProduct().getProductLabel(), closeContext.getProjectFile().getName());
                    MJOptionPane.showMessageDialog((Component)closeContext.getRepresentativeComponent(), (Object)string);
                }
                return true;
            }
        });
    }
}

