/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.pageddata.impl;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.pageddata.ClientPagedData;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.DataModelHandler2;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PagedDataImpl
implements ServerPagedData,
ClientPagedData {
    private PagedDataValues pagedDataValues;
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("paged data");
            thread.setDaemon(true);
            return thread;
        }
    });

    PagedDataImpl() {
    }

    public PagedDataImpl(PeerNode peerNode, String propertyKey, DataModelHandler handler) {
        this.pagedDataValues = new PagedDataValues(this, peerNode, propertyKey, handler);
    }

    private PagedDataImpl(PagedDataImpl pagedData) {
        this.pagedDataValues = pagedData.pagedDataValues;
    }

    public void destroy() {
        this.pagedDataValues.destroy();
    }

    public ClientPagedData updatePartialData(int startItem, int endItem) {
        return this.pagedDataValues.updatePartialData(startItem, -1, endItem, -1, false);
    }

    public ClientPagedData updatePartialData(int startRow, int startCol, int endRow, int endCol) {
        return this.pagedDataValues.updatePartialData(startRow, startCol, endRow, endCol, false);
    }

    public void update() {
        this.pagedDataValues.update();
    }

    public void setData(int startRow, int startCol, Object[] data) {
        this.pagedDataValues.setData(startRow, startCol, data);
    }

    public Object[] getPartialData() {
        return this.pagedDataValues.partialData;
    }

    public int getRowCount() {
        return this.pagedDataValues.rowCount;
    }

    public int getColumnCount() {
        return this.pagedDataValues.columnCount;
    }

    public int getCurrentStartRow() {
        return this.pagedDataValues.currentStartRow;
    }

    public int getCurrentEndRow() {
        return this.pagedDataValues.currentEndRow;
    }

    public int getCurrentStartCol() {
        return this.pagedDataValues.currentStartCol;
    }

    public int getCurrentEndCol() {
        return this.pagedDataValues.currentEndCol;
    }

    private static class PagedDataValues {
        public Object[] partialData;
        private DataModelHandler dataModelHandler;
        private PeerNode peerNode;
        private int rowCount = 0;
        private int columnCount = 0;
        private int currentStartRow = -1;
        private int currentEndRow = -1;
        private int currentStartCol = -1;
        private int currentEndCol = -1;
        private String propertyKey;
        private PagedDataImpl pagedData;
        private boolean updating;
        private Observer partialUpdateObserver = new Observer(){

            public void handle(Event event) {
                Map data = event.getData();
                if (data.containsKey("type") && data.containsKey("key") && data.get("key").equals(PagedDataValues.this.propertyKey)) {
                    if (data.get("type").equals("partialUpdate")) {
                        int startRow = (int)Math.floor((Double)data.get("startRow"));
                        int endRow = (int)Math.floor((Double)data.get("endRow"));
                        int startCol = (int)Math.floor((Double)data.get("startCol"));
                        int endCol = (int)Math.floor((Double)data.get("endCol"));
                        PagedDataValues.this.updatePartialData(startRow, startCol, endRow, endCol, true);
                    } else if (data.get("type").equals("changeData")) {
                        final int startRow = (int)Math.floor((Double)data.get("startRow"));
                        final int startCol = (int)Math.floor((Double)data.get("startCol"));
                        final Object[] newData = (Object[])data.get("newData");
                        scheduler.schedule(new Runnable(){

                            @Override
                            public void run() {
                                PagedDataValues.this.setDataHelper(startRow, startCol, newData);
                            }
                        }, 0L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        };

        public PagedDataValues(PagedDataImpl pagedData, PeerNode peerNode, String propertyKey, DataModelHandler handler) {
            this.pagedData = pagedData;
            this.peerNode = peerNode;
            this.propertyKey = propertyKey;
            this.setDataModelHandler(handler);
        }

        public void destroy() {
            if (this.peerNode.hasEventListener("peerEvent", this.partialUpdateObserver)) {
                this.peerNode.removeEventListener("peerEvent", this.partialUpdateObserver);
            }
            this.dataModelHandler.destroy();
        }

        public void update() {
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    PagedDataValues.this.updatePartialData(PagedDataValues.this.currentStartRow, PagedDataValues.this.currentStartCol, PagedDataValues.this.currentEndRow, PagedDataValues.this.currentEndCol, true);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDataHelper(int startRow, int startCol, Object[] newData) {
            this.updating = true;
            try {
                if (this.dataModelHandler.is2D()) {
                    int i = 0;
                    int row = startRow;
                    while (i < newData.length) {
                        Object[] rowData = (Object[])newData[i];
                        int j = 0;
                        int col = startCol;
                        while (j < rowData.length) {
                            this.dataModelHandler.setValueAt(rowData[j], row, col);
                            ++j;
                            ++col;
                        }
                        ++i;
                        ++row;
                    }
                } else {
                    int i = 0;
                    int row = startRow;
                    while (i < newData.length) {
                        this.dataModelHandler.setValueAt(newData[i], row);
                        ++i;
                        ++row;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.updating = false;
                this.pagedData.update();
            }
        }

        public PagedDataImpl updatePartialData(int startRow, int startCol, int endRow, int endCol, boolean forceUpdate) {
            if (!forceUpdate && startRow == this.currentStartRow && startCol == this.currentStartCol && endRow == this.currentEndRow && endCol == this.currentEndCol || this.updating) {
                return this.pagedData;
            }
            this.doSelfUpdate(startRow, startCol, endRow, endCol);
            return this.updatePeerNode();
        }

        private PagedDataImpl updatePeerNode() {
            this.pagedData = new PagedDataImpl(this.pagedData);
            this.dataModelHandler.update((ServerPagedData)this.pagedData);
            this.peerNode.setProperty(this.propertyKey, (Object)this.pagedData);
            return this.pagedData;
        }

        private void setDataModelHandler(DataModelHandler handler) {
            this.addPartialUpdateEventListener();
            this.dataModelHandler = handler;
            this.dataModelHandler.update((ServerPagedData)this.pagedData);
            this.doSelfUpdate(this.currentStartRow, this.currentStartCol, this.currentEndRow, this.currentEndCol);
        }

        private void addPartialUpdateEventListener() {
            if (!this.peerNode.hasEventListener("peerEvent", this.partialUpdateObserver)) {
                this.peerNode.addEventListener("peerEvent", this.partialUpdateObserver);
            }
        }

        private void doSelfUpdate(int startRow, int startCol, int endRow, int endCol) {
            if (this.dataModelHandler instanceof DataModelHandler2) {
                DataModelHandler2.PartialData data = ((DataModelHandler2)this.dataModelHandler).getPartialData(startRow, startCol, endRow, endCol);
                this.partialData = data.partialData;
                this.rowCount = data.rowCount;
                this.columnCount = data.columnCount;
                this.currentStartRow = data.startRow;
                this.currentStartCol = data.startCol;
                this.currentEndRow = data.endRow;
                this.currentEndCol = data.endCol;
            } else {
                this.rowCount = this.dataModelHandler.getRowCount();
                this.columnCount = this.dataModelHandler.getColumnCount();
                if (endRow < 0 || endRow > this.rowCount) {
                    endRow = this.rowCount;
                }
                if (endCol < 0 || endCol > this.columnCount) {
                    endCol = this.columnCount;
                }
                this.currentStartRow = startRow;
                this.currentStartCol = startCol;
                this.currentEndRow = endRow;
                this.currentEndCol = endCol;
                if (startRow < 0 || startCol < 0 && this.dataModelHandler.is2D()) {
                    this.partialData = null;
                } else {
                    Object[] newPartialData;
                    if (this.dataModelHandler.is2D()) {
                        newPartialData = new Object[endRow - startRow][endCol - startCol];
                        int i = startRow;
                        int row = 0;
                        while (i < endRow) {
                            int j = startCol;
                            int col = 0;
                            while (j < endCol) {
                                ((Object[])newPartialData[row])[col] = this.dataModelHandler.getValueAt(i, j);
                                ++j;
                                ++col;
                            }
                            ++i;
                            ++row;
                        }
                    } else {
                        newPartialData = new Object[endRow - startRow];
                        int i = startRow;
                        int row = 0;
                        while (i < endRow) {
                            newPartialData[row] = this.dataModelHandler.getValueAt(i);
                            ++i;
                            ++row;
                        }
                    }
                    this.partialData = newPartialData;
                }
            }
        }

        public void setData(int startRow, int startCol, Object[] data) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("type", "changeData");
            eventData.put("key", this.propertyKey);
            eventData.put("startRow", Double.valueOf(startRow));
            eventData.put("startCol", Double.valueOf(startCol));
            eventData.put("newData", data);
            this.peerNode.dispatchEvent("peerEvent", this.peerNode, eventData);
        }
    }
}

