/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.impl;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.PeerNodeSyncable;
import com.mathworks.peermodel.PeerNodeVisitor;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerNodeListener;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.impl.ObservableImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PeerNodeImpl
implements PeerNodeSyncable {
    private static final int NO_INDEX = -99;
    private String id;
    private String type;
    private ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private PeerNodeImpl parent = null;
    private final List<PeerNode> children = new ArrayList<PeerNode>();
    private final List<PeerNode> detached = new ArrayList<PeerNode>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final ObservableImpl observable = new ObservableImpl();
    private Map<String, Map<String, Integer>> versionVectors = null;

    PeerNodeImpl(String type) {
        this(type, null);
    }

    PeerNodeImpl(String type, Map<String, Object> properties) {
        this(null, type, properties);
    }

    PeerNodeImpl(String id, String type, Map<String, Object> properties) {
        if (id == null) {
            id = UUID.randomUUID().toString().substring(0, 8);
        }
        this.id = id;
        this.type = type;
        if (properties != null) {
            this.setProperties(properties);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setProperty(String key, Object value) {
        this.setProperty(key, value, null);
    }

    public void setProperty(String key, Object value, Object originator) {
        if (this.isInvalidValue(value)) {
            throw new IllegalArgumentException("Null, NaN, and Infinite property values are not allowed. Key = " + key + ", " + this.getType());
        }
        Object oldValue = this.setPropertyAndDispatchPropertySetEvent(key, value, originator);
        this.dispatchSinglePropertiesSetEvent(key, oldValue, value, originator);
    }

    private Object setPropertyAndDispatchPropertySetEvent(String key, Object value, Object originator) {
        Object oldValue;
        if (value != null) {
            oldValue = this.properties.put(key, value);
            if (this.propertyChanged(oldValue, value)) {
                this.dispatchPropertySetEvent((PeerNode)this, originator, key, oldValue, value);
            }
        } else {
            oldValue = this.properties.get(key);
        }
        return oldValue;
    }

    private boolean propertyChanged(Object oldValue, Object value) {
        if (oldValue == null) {
            return true;
        }
        if (oldValue.getClass().isArray() && value.getClass().isArray()) {
            return !Arrays.deepEquals(new Object[]{oldValue}, new Object[]{value});
        }
        return !value.equals(oldValue);
    }

    private void dispatchPropertySetEvent(PeerNode node, Object originator, String key, Object oldValue, Object newValue) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("key", key);
        data.put("oldValue", oldValue);
        data.put("newValue", newValue);
        this.observable.dispatchEvent("propertySet", originator, node, data);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public void unsetProperty(String key) {
        this.unsetProperty(key, null);
    }

    public void unsetProperty(String key, Object originator) {
        Object oldValue = this.unsetPropertyAndDispatchPropertyUnsetEvent(key, originator);
        this.dispatchSinglePropertiesUnsetEvent(key, oldValue, originator);
    }

    public void unsetProperties(String[] keys) {
        this.unsetProperties(keys, null);
    }

    public void unsetProperties(String[] keys, Object originator) {
        HashMap propertiesMap = new HashMap();
        propertiesMap.put("oldValues", new HashMap());
        for (String key : keys) {
            Object oldValue = this.unsetPropertyAndDispatchPropertyUnsetEvent(key, originator);
            ((Map)propertiesMap.get("oldValues")).put(key, oldValue);
        }
        this.dispatchPropertiesUnsetEvent((PeerNode)this, originator, propertiesMap);
    }

    private Object unsetPropertyAndDispatchPropertyUnsetEvent(String key, Object originator) {
        Object oldValue = this.properties.remove(key);
        this.dispatchPropertyUnsetEvent((PeerNode)this, originator, key, oldValue);
        return oldValue;
    }

    private void dispatchPropertyUnsetEvent(PeerNode node, Object originator, String key, Object oldValue) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("key", key);
        data.put("oldValue", oldValue);
        this.observable.dispatchEvent("propertyUnset", originator, node, data);
    }

    public void setProperties(Map<String, Object> properties) {
        this.setProperties(properties, null);
    }

    public void setProperties(Map<String, Object> properties, Object originator) {
        for (String key : properties.keySet()) {
            if (!this.isInvalidValue(properties.get(key))) continue;
            throw new IllegalArgumentException("Null, NaN, and Infinite property values are not allowed. Key = " + key + ", " + this.getType());
        }
        HashMap propertiesMap = new HashMap();
        propertiesMap.put("oldValues", new HashMap());
        propertiesMap.put("newValues", new HashMap());
        boolean propertiesChanged = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object newValue;
            String key = entry.getKey();
            Object oldValue = this.setPropertyAndDispatchPropertySetEvent(key, newValue = entry.getValue(), originator);
            if (!this.propertyChanged(oldValue, newValue)) continue;
            propertiesChanged = true;
            ((Map)propertiesMap.get("oldValues")).put(key, oldValue);
            ((Map)propertiesMap.get("newValues")).put(key, newValue);
        }
        if (propertiesChanged) {
            this.dispatchPropertiesSetEvent((PeerNode)this, originator, propertiesMap);
        }
    }

    private boolean isInvalidValue(Object value) {
        return value == null || value instanceof Double && Double.isNaN((Double)value) || value instanceof Double && Double.isInfinite((Double)value) || value instanceof Float && Float.isNaN(((Float)value).floatValue()) || value instanceof Float && Float.isInfinite(((Float)value).floatValue());
    }

    private void dispatchPropertiesSetEvent(PeerNode node, Object originator, Map properties) {
        this.observable.dispatchEvent("propertiesSet", originator, node, properties);
    }

    private void dispatchPropertiesUnsetEvent(PeerNode node, Object originator, Map properties) {
        this.observable.dispatchEvent("propertiesUnset", originator, node, properties);
    }

    private void dispatchSinglePropertiesSetEvent(String key, Object oldValue, Object newValue, Object originator) {
        if (this.propertyChanged(oldValue, newValue)) {
            HashMap<String, Object> oldValuesMap = new HashMap<String, Object>();
            oldValuesMap.put(key, oldValue);
            HashMap<String, Object> newValuesMap = new HashMap<String, Object>();
            newValuesMap.put(key, newValue);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("oldValues", oldValuesMap);
            data.put("newValues", newValuesMap);
            this.observable.dispatchEvent("propertiesSet", originator, (PeerNode)this, data);
        }
    }

    private void dispatchSinglePropertiesUnsetEvent(String key, Object oldValue, Object originator) {
        HashMap<String, Object> oldValuesMap = new HashMap<String, Object>();
        oldValuesMap.put(key, oldValue);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("oldValues", oldValuesMap);
        this.observable.dispatchEvent("propertiesUnset", originator, (PeerNode)this, data);
    }

    public void replaceProperties(Map<String, Object> properties) {
        this.replaceProperties(properties, null);
    }

    public void replaceProperties(Map<String, Object> properties, Object originator) {
        for (Object newValue : properties.values()) {
            if (newValue != null) continue;
            throw new IllegalArgumentException("Null property values are not allowed.");
        }
        Set oldKeys = this.properties.keySet();
        Set<String> newKeys = properties.keySet();
        for (String string : oldKeys) {
            if (newKeys.contains(string)) {
                this.setProperty(string, properties.get(string), originator);
                continue;
            }
            this.unsetProperty(string, originator);
        }
        for (Object object : newKeys) {
            String keyString = object.toString();
            if (this.properties.contains(keyString)) continue;
            this.setProperty(keyString, properties.get(keyString), originator);
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> p = new HashMap<String, Object>(this.properties);
        return Collections.unmodifiableMap(p);
    }

    public PeerNode addChild(String type) {
        return this.addChild(type, null, -99, null);
    }

    public PeerNode addChild(String type, Object originator) {
        return this.addChild(type, null, -99, originator);
    }

    public PeerNode addChild(String type, int index) {
        return this.addChild(type, null, index, null);
    }

    public PeerNode addChild(String type, int index, Object originator) {
        return this.addChild(type, null, index, originator);
    }

    public PeerNode addChild(String type, Map<String, Object> properties) {
        return this.addChild(type, properties, -99, null);
    }

    public PeerNode addChild(String type, Map<String, Object> properties, Object originator) {
        return this.addChild(type, properties, -99, originator);
    }

    public PeerNode addChild(String type, Map<String, Object> properties, int index) {
        return this.addChild(type, properties, index, null);
    }

    public PeerNode addChild(String type, Map<String, Object> properties, int index, Object originator) {
        PeerNodeImpl child = new PeerNodeImpl(type, properties);
        this.addChild((PeerNode)child, index, originator);
        return child;
    }

    public PeerNodeSyncable addChild(String id, String type, Map<String, Object> properties, int index, Object originator) {
        PeerNodeImpl child = new PeerNodeImpl(id, type, properties);
        this.addChild((PeerNode)child, index, originator);
        return child;
    }

    public void addChild(PeerNode child, int index, Object originator) {
        this.addChildNoEvent(child, index);
        this.dispatchChildAddedEvent(child, (PeerNode)this, index, originator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildNoEvent(PeerNode child, int index) {
        this.lockWrites();
        try {
            if (this.hasChild(child)) {
                return;
            }
            if (index != -99 && index < this.children.size()) {
                this.children.add(index, child);
            } else {
                this.children.add(child);
            }
            ((PeerNodeImpl)child).setParent(this);
        }
        finally {
            this.unlockWrites();
        }
    }

    private void dispatchChildAddedEvent(PeerNode child, PeerNode parent, int index, Object originator) {
        int childIndex = index == -99 ? this.children.size() - 1 : index;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("child", child);
        data.put("index", childIndex);
        this.observable.dispatchEvent("childAdded", originator, parent, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChild(PeerNode childNode) {
        this.lockReads();
        try {
            boolean bl = this.children.contains(childNode);
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChild(String childId) {
        this.lockReads();
        try {
            for (PeerNode child : this.children) {
                if (!child.getId().equals(childId)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNode getChild(int index) {
        this.lockReads();
        try {
            PeerNode peerNode = this.children.get(index);
            return peerNode;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNode getChild(String childId) {
        this.lockReads();
        try {
            for (PeerNode child : this.children) {
                if (!child.getId().equals(childId)) continue;
                PeerNode peerNode = child;
                return peerNode;
            }
            PeerNode peerNode = null;
            return peerNode;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        this.lockReads();
        try {
            boolean bl = this.children.size() != 0;
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerNode> getChildren() {
        this.lockReads();
        try {
            ArrayList<PeerNode> c = new ArrayList<PeerNode>(this.children);
            List<PeerNode> list = Collections.unmodifiableList(c);
            return list;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfChildren() {
        this.lockReads();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDetachedChildren() {
        this.lockReads();
        try {
            boolean bl = !this.detached.isEmpty();
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerNode> getDetachedChildren() {
        this.lockReads();
        try {
            ArrayList<PeerNode> c = new ArrayList<PeerNode>(this.detached);
            List<PeerNode> list = Collections.unmodifiableList(c);
            return list;
        }
        finally {
            this.unlockReads();
        }
    }

    public void detach() {
        this.detach(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object originator) {
        EventImpl removedEvent = null;
        EventImpl detachedEvent = null;
        this.lockWrites();
        try {
            if (!this.isDetached()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("child", this);
                data.put("index", this.getParent().getChildIndex((PeerNode)this));
                removedEvent = new EventImpl("childRemoved", originator, this.getParent(), data);
                detachedEvent = new EventImpl("childDetached", originator, this.getParent(), data);
                ((PeerNodeImpl)this.getParent()).detachChild(this);
            }
        }
        finally {
            this.unlockWrites();
        }
        if (removedEvent != null) {
            removedEvent.getTarget().dispatchEvent(removedEvent);
            detachedEvent.getTarget().dispatchEvent(detachedEvent);
        }
    }

    private void detachChild(PeerNodeImpl peerNode) {
        this.removeChild((PeerNode)peerNode);
        this.detached.add((PeerNode)peerNode);
    }

    public void reattach() {
        this.reattach(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reattach(Object originator) {
        this.lockWrites();
        try {
            if (this.hasParent()) {
                this.reattach(this.getParent().getNumberOfChildren(), originator);
            }
        }
        finally {
            this.unlockWrites();
        }
    }

    public void reattach(int index) {
        this.reattach(index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reattach(int index, Object originator) {
        EventImpl event = null;
        this.lockWrites();
        try {
            if (this.isDetached()) {
                ((PeerNodeImpl)this.getParent()).reattachChild(this, index);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("child", this);
                data.put("index", this.getParent().getChildIndex((PeerNode)this));
                event = new EventImpl("childReattached", originator, this.getParent(), data);
            }
        }
        finally {
            this.unlockWrites();
        }
        if (event != null) {
            event.getTarget().dispatchEvent(event);
        }
    }

    private void reattachChild(PeerNodeImpl peerNode, int index) {
        this.detached.remove(peerNode);
        this.addChildNoEvent((PeerNode)peerNode, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetached() {
        this.lockReads();
        try {
            boolean bl = this.hasParent() && this.getParent().getDetachedChildren().contains(this);
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAncestorDetached() {
        this.lockReads();
        try {
            boolean bl = this.hasParent() && (this.getParent().isDetached() || this.getParent().isAncestorDetached());
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    public boolean hasDescendant(final String id) {
        return this.accept(new PeerNodeVisitor.Cancellable(){

            public boolean visit(PeerNode node) {
                return node.getId().equals(id) && node != PeerNodeImpl.this;
            }
        });
    }

    public PeerNode getDescendant(final String id) {
        final PeerNode[] descendant = new PeerNode[]{null};
        this.accept(new PeerNodeVisitor.Cancellable(){

            public boolean visit(PeerNode node) {
                if (node.getId().equals(id) && node != PeerNodeImpl.this) {
                    descendant[0] = node;
                    return true;
                }
                return false;
            }
        });
        if (descendant[0] != null) {
            return descendant[0];
        }
        throw new IllegalArgumentException("No descendant found with id: " + id);
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(Object originator) {
        if (this.hasParent()) {
            this.dispatchSubTreeDestroyedEvent((PeerNode)this, originator);
        }
        LinkedList<Event> events = new LinkedList<Event>();
        this.destroyNodesRecursive(events, originator);
        while (!events.isEmpty()) {
            Event event = (Event)events.poll();
            event.getTarget().dispatchEvent(event);
        }
    }

    public void remove() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyNodesRecursive(Queue<Event> events, Object originator) {
        List<PeerNodeImpl> lockedNodes = this.lockTree();
        try {
            this.removeChildren(events, originator);
            if (this.hasParent()) {
                int index = this.parent.getChildIndex((PeerNode)this);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("child", this);
                data.put("index", index);
                events.add(new EventImpl("childRemoved", originator, (PeerNode)this.parent, data));
                events.add(new EventImpl("childDestroyed", originator, (PeerNode)this.parent, data));
                this.parent.removeChild((PeerNode)this);
                this.setParent(null);
            }
            events.add(new EventImpl("destroyed", originator, (PeerNode)this, new HashMap<String, Object>()));
        }
        finally {
            this.unlockTree(lockedNodes);
        }
    }

    private void removeChildren(Queue<Event> events, Object originator) {
        Vector<PeerNode> copy = new Vector<PeerNode>(this.children);
        for (PeerNode child : copy) {
            ((PeerNodeImpl)child).destroyNodesRecursive(events, originator);
            this.children.remove(child);
        }
        copy = new Vector<PeerNode>(this.detached);
        for (PeerNode child : copy) {
            ((PeerNodeImpl)child).destroyNodesRecursive(events, originator);
            this.detached.remove(child);
        }
    }

    void removeChild(PeerNode child) {
        this.children.remove(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchSubTreeDestroyedEvent(PeerNode node, Object originator) {
        this.lockReads();
        HashMap<String, Object> data = null;
        PeerNodeImpl eventParent = null;
        try {
            if (this.parent != null) {
                eventParent = this.parent;
                data = new HashMap<String, Object>();
                data.put("child", node);
                data.put("index", this.parent.getChildIndex((PeerNode)this));
            }
        }
        finally {
            this.unlockReads();
        }
        if (data != null) {
            this.dispatchEvent("subTreeDestroyed", originator, (PeerNode)eventParent, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParent(PeerNodeImpl parent) {
        this.lockWrites();
        try {
            this.parent = parent;
        }
        finally {
            this.unlockWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasParent() {
        this.lockReads();
        try {
            boolean bl = this.parent != null;
            return bl;
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PeerNode getParent() {
        this.lockReads();
        try {
            PeerNodeImpl peerNodeImpl = this.parent;
            return peerNodeImpl;
        }
        finally {
            this.unlockReads();
        }
    }

    public PeerNode getRoot() {
        PeerNodeImpl root = this;
        while (root.hasParent()) {
            root = root.getParent();
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildIndex(PeerNode child) {
        this.lockReads();
        try {
            int n = this.children.indexOf(child);
            return n;
        }
        finally {
            this.unlockReads();
        }
    }

    public void addPeerEventListener(String type, Observer observer) {
        this.observable.addPeerEventListener(type, observer);
    }

    public void removePeerEventListener(String type, Observer observer) {
        this.observable.removePeerEventListener(type, observer);
    }

    public boolean hasPeerEventListener(String type, Observer observer) {
        return this.observable.hasPeerEventListener(type, observer);
    }

    public void dispatchPeerEvent(String type, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchPeerEvent(type, target, data);
    }

    public void dispatchPeerEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchPeerEvent(type, originator, target, data);
    }

    public void addPeerNodeListener(PeerNodeListener listener) {
        this.observable.addPeerNodeListener(listener);
    }

    public void removePeerNodeListener(PeerNodeListener listener) {
        this.observable.removePeerNodeListener(listener);
    }

    public void addEventListener(String type, Observer observer) {
        this.observable.addEventListener(type, observer);
    }

    public void addSyncEventListener(String type, Observer observer) {
        this.observable.addSyncEventListener(type, observer);
    }

    public void removeEventListener(String type, Observer observer) {
        this.observable.removeEventListener(type, observer);
    }

    public void removeSyncEventListener(String type, Observer observer) {
        this.observable.removeSyncEventListener(type, observer);
    }

    public boolean hasEventListener(String type, Observer observer) {
        return this.observable.hasEventListener(type, observer);
    }

    public void dispatchEvent(String type, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchEvent(type, target, data);
    }

    public void dispatchEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchEvent(type, originator, target, data);
    }

    public void dispatchEvent(Event event) {
        this.observable.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(PeerNodeVisitor visitor) {
        this.lockReads();
        try {
            visitor.visit((PeerNode)this);
            for (PeerNode child : this.children) {
                child.accept(visitor);
            }
            for (PeerNode child : this.detached) {
                child.accept(visitor);
            }
        }
        finally {
            this.unlockReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(PeerNodeVisitor.Cancellable visitor) {
        this.lockReads();
        try {
            if (visitor.visit((PeerNode)this)) {
                boolean bl = true;
                return bl;
            }
            for (PeerNode child : this.children) {
                if (!child.accept(visitor)) continue;
                boolean bl = true;
                return bl;
            }
            for (PeerNode child : this.detached) {
                if (!child.accept(visitor)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unlockReads();
        }
        return false;
    }

    public Map<String, Integer> getVersionVector(String property) {
        if (this.versionVectors != null && this.versionVectors.containsKey(property)) {
            return new HashMap<String, Integer>(this.versionVectors.get(property));
        }
        return null;
    }

    public Map<String, Map<String, Integer>> getVersionVectors() {
        if (this.versionVectors != null) {
            HashMap<String, Map<String, Integer>> v = new HashMap<String, Map<String, Integer>>(this.versionVectors);
            return Collections.unmodifiableMap(v);
        }
        return null;
    }

    public void incrementVersionVector(String property, String clientId, Collection<String> allPeers) {
        Map<String, Integer> versionVector;
        Integer current = (versionVector = this.getOrCreateVersionVector(property)).get(clientId);
        versionVector.put(clientId, current == null ? 1 : current + 1);
        for (String peer : allPeers) {
            if (versionVector.containsKey(peer)) continue;
            versionVector.put(peer, 1);
        }
    }

    public void mergeVersionVectors(String property, Map<String, ?> otherVersionVector) {
        if (otherVersionVector != null) {
            Map<String, Integer> versionVector = this.getOrCreateVersionVector(property);
            for (Map.Entry<String, ?> entry : otherVersionVector.entrySet()) {
                int value;
                if (entry.getValue() == null) continue;
                String clientId = entry.getKey();
                int n = value = entry.getValue() instanceof Double ? (int)((Double)entry.getValue()).doubleValue() : (Integer)entry.getValue();
                if (versionVector.containsKey(clientId)) {
                    versionVector.put(clientId, Math.max(value, versionVector.get(clientId)));
                    continue;
                }
                versionVector.put(clientId, value);
            }
        }
    }

    private Map<String, Integer> getOrCreateVersionVector(String property) {
        if (this.versionVectors == null) {
            this.versionVectors = new HashMap<String, Map<String, Integer>>();
        }
        if (!this.versionVectors.containsKey(property)) {
            this.versionVectors.put(property, new HashMap());
        }
        return this.versionVectors.get(property);
    }

    private List<PeerNodeImpl> lockTree() {
        ArrayList<PeerNodeImpl> lockedNodes = new ArrayList<PeerNodeImpl>(10);
        if (this.hasParent()) {
            this.parent.lockWrites();
            lockedNodes.add(this.parent);
        }
        this.lockWrites();
        lockedNodes.add(this);
        this.lockChildren(lockedNodes);
        return lockedNodes;
    }

    private void unlockTree(List<PeerNodeImpl> lockedNodes) {
        for (int i = lockedNodes.size() - 1; i >= 0; --i) {
            lockedNodes.get(i).unlockWrites();
        }
    }

    private void lockChildren(List<PeerNodeImpl> lockedNodes) {
        for (PeerNode child : this.children) {
            ((PeerNodeImpl)child).lockWrites();
            ((PeerNodeImpl)child).lockChildren(lockedNodes);
            lockedNodes.add((PeerNodeImpl)child);
        }
        for (PeerNode child : this.detached) {
            ((PeerNodeImpl)child).lockWrites();
            ((PeerNodeImpl)child).lockChildren(lockedNodes);
            lockedNodes.add((PeerNodeImpl)child);
        }
    }

    private void lockWrites() {
        boolean locked = false;
        while (!locked) {
            try {
                locked = this.writeLock.tryLock(20L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void unlockWrites() {
        this.writeLock.unlock();
    }

    private void lockReads() {
        boolean locked = false;
        while (!locked) {
            try {
                locked = this.readLock.tryLock(20L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void unlockReads() {
        this.readLock.unlock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeerNodeImpl)) {
            return false;
        }
        PeerNodeImpl peerNode = (PeerNodeImpl)o;
        if (!this.children.equals(peerNode.children)) {
            return false;
        }
        if (!this.detached.equals(peerNode.detached)) {
            return false;
        }
        if (!this.id.equals(peerNode.id)) {
            return false;
        }
        if (this.parent != null ? !this.parent.getId().equals(peerNode.getParent().getId()) : peerNode.parent != null) {
            return false;
        }
        if (!this.properties.equals(peerNode.properties)) {
            return false;
        }
        return this.type.equals(peerNode.type);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        sb.append("PeerNodeImpl");
        sb.append("{id='").append(this.id).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append(", parent=").append(this.parent == null ? "null" : this.parent.getId());
        sb.append(", children=[");
        for (PeerNode child : this.children) {
            sb.append("\n");
            if (child instanceof PeerNodeImpl) {
                PeerNodeImpl peerNode = (PeerNodeImpl)child;
                sb.append(peerNode.toString(depth + 1));
                continue;
            }
            sb.append(child);
        }
        sb.append("]}");
        return sb.toString();
    }
}

