/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.propertyeditors;

import com.mathworks.jmi.Callback;
import com.mathworks.mlwidgets.graphics.ColorPicker;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.shared.controllib.messagesystem.MatlabXMLMessageSystem;
import com.mathworks.toolbox.shared.controllib.propertyeditors.LineStyleComboBox;
import com.mathworks.toolbox.shared.controllib.propertyeditors.MarkerStyleComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class WaveformEditorPanel
extends MJPanel {
    private static final long serialVersionUID = 24362462L;
    public WaveformStyleData fWaveFormStyleData;
    private MJTextField fNameEditField;
    private TextEditHandler fNameCallbackListener;
    private ColorPicker fLineColorPicker;
    private ColorPickerHandler fLineColorPickerCallbackListener;
    private LineStyleComboBox fLineStyleCombo;
    private LineStyleHandler fLineStyleCallbackListener;
    private MJComboBox fLineWidthCombo;
    private LineWidthHandler fLineWidthCallbackListener;
    private MarkerStyleComboBox fMarkerStyleCombo;
    private MarkerStyleHandler fMarkerStyleCallbackListener;

    public WaveformEditorPanel() {
        this.createWidgets();
    }

    public void createWidgets() {
        ResourceBundle resourceBundle = MatlabXMLMessageSystem.getBundle("Controllib:plots");
        MJLabel mJLabel = new MJLabel(resourceBundle.getString("strDisplayName") + ":");
        this.fNameEditField = new MJTextField(24);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FlowLayout(0));
        mJPanel.add((Component)mJLabel);
        mJPanel.add((Component)this.fNameEditField);
        MJLabel mJLabel2 = new MJLabel(resourceBundle.getString("strLine") + ":");
        this.fLineColorPicker = new ColorPicker(ColorPicker.NO_OPTIONS, ColorPicker.LINE_ICON, "Color");
        this.fLineStyleCombo = new LineStyleComboBox();
        this.fLineStyleCombo.setSize(80, 100);
        this.fLineWidthCombo = this.createLineWidthComboBox();
        this.fLineWidthCombo.setSize(80, 100);
        this.fMarkerStyleCombo = new MarkerStyleComboBox();
        this.fLineWidthCombo.setSize(80, 100);
        MJLabel mJLabel3 = new MJLabel(resourceBundle.getString("strMarker") + ":");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        this.protectSizeFromGridBag((JComponent)((Object)this.fLineStyleCombo));
        this.protectSizeFromGridBag((JComponent)this.fLineWidthCombo);
        this.protectSizeFromGridBag((JComponent)((Object)this.fMarkerStyleCombo));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mJPanel2.add((Component)mJLabel2, (Object)gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        mJPanel2.add((Component)((Object)this.fLineStyleCombo), (Object)gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        mJPanel2.add((Component)this.fLineWidthCombo, (Object)gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        mJPanel2.add((Component)this.fLineColorPicker, (Object)gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mJPanel2.add((Component)mJLabel3, (Object)gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        mJPanel2.add((Component)((Object)this.fMarkerStyleCombo), (Object)gridBagConstraints);
        mJPanel2.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 3, 1, 3)));
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)mJPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)mJPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new MJPanel(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)new MJPanel(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new MJPanel(), gridBagConstraints);
    }

    public MJComboBox createLineWidthComboBox() {
        Object[] objectArray = new String[]{"0.5", "1.0", "2.0", "3.0", "4.0", "6.0", "8.0", "10.0", "15.0", "20.0", "25.0", "30.0"};
        MJComboBox mJComboBox = new MJComboBox(objectArray);
        mJComboBox.setEditable(new Boolean("true").booleanValue());
        return mJComboBox;
    }

    public void setNameData(String string) {
        this.fNameEditField.setText(string);
    }

    public String GetNameData() {
        return this.fNameEditField.getText();
    }

    public void setLineColorData(Color color) {
        this.fLineColorPicker.setValue((Object)color);
    }

    public void setLineStyleData(String string) {
        this.fLineStyleCombo.setLineStyleData(string);
    }

    public String getLineStyleData() {
        return this.fLineStyleCombo.getLineStyleData();
    }

    public void setLineWidthData(String string) {
        this.fLineWidthCombo.setSelectedItem((Object)string);
    }

    public String getLineWidthData() {
        return (String)this.fLineWidthCombo.getSelectedItem();
    }

    public void setMarkerStyleData(String string) {
        this.fMarkerStyleCombo.setMarkerStyleData(string);
    }

    public String getMarkerStyleData() {
        return this.fMarkerStyleCombo.getMarkerStyleData();
    }

    public void createNameListener(Callback callback) {
        this.fNameCallbackListener = new TextEditHandler(callback);
        this.fNameEditField.addActionListener((ActionListener)this.fNameCallbackListener);
    }

    public void disableNameListener() {
        this.fNameEditField.removeActionListener((ActionListener)this.fNameCallbackListener);
    }

    public void restoreNameListener() {
        this.fNameEditField.addActionListener((ActionListener)this.fNameCallbackListener);
    }

    public void createLineColorListener(Callback callback) {
        this.fLineColorPickerCallbackListener = new ColorPickerHandler(callback);
        this.fLineColorPicker.addActionListener((ActionListener)this.fLineColorPickerCallbackListener);
    }

    public void disableLineColorListener() {
        this.fLineColorPicker.removeActionListener((ActionListener)this.fLineColorPickerCallbackListener);
    }

    public void restoreLineColorListener() {
        this.fLineColorPicker.addActionListener((ActionListener)this.fLineColorPickerCallbackListener);
    }

    public void createLineStyleListener(Callback callback) {
        this.fLineStyleCallbackListener = new LineStyleHandler(callback);
        this.fLineStyleCombo.fLineStyleList.addActionListener((ActionListener)this.fLineStyleCallbackListener);
    }

    public void disableLineStyleListener() {
        this.fLineStyleCombo.fLineStyleList.removeActionListener((ActionListener)this.fLineStyleCallbackListener);
    }

    public void restoreLineStyleListener() {
        this.fLineStyleCombo.fLineStyleList.addActionListener((ActionListener)this.fLineStyleCallbackListener);
    }

    public void createLineWidthListener(Callback callback) {
        this.fLineWidthCallbackListener = new LineWidthHandler(callback);
        this.fLineWidthCombo.addActionListener((ActionListener)this.fLineWidthCallbackListener);
    }

    public void disableLineWidthListener() {
        this.fLineWidthCombo.removeActionListener((ActionListener)this.fLineWidthCallbackListener);
    }

    public void restoreLineWidthListener() {
        this.fLineWidthCombo.addActionListener((ActionListener)this.fLineWidthCallbackListener);
    }

    public void createMarkerStyleListener(Callback callback) {
        this.fMarkerStyleCallbackListener = new MarkerStyleHandler(callback);
        this.fMarkerStyleCombo.fMarkerStyleList.addActionListener((ActionListener)this.fMarkerStyleCallbackListener);
    }

    public void disableMarkerStyleListener() {
        this.fMarkerStyleCombo.fMarkerStyleList.removeActionListener((ActionListener)this.fMarkerStyleCallbackListener);
    }

    public void restoreMarkerStyleListener() {
        this.fMarkerStyleCombo.fMarkerStyleList.addActionListener((ActionListener)this.fMarkerStyleCallbackListener);
    }

    public MJTextField qeGetNameEditField() {
        return this.fNameEditField;
    }

    public ColorPicker qeGetLineColorPicker() {
        return this.fLineColorPicker;
    }

    public LineStyleComboBox qeGetLineStyleCombo() {
        return this.fLineStyleCombo;
    }

    public MJComboBox qeGetLineWidthCombo() {
        return this.fLineWidthCombo;
    }

    public MarkerStyleComboBox qeGetfMarkerStyleCombo() {
        return this.fMarkerStyleCombo;
    }

    protected void protectSizeFromGridBag(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public static void main(String[] stringArray) {
        String string;
        try {
            string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = new MJFrame("Unit Test: WaveformPanel");
        string.setContentPane((Container)((Object)new WaveformEditorPanel()));
        string.setBounds(100, 100, 588, 462);
        string.setVisible(true);
        string.setDefaultCloseOperation(2);
        string.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public class WaveformStyleData {
        public Object fLineColor;
        public String fLineStyle;
        public String fLineWidth;
        public String fMakerStyle;
    }

    public class MarkerStyleHandler
    implements ActionListener {
        private Callback MarkerStyleHandlerCallback;

        public MarkerStyleHandler(Callback callback) {
            this.MarkerStyleHandlerCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.MarkerStyleHandlerCallback.postCallback(new Object[]{WaveformEditorPanel.this.fMarkerStyleCombo.getMarkerStyleData()});
        }
    }

    public class LineWidthHandler
    implements ActionListener {
        private Callback LineWidthHandlerCallback;

        public LineWidthHandler(Callback callback) {
            this.LineWidthHandlerCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.LineWidthHandlerCallback.postCallback(new Object[]{WaveformEditorPanel.this.fLineWidthCombo.getSelectedItem()});
        }
    }

    public class LineStyleHandler
    implements ActionListener {
        private Callback LineStyleHandlerCallback;

        public LineStyleHandler(Callback callback) {
            this.LineStyleHandlerCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.LineStyleHandlerCallback.postCallback(new Object[]{WaveformEditorPanel.this.fLineStyleCombo.getLineStyleData()});
        }
    }

    public class ColorPickerHandler
    implements ActionListener {
        private Callback ColorPickerHandlerCallback;

        public ColorPickerHandler(Callback callback) {
            this.ColorPickerHandlerCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
            this.ColorPickerHandlerCallback.postCallback(new Object[]{colorPicker.getValue()});
        }
    }

    public class TextEditHandler
    implements ActionListener {
        private Callback TextEditHandlerCallback;

        public TextEditHandler(Callback callback) {
            this.TextEditHandlerCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJTextField mJTextField = (MJTextField)actionEvent.getSource();
            this.TextEditHandlerCallback.postCallback(new Object[]{mJTextField.getText()});
        }
    }
}

