/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.guide;

import com.mathworks.toolbox.shared.controllib.guide.AbstractHMITableModel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Vector;

public class LampTableModel
extends AbstractHMITableModel {
    private final Vector<Boolean> fSelections = new Vector();
    private final Vector<Color> fColors = new Vector();
    private final Vector<String> fStates = new Vector();
    private static final long serialVersionUID = 1L;

    public LampTableModel(String[] stringArray, int n) {
        super(stringArray);
        this.setRowCount(n);
    }

    @Override
    public int getRowCount() {
        return this.fColors.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        if (n == 0) {
            clazz = Boolean.class;
        } else if (n == 1) {
            clazz = Color.class;
        } else if (n == 2) {
            clazz = String.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n2 == 0) {
            object = this.fSelections.get(n);
        } else if (n2 == 1) {
            object = this.fColors.get(n);
        } else if (n2 == 2) {
            object = this.fStates.get(n);
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.setDefaultRow(n);
        } else if (n2 == 1) {
            this.fColors.set(n, (Color)object);
        } else if (n2 == 2) {
            this.fStates.set(n, (String)object);
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public void setRowCount(int n) {
        int n2 = this.getRowCount();
        if (n2 == n) {
            return;
        }
        this.fSelections.setSize(n);
        this.fColors.setSize(n);
        this.fStates.setSize(n);
        if (n <= n2) {
            this.fireTableRowsDeleted(n, n2 - 1);
        } else {
            this.fireTableRowsInserted(n2, n - 1);
        }
    }

    public int getDefaultRow() {
        return this.fSelections.indexOf(Boolean.TRUE);
    }

    public void setDefaultRow(int n) {
        int n2 = this.getDefaultRow();
        if (n2 == n) {
            return;
        }
        for (int i = 0; i < this.fSelections.size(); ++i) {
            this.fSelections.set(i, Boolean.FALSE);
        }
        if (n > -1) {
            this.fSelections.set(n, Boolean.TRUE);
        }
        this.fireTableRowsUpdated(0, this.fSelections.size() - 1);
    }

    public Boolean[] getSelections() {
        Boolean[] booleanArray = new Boolean[this.fSelections.size()];
        return this.fSelections.toArray(booleanArray);
    }

    public void setSelections(Boolean[] booleanArray) {
        this.fSelections.clear();
        this.fSelections.addAll(Arrays.asList(booleanArray));
        this.fireTableRowsUpdated(0, this.fSelections.size() - 1);
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.fColors.size()];
        return this.fColors.toArray(colorArray);
    }

    public void setColors(Color[] colorArray) {
        this.fColors.clear();
        this.fColors.addAll(Arrays.asList(colorArray));
        this.fireTableRowsUpdated(0, this.fColors.size() - 1);
    }

    public String[] getStates() {
        String[] stringArray = new String[this.fStates.size()];
        return this.fStates.toArray(stringArray);
    }

    public void setStates(String[] stringArray) {
        this.fStates.clear();
        this.fStates.addAll(Arrays.asList(stringArray));
        this.fireTableRowsUpdated(0, this.fStates.size() - 1);
    }
}

