/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.toolbox.shared.controllib.databrowser.TCWorkspaceTable;
import com.mathworks.widgets.recordlist.DefaultSelectionPopupMenu;
import com.mathworks.widgets.recordlist.IActionProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SelectionPopupMenu
extends DefaultSelectionPopupMenu
implements PopupMenuListener {
    private static final long serialVersionUID = 558143911888307214L;
    private SharedActionListener fSharedActionListener;
    private Callback fMenuItemSelection = new Callback();
    private Callback fMenuWillBecomeVisible = new Callback();
    private TCWorkspaceTable fTCWorkspaceTable;
    private Vector<JMenuItem> fStaticMenuItems;
    private Vector<JMenuItem> fDynamicMenuItems;
    private JSeparator fTopSeparator;
    private JSeparator fButtomSeparator;

    public SelectionPopupMenu(TCWorkspaceTable tCWorkspaceTable) {
        super((IActionProvider)tCWorkspaceTable.getWSTable());
        this.fixInheritedMenus();
        this.addPopupMenuListener(this);
        this.fSharedActionListener = new SharedActionListener();
        this.fTCWorkspaceTable = tCWorkspaceTable;
        this.fStaticMenuItems = new Vector();
        this.fDynamicMenuItems = new Vector();
        this.fButtomSeparator = new JSeparator();
        this.fTopSeparator = new JSeparator();
    }

    private void fixInheritedMenus() {
        int n;
        for (n = 0; n < this.getComponentCount(); ++n) {
            if (!(this.getComponent(n) instanceof JMenuItem)) continue;
            try {
                if (!this.getComponent(n).getName().equals("RecordDeletionMenuItem")) continue;
                ((JMenuItem)this.getComponent(n)).setText(XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("ClearText"));
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            if (!(this.getComponent(n) instanceof JMenuItem)) continue;
            try {
                if (!this.getComponent(n).getName().equals("RecordDuplicationMenuItem")) continue;
                this.remove(this.getComponent(n));
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void addMenuItem(String string, String string2, boolean bl, int n) {
        CustomMenuItem customMenuItem = new CustomMenuItem();
        customMenuItem.setName(string2);
        customMenuItem.setActionCommand(customMenuItem.getName());
        customMenuItem.setText(string);
        customMenuItem.setMultiSelection(bl);
        customMenuItem.addActionListener(this.fSharedActionListener);
        if (n == -1) {
            this.add((JMenuItem)((Object)customMenuItem));
        } else {
            this.insert((Component)((Object)customMenuItem), n);
        }
        this.fStaticMenuItems.add((JMenuItem)((Object)customMenuItem));
    }

    public void removeMenuItem(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            try {
                if (!component.getName().equals(string)) continue;
                ((JMenuItem)component).removeActionListener(this.fSharedActionListener);
                this.remove(component);
                if (this.fStaticMenuItems.indexOf(component) == -1) break;
                this.fStaticMenuItems.remove(component);
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void addSeparator(int n) {
        this.insert(new JPopupMenu.Separator(), n);
    }

    public void addFullSeparator() {
        this.add(new JSeparator());
    }

    public void addFullSeparator(int n) {
        this.insert(new JSeparator(), n);
    }

    public void addDynamicMenuItem(String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        for (int i = 0; i < stringArray.length; ++i) {
            CustomMenuItem customMenuItem = new CustomMenuItem();
            customMenuItem.setText(stringArray[i]);
            customMenuItem.setActionCommand(stringArray2[i]);
            customMenuItem.setName(stringArray2[i]);
            customMenuItem.setMultiSelection(bl);
            customMenuItem.addActionListener(this.fSharedActionListener);
            this.fDynamicMenuItems.add((JMenuItem)((Object)customMenuItem));
            if (!bl2) {
                if (this.getComponentZOrder(this.fButtomSeparator) == -1) {
                    this.add(this.fButtomSeparator);
                }
                this.add((JMenuItem)((Object)customMenuItem));
                continue;
            }
            if (this.getComponentZOrder(this.fTopSeparator) == -1) {
                this.insert(this.fTopSeparator, 0);
            }
            this.insert((Component)((Object)customMenuItem), 0);
        }
    }

    public Callback getMenuItemSelectionEventSource() {
        return this.fMenuItemSelection;
    }

    public Callback getMenuWillBecomeVisibleEventSource() {
        return this.fMenuWillBecomeVisible;
    }

    private void notifyMATLABAboutMenuItemSelection(String string) {
        this.fMenuItemSelection.postCallback(new Object[]{string, this.getVariables()});
    }

    private void notifyMATLABAboutMenuWillBecomeVisible(Component component, int n, int n2) {
        int[] nArray = this.fTCWorkspaceTable.getWSTable().getSelectedRows();
        String[] stringArray = this.fTCWorkspaceTable.getVariableNamesFromViewIndices(nArray);
        this.fMenuWillBecomeVisible.postCallback(new Object[]{stringArray, component, n, n2});
    }

    public void resetStaticMenuItems() {
        for (JMenuItem jMenuItem : this.fStaticMenuItems) {
            jMenuItem.removeActionListener(this.fSharedActionListener);
            this.remove(jMenuItem);
        }
        this.fStaticMenuItems.removeAllElements();
    }

    public void resetDynamicMenuItems() {
        for (JMenuItem jMenuItem : this.fDynamicMenuItems) {
            jMenuItem.removeActionListener(this.fSharedActionListener);
            this.remove(jMenuItem);
        }
        this.fDynamicMenuItems.removeAllElements();
        this.remove(this.fButtomSeparator);
        this.remove(this.fTopSeparator);
    }

    public void reset() {
        this.resetDynamicMenuItems();
        this.resetStaticMenuItems();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        boolean bl = this.getVariables().length > 1;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            CustomMenuItem customMenuItem;
            if (!(this.getComponent(i) instanceof CustomMenuItem)) continue;
            customMenuItem.setEnabled((customMenuItem = (CustomMenuItem)((Object)this.getComponent(i))).isMultiSelection() || !customMenuItem.isMultiSelection() && !bl);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectionPopupMenu.this.resetDynamicMenuItems();
            }
        });
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void show(Component component, int n, int n2) {
        this.notifyMATLABAboutMenuWillBecomeVisible(component, n, n2);
    }

    public void delayedShow(Component component, int n, int n2) {
        super.show(component, n, n2);
    }

    private String[] getVariables() {
        int[] nArray = this.fTCWorkspaceTable.getWSTable().getSelectedRows();
        String[] stringArray = this.fTCWorkspaceTable.getVariableNamesFromViewIndices(nArray);
        return stringArray;
    }

    public void cleanup() {
        this.removeAll();
        this.fSharedActionListener = null;
        this.fTCWorkspaceTable = null;
        this.fDynamicMenuItems = null;
        this.fStaticMenuItems = null;
        this.reset();
    }

    private class CustomMenuItem
    extends MJMenuItem {
        private static final long serialVersionUID = 7914949595788353597L;
        private boolean fMultiSelection;

        private CustomMenuItem() {
        }

        public void setMultiSelection(boolean bl) {
            this.fMultiSelection = bl;
        }

        public boolean isMultiSelection() {
            return this.fMultiSelection;
        }
    }

    private class SharedActionListener
    implements ActionListener {
        private SharedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectionPopupMenu.this.notifyMATLABAboutMenuItemSelection(actionEvent.getActionCommand());
        }
    }
}

