/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.JAXPXPathStaticContext;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.xml.sax.InputSource;

public class XPathEvaluator
implements XPath {
    private Configuration config;
    private NodeInfo contextNode = null;
    private JAXPXPathStaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration config) {
        this.config = config;
        this.staticContext = new JAXPXPathStaticContext(config);
    }

    public XPathEvaluator(Source source) throws XPathException {
        this.config = source instanceof NodeInfo ? ((NodeInfo)source).getDocumentRoot().getConfiguration() : new Configuration();
        this.staticContext = new JAXPXPathStaticContext(this.config);
        this.setSource(source);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setStripSpace(boolean strip) {
        this.stripSpace = strip;
    }

    public NodeInfo setSource(Source source) throws XPathException {
        if (this.stripSpace) {
            AugmentedSource as = AugmentedSource.makeAugmentedSource((Source)source);
            as.setStripSpace(2);
            source = as;
        } else if (source instanceof NodeInfo) {
            NodeInfo origin = (NodeInfo)source;
            if (!origin.getConfiguration().isCompatible(this.config)) {
                throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
            }
            return (NodeInfo)source;
        }
        return this.config.buildDocument(source);
    }

    public void setStaticContext(JAXPXPathStaticContext context) {
        if (!this.config.isCompatible(context.getConfiguration())) {
            throw new IllegalArgumentException("Supplied static context uses a different and incompatible Configuration");
        }
        this.staticContext = context;
    }

    public JAXPXPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public Executable getExecutable() {
        return this.staticContext.getExecutable();
    }

    public XPathExpressionImpl createExpression(String expression) throws XPathException {
        return this.createExpressionInternal(expression);
    }

    private XPathExpressionImpl createExpressionInternal(String expression) throws XPathException {
        Expression exp = ExpressionTool.make((String)expression, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1, (boolean)false);
        ExpressionVisitor visitor = ExpressionVisitor.make((StaticContext)this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)exp, (int)0, (SlotManager)map);
        exp.setContainer((Container)this.staticContext);
        XPathExpressionImpl xpe = new XPathExpressionImpl(exp, this.getExecutable());
        xpe.setStackFrameMap(map);
        if (this.contextNode != null) {
            xpe.privatelySetContextNode(this.contextNode);
        }
        return xpe;
    }

    public void setContextNode(NodeInfo node) {
        if (!node.getConfiguration().isCompatible(this.config)) {
            throw new IllegalArgumentException("Supplied node must be built using the same or a compatible Configuration");
        }
        this.contextNode = node;
    }

    public List evaluate(String expression) throws XPathException {
        Expression exp = ExpressionTool.make((String)expression, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1, (boolean)false);
        ExpressionVisitor visitor = ExpressionVisitor.make((StaticContext)this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)exp, (int)0, (SlotManager)map);
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.staticContext.getExecutable());
        context.openStackFrame(map);
        SequenceIterator iterator = exp.iterate((XPathContext)context);
        ArrayList<Object> list = new ArrayList<Object>(20);
        Item item;
        while ((item = iterator.next()) != null) {
            list.add(Value.convertToJava((Item)item));
        }
        return list;
    }

    public void reset() {
        this.contextNode = null;
        this.stripSpace = false;
        this.staticContext = new JAXPXPathStaticContext(this.config);
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.staticContext.setBackwardsCompatibilityMode(compatible);
    }

    public boolean isBackwardsCompatible() {
        return this.staticContext.isInBackwardsCompatibleMode();
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.staticContext.setXPathVariableResolver(xPathVariableResolver);
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.staticContext.getXPathVariableResolver();
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.staticContext.setXPathFunctionResolver(xPathFunctionResolver);
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.staticContext.getXPathFunctionResolver();
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.staticContext.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.staticContext.getNamespaceContext();
    }

    public void importSchema(Source source) throws SchemaException {
        this.staticContext.importSchema(source);
    }

    public XPathExpression compile(String expr) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        try {
            return this.createExpressionInternal(expr);
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public Object evaluate(String expr, Object node, QName qName) throws XPathExpressionException {
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(node, qName);
    }

    public String evaluate(String expr, Object node) throws XPathExpressionException {
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(node);
    }

    public Object evaluate(String expr, InputSource inputSource, QName qName) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(inputSource, qName);
    }

    public String evaluate(String expr, InputSource inputSource) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(inputSource);
    }

    public Object evaluateSingle(String expression) throws XPathException {
        Expression exp = ExpressionTool.make((String)expression, (StaticContext)this.staticContext, (int)0, (int)-1, (int)1, (boolean)false);
        ExpressionVisitor visitor = ExpressionVisitor.make((StaticContext)this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots((Expression)exp, (int)0, (SlotManager)map);
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.staticContext.getExecutable());
        context.openStackFrame(map);
        SequenceIterator iterator = exp.iterate((XPathContext)context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava((Item)item);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("format: java XPathEvaluator source.xml \"expression\"");
            return;
        }
        XPathEvaluator xpe = new XPathEvaluator();
        List results = (List)xpe.evaluate(args[1], new StreamSource(new File(args[0])), XPathConstants.NODESET);
        for (int i = 0; i < results.size(); ++i) {
            Object o = results.get(i);
            System.err.println(o);
        }
    }
}

