/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class JAXPVariable
implements VariableDeclaration,
Binding {
    private StructuredQName name;
    private XPathVariableResolver resolver;

    protected JAXPVariable(StructuredQName name, XPathVariableResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    public SequenceType getRequiredType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean isGlobal() {
        return true;
    }

    public final boolean isAssignable() {
        return false;
    }

    public int getLocalSlotNumber() {
        return -1;
    }

    public StructuredQName getVariableQName() {
        return this.name;
    }

    public void registerReference(BindingReference ref) {
        ref.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        ref.fixup((Binding)this);
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Object value = this.resolver.resolveVariable((QName)this.name.makeQName(context.getConfiguration()));
        if (value == null) {
            return EmptySequence.getInstance();
        }
        return Value.convertJavaObjectToXPath((Object)value, (SequenceType)SequenceType.ANY_SEQUENCE, (XPathContext)context);
    }

    QName makeQName(QNameValue in) {
        return new QName(in.getNamespaceURI(), in.getLocalName(), in.getPrefix());
    }
}

