/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.product.dao.contentsm;

import com.mathworks.product.AbstractProduct;
import com.mathworks.product.Product;
import com.mathworks.product.dao.ProductDao;
import com.mathworks.product.dao.config.DaoConfig;
import com.mathworks.product.dao.config.file.FileDaoConfig;
import com.mathworks.product.dao.contentsm.ContentsmConstants;
import com.mathworks.product.util.ProductIdentifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ContentsmDao
implements ProductDao {
    private static final Logger log = Logger.getLogger("com.mathworks.product.dao.contentsm.ContentsmDao");
    private String matlabRootPath = null;
    private static final String PATHDEF_M_PATH = "toolbox" + File.separator + "local";
    private static final String PATHDEF_M = "pathdef.m";
    private static final String CONTENTS_M = "Contents.m";

    public ContentsmDao(DaoConfig daoConfig) {
        FileDaoConfig fileDaoConfig = (FileDaoConfig)daoConfig;
        this.matlabRootPath = fileDaoConfig.getPath();
    }

    @Override
    public Collection<Product> getInstalledProducts() {
        File file = new File(this.matlabRootPath);
        File file2 = new File(file, PATHDEF_M_PATH + File.separator + PATHDEF_M);
        Collection<String> collection = ContentsmDao.readPathdefm(file2);
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (String string : collection) {
            string = File.separator.equalsIgnoreCase("/") ? string.replaceAll("\\\\", File.separator) : string.replaceAll("/", "\\\\");
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(File.separator);
            stringBuffer.append(CONTENTS_M);
            File file3 = new File(file, stringBuffer.toString());
            String string2 = ContentsmDao.readFirstTwoLinesOfContentsm(file3);
            log.fine("raw product text from file '" + file3.getAbsolutePath() + "' :" + string2);
            Product product = this.extractProduct(string2, string);
            if (product == null) continue;
            arrayList.add(product);
            log.fine("added " + product);
        }
        return arrayList;
    }

    private Product extractProduct(String string, String string2) {
        String string3;
        ContentsmProduct contentsmProduct = null;
        Pattern pattern = Pattern.compile("toolbox/matlab/general");
        Matcher matcher = pattern.matcher(string3 = string2.replace("\\", "/"));
        String string4 = matcher.find() ? "MATLAB" : ContentsmDao.extractName(string);
        String string5 = ContentsmDao.extractVersion(string);
        String string6 = ContentsmDao.extractRelease(string);
        String string7 = ContentsmDao.extractDate(string);
        ProductIdentifier productIdentifier = ProductIdentifier.get(string4);
        if (productIdentifier == null) {
            log.fine("product not found in map '" + string4 + "'\n" + "full: " + string2);
        }
        if (productIdentifier != null && string7 != null && string6 != null && string5 != null && string4 != null && string7.length() > 0 && string6.length() > 0 && string5.length() > 0 && string4.length() > 0) {
            contentsmProduct = new ContentsmProduct(productIdentifier.getBitNum(), string4, string5, string6, string7);
        } else {
            log.fine("did not add: " + (Object)((Object)productIdentifier) + ", " + string7 + ", " + string6 + ", " + string5 + ", " + string4 + " ");
        }
        return contentsmProduct;
    }

    private static String extractName(String string) {
        String string2 = string.trim();
        String string3 = null;
        int n = string2.indexOf(37);
        int n2 = string2.indexOf(37, n + 1);
        if (n > -1 && n2 >= n && (string3 = string2.substring(n + 1, n2).trim()).length() > 0 && string3.endsWith(".")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    private static String extractVersion(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = ContentsmConstants.EXTRACT_VERSION_NUMBER.matcher(string);
        if (matcher.find()) {
            stringBuffer.append(matcher.group(1));
        }
        return stringBuffer.toString();
    }

    private static String extractRelease(String string) {
        String string2;
        Matcher matcher;
        String string3 = null;
        Matcher matcher2 = ContentsmConstants.EXTRACT_RELEASE_RAW.matcher(string);
        if (matcher2.find() && (matcher = ContentsmConstants.RELEASE.matcher(string2 = matcher2.group(2))).find()) {
            string3 = matcher.group(0);
        }
        return string3;
    }

    private static String extractDate(String string) {
        Object object;
        Object object2;
        String string2 = string.trim();
        int n = string2.lastIndexOf(32);
        String string3 = string2.substring(n + 1);
        Pattern pattern = Pattern.compile("([0-1]?[0-9]{1})-([A-Za-z]{3})-([0-9]{4})");
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find()) {
            object2 = matcher.group(1);
            object = matcher.group(2);
            String string4 = matcher.group(3);
            object2 = ((String)object2).length() == 1 ? '0' + (String)object2 : object2;
            StringBuffer stringBuffer = new StringBuffer(3);
            stringBuffer.append(((String)object).substring(0, 1).toUpperCase());
            stringBuffer.append(((String)object).substring(1).toLowerCase());
            object = stringBuffer.toString();
            string3 = (String)object2 + '-' + (String)object + '-' + string4;
        }
        object2 = new SimpleDateFormat("dd-MMM-yyyy");
        try {
            object = ((DateFormat)object2).parse(string3);
            log.fine("dateString parsed is " + ((DateFormat)object2).format((Date)object));
        }
        catch (ParseException parseException) {
            log.fine("Unable to parse '" + string3 + '\'');
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFirstTwoLinesOfContentsm(File file) {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            bufferedReader = new LineNumberReader(new FileReader(file));
            while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                if (((LineNumberReader)bufferedReader).getLineNumber() > 2) {
                    log.fine("---");
                    break;
                }
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            log.fine("unable to readFirstTwoLinesOfContentsm Contents.m for file '" + file + "' " + "due to exception: " + iOException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> readPathdefm(File file) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        BufferedReader bufferedReader = null;
        String string = "'(.*)(:|;)',";
        Pattern pattern = Pattern.compile(string);
        Pattern pattern2 = Pattern.compile("toolbox/(local|matlab)(;|/).*");
        Pattern pattern3 = Pattern.compile("toolbox/matlab/general");
        int n = 0;
        try {
            String string2;
            bufferedReader = new LineNumberReader(new FileReader(file));
            boolean bl = false;
            while ((string2 = ((LineNumberReader)bufferedReader).readLine()) != null) {
                String string3 = string2.trim();
                if (string3.equalsIgnoreCase("%%% BEGIN ENTRIES %%%")) {
                    bl = true;
                    continue;
                }
                if (string3.equalsIgnoreCase("%%% END ENTRIES %%%")) {
                    break;
                }
                if (!bl) continue;
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    String string4 = matcher.group(1);
                    string4 = string4.replace("$toolbox", "toolbox");
                    String string5 = string4.replace("\\", "/");
                    Matcher matcher2 = pattern2.matcher(string5);
                    Matcher matcher3 = pattern3.matcher(string5);
                    if (matcher3.find() || !matcher2.find()) {
                        linkedHashSet.add(string4);
                        log.fine("add path '" + string4 + "' to collections of paths to search for Contents.m");
                        continue;
                    }
                    log.fine("undesirable path '" + string4 + "' not added to the collection");
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            log.fine("unable to readFirstTwoLinesOfContentsm 'pathdef.m' due to exception: " + iOException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.fine("invalid path total: " + n);
        return linkedHashSet;
    }

    private final class ContentsmProduct
    extends AbstractProduct {
        private final Integer bitNumber;
        private final String name;
        private final String version;
        private final String release;
        private final String date;

        private ContentsmProduct(int n, String string, String string2, String string3, String string4) {
            this.bitNumber = n;
            this.name = string;
            this.version = string2;
            this.release = string3;
            this.date = string4;
        }

        @Override
        public Integer getBitNumber() {
            return this.bitNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getRelease() {
            return this.release;
        }

        @Override
        public String getDate() {
            return this.date;
        }

        public String toString() {
            return this.name;
        }
    }
}

