/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.product.dao;

import com.mathworks.product.dao.DaoFactory;
import com.mathworks.product.dao.DaoFactoryInternal;
import com.mathworks.product.dao.DaoPluginFactory;
import com.mathworks.product.dao.config.DaoConfig;
import com.mathworks.product.dao.wrapper.WrapperDaoFactory;
import java.util.logging.Logger;

public final class DefaultDaoFactory {
    private static final Logger log = Logger.getLogger("com.mathworks.product.dao.DefaultDaoFactory");

    public static DaoFactory getDao(DaoConfig daoConfig) {
        if (DaoPluginFactory.checkPrefSet()) {
            try {
                DaoFactory daoFactory = (DaoFactory)DaoPluginFactory.getPlugin();
                if (daoFactory != null) {
                    return daoFactory;
                }
            }
            catch (Exception exception) {
                log.info("Loading custom DaoFactory failed" + exception.getMessage());
            }
        }
        if (daoConfig == null) {
            throw new IllegalArgumentException("DaoConfig cannot be null");
        }
        try {
            DaoFactoryInternal daoFactoryInternal = (DaoFactoryInternal)daoConfig.getType().getDaoClazz().newInstance();
            daoFactoryInternal.setConfig(daoConfig);
            return daoFactoryInternal;
        }
        catch (InstantiationException instantiationException) {
            log.info("instantiating of " + daoConfig.getType().getDaoClazz() + " failed: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            log.info("instantiating of " + daoConfig.getType().getDaoClazz() + " failed: " + illegalAccessException.getMessage());
        }
        WrapperDaoFactory wrapperDaoFactory = new WrapperDaoFactory();
        wrapperDaoFactory.setConfig(daoConfig);
        return wrapperDaoFactory;
    }

    private DefaultDaoFactory() {
    }
}

