/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import java.awt.Color;

public class MWStyle
implements Cloneable {
    public static final int BOLD = 128;
    public static final int ITALIC = 64;
    public static final int BK_HILITE = 512;
    public static final int UNDERLINE = 8;
    public static final int STRIKETHRU = 4;
    public static final int HIDDEN = 2;
    public static final int LINK = 1;
    private int fKey;
    private Color fColor;
    private Color fBkColor;
    private boolean fIsAutoColor;

    public MWStyle() {
        this.fIsAutoColor = true;
    }

    public MWStyle(boolean bl) {
        this.fIsAutoColor = bl;
    }

    public MWStyle(Color color) {
        this.fColor = color;
        this.fIsAutoColor = color == null;
    }

    public MWStyle(Color color, Color color2, int n) {
        this.fIsAutoColor = color == null;
        this.fColor = color;
        this.fBkColor = color2;
        this.fKey |= this.fIsAutoColor ? n : n & 0x3FF;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    void morph(MWStyle mWStyle) {
        if (mWStyle != null) {
            this.fKey = mWStyle.fKey;
            this.fColor = mWStyle.fColor;
            this.fBkColor = mWStyle.fBkColor;
            this.fIsAutoColor = mWStyle.fIsAutoColor;
        }
    }

    public int getStyle() {
        return this.fKey & 0x3FF;
    }

    public Color getBackground() {
        return this.fBkColor;
    }

    public Color getForeground() {
        return this.fColor;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MWStyle)) {
            return false;
        }
        MWStyle mWStyle = (MWStyle)object;
        if (this.getStyle() != mWStyle.getStyle()) {
            return false;
        }
        if (!this.fIsAutoColor && !mWStyle.isAutoColor()) {
            int n = this.fColor != null ? this.fColor.getRGB() : 0;
            int n2 = this.fBkColor != null ? this.fBkColor.getRGB() : 0;
            int n3 = mWStyle.getForeground() != null ? mWStyle.getForeground().getRGB() : 0;
            int n4 = mWStyle.getBackground() != null ? mWStyle.getBackground().getRGB() : 0;
            return n == n3 && n2 == n4;
        }
        return this.fIsAutoColor && mWStyle.isAutoColor();
    }

    public int hashCode() {
        if (this.fIsAutoColor) {
            return this.fKey;
        }
        int n = this.fColor != null ? this.fColor.getRGB() : 0;
        int n2 = this.fBkColor != null ? this.fBkColor.getRGB() : 0;
        return n ^ n2 ^ this.fKey;
    }

    public String toString() {
        String string = "<MWStyle@" + Integer.toHexString(this.hashCode());
        string = this.fIsAutoColor ? string + "(AutoColor)>" : string + "(" + this.fColor + ")>";
        return string;
    }

    public boolean isAutoColor() {
        return this.fIsAutoColor;
    }

    public void setAutoColor(boolean bl) {
        this.fIsAutoColor = bl;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        this.fColor = color;
    }
}

