/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.Tracker;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class TrackerCursor
extends Tracker {
    private int fLastPart = 0;

    TrackerCursor() {
        super(32);
    }

    @Override
    public boolean mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Table) {
            Table table = (Table)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n = table.findPart(point.x, point.y);
            int n2 = table.getCursorType();
            if (n != this.fLastPart) {
                Cursor cursor = Cursor.getDefaultCursor();
                switch (n) {
                    case 1: 
                    case 2: 
                    case 4: {
                        cursor = Cursor.getPredefinedCursor(n2);
                        break;
                    }
                    case 3: {
                        if (table.getColumnOptions().isResizable()) {
                            cursor = Cursor.getPredefinedCursor(11);
                            break;
                        }
                        cursor = Cursor.getPredefinedCursor(n2);
                        break;
                    }
                    case 5: {
                        cursor = table.getColumnOptions().isResizable() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(n2);
                    }
                }
                table.setCursor(cursor);
                this.fLastPart = n;
            }
        }
        return false;
    }
}

