/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.MixedState;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class CellMWCheckbox
extends Cell {
    private boolean fMouseIn = false;
    private Rectangle fTrackRect = null;
    private boolean fHasRollover;
    private static final int CB_SEPARATOR = 5;

    public CellMWCheckbox(Table table) {
        super(67, table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof MWCheckbox) {
            MWCheckbox mWCheckbox = (MWCheckbox)object;
            Point point = this.getTable().getTrackingCell();
            boolean bl2 = this.fMouseIn && point.x == n2 && point.y == n;
            Point point2 = new Point();
            Point point3 = new Point();
            boolean bl3 = this.isTableActive();
            this.getLocations(mWCheckbox, rectangle, style, point2, point3);
            if (mWCheckbox.getAppearance() == 1) {
                Decorations.drawRadiobutton(graphics, point2.x, point2.y, bl2, mWCheckbox.getState(), false, style.isEditable(), this.fHasRollover);
            } else {
                Decorations.drawCheckbox(graphics, point2.x, point2.y, bl2, mWCheckbox.getState(), mWCheckbox.isMixedState(), style.isEditable(), this.fHasRollover);
            }
            if (bl && PlatformInfo.getAppearance() != 0) {
                graphics.setColor(Decorations.getColor(5, bl3, null));
            } else {
                graphics.setColor(style.getForeground());
            }
            graphics.setFont(style.getFont());
            graphics.drawString(mWCheckbox.getLabel(), point3.x, point3.y);
        } else if (object instanceof MixedState) {
            Point point = this.getTable().getTrackingCell();
            int n3 = ((MixedState)object).getState();
            boolean bl4 = this.fMouseIn && point.x == n2 && point.y == n;
            graphics.translate(rectangle.x, rectangle.y);
            Point point4 = this.getCheckboxLocation(rectangle.width, rectangle.height, style);
            Decorations.drawCheckbox(graphics, point4.x, point4.y, bl4, n3 == 1, n3 > 1 || n3 < 0, style.isEditable(), this.fHasRollover);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private void getLocations(MWCheckbox mWCheckbox, Rectangle rectangle, Style style, Point point, Point point2) {
        int n;
        FontMetrics fontMetrics;
        int n2 = Decorations.getChecksize();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Insets insets = style.getMargins();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (style.getFont() != null && (fontMetrics = toolkit.getFontMetrics(style.getFont())) != null) {
            n3 = fontMetrics.stringWidth(mWCheckbox.getLabel());
            n4 = fontMetrics.getHeight();
            n5 = fontMetrics.getAscent() + fontMetrics.getLeading();
        }
        point.x = rectangle.x + insets.left;
        int n6 = point2.x = n2 > 15 ? point.x + n2 + 5 : point.x + 18;
        if (style.getHAlignment() != 0 && (n = rectangle.width - (point2.x - rectangle.x + n3)) > 0) {
            if (style.getHAlignment() == 1) {
                n >>= 1;
            }
            point.x += n;
            point2.x += n;
        }
        switch (style.getVAlignment()) {
            case 0: {
                point.y = rectangle.y + insets.top;
                point2.y = rectangle.y + insets.top + n5;
                break;
            }
            case 1: {
                point.y = rectangle.y + insets.top + (rectangle.height - insets.top - insets.bottom - n2) / 2;
                point2.y = rectangle.y + insets.top + (rectangle.height - insets.top - insets.bottom - n4) / 2 + n5;
                break;
            }
            case 2: {
                point.y = rectangle.y + (rectangle.height - insets.bottom - n2);
                point2.y = rectangle.y + (rectangle.height - insets.bottom - (n4 - n5));
            }
        }
    }

    private Point getCheckboxLocation(int n, int n2, Style style) {
        int n3 = Decorations.getChecksize();
        Point point = new Point();
        Insets insets = style.getMargins();
        switch (style.getHAlignment()) {
            case 0: {
                point.x = insets.left;
                break;
            }
            case 1: {
                point.x = insets.left + (n - insets.left - insets.right - n3) / 2;
                break;
            }
            case 2: {
                point.x = n - insets.right - n3;
            }
        }
        switch (style.getVAlignment()) {
            case 0: {
                point.y = insets.top;
                break;
            }
            case 1: {
                point.y = insets.top + (n2 - insets.top - insets.bottom - n3) / 2;
                break;
            }
            case 2: {
                point.y = n2 - insets.bottom - n3;
            }
        }
        return point;
    }

    private final void getCheckBounds(int n, int n2, Rectangle rectangle) {
        if (rectangle != null) {
            this.getTable().getCellBoundsInternal(n, n2, true, rectangle);
            Style style = this.getTable().getCellStyle(n, n2);
            int n3 = Decorations.getChecksize();
            Point point = this.getCheckboxLocation(rectangle.width, rectangle.height, style);
            rectangle.x += point.x;
            rectangle.y += point.y;
            rectangle.width = n3;
            rectangle.height = n3;
        }
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl = false;
        Style style = this.getTable().getCellStyle(n, n2);
        if (style != null && style.isEditable()) {
            Rectangle rectangle;
            Point point = mouseEvent.getPoint();
            if (object instanceof MWCheckbox) {
                Insets insets = style.getMargins();
                rectangle = this.getTable().getCellBounds(n, n2);
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
            } else {
                rectangle = new Rectangle();
                this.getCheckBounds(n, n2, rectangle);
            }
            if (rectangle.contains(point.x, point.y)) {
                this.getTable().setTrackingCell(n, n2);
                this.fMouseIn = true;
                this.fTrackRect = rectangle;
                this.getTable().repaintCells(n, n2, n, n2);
                bl = true;
            }
        }
        return bl;
    }

    private final boolean trackMouse(Point point, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.fTrackRect != null && this.fTrackRect.contains(point);
        if (this.fMouseIn != bl) {
            this.fMouseIn = bl;
            this.getTable().repaintCells(n, n2, n, n2);
        }
        return this.fMouseIn;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        boolean bl = false;
        if (point.x == n2 && point.y == n) {
            boolean bl2 = this.trackMouse(mouseEvent.getPoint(), n, n2);
            if (bl2) {
                Object object2 = this.getTable().getCellData(n, n2);
                if (object2 instanceof MWCheckbox) {
                    boolean bl3;
                    MWCheckbox mWCheckbox = (MWCheckbox)object2;
                    if (mWCheckbox.isMixedState()) {
                        mWCheckbox.setMixedState(false);
                        bl3 = true;
                    } else {
                        bl3 = !mWCheckbox.getState();
                    }
                    mWCheckbox.setState(bl3);
                } else if (object2 instanceof MixedState) {
                    int n3 = ((MixedState)object2).getState() == 1 ? 0 : 1;
                    ((MixedState)object2).setState(n3);
                }
                this.getTable().repaintCells(n, n2, n, n2);
                this.getTable().setTrackingCell(-2, -2);
                this.getTable().fireValueChangedEvent(n, n2, null);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        boolean bl = false;
        if (point.x == n2 && point.y == n) {
            this.trackMouse(mouseEvent.getPoint(), n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    protected void getPreferredCellSize(int n, int n2, Dimension dimension) {
        if (dimension != null) {
            super.getPreferredCellSize(n, n2, dimension);
            Object object = this.getTable().getCellData(n, n2);
            if (object instanceof MWCheckbox) {
                Font font = this.getTable().getCellStyle(n, n2).getFont();
                FontMetrics fontMetrics = this.getTable().getFontMetrics(font);
                int n3 = Decorations.getChecksize();
                int n4 = fontMetrics.stringWidth(((MWCheckbox)object).getLabel());
                dimension.height += Math.max(n3, fontMetrics.getHeight());
                dimension.width += n4 + n3 + 5;
            }
        }
    }
}

