/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.floater;

import com.mathworks.mwt.floater.Floater;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DragForwarder
implements MouseListener,
MouseMotionListener {
    private boolean fDragging;
    private Floater fFloater;

    public DragForwarder(Floater floater) {
        this.fFloater = floater;
        this.fDragging = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Component component;
        if (this.fFloater instanceof Component && (component = (Component)((Object)this.fFloater)).isShowing()) {
            Dimension dimension = component.getSize();
            Point point = this.getDelta(mouseEvent.getComponent(), component);
            Point point2 = mouseEvent.getPoint();
            if (!this.fDragging && point2.x >= -point.x && point2.x < -point.x + dimension.width && point2.y >= -point.y && point2.y < -point.y + dimension.height) {
                this.fDragging = true;
            }
            if (this.fDragging) {
                mouseEvent.translatePoint(point.x, point.y);
                component.dispatchEvent(mouseEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Component component;
        if (this.fDragging && this.fFloater instanceof Component && (component = (Component)((Object)this.fFloater)).isShowing()) {
            Point point = this.getDelta(mouseEvent.getComponent(), component);
            mouseEvent.translatePoint(point.x, point.y);
            component.dispatchEvent(mouseEvent);
        }
        this.fDragging = false;
    }

    private Point getDelta(Component component, Component component2) {
        Point point = component.getLocationOnScreen();
        Point point2 = component2.getLocationOnScreen();
        Point point3 = new Point();
        point3.x = point.x - point2.x;
        point3.y = point.y - point2.y;
        return point3;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

