/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.decorations;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RotatedText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

abstract class PlatformDecorations
extends Component {
    static final int FONT_CONTROL = 0;
    static final int WINDOW_BG = 0;
    static final int DIALOG_BG = 1;
    static final int LIST_BG = 2;
    static final int LIST_LINE = 3;
    static final int SELECTION = 4;
    static final int SELECTED_TEXT = 5;
    static final int CONTROL = 6;
    static final int CONTROL_LT_HL = 7;
    static final int CONTROL_HL = 8;
    static final int CONTROL_SH = 9;
    static final int CONTROL_DK_SH = 10;
    static final int CONTROL_TEXT = 11;
    static final int WINDOW_TEXT = 12;
    static final int TEXT = 13;
    static final int TEXT_TEXT = 14;
    static final int INACTIVE_TEXT = 15;
    public static final int ACTIVE_CAPTION_BG = 16;
    public static final int ACTIVE_CAPTION_TEXT = 17;
    public static final int INACTIVE_CAPTION_BG = 18;
    public static final int INACTIVE_CAPTION_TEXT = 19;
    private static Color XP_BEVELSEL_COLOR = new Color(145, 155, 156);
    private static Color XP_TABSEL_COLOR = new Color(250, 250, 250);
    private static Color XP_BEVEL_COLOR = new Color(145, 167, 180);
    private static Color XP_TAB_COLOR_BLUE = new Color(243, 243, 238);
    private static Color XP_TAB_COLOR_SILVER = new Color(246, 247, 253);
    private static Color XP_CONTROL_SH = new Color(255, 200, 60);
    private static Color XP_CONTROL_DK_SH = new Color(230, 139, 44);
    private static Color XP_OLIVE_SH = new Color(227, 145, 79);
    private static Color XP_OLIVE_DK_SH = new Color(207, 114, 37);
    private static Color XP_OLIVE_COLOR = new Color(248, 245, 228);
    private static Color XP_OLIVE_BEVEL_COLOR = new Color(166, 161, 166);

    PlatformDecorations() {
    }

    abstract Font getFont(int var1);

    abstract Color getColor(int var1);

    void drawDesktopFrame(Graphics graphics, Rectangle rectangle, int n) {
        graphics.translate(rectangle.x, rectangle.y);
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.setColor(this.getColor(8));
        graphics.drawLine(0, n3 - 2, 0, 0);
        graphics.drawLine(1, 0, n2 - 1, 0);
        graphics.setColor(this.getColor(10));
        graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 1);
        graphics.drawLine(n2 - 2, n3 - 1, 0, n3 - 1);
        graphics.setColor(this.getColor(7));
        graphics.drawLine(1, n3 - 3, 1, 1);
        graphics.drawLine(2, 1, n2 - 2, 1);
        graphics.setColor(this.getColor(9));
        graphics.drawLine(n2 - 2, 2, n2 - 2, n3 - 2);
        graphics.drawLine(n2 - 3, n3 - 2, 1, n3 - 2);
        graphics.setColor(this.getColor(6));
        for (int i = 2; i < n; ++i) {
            graphics.drawRect(i, i, n2 - 2 * i - 1, n3 - 2 * i - 1);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    void drawBevelFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(this.getColor(9));
        graphics.drawLine(0, n4 - 2, 0, 0);
        graphics.drawLine(1, 0, n3 - 1, 0);
        graphics.setColor(this.getColor(7));
        graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 2, n4 - 1, 0, n4 - 1);
        graphics.setColor(this.getColor(10));
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(2, 1, n3 - 2, 1);
        graphics.setColor(this.getColor(8));
        graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 3, n4 - 2, 1, n4 - 2);
        graphics.translate(-n, -n2);
    }

    abstract void drawLabel(Graphics var1, String var2, int var3, int var4, boolean var5, boolean var6);

    abstract void drawButtonLabel(Graphics var1, String var2, int var3, int var4, boolean var5, boolean var6);

    abstract void drawButtonBevel(Graphics var1, Rectangle var2, boolean var3, boolean var4, boolean var5);

    abstract void drawTBButtonBevel(Graphics var1, Rectangle var2, boolean var3, boolean var4, boolean var5);

    void drawTextButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this.drawButtonBevel(graphics, rectangle, bl, bl2, bl3);
    }

    abstract MWImageResource[] drawButtonImage(MWImageResource[] var1, Graphics var2, MWImageResource var3, int var4, int var5, boolean var6, boolean var7);

    abstract Image[] drawButtonImage(Image[] var1, Graphics var2, Image var3, int var4, int var5, boolean var6, boolean var7);

    abstract void drawButtonImage(Graphics var1, Image var2, int var3, int var4, boolean var5, boolean var6);

    abstract int getChecksize();

    abstract void drawCheckbox(Graphics var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    abstract void drawRadiobutton(Graphics var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    int[] newRBInts(byte[] byArray, int[] nArray) {
        int n = 0;
        int n2 = byArray.length & 0xFFFFFFFC;
        int[] nArray2 = new int[byArray.length];
        while (n < n2) {
            nArray2[n] = nArray[byArray[n++]];
            nArray2[n] = nArray[byArray[n++]];
            nArray2[n] = nArray[byArray[n++]];
            nArray2[n] = nArray[byArray[n++]];
        }
        while (n < byArray.length) {
            nArray2[n] = nArray[byArray[n++]];
        }
        return nArray2;
    }

    int[] cloneRBInts(int[] nArray) {
        int n = 0;
        int n2 = nArray.length & 0xFFFFFFFC;
        int[] nArray2 = new int[nArray.length];
        while (n < n2) {
            nArray2[n] = nArray[n++];
            nArray2[n] = nArray[n++];
            nArray2[n] = nArray[n++];
            nArray2[n] = nArray[n++];
        }
        while (n < nArray.length) {
            nArray2[n] = nArray[n++];
        }
        return nArray2;
    }

    abstract void drawScrollTrack(Graphics var1, Rectangle var2, int var3, int var4, boolean var5, boolean var6);

    abstract void drawScrollThumb(Graphics var1, Rectangle var2, int var3, boolean var4, boolean var5, boolean var6);

    abstract void drawScrollArrowButton(Graphics var1, Rectangle var2, boolean var3, boolean var4, boolean var5, int var6, int var7);

    abstract void drawSliderThumb(Graphics var1, Rectangle var2, int var3, boolean var4, boolean var5, boolean var6);

    abstract void drawSliderTrack(Graphics var1, Rectangle var2, int var3, int var4, boolean var5);

    abstract int sliderThumbLength();

    abstract void drawPopupControl(Graphics var1, Rectangle var2, String var3, boolean var4, boolean var5, boolean var6);

    abstract void drawComboControl(Graphics var1, Rectangle var2, boolean var3, boolean var4, boolean var5);

    String shortenString(String string, FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics != null ? fontMetrics.stringWidth("...") : 0;
        int n3 = fontMetrics != null && string != null ? fontMetrics.stringWidth(string) : 0;
        String string2 = "";
        if (n3 < n) {
            string2 = string;
        } else if (n2 > n) {
            string2 = "";
        } else {
            string2 = new String(string);
            while (n3 + n2 > n) {
                string2 = string2.substring(0, string2.length() - 1);
                n3 = fontMetrics.stringWidth(string2);
            }
            string2 = string2 + "...";
        }
        return string2;
    }

    void drawDialogTab(Graphics graphics, String string, Rectangle rectangle, boolean bl, int n, boolean bl2, boolean bl3, Component component) {
        Color color;
        Rectangle rectangle2 = new Rectangle(rectangle);
        Point point = this.calcTabTextPos(graphics.getFontMetrics(), string, rectangle, n);
        boolean bl4 = PlatformInfo.getWindowsXPScheme() == 1;
        Color color2 = this.getColor(6);
        Color color3 = bl ? XP_BEVELSEL_COLOR : XP_BEVEL_COLOR;
        Color color4 = PlatformInfo.useWindowsXPAppearance() ? color3 : this.getColor(7);
        Color color5 = PlatformInfo.useWindowsXPAppearance() ? color3 : this.getColor(8);
        Color color6 = PlatformInfo.useWindowsXPAppearance() ? color3 : this.getColor(9);
        Color color7 = color = PlatformInfo.useWindowsXPAppearance() ? color3 : this.getColor(10);
        if (PlatformInfo.useWindowsXPAppearance()) {
            color3 = bl ? XP_TABSEL_COLOR : (bl4 ? XP_OLIVE_COLOR : (PlatformInfo.getWindowsXPScheme() == 2 ? XP_TAB_COLOR_SILVER : XP_TAB_COLOR_BLUE));
        } else {
            color3 = color2;
            bl3 = false;
        }
        switch (n) {
            case 1: {
                if (bl) {
                    rectangle2.y -= 2;
                    rectangle2.height += 3;
                    rectangle2.x -= 2;
                    rectangle2.width += 4;
                }
                int n2 = rectangle2.x + rectangle2.width;
                int n3 = rectangle2.y + rectangle2.height;
                int n4 = (bl || bl3) && PlatformInfo.useWindowsXPAppearance() ? 1 : 0;
                graphics.setColor(color4);
                graphics.drawLine(rectangle2.x, n3 - 1, rectangle2.x, rectangle2.y + 2 + n4);
                if ((bl || bl3) && PlatformInfo.useWindowsXPAppearance()) {
                    graphics.setColor(bl4 ? XP_OLIVE_DK_SH : XP_CONTROL_DK_SH);
                    graphics.drawLine(n2 - 2, rectangle2.y + 2, n2 - 2, rectangle2.y + 2);
                    graphics.drawLine(rectangle2.x + 1, rectangle2.y + 2, rectangle2.x + 1, rectangle2.y + 2);
                }
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + 1);
                graphics.drawLine(rectangle2.x + 2, rectangle2.y, n2 - 3, rectangle2.y);
                if ((bl || bl3) && PlatformInfo.useWindowsXPAppearance()) {
                    graphics.setColor(bl4 ? XP_OLIVE_SH : XP_CONTROL_SH);
                    graphics.drawLine(rectangle2.x + 2, rectangle2.y + 2, n2 - 3, rectangle2.y + 2);
                } else {
                    graphics.setColor(color5);
                }
                graphics.drawLine(rectangle2.x + 2, rectangle2.y + 1, n2 - 3, rectangle2.y + 1);
                graphics.setColor(color5);
                graphics.drawLine(rectangle2.x + 1, n3 - 1, rectangle2.x + 1, rectangle2.y + 2 + n4);
                graphics.setColor(color6);
                graphics.drawLine(n2 - 2, n3 - 1, n2 - 2, rectangle2.y + 2 + n4);
                graphics.setColor(color);
                graphics.drawLine(n2 - 1, n3 - 1, n2 - 1, rectangle2.y + 2 + n4);
                if ((bl || bl3) && PlatformInfo.useWindowsXPAppearance()) {
                    graphics.setColor(bl4 ? XP_OLIVE_DK_SH : XP_CONTROL_DK_SH);
                }
                graphics.drawLine(n2 - 2, rectangle2.y + 1, n2 - 2, rectangle2.y + 1);
                graphics.setColor(color3);
                if (bl || bl3) {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y + 2 + n4, rectangle2.width - 4, rectangle2.height - 1 - n4);
                } else {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y + 2, rectangle2.width - 4, rectangle2.height - 2);
                }
                point.y = bl ? point.y - 1 : point.y + 1;
                this.drawButtonLabel(graphics, string, point.x, point.y, false, bl2);
                break;
            }
            case 2: {
                if (bl) {
                    rectangle2.x -= 2;
                    rectangle2.width += 3;
                    rectangle2.y -= 2;
                    rectangle2.height += 4;
                }
                int n5 = rectangle2.x + rectangle2.width;
                int n6 = rectangle2.y + rectangle2.height;
                graphics.setColor(color4);
                graphics.drawLine(n5 - 1, rectangle2.y, rectangle2.x + 2, rectangle2.y);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + 1);
                graphics.drawLine(rectangle2.x, rectangle2.y + 2, rectangle2.x, n6 - 3);
                graphics.setColor(color5);
                graphics.drawLine(n5 - 1, rectangle2.y + 1, rectangle2.x + 2, rectangle2.y + 1);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + 2, rectangle2.x + 1, n6 - 3);
                graphics.setColor(color6);
                graphics.drawLine(n5 - 1, n6 - 2, rectangle2.x + 2, n6 - 2);
                graphics.setColor(color);
                graphics.drawLine(n5 - 1, n6 - 1, rectangle2.x + 2, n6 - 1);
                graphics.drawLine(rectangle2.x + 1, n6 - 2, rectangle2.x + 1, n6 - 2);
                graphics.setColor(color3);
                if (bl) {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y + 2, rectangle2.width - 1, rectangle2.height - 4);
                } else {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y + 2, rectangle2.width - 2, rectangle2.height - 4);
                }
                point.x = bl ? point.x - 1 : point.x + 1;
                graphics.setColor(this.getColor(11));
                RotatedText.drawRotatedText((Graphics)graphics, (String)string, (int)point.x, (int)point.y, (int)90, (Component)component);
                break;
            }
            case 3: {
                if (bl) {
                    --rectangle2.y;
                    rectangle2.height += 3;
                    rectangle2.x -= 2;
                    rectangle2.width += 4;
                }
                int n7 = rectangle2.x + rectangle2.width;
                int n8 = rectangle2.y + rectangle2.height;
                int n9 = (bl || bl3) && PlatformInfo.useWindowsXPAppearance() ? 2 : 1;
                graphics.setColor(color4);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, n8 - 3);
                graphics.setColor(color5);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y, rectangle2.x + 1, n8 - 3);
                if ((bl || bl3) && PlatformInfo.useWindowsXPAppearance()) {
                    graphics.setColor(bl4 ? XP_OLIVE_SH : XP_CONTROL_SH);
                    graphics.drawLine(rectangle2.x + 2, n8 - 3, n7 - 3, n8 - 3);
                } else {
                    graphics.setColor(color6);
                }
                graphics.drawLine(rectangle2.x + 2, n8 - 2, n7 - 3, n8 - 2);
                graphics.setColor(color6);
                graphics.drawLine(n7 - 2, rectangle2.y, n7 - 2, n8 - 3);
                if ((bl || bl3) && PlatformInfo.useWindowsXPAppearance()) {
                    graphics.setColor(bl4 ? XP_OLIVE_DK_SH : XP_CONTROL_DK_SH);
                    graphics.drawLine(rectangle2.x + 1, n8 - 3, rectangle2.x + 1, n8 - 3);
                    graphics.drawLine(n7 - 2, n8 - 3, n7 - 2, n8 - 3);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawLine(rectangle2.x + 1, n8 - 2, rectangle2.x + 1, n8 - 2);
                graphics.drawLine(rectangle2.x + 2, n8 - 1, n7 - 3, n8 - 1);
                graphics.drawLine(n7 - 2, n8 - 2, n7 - 2, n8 - 2);
                graphics.setColor(color);
                graphics.drawLine(n7 - 1, rectangle2.y, n7 - 1, n8 - 2 - n9);
                graphics.setColor(color3);
                if (bl || bl3) {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y - 1, rectangle2.width - 4, rectangle2.height - n9);
                } else {
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y, rectangle2.width - 4, rectangle2.height - 2);
                }
                int n10 = point.y = bl ? point.y + 2 : point.y;
                if (bl && PlatformInfo.useWindowsXPAppearance()) {
                    point.y -= 2;
                }
                this.drawButtonLabel(graphics, string, point.x, point.y, false, bl2);
                break;
            }
            case 4: {
                if (bl) {
                    --rectangle2.x;
                    rectangle2.width += 3;
                    rectangle2.y -= 2;
                    rectangle2.height += 4;
                }
                int n11 = rectangle2.x + rectangle2.width;
                int n12 = rectangle2.y + rectangle2.height;
                graphics.setColor(color4);
                graphics.drawLine(rectangle2.x, rectangle2.y, n11 - 3, rectangle2.y);
                graphics.setColor(color5);
                graphics.drawLine(rectangle2.x, rectangle2.y + 1, n11 - 3, rectangle2.y + 1);
                graphics.setColor(color6);
                graphics.drawLine(rectangle2.x, n12 - 2, n11 - 3, n12 - 2);
                graphics.drawLine(n11 - 2, rectangle2.y + 2, n11 - 2, n12 - 3);
                graphics.setColor(color);
                graphics.drawLine(n11 - 2, rectangle2.y + 1, n11 - 2, rectangle2.y + 1);
                graphics.drawLine(n11 - 1, rectangle2.y + 2, n11 - 1, n12 - 3);
                graphics.drawLine(n11 - 2, n12 - 2, n11 - 2, n12 - 2);
                graphics.drawLine(rectangle2.x, n12 - 1, n11 - 3, n12 - 1);
                graphics.setColor(color3);
                if (bl) {
                    graphics.fillRect(rectangle2.x - 1, rectangle2.y + 2, rectangle2.width - 1, rectangle2.height - 4);
                } else {
                    graphics.fillRect(rectangle2.x, rectangle2.y + 2, rectangle2.width - 2, rectangle2.height - 4);
                }
                point.x = bl ? point.x + 1 : point.x - 1;
                graphics.setColor(this.getColor(11));
                RotatedText.drawRotatedText((Graphics)graphics, (String)string, (int)point.x, (int)point.y, (int)270, (Component)component);
            }
        }
    }

    void drawDocumentTab(Graphics graphics, String string, Rectangle rectangle, int n, int n2, boolean bl, Component component) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        Point point = this.calcTabTextPos(graphics.getFontMetrics(), string, rectangle, n2);
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle2.y + rectangle2.height;
        int n5 = rectangle2.x + rectangle2.height / 2;
        int n6 = rectangle2.y + rectangle2.width / 2;
        int n7 = n3 - rectangle2.height / 2;
        int n8 = n4 - rectangle2.width / 2;
        switch (n2) {
            case 1: {
                int[] nArray = new int[]{rectangle2.x, n5, n7 - 1, n3};
                int[] nArray2 = new int[]{n4, rectangle2.y, rectangle2.y, n4};
                graphics.setColor(this.getColor(n));
                graphics.fillPolygon(nArray, nArray2, 4);
                graphics.setColor(Color.black);
                if (rectangle2.height % 2 == 0) {
                    graphics.drawLine(rectangle2.x, n4 - 1, n5 - 1, rectangle2.y + 1);
                    graphics.drawLine(n7, rectangle2.y + 1, n3 - 1, n4 - 1);
                } else {
                    graphics.drawLine(rectangle2.x, n4 - 1, n5, rectangle2.y);
                    graphics.drawLine(n7 - 1, rectangle2.y, n3 - 1, n4 - 1);
                }
                graphics.drawLine(n5, rectangle2.y, n7 - 1, rectangle2.y);
                this.drawLabel(graphics, string, point.x, point.y, false, bl);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n3, rectangle2.x, rectangle2.x, n3};
                int[] nArray3 = new int[]{rectangle2.y, n6, n8, n4};
                graphics.setColor(this.getColor(n));
                graphics.fillPolygon(nArray, nArray3, 4);
                graphics.setColor(Color.black);
                if (rectangle2.width % 2 == 0) {
                    graphics.drawLine(n3 - 1, rectangle2.y, rectangle2.x + 1, n6 - 1);
                    graphics.drawLine(rectangle2.x + 1, n8, n3 - 1, n4 - 1);
                } else {
                    graphics.drawLine(n3 - 1, rectangle2.y, rectangle2.x, n6);
                    graphics.drawLine(rectangle2.x, n8 - 1, n3 - 1, n4 - 1);
                }
                graphics.drawLine(rectangle2.x, n6, rectangle2.x, n8 - 1);
                graphics.setColor(this.getColor(12));
                RotatedText.drawRotatedText((Graphics)graphics, (String)string, (int)point.x, (int)point.y, (int)90, (Component)component);
                break;
            }
            case 3: {
                int[] nArray = new int[]{rectangle2.x, n5, n7, n3};
                int[] nArray4 = new int[]{rectangle2.y, n4, n4, rectangle2.y};
                graphics.setColor(this.getColor(n));
                graphics.fillPolygon(nArray, nArray4, 4);
                graphics.setColor(Color.black);
                if (rectangle2.height % 2 == 0) {
                    graphics.drawLine(rectangle2.x, rectangle2.y, n5 - 1, n4 - 2);
                    graphics.drawLine(n7, n4 - 2, n3 - 1, rectangle2.y);
                } else {
                    graphics.drawLine(rectangle2.x, rectangle2.y, n5, n4 - 1);
                    graphics.drawLine(n7 - 1, n4 - 1, n3 - 1, rectangle2.y);
                }
                graphics.drawLine(n5, n4 - 1, n7 - 1, n4 - 1);
                this.drawLabel(graphics, string, point.x, point.y, false, bl);
                break;
            }
            case 4: {
                int[] nArray = new int[]{rectangle2.x, n3, n3, rectangle2.x};
                int[] nArray5 = new int[]{rectangle2.y, n6, n8 - 1, n4};
                graphics.setColor(this.getColor(n));
                graphics.fillPolygon(nArray, nArray5, 4);
                graphics.setColor(Color.black);
                if (rectangle2.width % 2 == 0) {
                    graphics.drawLine(rectangle2.x, rectangle2.y, n3 - 2, n6 - 1);
                    graphics.drawLine(n3 - 2, n8, rectangle2.x, n4 - 1);
                } else {
                    graphics.drawLine(rectangle2.x, rectangle2.y, n3 - 1, n6);
                    graphics.drawLine(n3 - 1, n8 - 1, rectangle2.x, n4 - 1);
                }
                graphics.drawLine(n3 - 1, n6, n3 - 1, n8 - 1);
                graphics.setColor(this.getColor(12));
                RotatedText.drawRotatedText((Graphics)graphics, (String)string, (int)point.x, (int)point.y, (int)270, (Component)component);
            }
        }
    }

    void drawDialogTabEdge(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        Color color = PlatformInfo.useWindowsXPAppearance() ? XP_BEVELSEL_COLOR : this.getColor(7);
        Color color2 = PlatformInfo.useWindowsXPAppearance() ? XP_BEVELSEL_COLOR : this.getColor(8);
        Color color3 = PlatformInfo.useWindowsXPAppearance() ? XP_BEVELSEL_COLOR : this.getColor(9);
        Color color4 = PlatformInfo.useWindowsXPAppearance() ? XP_BEVELSEL_COLOR : this.getColor(10);
        switch (n3) {
            case 1: {
                graphics.setColor(color);
                if (n > rectangle.x) {
                    graphics.drawLine(rectangle.x, n5 - 1, rectangle.x, n5 - 1);
                    graphics.drawLine(rectangle.x, n5 - 2, n - 1, n5 - 2);
                }
                if (n2 < n4) {
                    graphics.drawLine(n2, n5 - 2, n4 - 1, n5 - 2);
                }
                graphics.setColor(color2);
                if (n > rectangle.x) {
                    graphics.drawLine(rectangle.x + 1, n5 - 1, n - 1, n5 - 1);
                }
                if (n2 >= n4) break;
                graphics.drawLine(n2, n5 - 1, n4 - 2, n5 - 1);
                graphics.setColor(color4);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, n5 - 1);
                break;
            }
            case 2: {
                graphics.setColor(color);
                if (n > rectangle.y) {
                    graphics.drawLine(n4 - 1, rectangle.y, n4 - 1, rectangle.y);
                    graphics.drawLine(n4 - 2, rectangle.y, n4 - 2, n);
                }
                if (n2 < n5) {
                    graphics.drawLine(n4 - 2, n2, n4 - 2, n5 - 1);
                }
                graphics.setColor(color2);
                if (n > rectangle.y) {
                    graphics.drawLine(n4 - 1, rectangle.y + 1, n4 - 1, n);
                }
                if (n2 >= n5) break;
                graphics.drawLine(n4 - 1, n2, n4 - 1, n5 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, n5 - 1);
                break;
            }
            case 3: {
                if (n > rectangle.x) {
                    graphics.setColor(color);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + 1);
                    graphics.setColor(color2);
                    graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y);
                }
                graphics.setColor(color4);
                if (n > rectangle.x) {
                    graphics.drawLine(rectangle.x + 1, rectangle.y + 1, n - 1, rectangle.y + 1);
                }
                if (n2 < n4) {
                    graphics.drawLine(n2, rectangle.y + 1, n4 - 1, rectangle.y + 1);
                    graphics.drawLine(n4 - 1, rectangle.y, n4 - 1, rectangle.y);
                }
                graphics.setColor(color3);
                if (n > rectangle.x + 2) {
                    graphics.drawLine(rectangle.x + 2, rectangle.y, n - 2, rectangle.y);
                }
                if (n2 >= n4) break;
                graphics.drawLine(n2, rectangle.y, n4 - 2, rectangle.y);
                break;
            }
            case 4: {
                if (n > rectangle.y) {
                    graphics.setColor(color);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + 1, rectangle.y);
                    graphics.setColor(color2);
                    graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x, rectangle.y + 1);
                }
                graphics.setColor(color4);
                if (n > rectangle.y) {
                    graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, n - 1);
                }
                if (n2 < n5) {
                    graphics.drawLine(rectangle.x + 1, n2, rectangle.x + 1, n5 - 1);
                    graphics.drawLine(rectangle.x, n5 - 1, rectangle.x, n5 - 1);
                }
                graphics.setColor(color3);
                if (n > rectangle.y + 2) {
                    graphics.drawLine(rectangle.x, rectangle.y + 2, rectangle.x, n - 2);
                }
                if (n2 >= n5) break;
                graphics.drawLine(rectangle.x, n2, rectangle.x, n5 - 2);
            }
        }
    }

    void drawDocumentTabEdge(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        switch (n3) {
            case 1: {
                graphics.setColor(Color.black);
                if (n > rectangle.x) {
                    graphics.drawLine(rectangle.x, n5 - 1, n - 1, n5 - 1);
                }
                if (n2 >= n4) break;
                graphics.drawLine(n2, n5 - 1, n4 - 1, n5 - 1);
                break;
            }
            case 2: {
                graphics.setColor(Color.black);
                if (n > rectangle.y) {
                    graphics.drawLine(n4 - 1, rectangle.y, n4 - 1, n - 1);
                }
                if (n2 >= n5) break;
                graphics.drawLine(n4 - 1, n2, n4 - 1, n5 - 1);
                break;
            }
            case 3: {
                graphics.setColor(Color.black);
                if (n > rectangle.x) {
                    graphics.drawLine(rectangle.x, rectangle.y, n - 1, rectangle.y);
                }
                if (n2 >= n4) break;
                graphics.drawLine(n2, rectangle.y, n4 - 1, rectangle.y);
                break;
            }
            case 4: {
                graphics.setColor(Color.black);
                if (n > rectangle.y) {
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n - 1);
                }
                if (n2 >= n5) break;
                graphics.drawLine(rectangle.x, n2, rectangle.x, n5 - 1);
            }
        }
    }

    private Point calcTabTextPos(FontMetrics fontMetrics, String string, Rectangle rectangle, int n) {
        Point point = new Point();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getMaxAscent();
        int n4 = n3 + fontMetrics.getMaxDescent();
        if (n == 1 || n == 3) {
            point.x = rectangle.x + (rectangle.width - n2) / 2;
            point.y = rectangle.y + (rectangle.height - n4) / 2 + n3;
        } else if (n == 2) {
            point.x = rectangle.x + (rectangle.width - n4) / 2 + n3;
            point.y = rectangle.y + rectangle.height - (rectangle.height - n2) / 2;
        } else {
            point.x = rectangle.x + (rectangle.width - n4) / 2 + (n4 - n3);
            point.y = rectangle.y + (rectangle.height - n2) / 2;
        }
        return point;
    }
}

