/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.ListItem;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWMouseWheelTarget;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class MWTList
extends MWContainer
implements AdjustmentListener,
ItemSelectable,
KeyListener,
MouseListener,
MouseMotionListener,
MWMouseWheelTarget {
    public static final int NO_ITEM = -1;
    private static final int ICON_WIDTH = 16;
    private static final int TWISTY_WIDTH = 14;
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int DOUBLE_CLICK_TIME = 500;
    private static final Color TWISTY_COLOR = new Color(156, 156, 255);
    private static final Color TWISTY_SELECTED_COLOR = new Color(49, 49, 156);
    private static final Color XP_BORDER = new Color(120, 152, 181);
    private static final Color XP_CORNER = new Color(176, 194, 211);
    private static final Color XP_GRAY1 = new Color(195, 186, 170);
    private static final Color XP_GRAY2 = new Color(210, 204, 192);
    private static final Color XP_GRAY3 = new Color(237, 237, 231);
    private static boolean sIsSGI = System.getProperty("os.name").equals("Irix");
    private MWTListListener fPopListener;
    transient ActionListener fActionListener;
    transient ItemListener fItemListener;
    private int fColumnCount;
    private String[] fHeaders;
    private int[] fColumnWidths;
    private int fHeaderHeight;
    private boolean fUseHeader;
    private boolean fAlignHeaderWithText;
    private String fActionCommand;
    private int fLeftMargin;
    private int fFontHeight = 0;
    private int fCellHeight;
    private int fLevelIndent;
    private FontMetrics fFontInfo;
    private MWScrollbar fHScroll;
    private MWScrollbar fVScroll;
    private int fLastClickedItem = 0;
    private int fSelectionAnchor = -1;
    private Vector fList;
    private int fTwistyClicked;
    private int fColumnResize;
    private int fResizeX;
    private int fMinimumX;
    private int fNextItem;
    private int fNextAvailableID;
    private int fCachedItem;
    private int fSelectID;
    private int fSelectCount;
    private Offscreen fOffscreen;
    private Point fStartPoint;
    private long fLastClickTime;
    private int fCurrentX;
    private int fCurrentY;
    private int fInvalCount;
    private int fMaxWidth;
    private boolean fUseIcons;
    private boolean fIsTwisty;
    private boolean fWholeItemSelect;
    private boolean fWholeItemHilite;
    private boolean fMultiSelection;
    private int fAppearance;
    private boolean fDrawColumnLines;
    private boolean fDrawRowLines;
    private boolean fHiliteItemHilite;
    private boolean fDrawSelection;
    private boolean fDrawFrame;
    private boolean fImmediateClick;
    private boolean fKeyScrollSelect;
    private boolean fDrawTreeLines;
    private boolean fForceSelectionActive;
    private Color fListColor;
    private Color fSortColumnColor;
    private Color fHGridColor;
    private boolean fDoDeselect;
    private boolean fScrollOnTwist;
    private boolean fHScrollVisAWT;
    private boolean fVScrollVisAWT;
    private Rectangle fHScrollBoundsAWT;
    private Rectangle fVScrollBoundsAWT;

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private Rectangle getListArea() {
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.fVScroll.isVisible() || this.fVScrollVisAWT) {
            rectangle.width -= 16;
            if (this.fAppearance != 1) {
                ++rectangle.width;
            }
        }
        if (this.fHScroll.isVisible() || this.fHScrollVisAWT) {
            rectangle.height -= 16;
            if (this.fAppearance != 1) {
                ++rectangle.height;
            } else if (!PlatformInfo.useWindowsXPAppearance()) {
                --rectangle.height;
            }
        }
        rectangle.y = this.fHeaderHeight;
        rectangle.height -= this.fHeaderHeight;
        return rectangle;
    }

    private void invalIndex(int n) {
        Rectangle rectangle = this.getListArea();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-1, -1);
        rectangle2.y += (n - this.fCurrentY) * this.fCellHeight;
        rectangle2.height = this.fCellHeight - 1;
        rectangle2 = rectangle.intersection(rectangle2);
        this.repaint(5L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    private void invalItemString(int n) {
        Rectangle rectangle = this.getListArea();
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.fHiliteItemHilite) {
            ++rectangle2.x;
            rectangle2.width -= 2;
            rectangle2.y += (n - this.fCurrentY) * this.fCellHeight + 1;
            rectangle2.height = this.fCellHeight - 1;
        } else {
            rectangle2.y += (n - this.fCurrentY) * this.fCellHeight + 1;
            rectangle2.x += this.fCurrentX + this.fLeftMargin - 1;
            rectangle2.width -= rectangle2.x + 1;
            rectangle2.height = this.fCellHeight - 1;
            rectangle2 = rectangle.intersection(rectangle2);
        }
        this.repaint(5L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    private void invalBelowItem(int n) {
        Rectangle rectangle = this.getListArea();
        int n2 = rectangle.y + (n - this.fCurrentY + 1) * this.fCellHeight;
        this.repaint(5L, rectangle.x + 1, n2 + 1, rectangle.width - 2, rectangle.y + rectangle.height - n2 - 2);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isVisible()) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    private void selectItemIndex(int n) {
        ListItem listItem = (ListItem)this.fList.elementAt(n);
        if (!listItem.fSelected) {
            this.fSelectID = ++this.fSelectCount == 1 ? listItem.fId : -1;
            listItem.fSelected = true;
            this.invalItemString(n);
        }
    }

    private void toggleItem(int n) {
        ListItem listItem = (ListItem)this.fList.elementAt(n);
        if (listItem.fSelected) {
            this.unselectItemIndex(n);
        } else {
            this.selectItemIndex(n);
        }
    }

    private void unselectItemIndex(int n) {
        this.unselectItemIndex(n, true);
    }

    private void unselectItemIndex(int n, boolean bl) {
        ListItem listItem = (ListItem)this.fList.elementAt(n);
        if (listItem.fSelected) {
            if (--this.fSelectCount == 0) {
                this.fSelectID = -1;
            }
            listItem.fSelected = false;
            if (bl) {
                this.invalItemString(n);
            }
        }
    }

    private boolean isIndexSelected(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fSelected;
    }

    public boolean isSelected(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            return ((ListItem)this.fList.elementAt((int)n2)).fSelected;
        }
        return false;
    }

    public void unselectAll() {
        if (this.fSelectID == -1) {
            for (int i = 0; i < this.fList.size(); ++i) {
                this.unselectItemIndex(i);
            }
        } else {
            int n = this.idToIndex(this.fSelectID);
            this.unselectItemIndex(n);
        }
    }

    private String cellString(int n, int n2) {
        return ((ListItem)this.fList.elementAt((int)n)).fString[n2];
    }

    private int cellStringWidth(int n, int n2) {
        return ((ListItem)this.fList.elementAt((int)n)).fStringWidth[n2];
    }

    private void setCellString(int n, int n2, String string) {
        ((ListItem)this.fList.elementAt((int)n)).fString[n2] = string;
    }

    private void setItemStringWidth(int n, int n2, int n3) {
        ((ListItem)this.fList.elementAt((int)n)).fStringWidth[n2] = n3;
    }

    private boolean isTwisted(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fIsTwisted;
    }

    private void setIndexIsTwisted(int n, boolean bl) {
        ((ListItem)this.fList.elementAt((int)n)).fIsTwisted = bl;
    }

    private Image getIndexIcon(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fIcon;
    }

    private int idToIndex(int n) {
        int n2;
        int n3;
        int n4 = -1;
        if (this.fCachedItem != -1) {
            n3 = this.fCachedItem;
            n2 = this.fList.size();
            if (n3 >= 0 && n3 < n2) {
                if (this.id(n3) == n) {
                    n4 = n3;
                } else if (++n3 < n2 && this.id(n3) == n) {
                    n4 = n3;
                } else if ((n3 -= 2) > 0 && this.id(n3) == n) {
                    n4 = n3;
                }
            }
        }
        if (n4 == -1) {
            int n5 = this.fCurrentY - 3;
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n2 = this.fCurrentY + this.getBounds().height / this.fCellHeight + 3) > this.fList.size()) {
                n2 = this.fList.size();
            }
            for (n3 = n5; n3 < n2; ++n3) {
                if (this.id(n3) != n) continue;
                n4 = n3;
                break;
            }
        }
        if (n4 == -1) {
            for (n3 = 0; n3 < this.fList.size(); ++n3) {
                if (this.id(n3) != n) continue;
                n4 = n3;
                break;
            }
        }
        this.fCachedItem = n4;
        return n4;
    }

    public Image getIcon(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            return ((ListItem)this.fList.elementAt((int)n2)).fIcon;
        }
        return null;
    }

    private void setIconIndex(int n, Image image) {
        ((ListItem)this.fList.elementAt((int)n)).fIcon = image;
    }

    public boolean getUseIcons() {
        return this.fUseIcons;
    }

    private void deleteIndex(int n) {
        if (this.fIsTwisty) {
            this.deleteDescendants(n);
        }
        this.unselectItemIndex(n, false);
        this.fList.removeElementAt(n);
        this.redoScrollbars();
        this.invalBelowItem(n - 1);
    }

    private void deleteDescendants(int n) {
        int n2 = this.level(n) + 1;
        int n3 = n + 1;
        while (n3 < this.fList.size() && this.level(n3) >= n2) {
            this.unselectItemIndex(n3, false);
            this.fList.removeElementAt(n3);
        }
        this.redoScrollbars();
    }

    public synchronized void removeDescendants(int n) {
        for (int i = 0; i < this.fList.size(); ++i) {
            if (this.id(i) != n) continue;
            int n2 = this.getVOffset();
            int n3 = this.fList.size();
            this.deleteDescendants(i);
            this.setIndexIsTwisted(i, false);
            this.invalIndex(i);
            Rectangle rectangle = this.getListArea();
            if (n2 + rectangle.height / this.fCellHeight < n3) break;
            this.invalBelowItem(-1);
            this.fCurrentX = this.getHOffset();
            this.fCurrentY = this.getVOffset();
            this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
            break;
        }
    }

    public int[] getChildren(int n) {
        int n2;
        int[] nArray = null;
        if (n == -1) {
            n2 = -1;
        } else {
            for (n2 = 0; n2 < this.fList.size() && this.id(n2) != n; ++n2) {
            }
        }
        if (n == -1 || n2 < this.fList.size() - 1 && this.isTwisted(n2)) {
            int n3;
            int n4 = n == -1 ? -1 : this.level(n2);
            int n5 = 0;
            int n6 = n3 = n2 + 1;
            while (n3 < this.fList.size() && this.level(n3) > n4) {
                if (this.level(n3) == n4 + 1) {
                    ++n5;
                }
                ++n3;
            }
            nArray = new int[n5];
            if (n5 > 0) {
                int n7 = 0;
                for (int i = n6; i < n3; ++i) {
                    if (this.level(i) != n4 + 1) continue;
                    nArray[n7++] = this.id(i);
                }
            }
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getDescendants(int n) {
        int n2;
        int[] nArray = null;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.fList.size(); ++n2) {
            if (this.id(n2) != n) continue;
            int n5 = this.level(n2);
            for (int i = n2 + 1; i < this.fList.size() && this.level(i) > n5; ++i) {
                if (i == n2 + 1) {
                    n4 = n3 = i;
                    continue;
                }
                n3 = i;
            }
        }
        if (n4 == 0 && n3 == 0) {
            nArray = new int[]{};
        } else {
            nArray = new int[n3 - n4 + 1];
            for (n2 = n4; n2 <= n3; ++n2) {
                nArray[n2 - n4] = this.id(n2);
            }
        }
        return nArray;
    }

    public void setItemKiddable(int n, boolean bl) {
        int n2;
        if (this.fIsTwisty && (n2 = this.idToIndex(n)) != -1) {
            if (!bl && this.canHaveKids(n2) && this.isTwisted(n2)) {
                this.removeDescendants(n);
            }
            this.setCanHaveKids(n2, bl);
            this.repaint(5L);
        }
    }

    public boolean isItemKiddable(int n) {
        int n2;
        if (this.fIsTwisty && (n2 = this.idToIndex(n)) != -1) {
            return this.canHaveKids(n2);
        }
        return false;
    }

    public void unselectItem(int n) {
        if (!this.fMultiSelection) {
            this.unselectAll();
            return;
        }
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            this.unselectItemIndex(n2);
        }
    }

    public void selectItem(int n) {
        int n2;
        if (!this.fMultiSelection) {
            this.unselectAll();
        }
        if ((n2 = this.idToIndex(n)) != -1) {
            this.selectItemIndex(n2);
        }
    }

    @Override
    public synchronized void removeAll() {
        this.fSelectID = -1;
        this.fSelectCount = 0;
        this.fList.removeAllElements();
        this.fCurrentX = 0;
        this.fCurrentY = 0;
        this.fNextAvailableID = 200300;
        this.redoScrollbars();
        this.invalBelowItem(-1);
    }

    private void setTwistedIndex(int n, boolean bl) {
        if (this.isTwisted(n) == bl) {
            return;
        }
        this.setIndexIsTwisted(n, bl);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.drawTwisty(graphics, n, false);
            graphics.dispose();
        }
        if (bl) {
            this.processMWTListEvent(new MWTListEvent(this, this.id(n), 1));
        } else {
            this.processMWTListEvent(new MWTListEvent(this, this.id(n), 2));
        }
        if (bl && this.fScrollOnTwist && this.showChildren(n)) {
            return;
        }
        if (this.fAppearance != 0) {
            this.invalBelowItem(n - 1);
        } else {
            this.invalBelowItem(n);
        }
    }

    private void setTwistedItem(int n, boolean bl) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            this.setTwistedIndex(n2, bl);
        }
    }

    public void setItemTwisted(int n, boolean bl) {
        int n2 = this.idToIndex(n);
        if (n2 != -1 && this.isTwisted(n2) != bl) {
            this.setIndexIsTwisted(n2, bl);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.drawTwisty(graphics, n2, false);
                graphics.dispose();
            }
            if (bl && this.fScrollOnTwist && this.showChildren(n2)) {
                return;
            }
            this.invalIndex(n2);
        }
    }

    public boolean isItemTwisted(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            return this.isTwisted(n2);
        }
        return false;
    }

    private boolean canHaveKids(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fCanHaveKids;
    }

    private void setCanHaveKids(int n, boolean bl) {
        ((ListItem)this.fList.elementAt((int)n)).fCanHaveKids = bl;
    }

    private int id(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fId;
    }

    protected void setItemId(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (n3 != -1) {
            ((ListItem)this.fList.elementAt((int)n3)).fId = n2;
        }
    }

    public int getIdForQE(int n) {
        return this.id(n);
    }

    private int level(int n) {
        return ((ListItem)this.fList.elementAt((int)n)).fLevel;
    }

    protected int itemLevel(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            return this.level(n2);
        }
        return 0;
    }

    private int getVOffset() {
        return this.fVScroll.getValue();
    }

    private int getHOffset() {
        if (this.fHScroll != null) {
            return -this.fHScroll.getValue() * this.fFontInfo.charWidth('3');
        }
        return 0;
    }

    private void twistDown(boolean bl) {
        int[] nArray = this.getSelectedIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                this.recursiveTwistDown(nArray[i]);
            }
            if (!this.isItemKiddable(nArray[i]) || this.isItemTwisted(nArray[i])) continue;
            this.setTwistedItem(nArray[i], true);
        }
    }

    private void recursiveTwistDown(int n) {
        if (this.isItemKiddable(n)) {
            if (!this.isItemTwisted(n)) {
                this.setTwistedItem(n, true);
            }
            int[] nArray = this.getChildren(n);
            for (int i = 0; i < nArray.length; ++i) {
                this.recursiveTwistDown(nArray[i]);
            }
        }
    }

    private void twistUp() {
        int[] nArray = this.getSelectedIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.isItemKiddable(nArray[i]) || !this.isItemTwisted(nArray[i])) continue;
            this.setTwistedItem(nArray[i], false);
        }
        if (this.getScrollOnTwist()) {
            this.showFirstSelectedItem();
        }
    }

    private int getFirstSelectedIndex() {
        if (this.fSelectID == -1) {
            int n = this.fList.size();
            for (int i = 0; i < n; ++i) {
                if (!this.isIndexSelected(i)) continue;
                return i;
            }
        } else {
            return this.idToIndex(this.fSelectID);
        }
        return -1;
    }

    private int getLastSelectedIndex() {
        if (this.fSelectID == -1) {
            for (int i = this.fList.size() - 1; i >= 0; --i) {
                if (!this.isIndexSelected(i)) continue;
                return i;
            }
        } else {
            return this.idToIndex(this.fSelectID);
        }
        return -1;
    }

    private int getNextSelectedIndex(int n) {
        int n2 = this.fList.size();
        for (int i = n + 1; i < n2; ++i) {
            if (!this.isIndexSelected(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        boolean bl = keyEvent.isShiftDown();
        switch (n) {
            case 38: {
                int n2 = this.getFirstSelectedIndex();
                if (n2 != -1) {
                    if (bl) {
                        if (n2 < this.fSelectionAnchor && n2 > 0) {
                            this.selectItemIndex(n2 - 1);
                            this.showFirstSelectedItem();
                        } else {
                            n2 = this.getLastSelectedIndex();
                            if (n2 > this.fSelectionAnchor) {
                                this.unselectItemIndex(n2);
                                this.showLastSelectedItem();
                            } else if (n2 > 0) {
                                this.selectItemIndex(n2 - 1);
                                this.showFirstSelectedItem();
                            }
                        }
                    } else if (n2 > 0) {
                        this.unselectAll();
                        this.selectItemIndex(n2 - 1);
                        this.fSelectionAnchor = n2 - 1;
                        this.showFirstSelectedItem();
                    }
                    this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    break;
                }
                if (this.fList.size() <= 0) break;
                this.selectItemIndex(this.fList.size() - 1);
                this.fSelectionAnchor = this.fList.size() - 1;
                this.showFirstSelectedItem();
                this.processItemEvent(new ItemEvent(this, 0, this, 1));
                break;
            }
            case 40: {
                int n3 = this.getLastSelectedIndex();
                if (n3 != -1) {
                    if (bl) {
                        if (n3 > this.fSelectionAnchor && n3 < this.fList.size() - 1) {
                            this.selectItemIndex(n3 + 1);
                            this.showLastSelectedItem();
                        } else {
                            n3 = this.getFirstSelectedIndex();
                            if (n3 < this.fSelectionAnchor) {
                                this.unselectItemIndex(n3);
                                this.showFirstSelectedItem();
                            } else if (n3 < this.fList.size() - 1) {
                                this.selectItemIndex(n3 + 1);
                                this.showLastSelectedItem();
                            }
                        }
                    } else if (n3 < this.fList.size() - 1) {
                        this.unselectAll();
                        this.fSelectionAnchor = n3 + 1;
                        this.selectItemIndex(n3 + 1);
                        this.showFirstSelectedItem();
                    }
                    this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    break;
                }
                if (this.fList.size() <= 0) break;
                this.selectItemIndex(0);
                this.fSelectionAnchor = 0;
                this.showFirstSelectedItem();
                this.processItemEvent(new ItemEvent(this, 0, this, 1));
                break;
            }
            case 37: 
            case 109: {
                this.twistUp();
                break;
            }
            case 39: 
            case 107: {
                this.twistDown(false);
                break;
            }
            case 106: {
                this.twistDown(true);
                break;
            }
            case 10: {
                this.processActionEvent(new ActionEvent(this, 0, this.getActionCommand()));
                break;
            }
            case 33: {
                if (this.fKeyScrollSelect) {
                    int n4 = this.getFirstSelectedIndex();
                    int n5 = n4 == -1 ? this.getTopItem() - this.fVScroll.getBlockIncrement() : (n4 == this.getTopItem() ? n4 - this.fVScroll.getBlockIncrement() : this.getTopItem());
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (bl) {
                        for (n4 = this.fSelectionAnchor - 1; n4 >= n5; --n4) {
                            this.selectItemIndex(n4);
                        }
                        for (n4 = this.getLastSelectedIndex(); n4 > this.fSelectionAnchor; --n4) {
                            this.unselectItemIndex(n4);
                        }
                    } else {
                        this.unselectAll();
                        this.fSelectionAnchor = n5;
                        this.selectItemIndex(n5);
                    }
                    this.showFirstSelectedItem();
                    this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    break;
                }
                if (this.fVScroll == null) break;
                int n6 = this.fVScroll.getValue() - this.fVScroll.getBlockIncrement();
                if (n6 < this.fVScroll.getMinimum()) {
                    n6 = this.fVScroll.getMinimum();
                }
                if (n6 == this.fVScroll.getValue()) break;
                this.fVScroll.setValue(n6);
                this.adjustmentValueChanged(new AdjustmentEvent(this.fVScroll, 601, 3, n6));
                break;
            }
            case 34: {
                if (this.fKeyScrollSelect) {
                    int n7 = this.getLastSelectedIndex();
                    int n8 = n7 == -1 ? this.getBottomItem() + this.fVScroll.getBlockIncrement() : (n7 >= this.getBottomItem() - 1 ? n7 + this.fVScroll.getBlockIncrement() : this.getBottomItem());
                    if (n8 >= this.fList.size()) {
                        n8 = this.fList.size() - 1;
                    }
                    if (bl) {
                        for (n7 = this.fSelectionAnchor + 1; n7 <= n8; ++n7) {
                            this.selectItemIndex(n7);
                        }
                        for (n7 = this.getFirstSelectedIndex(); n7 < this.fSelectionAnchor; ++n7) {
                            this.unselectItemIndex(n7);
                        }
                    } else {
                        this.unselectAll();
                        this.fSelectionAnchor = n8;
                        this.selectItemIndex(n8);
                    }
                    this.showLastSelectedItem();
                    this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    break;
                }
                if (this.fVScroll == null) break;
                int n9 = this.fVScroll.getValue() + this.fVScroll.getBlockIncrement();
                if (n9 > this.fVScroll.getMaximum()) {
                    n9 = this.fVScroll.getMaximum();
                }
                if (n9 == this.fVScroll.getValue()) break;
                this.fVScroll.setValue(n9);
                this.adjustmentValueChanged(new AdjustmentEvent(this.fVScroll, 601, 4, n9));
                break;
            }
            case 36: {
                if (this.fVScroll != null && this.fVScroll.getValue() != this.fVScroll.getMinimum()) {
                    this.fVScroll.setValue(this.fVScroll.getMinimum());
                    this.adjustmentValueChanged(new AdjustmentEvent(this.fVScroll, 601, 5, this.fVScroll.getValue()));
                }
                if (!this.fKeyScrollSelect) break;
                int n10 = this.getFirstSelectedIndex();
                if (n10 != -1 && bl) {
                    for (n10 = this.fSelectionAnchor - 1; n10 >= 0; --n10) {
                        this.selectItemIndex(n10);
                    }
                    for (n10 = this.getLastSelectedIndex(); n10 > this.fSelectionAnchor; --n10) {
                        this.unselectItemIndex(n10);
                    }
                } else if (this.fList.size() > 0) {
                    this.unselectAll();
                    this.selectItemIndex(0);
                    this.fSelectionAnchor = 0;
                }
                this.processItemEvent(new ItemEvent(this, 0, this, 1));
                break;
            }
            case 35: {
                if (this.fVScroll != null && this.fVScroll.getValue() != this.fVScroll.getMaximum()) {
                    this.fVScroll.setValue(this.fVScroll.getMaximum());
                    this.adjustmentValueChanged(new AdjustmentEvent(this.fVScroll, 601, 5, this.fVScroll.getValue()));
                }
                if (!this.fKeyScrollSelect) break;
                int n11 = this.getLastSelectedIndex();
                if (n11 != -1 && bl) {
                    for (n11 = this.fSelectionAnchor + 1; n11 < this.fList.size(); ++n11) {
                        this.selectItemIndex(n11);
                    }
                    for (n11 = this.getFirstSelectedIndex(); n11 < this.fSelectionAnchor; ++n11) {
                        this.unselectItemIndex(n11);
                    }
                } else if (this.fList.size() > 0) {
                    this.unselectAll();
                    this.selectItemIndex(this.fList.size() - 1);
                    this.fSelectionAnchor = this.fList.size() - 1;
                }
                this.processItemEvent(new ItemEvent(this, 0, this, 1));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fDoDeselect && (Math.abs(this.fStartPoint.x - mouseEvent.getX()) > 2 || Math.abs(this.fStartPoint.y - mouseEvent.getY()) > 2 || this.fTwistyClicked != -1 || this.fColumnResize != -1)) {
            this.fDoDeselect = false;
        }
        if (this.fTwistyClicked != -1) {
            Rectangle rectangle = this.getListArea();
            Rectangle rectangle2 = new Rectangle();
            Graphics graphics = this.getGraphics();
            rectangle2.x = rectangle.x + this.fCurrentX;
            if (this.fAppearance != 0) {
                rectangle2.x += this.level(this.fTwistyClicked) * this.fLevelIndent;
                if (this.fAppearance == 1) {
                    ++rectangle2.x;
                }
            }
            rectangle2.y = rectangle.y + (this.fTwistyClicked - this.fCurrentY) * this.fCellHeight;
            rectangle2.width = 14;
            rectangle2.height = this.fCellHeight;
            if (rectangle2.contains(mouseEvent.getPoint())) {
                this.drawTwisty(graphics, this.fTwistyClicked, true);
            } else {
                this.drawTwisty(graphics, this.fTwistyClicked, false);
            }
            if (graphics != null) {
                graphics.dispose();
            }
        } else if (this.fColumnResize != -1) {
            this.drawResizeLine();
            this.fResizeX = mouseEvent.getX();
            if (this.fResizeX < this.fMinimumX) {
                this.fResizeX = this.fMinimumX;
            }
            this.drawResizeLine();
        }
    }

    private boolean clickItemPrep(MouseEvent mouseEvent, int n, boolean bl) {
        int n2;
        Rectangle rectangle = this.getListArea();
        rectangle.y += (mouseEvent.getY() - this.fHeaderHeight) / this.fCellHeight * this.fCellHeight;
        rectangle.height = this.fCellHeight;
        int n3 = 0;
        int n4 = this.fCurrentX;
        for (int i = 0; i < this.fColumnCount; ++i) {
            if (mouseEvent.getX() >= (n4 += this.fColumnWidths[i])) continue;
            n3 = i;
            break;
        }
        rectangle.x = n4 - this.fColumnWidths[n3];
        if (n3 == 0) {
            if (this.fIsTwisty) {
                n2 = this.fLeftMargin + this.itemLevel(n) * this.fLevelIndent;
                if (this.fAppearance == 1) {
                    ++n2;
                }
            } else {
                n2 = this.fLeftMargin;
            }
        } else {
            n2 = 0;
        }
        rectangle.x += n2;
        rectangle.width = this.fColumnCount > 1 ? this.fColumnWidths[n3] - 3 : (rectangle.width -= n2);
        if (rectangle.width < 0) {
            rectangle.width = 0;
        }
        if (bl) {
            return this.releaseItem(mouseEvent, n, n3, rectangle);
        }
        return this.clickItem(mouseEvent, n, n3, rectangle);
    }

    public boolean clickItem(MouseEvent mouseEvent, int n, int n2, Rectangle rectangle) {
        return false;
    }

    public boolean releaseItem(MouseEvent mouseEvent, int n, int n2, Rectangle rectangle) {
        return false;
    }

    @Override
    public void mouseWheelTurned(int n, int n2) {
        if (n2 == 0 && this.fVScroll != null && this.fVScroll.isEnabled()) {
            int n3 = this.fVScroll.getValue() + n;
            if (n3 > this.fVScroll.getMaximum()) {
                n3 = this.fVScroll.getMaximum();
            }
            if (n3 != this.fVScroll.getValue()) {
                this.fVScroll.setValue(n3);
                this.adjustmentValueChanged(new AdjustmentEvent(this.fVScroll, 601, 4, n3));
            }
        }
    }

    private void drawResizeLine() {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        graphics.setXORMode(this.getBackground());
        graphics.drawLine(this.fResizeX, rectangle.y, this.fResizeX, rectangle.y + rectangle.height);
        graphics.dispose();
    }

    private void handleHeaderClick(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = this.fCurrentX;
        for (int i = 0; i < this.fHeaders.length; ++i) {
            if (n <= (n2 += this.fColumnWidths[i]) - 7 || n >= n2 + 2) continue;
            this.fResizeX = mouseEvent.getX();
            this.fMinimumX = n2 - this.fColumnWidths[i] + 5;
            this.drawResizeLine();
            this.fColumnResize = i;
            break;
        }
    }

    private void processDoubleClickAction(ActionEvent actionEvent) {
        long l = System.currentTimeMillis();
        if (l - this.fLastClickTime < 500L) {
            this.processActionEvent(actionEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.fTwistyClicked = -1;
        this.fColumnResize = -1;
        boolean bl = PlatformInfo.getPlatform() == 0 ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
        this.fDoDeselect = !mouseEvent.isShiftDown() && !bl && (mouseEvent.getModifiers() & 0x10) != 0;
        this.fStartPoint = mouseEvent.getPoint();
        Rectangle rectangle = this.getListArea();
        int n = mouseEvent.getX() - rectangle.x + this.fCurrentX;
        int n2 = mouseEvent.getY() - rectangle.y;
        int n3 = n2 / this.fCellHeight + this.fCurrentY;
        if (this.fUseHeader && mouseEvent.getY() < this.fHeaderHeight) {
            this.handleHeaderClick(mouseEvent);
        } else if (n2 < 0 || n3 >= this.fList.size() || n3 < 0) {
            if (!this.fMultiSelection || !mouseEvent.isShiftDown() && !bl) {
                this.unselectAll();
                this.fSelectionAnchor = -1;
                this.processItemEvent(new ItemEvent(this, 0, this, 2));
            }
        } else {
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x + this.fCurrentX;
            if (this.fAppearance != 0) {
                rectangle2.x += this.level(n3) * this.fLevelIndent;
                if (this.fAppearance == 1) {
                    ++rectangle2.x;
                }
            }
            rectangle2.y = rectangle.y + (n3 - this.fCurrentY) * this.fCellHeight;
            rectangle2.width = this.canHaveKids(n3) ? 14 : 0;
            rectangle2.height = this.fCellHeight;
            Rectangle rectangle3 = new Rectangle();
            rectangle3.x = rectangle.x + this.fCurrentX + this.fLeftMargin + this.level(n3) * this.fLevelIndent;
            if (this.fAppearance == 1) {
                ++rectangle3.x;
            }
            rectangle3.width = this.cellStringWidth(n3, 0);
            if (this.getIndexIcon(n3) != null) {
                rectangle3.x -= 20;
                rectangle3.width += 20;
            }
            rectangle3.y = rectangle.y + (n3 - this.fCurrentY) * this.fCellHeight;
            rectangle3.height = this.fCellHeight;
            if (!(this.fWholeItemSelect || (this.fIsTwisty || mouseEvent.getX() >= rectangle3.x && mouseEvent.getX() <= rectangle3.x + rectangle3.width) && (!this.fIsTwisty || rectangle2.contains(mouseEvent.getPoint()) || rectangle3.contains(mouseEvent.getPoint())))) {
                if (!this.fMultiSelection || !mouseEvent.isShiftDown() && !bl) {
                    this.unselectAll();
                    this.fSelectionAnchor = -1;
                    this.processItemEvent(new ItemEvent(this, 0, this, 2));
                }
                return;
            }
            if (this.fMultiSelection && mouseEvent.isShiftDown()) {
                if (this.fSelectionAnchor == -1 || this.fSelectionAnchor == n3) {
                    if (this.isIndexSelected(n3)) {
                        this.processDoubleClickAction(new ActionEvent(this, 0, this.getActionCommand(), mouseEvent.getModifiers()));
                    } else {
                        this.selectItemIndex(n3);
                        this.fSelectionAnchor = n3;
                        if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                            this.processItemEvent(new ItemEvent(this, 0, this, 1));
                        }
                    }
                } else if (this.fSelectionAnchor < n3) {
                    this.unselectAll();
                    for (int i = this.fSelectionAnchor; i <= n3; ++i) {
                        this.selectItemIndex(i);
                    }
                    if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                        this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    }
                    if (this.fKeyScrollSelect) {
                        this.processDoubleClickAction(new ActionEvent(this, 0, this.getActionCommand(), mouseEvent.getModifiers()));
                    }
                } else if (this.fSelectionAnchor > n3) {
                    this.unselectAll();
                    for (int i = this.fSelectionAnchor; i >= n3; --i) {
                        this.selectItemIndex(i);
                    }
                    if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                        this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    }
                    if (this.fKeyScrollSelect) {
                        this.processDoubleClickAction(new ActionEvent(this, 0, this.getActionCommand(), mouseEvent.getModifiers()));
                    }
                } else if (this.fLastClickedItem == n3) {
                    if (this.isIndexSelected(n3)) {
                        this.processDoubleClickAction(new ActionEvent(this, 0, this.getActionCommand(), mouseEvent.getModifiers()));
                    } else {
                        this.selectItemIndex(n3);
                        this.fSelectionAnchor = n3;
                        if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                            this.processItemEvent(new ItemEvent(this, 0, this, 1));
                        }
                    }
                }
            } else if (bl) {
                if (this.fMultiSelection) {
                    this.toggleItem(n3);
                    if (this.isIndexSelected(n3)) {
                        this.fSelectionAnchor = n3;
                        if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                            this.processItemEvent(new ItemEvent(this, 0, this, 1));
                        }
                    } else {
                        if (this.getFirstSelectedIndex() == -1) {
                            this.fSelectionAnchor = -1;
                        }
                        this.processItemEvent(new ItemEvent(this, 0, this, 2));
                    }
                } else {
                    if (this.isIndexSelected(n3)) {
                        this.toggleItem(n3);
                    } else {
                        this.unselectAll();
                        this.selectItemIndex(n3);
                    }
                    if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                        this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    }
                }
                if (this.fKeyScrollSelect && this.hasSelection()) {
                    this.processDoubleClickAction(new ActionEvent(this, 0, this.getActionCommand(), mouseEvent.getModifiers()));
                }
            } else if (this.canHaveKids(n3) && rectangle2.contains(mouseEvent.getPoint())) {
                this.fTwistyClicked = n3;
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    this.drawTwisty(graphics, this.fTwistyClicked, true);
                    graphics.dispose();
                }
            } else if (!this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                if (this.isIndexSelected(n3)) {
                    long l = System.currentTimeMillis();
                    if (l - this.fLastClickTime < 500L) {
                        this.processActionEvent(new ActionEvent(this, 0, this.getActionCommand()));
                    } else if (this.fDoDeselect && this.getFirstSelectedIndex() == n3 && this.getNextSelectedIndex(n3) == -1) {
                        this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    }
                } else {
                    this.unselectAll();
                    this.selectItemIndex(n3);
                    this.fSelectionAnchor = n3;
                    if (!this.fImmediateClick || !this.clickItemPrep(mouseEvent, this.id(n3), false)) {
                        this.processItemEvent(new ItemEvent(this, 0, this, 1));
                    }
                }
            }
            this.fLastClickedItem = n3;
            this.fLastClickTime = System.currentTimeMillis();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fTwistyClicked != -1) {
            Rectangle rectangle = this.getListArea();
            int n = mouseEvent.getY() - rectangle.y;
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x + this.fCurrentX;
            if (this.fAppearance != 0) {
                rectangle2.x += this.level(this.fTwistyClicked) * this.fLevelIndent;
                if (this.fAppearance == 1) {
                    ++rectangle2.x;
                }
            }
            rectangle2.y = rectangle.y + (this.fTwistyClicked - this.fCurrentY) * this.fCellHeight;
            rectangle2.width = 14;
            rectangle2.height = this.fCellHeight;
            int n2 = n / this.fCellHeight + this.fCurrentY;
            if (n2 == this.fTwistyClicked && rectangle2.contains(mouseEvent.getPoint())) {
                if (this.fAppearance == 0) {
                    Graphics graphics = this.getGraphics();
                    this.drawIntermediateTwisty(graphics, n2);
                    graphics.dispose();
                    long l = System.currentTimeMillis();
                    while (System.currentTimeMillis() < l + 33L) {
                    }
                }
                this.setTwistedIndex(n2, !this.isTwisted(n2));
            }
            this.fTwistyClicked = -1;
        } else if (this.fColumnResize != -1) {
            this.drawResizeLine();
            int n = this.fCurrentX;
            for (int i = 0; i < this.fColumnResize; ++i) {
                n += this.fColumnWidths[i];
            }
            this.fColumnWidths[this.fColumnResize] = this.fResizeX - n;
            this.fColumnResize = -1;
            this.redoScrollbars();
            this.repaint(5L);
        } else {
            Rectangle rectangle = this.getListArea();
            int n = mouseEvent.getX() - rectangle.x + this.fCurrentX;
            int n3 = mouseEvent.getY() - rectangle.y;
            int n4 = n3 / this.fCellHeight + this.fCurrentY;
            if (n3 >= 0 && n4 < this.fList.size() && n4 >= 0) {
                if (this.fDoDeselect && this.fAppearance != 0 && (!this.isIndexSelected(n4) || this.getFirstSelectedIndex() != n4 || this.getNextSelectedIndex(n4) != -1)) {
                    this.unselectAll();
                    this.selectItemIndex(n4);
                    this.processItemEvent(new ItemEvent(this, 0, this, 1));
                }
                this.clickItemPrep(mouseEvent, this.id(n4), true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (!this.fUseHeader || mouseEvent.getY() > this.fHeaderHeight) {
            if (this.getCursor() == Cursor.getPredefinedCursor(11)) {
                this.setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = this.fCurrentX;
        for (n = 0; n < this.fHeaders.length; ++n) {
            if (n2 <= (n3 += this.fColumnWidths[n]) - 7 || n2 >= n3 + 2) continue;
            this.setCursor(Cursor.getPredefinedCursor(11));
            break;
        }
        if (n >= this.fHeaders.length && this.getCursor() == Cursor.getPredefinedCursor(11)) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this.fActionListener != null) {
            this.fActionListener.actionPerformed(actionEvent);
        }
    }

    public String getActionCommand() {
        return this.fActionCommand;
    }

    public void setActionCommand(String string) {
        this.fActionCommand = string;
    }

    public int[] getSelectedIds() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.fList.size(); ++n) {
            if (!this.isIndexSelected(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (n = 0; n < this.fList.size(); ++n) {
            if (!this.isIndexSelected(n)) continue;
            nArray[n2++] = this.id(n);
        }
        return nArray;
    }

    @Override
    public Object[] getSelectedObjects() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.fList.size(); ++n) {
            if (!this.isIndexSelected(n)) continue;
            ++n2;
        }
        Object[] objectArray = new String[n2];
        n2 = 0;
        for (n = 0; n < this.fList.size(); ++n) {
            if (!this.isIndexSelected(n)) continue;
            objectArray[n2++] = new String(this.cellString(n, 0));
        }
        return objectArray;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public void processItemEvent(ItemEvent itemEvent) {
        if (this.fItemListener != null) {
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized void addMWTListListener(MWTListListener mWTListListener) {
        this.fPopListener = mWTListListener;
    }

    public synchronized void removeMWTListListener(MWTListListener mWTListListener) {
        this.fPopListener = null;
    }

    public void processMWTListEvent(MWTListEvent mWTListEvent) {
        if (this.fPopListener != null) {
            int n = mWTListEvent.getEventType();
            if (n == 1) {
                this.fPopListener.expandItem(mWTListEvent);
            } else if (n == 2) {
                this.fPopListener.collapseItem(mWTListEvent);
            } else if (n == 3) {
                this.fPopListener.scrollList(mWTListEvent);
            }
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl = false;
        MWScrollbar mWScrollbar = (MWScrollbar)adjustmentEvent.getAdjustable();
        if (mWScrollbar == this.fVScroll || mWScrollbar == this.fHScroll) {
            ++this.fInvalCount;
            if (this.fInvalCount > 1) {
                if (this.fInvalCount <= 2) {
                    this.repaint(5L);
                }
                int n = this.fCurrentX;
                int n2 = this.fCurrentY;
                this.fCurrentX = this.getHOffset();
                this.fCurrentY = this.getVOffset();
                if (n != this.fCurrentX || n2 != this.fCurrentY) {
                    this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
                }
                return;
            }
            Rectangle rectangle = this.getListArea();
            rectangle.grow(-1, -1);
            if (this.fAppearance == 1) {
                ++rectangle.x;
                --rectangle.width;
                if (!PlatformInfo.useWindowsXPAppearance()) {
                    ++rectangle.y;
                    --rectangle.height;
                    if (!this.fHScroll.isVisible()) {
                        --rectangle.height;
                    }
                }
                if (!this.fVScroll.isVisible()) {
                    --rectangle.width;
                }
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            Rectangle rectangle3 = new Rectangle(rectangle);
            int n = -this.fCurrentX + this.getHOffset();
            int n3 = (this.fCurrentY - this.getVOffset()) * this.fCellHeight;
            if (n3 < 0) {
                rectangle2.y = rectangle.y + rectangle.height + n3;
                if (rectangle2.y < rectangle.y) {
                    rectangle2.y = rectangle.y;
                }
                rectangle2.height = -n3;
                if (rectangle2.height > rectangle.height) {
                    rectangle2.height = rectangle.height;
                }
                rectangle.y -= n3;
                rectangle.height += n3;
            } else if (n3 > 0) {
                rectangle2.height = n3;
                if (rectangle2.height > rectangle.height) {
                    rectangle2.height = rectangle.height;
                }
                rectangle.height -= n3;
            }
            if (n != 0 && this.fUseHeader && this.fAlignHeaderWithText) {
                rectangle3.y -= this.fHeaderHeight;
                rectangle3.height += this.fHeaderHeight;
                rectangle.y -= this.fHeaderHeight;
                rectangle.height += this.fHeaderHeight;
                bl = true;
            }
            if (n < 0) {
                rectangle3.x = rectangle.x + rectangle.width + n;
                if (rectangle3.x < rectangle.x) {
                    rectangle3.x = rectangle.x;
                }
                rectangle3.width = -n;
                if (rectangle3.width > rectangle.width) {
                    rectangle3.width = rectangle.width;
                }
                rectangle.x -= n;
                rectangle.width += n;
            } else if (n > 0) {
                rectangle3.width = n;
                if (rectangle3.width > rectangle.width) {
                    rectangle3.width = rectangle.width;
                }
                rectangle.width -= n;
            }
            if (n != 0 && this.fUseHeader && this.fVScroll.isVisible()) {
                rectangle3.width += 16;
                if (this.fAppearance != 1) {
                    ++rectangle3.width;
                }
            }
            this.getToolkit().sync();
            Graphics graphics = this.getGraphics();
            if (bl) {
                this.paint(graphics);
            } else {
                if (rectangle.height > rectangle.y && rectangle.width > rectangle.x) {
                    graphics.copyArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n3);
                }
                this.fCurrentX = this.getHOffset();
                this.fCurrentY = this.getVOffset();
                if (n != 0) {
                    graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.paint(graphics);
                }
                if (n3 != 0) {
                    graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    this.paint(graphics);
                }
            }
            graphics.dispose();
            if (n3 != 0 || n != 0) {
                this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
            }
        }
    }

    public int getTopItem() {
        return this.fCurrentY;
    }

    public int getBottomItem() {
        int n;
        int n2 = this.getBounds().height;
        if (this.fHScroll.isVisible()) {
            n2 -= 16;
            if (this.fAppearance == 1) {
                --n2;
                if (!PlatformInfo.useWindowsXPAppearance()) {
                    --n2;
                }
            }
        }
        if ((n = this.fCurrentY + (n2 - this.fCellHeight + 1) / this.fCellHeight) >= this.fList.size()) {
            n = this.fList.size() - 1;
        }
        return n;
    }

    public void setTopItem(int n) {
        this.fCurrentY = n;
        this.fVScroll.setValue(n);
        this.repaint(5L);
    }

    public void showBottom() {
        this.fCurrentY = this.fVScroll.getMaximum();
        this.fVScroll.setValue(this.fCurrentY);
        this.repaint(5L);
    }

    public int getHorizontalScroll() {
        return this.fCurrentX;
    }

    public int getVerticalScroll() {
        return this.fCurrentY;
    }

    private void drawIntermediateTwisty(Graphics graphics, int n) {
        int[] nArray = new int[]{2, 9, 9, 2};
        int[] nArray2 = new int[]{-2, -2, -9, -2};
        if (this.fAppearance != 0) {
            return;
        }
        Rectangle rectangle = this.getListArea();
        rectangle.grow(-1, -1);
        Shape shape = graphics.getClip();
        this.clipRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.fCurrentY;
        int n3 = rectangle.y - 1 + (n - n2 + 1) * this.fCellHeight - (this.fCellHeight - 10) / 2;
        nArray2[0] = nArray2[0] + n3;
        nArray2[1] = nArray2[1] + n3;
        nArray2[2] = nArray2[2] + n3;
        nArray2[3] = nArray2[3] + n3;
        int n4 = rectangle.x + this.fCurrentX;
        nArray[0] = nArray[0] + n4;
        nArray[1] = nArray[1] + n4;
        nArray[2] = nArray[2] + n4;
        nArray[3] = nArray[3] + n4;
        Color color = new Color(156, 156, 255);
        this.setTwistyBackColor(graphics, n);
        graphics.fillRect(this.fCurrentX + rectangle.x, rectangle.y + (n - n2) * this.fCellHeight + 1, 14, this.fCellHeight - 4);
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, 4);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 4);
        this.setClip(graphics, shape);
    }

    private void setTwistyBackColor(Graphics graphics, int n) {
        if (this.fHiliteItemHilite && this.isIndexSelected(n)) {
            graphics.setColor(Decorations.getColor(4));
        } else if (this.fSortColumnColor != null && this.fColumnWidths[0] > 0) {
            graphics.setColor(this.fSortColumnColor);
        } else {
            graphics.setColor(Decorations.getColor(2));
        }
    }

    protected Color getListBGColor() {
        if (this.fListColor == null) {
            return Decorations.getColor(2);
        }
        return this.fListColor;
    }

    private void drawTwisty(Graphics graphics, int n, boolean bl) {
        if (graphics == null) {
            return;
        }
        if (this.isTwisted(n) || this.canHaveKids(n)) {
            Rectangle rectangle = this.getListArea();
            Shape shape = graphics.getClip();
            this.clipRect(graphics, rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            int n2 = rectangle.y + (n - this.fCurrentY + 1) * this.fCellHeight - (this.fCellHeight - 10) / 2;
            int n3 = rectangle.x + this.fCurrentX;
            if (this.fAppearance != 0) {
                n3 += this.level(n) * this.fLevelIndent;
                if (this.fAppearance == 1) {
                    ++n3;
                }
            }
            this.setTwistyBackColor(graphics, n);
            graphics.fillRect(n3 + 1, rectangle.y + (n - this.fCurrentY) * this.fCellHeight + 2, 14, this.fCellHeight - 5);
            if (this.fAppearance == 0) {
                int[] nArray = new int[]{5, 5, 10, 5};
                int[] nArray2 = new int[]{-1, -11, -6, -1};
                if (this.isTwisted(n)) {
                    n3 -= 3;
                    nArray[1] = nArray[1] + 10;
                    n2 -= 7;
                    nArray2[1] = nArray2[1] + 10;
                    nArray2[2] = nArray2[2] + 10;
                }
                graphics.translate(n3, n2);
                if (bl) {
                    graphics.setColor(TWISTY_SELECTED_COLOR);
                } else {
                    graphics.setColor(TWISTY_COLOR);
                }
                graphics.fillPolygon(nArray, nArray2, nArray.length);
                graphics.setColor(Color.black);
                graphics.drawPolygon(nArray, nArray2, nArray.length);
                graphics.translate(-n3, -n2);
            } else {
                if (this.fDrawTreeLines) {
                    if (this.fAppearance == 1) {
                        graphics.setColor(Decorations.getColor(9));
                    } else {
                        graphics.setColor(Color.gray);
                    }
                    graphics.drawLine(n3 + 10, n2 - 5, n3 + 18, n2 - 5);
                    graphics.drawLine(n3 + 6, n2, n3 + 6, n2);
                    if (n != 0) {
                        graphics.drawLine(n3 + 6, n2 - this.fCellHeight, n3 + 6, n2 - 10);
                    }
                }
                int n4 = 9;
                int n5 = 9;
                graphics.translate(n3 += 2, n2 -= 9);
                if (this.fAppearance == 1) {
                    if (bl) {
                        graphics.setColor(Color.black);
                    } else {
                        graphics.setColor(Color.white);
                    }
                    graphics.fillRect(1, 1, n5 - 2, n4 - 2);
                    if (!PlatformInfo.useWindowsXPAppearance()) {
                        graphics.setColor(Decorations.getColor(9));
                        graphics.drawRect(0, 0, n5 - 1, n4 - 1);
                    } else {
                        graphics.setColor(XP_BORDER);
                        graphics.drawRect(0, 0, n5 - 1, n4 - 1);
                        graphics.setColor(XP_CORNER);
                        graphics.drawLine(0, 0, 0, 0);
                        graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
                        graphics.drawLine(0, n4 - 1, 0, n4 - 1);
                        graphics.drawLine(n5 - 1, n4 - 1, n5 - 1, n4 - 1);
                        if (!bl) {
                            graphics.setColor(XP_GRAY1);
                            graphics.drawLine(2, n4 - 2, n5 - 2, n4 - 2);
                            graphics.setColor(XP_GRAY2);
                            graphics.drawLine(2, n4 - 3, n5 - 3, n4 - 3);
                            graphics.drawLine(n5 - 2, 3, n5 - 2, n4 - 3);
                            graphics.drawLine(1, n4 - 2, 1, n4 - 2);
                            graphics.setColor(XP_GRAY3);
                            graphics.fillRect(1, 3, 6, 3);
                            graphics.drawLine(1, n4 - 3, 1, n4 - 3);
                            graphics.drawLine(n5 - 2, 2, n5 - 2, 2);
                        }
                    }
                } else {
                    if (bl) {
                        graphics.setColor(Color.black);
                    } else {
                        graphics.setColor(Color.lightGray);
                    }
                    graphics.fillRect(1, 1, n5 - 2, n4 - 2);
                    graphics.setColor(Color.gray);
                    graphics.drawRect(0, 0, n5 - 1, n4 - 1);
                }
                if (bl) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawLine(2, 4, n5 - 3, 4);
                if (this.canHaveKids(n) && !this.isTwisted(n)) {
                    graphics.drawLine(4, 2, 4, n4 - 3);
                }
                graphics.translate(-n3, -n2);
            }
            this.setClip(graphics, shape);
        }
    }

    private void redoScrollbars() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle;
        if (this.fCellHeight == 0) {
            return;
        }
        Rectangle rectangle2 = rectangle = this.fVScrollBoundsAWT != null ? this.fVScrollBoundsAWT : this.fVScroll.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n6 = this.fList.size() - rectangle.height / this.fCellHeight;
        if (this.fVScroll.getMaximum() != n6) {
            this.fVScroll.setMaximum(n6);
        }
        if ((n5 = rectangle.height / this.fCellHeight) != this.fVScroll.getVisibleAmount()) {
            this.fVScroll.setVisibleAmount(n5);
        }
        if (this.fVScroll.getMaximum() == this.fVScroll.getMinimum()) {
            this.fVScrollVisAWT = false;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                n4 = this.fCurrentY;
                this.fCurrentY = 0;
                this.repaint();
                if (this.fCurrentY != n4) {
                    this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
                }
            }
        } else {
            this.fVScrollVisAWT = true;
            if (this.fVScroll.isVisible() != this.fVScrollVisAWT) {
                this.fVScroll.repaint();
            }
        }
        int n7 = 0;
        if (this.fColumnCount > 1) {
            if (this.fColumnWidths[0] == 0) {
                rectangle = this.getBounds();
                for (n4 = 0; n4 < this.fColumnCount; ++n4) {
                    this.fColumnWidths[n4] = (rectangle.width - 30) / this.fColumnCount;
                }
                n7 = rectangle.width;
            } else {
                for (n4 = 0; n4 < this.fColumnCount; ++n4) {
                    n7 += this.fColumnWidths[n4];
                }
            }
        } else {
            for (n4 = 0; n4 < this.fList.size(); ++n4) {
                n3 = this.fLeftMargin + this.level(n4) * this.fLevelIndent;
                for (int i = 0; i < this.fColumnCount; ++i) {
                    n3 += this.cellStringWidth(n4, i);
                }
                if (n7 >= n3) continue;
                n7 = n3;
            }
        }
        rectangle = this.fHScrollBoundsAWT != null ? this.fHScrollBoundsAWT : this.fHScroll.getBounds();
        n6 = (n7 - rectangle.width) / this.fFontInfo.charWidth('3') + 1;
        if (this.fHScroll.getMaximum() != n6) {
            this.fHScroll.setMaximum(n6);
        }
        n3 = rectangle.width / this.fFontInfo.charWidth('3');
        if (this.fHScroll.getVisibleAmount() != n3) {
            this.fHScroll.setVisibleAmount(n3);
        }
        if (this.fHScroll.getMaximum() == this.fHScroll.getMinimum()) {
            this.fHScrollVisAWT = false;
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                n4 = this.fCurrentX;
                this.fCurrentX = 0;
                if (this.fCurrentX != n4) {
                    this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
                }
                this.repaint();
            }
        } else {
            this.fHScrollVisAWT = true;
            if (this.fHScroll.isVisible() != this.fHScrollVisAWT) {
                this.fHScroll.repaint();
            }
        }
        boolean bl = this.fVScroll.getMaximum() != this.fVScroll.getMinimum();
        boolean bl2 = this.fHScroll.getMaximum() != this.fHScroll.getMinimum();
        Rectangle rectangle3 = this.getBounds();
        this.fMaxWidth = Math.max(rectangle3.width, n7);
        if (bl2) {
            n2 = 0;
            n = rectangle3.height - 16;
            n3 = rectangle3.width - 16 + 2;
            if (this.fAppearance == 1) {
                n2 += 2;
                n -= 2;
                n3 -= 4;
                if (PlatformInfo.useWindowsXPAppearance()) {
                    --n2;
                    ++n;
                }
            }
            Rectangle rectangle4 = rectangle = this.fHScrollBoundsAWT != null ? this.fHScrollBoundsAWT : this.fHScroll.getBounds();
            if (bl) {
                if (this.fAppearance == 0) {
                    --n3;
                }
                if (rectangle.width != n3 || n != rectangle.y) {
                    rectangle.setBounds(n2, n, n3, 16);
                    this.fHScrollBoundsAWT = rectangle;
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else if (rectangle.width != (n3 += 14) || n != rectangle.y) {
                rectangle.setBounds(n2, n, n3, 16);
                this.fHScrollBoundsAWT = rectangle;
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (bl) {
            rectangle = this.fVScrollBoundsAWT != null ? this.fVScrollBoundsAWT : this.fVScroll.getBounds();
            n5 = rectangle3.height - this.fHeaderHeight - 16 + 1;
            n2 = rectangle3.width - 16;
            n = this.fHeaderHeight;
            if (this.fAppearance == 1) {
                --n2;
                n += 2;
                n5 -= 5;
                if (PlatformInfo.useWindowsXPAppearance()) {
                    --n;
                    n5 += 2;
                }
            }
            if (bl2) {
                if (rectangle.height != n5 || n2 != rectangle.x) {
                    rectangle.setBounds(n2, n, 16, n5);
                    this.fVScrollBoundsAWT = rectangle;
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                if (this.fAppearance == 0) {
                    --n5;
                }
                if (rectangle.height != (n5 += 16) || n2 != rectangle.x) {
                    rectangle.setBounds(n2, n, 16, n5);
                    this.fVScrollBoundsAWT = rectangle;
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        rectangle = this.getListArea();
        n5 = rectangle.height / this.fCellHeight - 1;
        if (n5 != this.fVScroll.getBlockIncrement()) {
            this.fVScroll.setBlockIncrement(n5);
        }
    }

    @Override
    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.width != n3 || rectangle.height != n4 || rectangle.x != n || rectangle.y != n2) {
            super.setBounds(n, n2, n3, n4);
            if (n3 == 0 && n4 == 0) {
                return;
            }
            n2 = 0;
            n = 0;
            int n5 = n4;
            if (this.fHScroll.isVisible() || this.fHScrollVisAWT) {
                n5 -= 16;
            }
            n5 -= this.fHeaderHeight;
            n2 += this.fHeaderHeight;
            n4 -= this.fHeaderHeight;
            if (this.fAppearance == 1) {
                ++n2;
                n5 -= 2;
                n4 -= 2;
                ++n;
                n3 -= 2;
            }
            this.fVScroll.setBounds(n + n3 - 16, n2, 16, n5);
            this.fHScroll.setBounds(n, n2 + n4 - 16, n3 - 16 + 1, 16);
            this.redoScrollbars();
            this.repaint();
        }
    }

    @Override
    public void setSize(Dimension dimension) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
    }

    @Override
    public void setSize(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        super.setFont(font);
        MWTList mWTList = this;
        synchronized (mWTList) {
            this.checkFontInfo();
            this.fFontHeight = 0;
            for (int i = 0; i < this.fList.size(); ++i) {
                for (int j = 0; j < this.fColumnCount; ++j) {
                    this.setItemStringWidth(i, j, -1);
                }
            }
        }
    }

    private void drawTreeLines(Graphics graphics) {
        Rectangle rectangle = this.getListArea();
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = rectangle.x + 1;
        rectangle2.y = rectangle.y + 1;
        rectangle2.width = rectangle.width - 2;
        rectangle2.height = rectangle.height - 2;
        this.clipRect(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        if (this.fAppearance == 1) {
            graphics.setColor(Decorations.getColor(9));
        } else {
            graphics.setColor(Color.gray);
        }
        int n = this.fCurrentY;
        for (int i = 0; i < this.fList.size(); ++i) {
            int n2 = rectangle.y + (i - n + 1) * this.fCellHeight - (this.fCellHeight - 10) / 2;
            int n3 = rectangle.x + this.fCurrentX + this.level(i) * this.fLevelIndent;
            if (this.fAppearance == 1) {
                ++n3;
            }
            int n4 = this.level(i);
            if (this.canHaveKids(i)) {
                graphics.drawLine(n3 + 10, n2 - 5, n3 + 18, n2 - 5);
                n2 -= 10;
            } else {
                graphics.drawLine(n3 + 6, n2 - 5, n3 + 18, n2 - 5);
                n2 -= 5;
            }
            int n5 = rectangle.y;
            n3 += 6;
            for (int j = i - 1; j >= 0; --j) {
                if (this.level(j) > n4) continue;
                n5 = rectangle.y + (j - n + 1) * this.fCellHeight - (this.fCellHeight - 10) / 2;
                if (this.canHaveKids(j)) break;
                n5 -= 5;
                break;
            }
            if (i == 0) continue;
            graphics.drawLine(n3, n2, n3, n5);
        }
        this.setClip(graphics, shape);
    }

    private boolean checkFontInfo() {
        boolean bl = false;
        if (this.fFontHeight == 0) {
            this.fFontInfo = this.getFontMetrics(this.getFont());
            this.fFontHeight = this.fFontInfo.getAscent() + this.fFontInfo.getDescent();
            this.fCellHeight = this.fFontHeight + 3;
            if (this.fUseIcons && this.fCellHeight < 19) {
                this.fCellHeight = 19;
            }
            int n = this.fFontInfo.charWidth('3');
            this.fLevelIndent = n * 3;
            int n2 = this.fHeaderHeight;
            if (this.fUseHeader) {
                this.fHeaderHeight = this.fFontHeight + 5;
            }
            if (n2 != this.fHeaderHeight) {
                Rectangle rectangle = this.getBounds();
                this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            bl = true;
        }
        return bl;
    }

    public int getCellHeight() {
        return this.fCellHeight;
    }

    public void setCellHeight(int n) {
        this.checkFontInfo();
        this.fCellHeight = n;
        Rectangle rectangle = this.getListArea();
        this.fVScroll.setBlockIncrement(rectangle.height / this.fCellHeight - 1);
    }

    public void drawItem(Graphics graphics, int n, int n2, Rectangle rectangle, boolean bl) {
        int n3;
        Image image;
        int n4 = rectangle.x;
        if (this.getUseIcons() && n2 == 0 && (image = this.getIcon(n)) != null) {
            n3 = rectangle.y + (this.getCellHeight() - 16) / 2 + 1;
            if (image != null) {
                graphics.drawImage(image, n4, n3, null);
            }
            n4 = rectangle.x + 20;
        }
        if (this.isSelected(n)) {
            graphics.setColor(Decorations.getColor(5, bl, null));
        } else {
            graphics.setColor(Decorations.getColor(12));
        }
        n3 = rectangle.y + (this.getCellHeight() - this.fFontHeight) / 2 + 1 + this.fFontHeight - this.fFontInfo.getDescent();
        String string = this.getItemString(n, n2);
        graphics.drawString(string, n4, n3);
    }

    private final void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!sIsSGI) {
            graphics.setClip(n, n2, n3, n4);
        }
    }

    private final void setClip(Graphics graphics, Shape shape) {
        if (!sIsSGI) {
            graphics.setClip(shape);
        }
    }

    private final void clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!sIsSGI) {
            graphics.clipRect(n, n2, n3, n4);
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        Graphics graphics2;
        if (PlatformInfo.useWindowsXPAppearance()) {
            Rectangle rectangle;
            Rectangle rectangle2 = null;
            if (this.fVScroll != null && this.fVScrollVisAWT && this.fVScroll.isVisible() && this.fVScrollBoundsAWT == null) {
                rectangle2 = graphics.getClipBounds();
                rectangle = this.fVScroll.getBounds();
                if (rectangle2.x >= rectangle.x && rectangle2.y >= rectangle.y && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                    super.paint(graphics);
                    return;
                }
            }
            if (this.fHScroll != null && this.fHScrollVisAWT && this.fHScroll.isVisible() && this.fHScrollBoundsAWT == null) {
                if (rectangle2 == null) {
                    rectangle2 = graphics.getClipBounds();
                }
                rectangle = this.fHScroll.getBounds();
                if (rectangle2.x >= rectangle.x && rectangle2.y >= rectangle.y && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                    super.paint(graphics);
                    return;
                }
            }
        }
        if ((graphics2 = this.fOffscreen.startRender(graphics)) == null) {
            return;
        }
        this.bufferedPaint(graphics2);
        this.fOffscreen.finishRender(graphics);
    }

    @Override
    public void print(Graphics graphics) {
        this.bufferedPaint(graphics);
    }

    public void bufferedPaint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle;
        int n6;
        if (this.fVScroll != null) {
            this.fVScroll.setVisible(this.fVScrollVisAWT);
            if (this.fVScrollBoundsAWT != null) {
                this.fVScroll.setBounds(this.fVScrollBoundsAWT.x, this.fVScrollBoundsAWT.y, this.fVScrollBoundsAWT.width, this.fVScrollBoundsAWT.height);
                this.fVScrollBoundsAWT = null;
            }
        }
        if (this.fHScroll != null) {
            this.fHScroll.setVisible(this.fHScrollVisAWT);
            if (this.fHScrollBoundsAWT != null) {
                this.fHScroll.setBounds(this.fHScrollBoundsAWT.x, this.fHScrollBoundsAWT.y, this.fHScrollBoundsAWT.width, this.fHScrollBoundsAWT.height);
                this.fHScrollBoundsAWT = null;
            }
        }
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = this.getBounds();
        rectangle4.y = 0;
        rectangle4.x = 0;
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
        if (this.fColumnWidths[0] == 0) {
            for (n6 = 0; n6 < this.fColumnCount; ++n6) {
                this.fColumnWidths[n6] = (rectangle4.width - 30) / this.fColumnCount;
            }
        }
        graphics.setFont(this.getFont());
        boolean bl = this.checkFontInfo();
        Rectangle rectangle5 = graphics.getClipBounds();
        rectangle5 = rectangle5 == null || rectangle5.isEmpty() ? new Rectangle(this.getBounds()) : new Rectangle(rectangle5);
        if (this.fUseHeader) {
            if (this.fColumnCount > 1) {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, rectangle5.width - 1, 0);
                graphics.drawLine(0, 0, 0, rectangle5.height - 1);
                graphics.setColor(Color.gray);
                graphics.drawLine(0, this.fHeaderHeight - 1, rectangle5.width - 1, this.fHeaderHeight - 1);
                graphics.drawLine(rectangle5.width - 1, 1, rectangle5.width - 1, this.fHeaderHeight - 1);
            }
            rectangle = rectangle2;
            n5 = 0;
            for (n6 = 0; n6 < this.fHeaders.length; ++n6) {
                int n7;
                rectangle.x = n5 + this.fCurrentX - 1;
                rectangle.y = 0;
                rectangle.width = this.fColumnWidths[n6] - 1;
                rectangle.height = this.fHeaderHeight;
                this.setClip(graphics, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                this.clipRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                n4 = 0;
                if (this.fAlignHeaderWithText) {
                    n7 = n5 + this.fCurrentX;
                    if (this.fUseIcons && n6 == 0) {
                        n4 += 20;
                    }
                    if (this.fIsTwisty && n6 == 0) {
                        n4 += 20;
                    }
                } else {
                    n7 = n5 + 1;
                }
                graphics.setColor(Color.black);
                graphics.drawString(this.fHeaders[n6], n7 += n4, this.fFontInfo.getAscent() + 2);
                if (this.fColumnCount > 1 && this.fHeaders.length == this.fColumnCount) {
                    n3 = n7 - n4 + this.fColumnWidths[n6] - 3;
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n3, this.fHeaderHeight - 1, n3, 1);
                    graphics.setColor(Color.white);
                    graphics.drawLine(n3 + 1, this.fHeaderHeight - 1, n3 + 1, 1);
                }
                n5 += this.fColumnWidths[n6];
            }
            this.setClip(graphics, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
        }
        rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        rectangle.grow(-1, -1);
        if (this.fHScroll.isVisible()) {
            rectangle.height -= 16;
            if (this.fAppearance != 1) {
                ++rectangle.height;
            } else if (!PlatformInfo.useWindowsXPAppearance()) {
                --rectangle.height;
            }
        }
        if (this.fVScroll.isVisible()) {
            rectangle.width -= 16;
            if (this.fAppearance != 1) {
                ++rectangle.width;
            }
        }
        if (this.fInvalCount > 1) {
            this.setClip(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clipRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.fInvalCount = 0;
        graphics.setColor(this.getListBGColor());
        graphics.fillRect(rectangle.x, rectangle.y + this.fHeaderHeight, rectangle.width, rectangle.height - this.fHeaderHeight);
        if (this.fSortColumnColor != null && this.fColumnWidths[0] > 0) {
            graphics.setColor(this.fSortColumnColor);
            graphics.fillRect(rectangle.x + this.fCurrentX, rectangle.y + this.fHeaderHeight, this.fColumnWidths[0] - 1, rectangle.height - this.fHeaderHeight);
        }
        if ((n2 = (n = this.fCurrentY) + rectangle.height / this.fCellHeight + 1) > this.fList.size()) {
            n2 = this.fList.size();
        }
        boolean bl2 = MWUtils.isParentFrameActive(this) || this.fForceSelectionActive;
        Rectangle rectangle6 = this.getListArea();
        rectangle = rectangle2;
        Rectangle rectangle7 = rectangle3;
        for (n6 = n; n6 < n2; ++n6) {
            rectangle.y = rectangle6.y + (n6 - n) * this.fCellHeight;
            rectangle.x = rectangle6.x + this.fCurrentX;
            rectangle.height = this.fCellHeight;
            rectangle.width = rectangle6.width;
            if (this.fDrawRowLines) {
                if (this.fHGridColor == null) {
                    graphics.setColor(Decorations.getColor(3));
                } else {
                    graphics.setColor(this.fHGridColor);
                }
                graphics.drawLine(rectangle.x, rectangle.y + this.fCellHeight, rectangle.width, rectangle.y + this.fCellHeight);
            }
            if (this.cellStringWidth(n6, 0) == -1) {
                String string = this.cellString(n6, 0);
                n3 = this.fFontInfo.stringWidth(string);
                this.setItemStringWidth(n6, 0, n3);
                bl = true;
            }
            if (this.fDrawSelection && this.isIndexSelected(n6)) {
                int n8 = rectangle.y + (this.fCellHeight - this.fFontHeight) / 2 + 1;
                graphics.setColor(Decorations.getColor(4, bl2, this.getListBGColor()));
                if (this.fHiliteItemHilite) {
                    graphics.fillRect(0, rectangle.y + 1, this.fMaxWidth, rectangle.height - 1);
                } else if (this.fWholeItemHilite || this.fColumnCount > 1) {
                    graphics.fillRect(rectangle.x + this.fLeftMargin - 1, n8 - 1, this.fMaxWidth, this.fFontHeight + 2);
                } else {
                    n3 = this.fLeftMargin;
                    if (this.fUseIcons && this.getIcon(this.id(n6)) == null) {
                        n3 = 20;
                    }
                    graphics.fillRect(rectangle.x + n3 - 1 + this.level(n6) * this.fLevelIndent, n8 - 1, this.cellStringWidth(n6, 0) + 2, this.fFontHeight + 2);
                }
            }
            n5 = 0;
            for (int i = 0; i < this.fColumnCount; ++i) {
                if (this.cellStringWidth(n6, i) == -1) {
                    this.setItemStringWidth(n6, i, this.fFontInfo.stringWidth(this.cellString(n6, i)));
                    bl = true;
                }
                rectangle7.y = rectangle.y;
                rectangle7.height = rectangle.height;
                n4 = i == 0 ? (this.fIsTwisty ? 20 + this.level(n6) * this.fLevelIndent : 4 + this.level(n6) * this.fLevelIndent) : 0;
                rectangle7.x = n5 + this.fCurrentX + n4;
                rectangle7.width = this.fColumnCount > 1 ? this.fColumnWidths[i] - 3 - n4 : this.fMaxWidth;
                if (rectangle7.width < 0) {
                    rectangle7.width = 0;
                }
                Shape shape = graphics.getClip();
                this.setClip(graphics, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                this.clipRect(graphics, rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height);
                if (this.fDrawColumnLines && this.fColumnCount > 1) {
                    n3 = rectangle7.x + rectangle7.width;
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n3, 0, n3, this.getListArea().height + this.fHeaderHeight);
                    graphics.setColor(Color.white);
                    graphics.drawLine(n3 + 1, 0, n3 + 1, this.getListArea().height + this.fHeaderHeight);
                }
                this.clipRect(graphics, rectangle7.x, rectangle7.y, rectangle7.width, rectangle7.height);
                graphics.setColor(Decorations.getColor(12));
                this.drawItem(graphics, this.id(n6), i, rectangle7, bl2);
                this.setClip(graphics, shape);
                n5 += this.fColumnWidths[i];
            }
            if (!this.fIsTwisty) continue;
            this.drawTwisty(graphics, n6, false);
        }
        if (this.fDrawTreeLines && this.fIsTwisty) {
            this.drawTreeLines(graphics);
        }
        this.setClip(graphics, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
        if (bl) {
            this.redoScrollbars();
        }
        if (this.fDrawFrame) {
            rectangle = this.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            if (this.fAppearance == 1) {
                Decorations.drawBevelFrame(graphics, rectangle.x, rectangle.y + this.fHeaderHeight, rectangle.width, rectangle.height - rectangle.y - this.fHeaderHeight);
            } else {
                graphics.setColor(Color.black);
                graphics.drawRect(rectangle.x, rectangle.y + this.fHeaderHeight, rectangle.width - 1, rectangle.height - rectangle.y - this.fHeaderHeight - 1);
            }
        }
        super.paint(graphics);
    }

    public Rectangle getItemRect(int n, int n2) {
        Rectangle rectangle = null;
        int n3 = this.idToIndex(n);
        if (n3 < this.fList.size()) {
            Rectangle rectangle2 = this.getListArea();
            rectangle2.y += (n3 - this.fCurrentY) * this.fCellHeight;
            rectangle2.x += this.fCurrentX;
            rectangle2.height = this.fCellHeight;
            int n4 = 0;
            for (int i = 0; i < n2 && i < this.fColumnWidths.length; ++i) {
                n4 += this.fColumnWidths[i];
            }
            rectangle = new Rectangle(rectangle2);
            rectangle.x = n4 + this.fCurrentX;
            int n5 = n2 == 0 ? (this.fIsTwisty ? 20 + this.level(n3) * this.fLevelIndent : 4) : 0;
            rectangle.x += n5;
            rectangle.width = this.fColumnCount > 1 ? this.fColumnWidths[n2] - 3 - n5 : this.fMaxWidth;
            if (rectangle.width < 0) {
                rectangle.width = 0;
            }
        }
        return rectangle;
    }

    public synchronized void add(int n, int n2, String[] stringArray, Image image, boolean bl) {
        if (!this.fIsTwisty) {
            bl = false;
        }
        if (!this.fUseIcons) {
            image = null;
        }
        if (n == -1) {
            ListItem listItem = new ListItem(n2, stringArray, image, 0, bl);
            this.fList.addElement(listItem);
            this.invalBelowItem(this.fList.size() - 2);
        } else {
            int n3;
            int n4 = 0;
            int n5 = this.fList.size();
            for (n3 = 0; n3 < n5; ++n3) {
                if (n != this.id(n3)) continue;
                n4 = this.level(n3);
                break;
            }
            if (n3 + 1 < n5) {
                ++n3;
                while (n3 < n5 && this.level(n3) > n4) {
                    ++n3;
                }
                if (n3 < n5) {
                    ListItem listItem = new ListItem(n2, stringArray, image, n4 + 1, bl);
                    this.fList.insertElementAt(listItem, n3);
                    this.invalBelowItem(n3 - 1);
                } else {
                    ListItem listItem = new ListItem(n2, stringArray, image, n4 + 1, bl);
                    this.fList.addElement(listItem);
                    this.invalBelowItem(this.fList.size() - 2);
                }
            } else {
                ListItem listItem = new ListItem(n2, stringArray, image, n4 + 1, bl);
                this.fList.addElement(listItem);
                this.invalBelowItem(this.fList.size() - 2);
            }
        }
        this.redoScrollbars();
    }

    public void add(int n, int n2, String string, Image image, boolean bl) {
        String[] stringArray = new String[]{string};
        this.add(n, n2, stringArray, image, bl);
    }

    public void add(int n, int n2, String string) {
        this.add(n, n2, string, null, false);
    }

    public void add(String string) {
        this.add(-1, this.fNextAvailableID++, string, null, false);
    }

    public void add(int n, int n2, String string, Image image) {
        this.add(n, n2, string, image, false);
    }

    public void add(int n, int n2, String string, boolean bl) {
        this.add(n, n2, string, null, bl);
    }

    public void insert(int n, int n2, int n3, String[] stringArray, Image image, boolean bl) {
        int n4;
        int[] nArray = this.getChildren(n);
        if (!this.fIsTwisty) {
            bl = false;
        }
        if (!this.fUseIcons) {
            image = null;
        }
        for (n4 = 0; n4 < this.fList.size() && this.id(n4) != n; ++n4) {
        }
        if (n4 == this.fList.size()) {
            n4 = -1;
        }
        int n5 = n4 == -1 ? -1 : this.level(n4);
        if (n2 >= nArray.length) {
            this.add(n, n3, stringArray, image, bl);
        } else {
            int n6;
            if (n2 < 0) {
                n2 = 0;
            }
            int n7 = nArray[n2];
            for (n6 = n4 + 1; n6 < this.fList.size() && this.id(n6) != n7; ++n6) {
            }
            if (n6 == this.fList.size()) {
                this.add(n, n3, stringArray, image, bl);
            } else {
                ListItem listItem = new ListItem(n3, stringArray, image, n5 + 1, bl);
                this.fList.insertElementAt(listItem, n6);
                this.invalBelowItem(n6 - 1);
                this.redoScrollbars();
            }
        }
    }

    public void insert(int n, int n2, int n3, String string, Image image, boolean bl) {
        String[] stringArray = new String[]{string};
        this.insert(n, n2, n3, stringArray, image, bl);
    }

    public void insertBefore(int n, int n2, String[] stringArray, Image image, boolean bl) {
        if (!this.fIsTwisty) {
            bl = false;
        }
        if (!this.fUseIcons) {
            image = null;
        }
        if (n == -1) {
            ListItem listItem = new ListItem(n2, stringArray, image, 0, bl);
            this.fList.addElement(listItem);
            this.invalBelowItem(-1);
        } else {
            int n3 = this.fList.size();
            for (int i = 0; i < n3; ++i) {
                if (n != this.id(i)) continue;
                ListItem listItem = new ListItem(n2, stringArray, image, 0, bl);
                this.fList.insertElementAt(listItem, i);
                this.invalBelowItem(i - 1);
                break;
            }
        }
        this.redoScrollbars();
    }

    public void insertBefore(int n, int n2, String string, Image image, boolean bl) {
        String[] stringArray = new String[]{string};
        this.insertBefore(n, n2, stringArray, image, bl);
    }

    public void insertBefore(int n, int n2, String string) {
        this.insertBefore(n, n2, string, null, false);
    }

    public void insertBefore(int n, int n2, String string, Image image) {
        this.insertBefore(n, n2, string, image, false);
    }

    public void insertBefore(int n, int n2, String string, boolean bl) {
        this.insertBefore(n, n2, string, null, bl);
    }

    public void setItemIcon(int n, Image image) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            this.setIconIndex(n2, image);
            this.invalIndex(n2);
        }
    }

    public void swapIcons(Image image, Image image2) {
        for (int i = 0; i < this.fList.size(); ++i) {
            Image image3 = this.getIndexIcon(i);
            if (image3 == image) {
                this.setIconIndex(i, image2);
                continue;
            }
            if (image3 != image2) continue;
            this.setIconIndex(i, image);
        }
    }

    public void setAlignHeaderWithText(boolean bl) {
        this.fAlignHeaderWithText = bl;
    }

    public void setHeader(String[] stringArray) {
        this.fUseHeader = true;
        this.fHeaders = (String[])stringArray.clone();
        if (stringArray.length > 1) {
            this.fAlignHeaderWithText = true;
        }
        if (this.checkFontInfo()) {
            Rectangle rectangle = this.getBounds();
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.fHeaderHeight = this.fFontHeight + 5;
        this.repaint(5L);
    }

    public void setHeader(String string) {
        String[] stringArray = new String[]{string};
        this.setHeader(stringArray);
    }

    public String getHeader() {
        if (this.fHeaders != null) {
            return this.fHeaders[0];
        }
        return null;
    }

    public void setColumnWidths(int[] nArray) {
        System.arraycopy(nArray, 0, this.fColumnWidths, 0, nArray.length);
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int[] getColumnWidths() {
        return this.fColumnWidths;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.fList.size() * this.fCellHeight;
        return new Dimension(200, 60);
    }

    public Color getSortColumnColor() {
        return this.fSortColumnColor;
    }

    public void setSortColumnColor(Color color) {
        this.fSortColumnColor = color;
    }

    public Color getHGridColor() {
        return this.fHGridColor;
    }

    public void setHGridColor(Color color) {
        this.fHGridColor = color;
    }

    public Color getListColor() {
        return this.fListColor;
    }

    public void setListColor(Color color) {
        this.fListColor = color;
    }

    public boolean getDrawSelection() {
        return this.fDrawSelection;
    }

    public void setDrawSelection(boolean bl) {
        this.fDrawSelection = bl;
    }

    public boolean setSelActiveWhenNoFocus(boolean bl) {
        boolean bl2 = this.fForceSelectionActive;
        if (this.fForceSelectionActive != bl) {
            this.fForceSelectionActive = bl;
            this.repaint(5L);
        }
        return bl2;
    }

    public void setWholeItemHilite(boolean bl) {
        this.fWholeItemHilite = bl;
    }

    public void setWholeItemSelect(boolean bl) {
        this.fWholeItemSelect = bl;
    }

    public void setDrawFrame(boolean bl) {
        if (this.fDrawFrame != bl) {
            this.fDrawFrame = bl;
            this.repaint(5L);
        }
    }

    public void setMultiSelection(boolean bl) {
        this.fMultiSelection = bl;
    }

    public boolean getMultiSelection() {
        return this.fMultiSelection;
    }

    public void setImmediateClick(boolean bl) {
        this.fImmediateClick = bl;
    }

    public boolean getImmediateClick() {
        return this.fImmediateClick;
    }

    public void setScrollOnTwist(boolean bl) {
        this.fScrollOnTwist = bl;
    }

    public boolean getScrollOnTwist() {
        return this.fScrollOnTwist;
    }

    public boolean hasSelection() {
        return this.getFirstSelectedItem() != -1;
    }

    public int getLastItem() {
        if (this.fList.size() > 0) {
            return this.id(this.fList.size() - 1);
        }
        return -1;
    }

    public int getFirstItem() {
        this.fNextItem = 1;
        if (this.fList.size() > 0) {
            return this.id(0);
        }
        return -1;
    }

    public int getPreviousItem(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1 && n2 > 0) {
            return this.id(n2 - 1);
        }
        return -1;
    }

    public int getNextItem(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1 && n2 < this.fList.size() - 1) {
            return this.id(n2 + 1);
        }
        return -1;
    }

    public int getNextItem() {
        int n = -1;
        if (this.fNextItem < this.fList.size()) {
            n = this.id(this.fNextItem);
            ++this.fNextItem;
        }
        return n;
    }

    public int getFirstSelectedItem() {
        int n = this.getFirstSelectedIndex();
        if (n != -1) {
            n = this.id(n);
        }
        return n;
    }

    public int getLastSelectedItem() {
        int n = this.getLastSelectedIndex();
        if (n != -1) {
            n = this.id(n);
        }
        return n;
    }

    public int getNextSelectedItem(int n) {
        boolean bl = false;
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < this.fList.size(); ++i) {
            if (this.isIndexSelected(i) && bl) {
                return this.id(i);
            }
            if (this.id(i) != n) continue;
            bl = true;
        }
        return -1;
    }

    public int getParentId(int n) {
        int n2 = -1;
        block0: for (int i = 0; i < this.fList.size(); ++i) {
            if (this.id(i) != n) continue;
            int n3 = this.level(i) - 1;
            if (n3 < 0) break;
            for (int j = i - 1; j >= 0; --j) {
                if (this.level(j) != n3) continue;
                n2 = this.id(j);
                continue block0;
            }
        }
        return n2;
    }

    public boolean itemExists(int n) {
        int n2 = this.idToIndex(n);
        return n2 != -1;
    }

    public String getItemString(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (n3 != -1) {
            return this.cellString(n3, n2);
        }
        return null;
    }

    public String getItemString(int n) {
        return this.getItemString(n, 0);
    }

    public void setItemString(int n, int n2, String string) {
        int n3 = this.idToIndex(n);
        if (n3 != -1) {
            this.setCellString(n3, n2, string);
            this.setItemStringWidth(n3, n2, -1);
            this.invalItemString(n3);
        }
    }

    public void setItemString(int n, String string) {
        this.setItemString(n, 0, string);
    }

    @Override
    public synchronized void remove(int n) {
        int n2 = this.idToIndex(n);
        if (n2 != -1) {
            this.deleteIndex(n2);
        }
    }

    public int getRows() {
        return this.fList.size();
    }

    public int getColumns() {
        return this.fColumnCount;
    }

    public void setDrawColumnLines(boolean bl) {
        if (this.fDrawColumnLines != bl) {
            this.fDrawColumnLines = bl;
            this.repaint(5L);
        }
    }

    public void setDrawRowLines(boolean bl) {
        if (this.fDrawRowLines != bl) {
            this.fDrawRowLines = bl;
            this.repaint(5L);
        }
    }

    protected void setDrawTreeLines(boolean bl) {
        if (this.fDrawTreeLines != bl) {
            this.fDrawTreeLines = bl;
            this.repaint(5L);
        }
    }

    protected void setIsTwisty(boolean bl) {
        if (this.fIsTwisty != bl) {
            this.fIsTwisty = bl;
            this.repaint(5L);
        }
    }

    public void setHiliteItemHilite(boolean bl) {
        if (this.fHiliteItemHilite != bl) {
            this.fHiliteItemHilite = bl;
            this.repaint(5L);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.fHScroll.getMinimum() != this.fHScroll.getMaximum()) {
            this.fHScroll.setVisible(bl);
        }
        if (this.fVScroll.getMinimum() != this.fVScroll.getMaximum()) {
            this.fVScroll.setVisible(bl);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.fHScroll.setEnabled(bl);
            this.fVScroll.setEnabled(bl);
        }
    }

    public void showLastSelectedItem() {
        int n = this.getLastSelectedIndex();
        Rectangle rectangle = this.getListArea();
        int n2 = rectangle.height / this.fCellHeight;
        int n3 = this.fCurrentY;
        if (n < this.fCurrentY) {
            this.fCurrentY = n;
            this.fVScroll.setValue(this.fCurrentY);
            this.repaint(5L);
        } else if (n > this.fCurrentY + n2 - 1) {
            this.fCurrentY += n - (this.fCurrentY + n2 - 1);
            this.fVScroll.setValue(this.fCurrentY);
            this.repaint(5L);
        }
        if (this.fCurrentY != n3) {
            this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
        }
    }

    public void showFirstSelectedItem(boolean bl) {
        int n = this.getFirstSelectedIndex();
        Rectangle rectangle = this.getListArea();
        int n2 = rectangle.height / this.fCellHeight;
        int n3 = this.fCurrentY;
        int n4 = !bl ? n2 - 1 : 0;
        if (n < this.fCurrentY) {
            this.fCurrentY = n;
            this.fVScroll.setValue(this.fCurrentY);
            this.repaint(5L);
        } else if (n > this.fCurrentY + n4) {
            this.fCurrentY += n - (this.fCurrentY + n4);
            this.fVScroll.setValue(this.fCurrentY);
            this.repaint(5L);
        }
        if (this.fCurrentY != n3) {
            this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
        }
    }

    public void showFirstSelectedItem() {
        this.showFirstSelectedItem(false);
    }

    private int childCount(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.level(n);
        for (int i = n + 1; i < this.fList.size() && (n2 = this.level(i)) > n4; ++i) {
            if (this.level(i) != n4 + 1) continue;
            ++n3;
        }
        return n3;
    }

    private boolean showChildren(int n) {
        int n2;
        int n3 = this.getListArea().height;
        if (!this.fHScroll.isVisible()) {
            n3 -= 16;
        }
        int n4 = n3 / this.fCellHeight;
        int n5 = this.childCount(n);
        if (n5 + 1 > n4) {
            n5 = n4 - 1;
        }
        if ((n2 = n4 - (n - this.fCurrentY + 1)) < n5) {
            this.fCurrentY = n + n5 - n4 + 1;
            this.fVScroll.setValue(this.fCurrentY);
            this.repaint(5L);
            this.processMWTListEvent(new MWTListEvent(this, 3, this.fCurrentX, this.fCurrentY));
            return true;
        }
        return false;
    }

    public MWTList(boolean bl, boolean bl2, int n) {
        this.setLayout(null);
        this.fUseIcons = bl;
        this.fIsTwisty = bl2;
        this.fLeftMargin = this.fIsTwisty ? 20 : 4;
        if (this.fUseIcons) {
            this.fLeftMargin += 20;
        }
        this.fList = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.fHScroll = new MWScrollbar(1);
        this.fHScroll.setValues(0, 0, 0, 0);
        this.fHScroll.setVisible(false);
        this.add(this.fHScroll);
        this.fVScroll = new MWScrollbar(0);
        this.fVScroll.setValues(0, 0, 0, 0);
        this.fVScroll.setVisible(false);
        this.add(this.fVScroll);
        this.fVScroll.addAdjustmentListener(this);
        this.fHScroll.addAdjustmentListener(this);
        this.fHScroll.setUnitIncrement(1);
        this.fVScroll.setUnitIncrement(1);
        this.fHScroll.setBlockIncrement(5);
        this.fPopListener = null;
        this.fColumnCount = n;
        this.fHeaders = new String[n];
        this.fColumnWidths = new int[n];
        this.fHeaderHeight = 0;
        this.fListColor = null;
        this.fHGridColor = null;
        this.fSortColumnColor = null;
        this.fDrawSelection = true;
        this.fWholeItemHilite = false;
        this.fWholeItemSelect = false;
        this.fMultiSelection = false;
        this.fDrawColumnLines = true;
        this.fHiliteItemHilite = false;
        this.fDrawFrame = true;
        this.fImmediateClick = false;
        this.fScrollOnTwist = true;
        this.fSelectID = -1;
        this.fAppearance = PlatformInfo.getAppearance();
        if (this.fAppearance != 0) {
            this.fDrawRowLines = false;
            this.fDrawTreeLines = true;
            this.fKeyScrollSelect = true;
        } else {
            this.fDrawRowLines = true;
            this.fDrawTreeLines = false;
            this.fKeyScrollSelect = false;
        }
        this.fLastClickedItem = -1;
        this.fLastClickTime = 0L;
        this.fCurrentX = 0;
        this.fCurrentY = 0;
        this.fNextAvailableID = 200300;
        this.addFocusListener(new FocusHandler());
        this.fOffscreen = new Offscreen((Component)this);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public MWTList(boolean bl, boolean bl2) {
        this(bl, bl2, 1);
    }

    public MWTList(boolean bl, int n) {
        this(bl, false, n);
    }

    public MWTList(int n) {
        this(false, false, n);
    }

    public MWTList(boolean bl) {
        this(bl, false, 1);
    }

    public MWTList() {
        this(false, false, 1);
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintIfSel();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintIfSel();
        }

        private void repaintIfSel() {
            MWTList.this.repaint();
        }
    }
}

