/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWLightweight;
import com.mathworks.mwt.MWScrollLayout;
import com.mathworks.mwt.MWScrollTarget;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.Offscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Vector;

public class MWScrollPanel
extends Container
implements MWLightweight {
    private Scroller fScroller;
    private MWScrollbar fHorizontalScrollbar;
    private MWScrollbar fVerticalScrollbar;
    private Vector fScrollTargets = new Vector(1);
    private int fHLoc;
    private int fVLoc;
    private int fTop = 2;
    private int fLeft = 2;
    private int fBottom = 2;
    private int fRight = 2;

    public MWScrollPanel(Component component, boolean bl) {
        this.setLayout(new MWScrollLayout());
        this.fScroller = new Scroller(component, bl);
        this.addScrollTarget(this.fScroller);
        component.addComponentListener(new ComponentResized());
        this.fHorizontalScrollbar = new MWScrollbar(1, 0, 0, 0, 0);
        this.fHorizontalScrollbar.setUnitIncrement(10);
        this.fHorizontalScrollbar.addAdjustmentListener(new SetHorizLoc());
        this.fVerticalScrollbar = new MWScrollbar(0, 0, 0, 0, 0);
        this.fVerticalScrollbar.setUnitIncrement(10);
        this.fVerticalScrollbar.addAdjustmentListener(new SetVertLoc());
        this.add((Component)this.fScroller, "Center");
        this.add((Component)this.fHorizontalScrollbar, "Horizontal");
        this.add((Component)this.fVerticalScrollbar, "Vertical");
        this.add((Component)new MWCanvas(), "Southeast");
    }

    public MWScrollPanel(Component component) {
        this(component, true);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.fTop, this.fLeft, this.fBottom, this.fRight);
    }

    @Override
    public void paint(Graphics graphics) {
        this.checkScroller();
        super.paint(graphics);
        if (this.fTop != 0 || this.fLeft != 0 || this.fBottom != 0 || this.fRight != 0) {
            Dimension dimension = this.getSize();
            Decorations.drawBevelFrame(graphics, this.fLeft - 2, this.fTop - 2, dimension.width - this.fLeft - this.fRight + 4, dimension.height - this.fTop - this.fBottom + 4);
        }
    }

    public void setInsets(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fTop = bl ? 2 : 0;
        this.fLeft = bl2 ? 2 : 0;
        this.fBottom = bl3 ? 2 : 0;
        this.fRight = bl4 ? 2 : 0;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    public void addScrollTarget(MWScrollTarget mWScrollTarget) {
        this.fScrollTargets.addElement(mWScrollTarget);
        mWScrollTarget.scrollTo(this.fHLoc, this.fVLoc);
    }

    public void removeScrollTarget(MWScrollTarget mWScrollTarget) {
        this.fScrollTargets.removeElement(mWScrollTarget);
    }

    public void setHorizLoc(int n) {
        this.fHLoc = n;
        this.notifyTargets();
    }

    public final int getHorizLoc() {
        return this.fHLoc;
    }

    public void setVertLoc(int n) {
        this.fVLoc = n;
        this.notifyTargets();
    }

    public final int getVertLoc() {
        return this.fVLoc;
    }

    public void setLoc(int n, int n2) {
        this.fHLoc = n;
        this.fVLoc = n2;
        this.notifyTargets();
    }

    public final Rectangle getAperture() {
        return new Rectangle(this.fHLoc, this.fVLoc, this.fScroller.getScrollerWidth(), this.fScroller.getScrollerHeight());
    }

    private void notifyTargets() {
        Enumeration enumeration = this.fScrollTargets.elements();
        while (enumeration.hasMoreElements()) {
            MWScrollTarget mWScrollTarget = (MWScrollTarget)enumeration.nextElement();
            mWScrollTarget.scrollTo(this.fHLoc, this.fVLoc);
        }
    }

    private void scrollerResized() {
        int n;
        int n2 = this.fHLoc;
        int n3 = this.fVLoc;
        if (this.fHorizontalScrollbar != null) {
            n = this.fScroller.getComponentWidth() - this.fScroller.getScrollerWidth();
            if (n < 0) {
                n = 0;
            }
            if ((n2 = this.fHorizontalScrollbar.getValue()) > n) {
                n2 = n;
            }
            this.fHorizontalScrollbar.setBlockIncrement(this.fScroller.getScrollerWidth() - this.fHorizontalScrollbar.getUnitIncrement());
            this.fHorizontalScrollbar.setValues(n2, this.fScroller.getScrollerWidth(), 0, n);
        }
        if (this.fVerticalScrollbar != null) {
            n = this.fScroller.getComponentHeight() - this.fScroller.getScrollerHeight();
            if (n < 0) {
                n = 0;
            }
            if ((n3 = this.fVerticalScrollbar.getValue()) > n) {
                n3 = n;
            }
            this.fVerticalScrollbar.setBlockIncrement(this.fScroller.getScrollerHeight() - this.fVerticalScrollbar.getUnitIncrement());
            this.fVerticalScrollbar.setValues(n3, this.fScroller.getScrollerHeight(), 0, n);
        }
        if (n2 != this.fHLoc || n3 != this.fVLoc) {
            this.fHLoc = n2;
            this.fVLoc = n3;
            this.notifyTargets();
        }
    }

    private void checkScroller() {
        if (this.fScroller.sizeChanged()) {
            this.scrollerResized();
        }
    }

    private class ComponentResized
    extends ComponentAdapter {
        private ComponentResized() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MWScrollPanel.this.checkScroller();
        }
    }

    private class SetVertLoc
    implements AdjustmentListener {
        private SetVertLoc() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            MWScrollPanel.this.setVertLoc(adjustmentEvent.getValue());
        }
    }

    private class SetHorizLoc
    implements AdjustmentListener {
        private SetHorizLoc() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            MWScrollPanel.this.setHorizLoc(adjustmentEvent.getValue());
        }
    }

    private static class Scroller
    extends Container
    implements MWScrollTarget {
        private int fScrollerWidth;
        private int fScrollerHeight;
        private Component fComponent;
        private int fComponentX;
        private int fComponentY;
        private int fComponentWidth;
        private int fComponentHeight;
        private boolean fUseOffscreen;
        private Offscreen fOffscreen;

        Scroller(Component component, boolean bl) {
            this.setLayout(null);
            this.fComponent = component;
            this.add(this.fComponent);
            if (bl) {
                this.fOffscreen = new Offscreen((Component)this);
                this.fUseOffscreen = true;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics graphics2;
            Graphics graphics3 = graphics2 = this.fUseOffscreen ? this.fOffscreen.startRender(graphics) : graphics;
            if (graphics2 == null) {
                return;
            }
            if (this.fUseOffscreen) {
                this.eraseBackground(graphics2);
            }
            super.paint(graphics2);
            this.erasePadding(graphics2);
            if (this.fUseOffscreen) {
                this.fOffscreen.finishRender(graphics);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.fComponent.getPreferredSize();
        }

        @Override
        public void scrollTo(int n, int n2) {
            this.fComponentX = -n;
            this.fComponentY = -n2;
            this.fComponent.setLocation(-n, -n2);
        }

        final int getScrollerWidth() {
            return this.fScrollerWidth;
        }

        final int getScrollerHeight() {
            return this.fScrollerHeight;
        }

        final int getComponentWidth() {
            return this.fComponentWidth;
        }

        final int getComponentHeight() {
            return this.fComponentHeight;
        }

        boolean sizeChanged() {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.fComponent.getPreferredSize();
            if (dimension.width != this.fScrollerWidth || dimension.height != this.fScrollerHeight || dimension2.width != this.fComponentWidth || dimension2.height != this.fComponentHeight) {
                this.fScrollerWidth = dimension.width;
                this.fScrollerHeight = dimension.height;
                this.fComponentWidth = dimension2.width;
                this.fComponentHeight = dimension2.height;
                this.fComponent.setSize(this.fComponentWidth, this.fComponentHeight);
                return true;
            }
            return false;
        }

        private void eraseBackground(Graphics graphics) {
            if (this.fComponent != null) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.fScrollerWidth, this.fScrollerHeight);
            }
        }

        private void erasePadding(Graphics graphics) {
            if (this.fComponent != null) {
                if (this.fComponentWidth - this.fComponentX < this.fScrollerWidth) {
                    graphics.setColor(Color.darkGray);
                    graphics.fillRect(this.fComponentWidth - this.fComponentX, 0, this.fScrollerWidth - this.fComponentWidth + this.fComponentX, this.fScrollerHeight);
                }
                if (this.fComponentHeight - this.fComponentY < this.fScrollerHeight) {
                    graphics.setColor(Color.darkGray);
                    int n = this.fComponentWidth - this.fComponentX < this.fScrollerWidth ? this.fComponentWidth - this.fComponentX : this.fScrollerWidth;
                    graphics.fillRect(0, this.fComponentHeight - this.fComponentY, n, this.fScrollerHeight - this.fComponentHeight + this.fComponentY);
                }
            } else {
                graphics.setColor(Color.darkGray);
                graphics.fillRect(0, 0, this.fScrollerWidth, this.fScrollerHeight);
            }
        }
    }
}

