/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWScrollbar;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class MWScrollLayout
implements LayoutManager2,
Serializable {
    public static final String CENTER = "Center";
    public static final String HORIZONTAL = "Horizontal";
    public static final String VERTICAL = "Vertical";
    public static final String NORTH = "North";
    public static final String WEST = "West";
    public static final String SOUTHEAST = "Southeast";
    public static final String NORTHWEST = "Northwest";
    public static final String SOUTHWEST = "Southwest";
    public static final String NORTHEAST = "Northeast";
    private Component fCenter;
    private MWScrollbar fHoriz;
    private MWScrollbar fVert;
    private Component fNorth;
    private Component fWest;
    private Component fSoutheast;
    private Component fNorthwest;
    private Component fSouthwest;
    private Component fNortheast;

    private static int getScrollbarOffset() {
        return PlatformInfo.getAppearance() == 0 ? 1 : 0;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
        }
        this.addLayoutComponent((String)object, component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addLayoutComponent(String string, Component component) {
        if (CENTER.equals(string)) {
            this.fCenter = component;
            return;
        } else if (HORIZONTAL.equals(string)) {
            if (!(component instanceof MWScrollbar)) throw new IllegalArgumentException(string + " constraint must be used with scroll bar");
            this.fHoriz = (MWScrollbar)component;
            return;
        } else if (VERTICAL.equals(string)) {
            if (!(component instanceof MWScrollbar)) throw new IllegalArgumentException(string + " constraint must be used with scroll bar");
            this.fVert = (MWScrollbar)component;
            return;
        } else if (NORTH.equals(string)) {
            this.fNorth = component;
            return;
        } else if (WEST.equals(string)) {
            this.fWest = component;
            return;
        } else if (SOUTHEAST.equals(string)) {
            this.fSoutheast = component;
            return;
        } else if (NORTHWEST.equals(string)) {
            this.fNorthwest = component;
            return;
        } else if (SOUTHWEST.equals(string)) {
            this.fSouthwest = component;
            return;
        } else {
            if (!NORTHEAST.equals(string)) throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            this.fNortheast = component;
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == this.fCenter) {
            this.fCenter = null;
        } else if (component == this.fHoriz) {
            this.fHoriz = null;
        } else if (component == this.fVert) {
            this.fVert = null;
        } else if (component == this.fNorth) {
            this.fNorth = null;
        } else if (component == this.fWest) {
            this.fWest = null;
        } else if (component == this.fSoutheast) {
            this.fSoutheast = null;
        } else if (component == this.fNorthwest) {
            this.fNorthwest = null;
        } else if (component == this.fSouthwest) {
            this.fSouthwest = null;
        } else if (component == this.fNortheast) {
            this.fNortheast = null;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = MWScrollLayout.getScrollbarOffset();
        Insets insets = container.getInsets();
        int n2 = 0;
        if (this.has(this.fSouthwest)) {
            n2 += this.fSouthwest.getMinimumSize().width;
        }
        if (this.has(this.fHoriz)) {
            n2 += this.fHoriz.getMinimumSize().width;
        }
        if (this.has(this.fVert)) {
            n2 += this.fVert.getMinimumSize().width;
        }
        int n3 = 0;
        if (this.has(this.fWest)) {
            n3 += this.fWest.getMinimumSize().width;
        }
        if (this.has(this.fCenter)) {
            n3 += this.fCenter.getMinimumSize().width;
        }
        if (this.has(this.fVert)) {
            n3 += this.fVert.getMinimumSize().width;
        }
        int n4 = Math.max(n2, n3) + insets.left + insets.right;
        int n5 = 0;
        if (this.has(this.fNortheast)) {
            n5 += this.fNortheast.getMinimumSize().height;
        }
        if (this.has(this.fVert)) {
            n5 += this.fVert.getMinimumSize().height;
        }
        if (this.has(this.fHoriz)) {
            n5 += this.fHoriz.getMinimumSize().height;
        }
        int n6 = 0;
        if (this.has(this.fNorth)) {
            n6 += this.fNorth.getMinimumSize().height;
        }
        if (this.has(this.fCenter)) {
            n6 += this.fCenter.getMinimumSize().height;
        }
        if (this.has(this.fHoriz)) {
            n6 += this.fHoriz.getMinimumSize().height;
        }
        int n7 = Math.max(n5, n6) + insets.top + insets.bottom;
        return new Dimension(n4, n7);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = MWScrollLayout.getScrollbarOffset();
        Insets insets = container.getInsets();
        int n2 = 0;
        if (this.has(this.fSouthwest)) {
            n2 += this.fSouthwest.getPreferredSize().width + n;
        }
        if (this.has(this.fHoriz)) {
            n2 += this.fHoriz.getPreferredSize().width - 2 * n;
        }
        if (this.has(this.fVert)) {
            n2 += this.fVert.getPreferredSize().width - n;
        }
        int n3 = 0;
        if (this.has(this.fWest)) {
            n3 += this.fWest.getPreferredSize().width;
        }
        if (this.has(this.fCenter)) {
            n3 += this.fCenter.getPreferredSize().width;
        }
        if (this.has(this.fVert)) {
            n3 += this.fVert.getPreferredSize().width - n;
        }
        int n4 = Math.max(n2, n3) + insets.left + insets.right;
        int n5 = 0;
        if (this.has(this.fNortheast)) {
            n5 += this.fNortheast.getPreferredSize().height;
        }
        if (this.has(this.fVert)) {
            n5 += this.fVert.getPreferredSize().height - 2 * n;
        }
        if (this.has(this.fHoriz)) {
            n5 += this.fHoriz.getPreferredSize().height - n;
        }
        int n6 = 0;
        if (this.has(this.fNorth)) {
            n6 += this.fNorth.getPreferredSize().height;
        }
        if (this.has(this.fCenter)) {
            n6 += this.fCenter.getPreferredSize().height;
        }
        if (this.has(this.fHoriz)) {
            n6 += this.fHoriz.getPreferredSize().height - n;
        }
        int n7 = Math.max(n5, n6) + insets.top + insets.bottom;
        return new Dimension(n4, n7);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n3 = MWScrollLayout.getScrollbarOffset();
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = dimension.width - insets.left - insets.right;
        int n7 = dimension.height - insets.top - insets.bottom;
        int n8 = this.has(this.fVert) ? this.fVert.getPreferredSize().width : 0;
        int n9 = this.has(this.fWest) ? this.fWest.getPreferredSize().width : 0;
        int n10 = this.has(this.fSouthwest) ? this.fSouthwest.getPreferredSize().width : 0;
        int n11 = this.has(this.fHoriz) ? this.fHoriz.getPreferredSize().height : 0;
        int n12 = this.has(this.fNorth) ? this.fNorth.getPreferredSize().height : 0;
        int n13 = n2 = this.has(this.fNortheast) ? this.fNortheast.getPreferredSize().height : 0;
        if (this.fCenter != null) {
            this.fCenter.setBounds(n4 + n9, n5 + n12, n6 - n8 - n9 + n3, n7 - n11 - n12 + n3);
        }
        if (this.fHoriz != null) {
            n = n10 == 0 ? n3 : 0;
            this.fHoriz.setBounds(n4 + n10 - n, n5 + n7 - n11 + n3, n6 - n8 - n10 + 2 * n3 + n, n11);
        }
        if (this.fVert != null) {
            n = n2 == 0 ? n3 : 0;
            this.fVert.setBounds(n4 + n6 - n8 + n3, n5 + n2 - n, n8, n7 - n11 - n2 + 2 * n3 + n);
        }
        if (this.fNorth != null) {
            this.fNorth.setBounds(n4 + n9, n5, n6 - n8 - n9 + n3, n12);
        }
        if (this.fWest != null) {
            this.fWest.setBounds(n4, n5 + n12, n9, n7 - n11 - n12 + n3);
        }
        if (this.fSoutheast != null) {
            this.fSoutheast.setBounds(n4 + n6 - n8 + n3, n5 + n7 - n11 + n3, n8, n11);
        }
        if (this.fNorthwest != null) {
            this.fNorthwest.setBounds(n4, n5, n9, n12);
        }
        if (this.fSouthwest != null) {
            this.fSouthwest.setBounds(n4, n5 + n7 - n11 + n3, n10, n11);
        }
        if (this.fNortheast != null) {
            this.fNortheast.setBounds(n4 + n6 - n8 + n3, n5, n8, n2);
        }
    }

    private boolean has(Component component) {
        return component != null && component.isVisible();
    }
}

